﻿using System;
using System.Globalization;
using System.Windows;
using System.Windows.Data;

namespace GraphicScript
{
	internal class BoolToVisibilityConverter : IValueConverter
	{
		public bool IsInverted { get; set; }

		public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
		{
			if (!(value is bool))
				return DependencyProperty.UnsetValue;

			var data = (bool) value;
			return data ^ IsInverted ? Visibility.Visible : Visibility.Collapsed;
		}

		public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
		{
			throw new NotImplementedException();
		}
	}
}
