# Frequently Asked Questions

## Installation problems

### Tensorflow dependency
ML Agents requires TensorFlow; if you don't already have it installed, `pip` will try to install it when you install
the ml-agents package.

If you see a message like this
```console
ERROR: Could not find a version that satisfies the requirement tensorflow<2.0,>=1.7 (from mlagents) (from versions: none)
ERROR: No matching distribution found for tensorflow<2.0,>=1.7 (from mlagents)
```
it means that there is no version of TensorFlow for your python environment. Some known potential causes are:
 * You're using 32-bit python instead of 64-bit. See the answer [here](https://stackoverflow.com/a/1405971/224264)
  for how to tell which you have installed.
 * You're using python 3.8. Tensorflow plans to release packages for this as soon as possible; see
  [this issue](https://github.com/tensorflow/tensorflow/issues/33374) for more details.
 * You have the `tensorflow-gpu` package installed. This is equivalent to `tensorflow`, however `pip` doesn't recognize
  this. The best way to resolve this is to update to `tensorflow==1.15.0` which provides GPU support in the same package
  (see the [release notes](https://github.com/tensorflow/tensorflow/issues/33374) for more details.)
 * You're on another architecture (e.g. ARM) which requires vendor provided packages.

In all of these cases, the issue is a pip/python environment setup issue.  Please search the tensorflow github issues
for similar problems and solutions before creating a new issue.

## Scripting Runtime Environment not setup correctly

If you haven't switched your scripting runtime version from .NET 3.5 to .NET 4.6
or .NET 4.x, you will see such error message:

```console
error CS1061: Type `System.Text.StringBuilder' does not contain a definition for `Clear' and no extension method `Clear' of type `System.Text.StringBuilder' could be found. Are you missing an assembly reference?
```

This is because .NET 3.5 doesn't support method Clear() for StringBuilder, refer
to [Setting Up The ML-Agents Toolkit Within
Unity](Installation.md#setting-up-ml-agent-within-unity) for solution.

## Environment Permission Error

If you directly import your Unity environment without building it in the
editor, you might need to give it additional permissions to execute it.

If you receive such a permission error on macOS, run:

```sh
chmod -R 755 *.app
```

or on Linux:

```sh
chmod -R 755 *.x86_64
```

On Windows, you can find
[instructions](https://technet.microsoft.com/en-us/library/cc754344(v=ws.11).aspx).

## Environment Connection Timeout

If you are able to launch the environment from `UnityEnvironment` but then
receive a timeout error like this:

```
UnityAgentsException: The Communicator was unable to connect. Please make sure the External process is ready to accept communication with Unity.
```

There may be a number of possible causes:

* _Cause_: There may be no agent in the scene
* _Cause_: On OSX, the firewall may be preventing communication with the
  environment. _Solution_: Add the built environment binary to the list of
  exceptions on the firewall by following
  [instructions](https://support.apple.com/en-us/HT201642).
* _Cause_: An error happened in the Unity Environment preventing communication.
  _Solution_: Look into the [log
  files](https://docs.unity3d.com/Manual/LogFiles.html) generated by the Unity
  Environment to figure what error happened.
* _Cause_: You have assigned HTTP_PROXY and HTTPS_PROXY values in your
  environment variables. _Solution_: Remove these values and try again.

## Communication port {} still in use

If you receive an exception `"Couldn't launch new environment because
communication port {} is still in use. "`, you can change the worker number in
the Python script when calling

```python
UnityEnvironment(file_name=filename, worker_id=X)
```

## Mean reward : nan

If you receive a message `Mean reward : nan` when attempting to train a model
using PPO, this is due to the episodes of the Learning Environment not
terminating. In order to address this, set `Max Steps` for the
Agents within the Scene Inspector to a value greater than 0. Alternatively, it
is possible to manually set `done` conditions for episodes from within scripts
for custom episode-terminating events.

## Problems with training on AWS

Please refer to [Training on Amazon Web Service FAQ](Training-on-Amazon-Web-Service.md#faq)

# Known Issues

## Release 0.10.0
* ml-agents 0.10.0 and earlier were incompatible with TensorFlow 1.15.0; the graph could contain
 an operator that `tensorflow_to_barracuda` didn't handle. This was fixed in the 0.11.0 release.
