# Unity ML-Agents Toolkit Documentation

## Installation & Set-up

* [Installation](Installation.md)
  * [Background: Jupyter Notebooks](Background-Jupyter.md)
  * [Using Virtual Environment](Using-Virtual-Environment.md)
* [Basic Guide](Basic-Guide.md)

## Getting Started

* [ML-Agents Toolkit Overview](ML-Agents-Overview.md)
  * [Background: Unity](Background-Unity.md)
  * [Background: Machine Learning](Background-Machine-Learning.md)
  * [Background: TensorFlow](Background-TensorFlow.md)
* [Getting Started with the 3D Balance Ball Environment](Getting-Started-with-Balance-Ball.md)
* [Example Environments](Learning-Environment-Examples.md)

## Creating Learning Environments

* [Making a New Learning Environment](Learning-Environment-Create-New.md)
* [Designing a Learning Environment](Learning-Environment-Design.md)
* [Designing Agents](Learning-Environment-Design-Agents.md)
* [Learning Environment Best Practices](Learning-Environment-Best-Practices.md)

### Advanced Usage
  * [Using the Monitor](Feature-Monitor.md)
  * [Using the Video Recorder](https://github.com/Unity-Technologies/video-recorder)
  * [Using an Executable Environment](Learning-Environment-Executable.md)

## Training

* [Training ML-Agents](Training-ML-Agents.md)
* [Using TensorBoard to Observe Training](Using-Tensorboard.md)
* [Training Using Concurrent Unity Instances](Training-Using-Concurrent-Unity-Instances.md)
* [Training with Proximal Policy Optimization](Training-PPO.md)
* [Training with Soft Actor-Critic](Training-SAC.md)

### Advanced Training Methods

* [Training with Curriculum Learning](Training-Curriculum-Learning.md)
* [Training with Imitation Learning](Training-Imitation-Learning.md)
* [Training with LSTM](Feature-Memory.md)
* [Training Generalized Reinforcement Learning Agents](Training-Generalized-Reinforcement-Learning-Agents.md)

## Inference

* [Unity Inference Engine](Unity-Inference-Engine.md)

## Help

* [Migrating from earlier versions of ML-Agents](Migrating.md)
* [Frequently Asked Questions](FAQ.md)
* [ML-Agents Glossary](Glossary.md)
* [Limitations](Limitations.md)

## API Docs

* [API Reference](API-Reference.md)
* [How to use the Python API](Python-API.md)
* [Wrapping Learning Environment as a Gym (+Baselines/Dopamine Integration)](../gym-unity/README.md)

## Translations

To make the Unity ML-Agents toolkit accessible to the global research and
Unity developer communities, we're attempting to create and maintain
translations of our documentation. We've started with translating a subset
of the documentation to one language (Chinese), but we hope to continue
translating more pages and to other languages. Consequently,
we welcome any enhancements and improvements from the community.

* [Chinese](localized/zh-CN/)
* [Korean](localized/KR/)

## Deprecated Docs
We no longer use them ourselves and so they may not be up-to-date.
We've decided to keep them up just in case they are helpful to you.

* [Training on the Cloud with Amazon Web Services](Training-on-Amazon-Web-Service.md)
* [Training on the Cloud with Microsoft Azure](Training-on-Microsoft-Azure.md)
* [Using Docker](Using-Docker.md)
* [Installation-Windows](Installation-Windows.md)
