# Unity ML-Agents Toolkit Documentation

## Installation & Set-up

- [Installation](Installation.md)
  - [Using Virtual Environment](Using-Virtual-Environment.md)

## Getting Started

- [Getting Started Guide](Getting-Started.md)
- [ML-Agents Toolkit Overview](ML-Agents-Overview.md)
  - [Background: Unity](Background-Unity.md)
  - [Background: Machine Learning](Background-Machine-Learning.md)
  - [Background: TensorFlow](Background-TensorFlow.md)
- [Example Environments](Learning-Environment-Examples.md)

## Creating Learning Environments

- [Making a New Learning Environment](Learning-Environment-Create-New.md)
- [Designing a Learning Environment](Learning-Environment-Design.md)
  - [Designing Agents](Learning-Environment-Design-Agents.md)
- [Using an Executable Environment](Learning-Environment-Executable.md)

## Training & Inference

- [Training ML-Agents](Training-ML-Agents.md)
  - [Training Configuration File](Training-Configuration-File.md)
  - [Using TensorBoard to Observe Training](Using-Tensorboard.md)
  - [Profiling Trainers](Profiling-Python.md)
- [Unity Inference Engine](Unity-Inference-Engine.md)

## Extending ML-Agents

- [Creating Custom Side Channels](Custom-SideChannels.md)
- [Creating Custom Samplers for Environment Parameter Randomization](Training-ML-Agents.md#defining-a-new-sampler-type)

## Help

- [Migrating from earlier versions of ML-Agents](Migrating.md)
- [Frequently Asked Questions](FAQ.md)
- [ML-Agents Glossary](Glossary.md)
- [Limitations](Limitations.md)

## API Docs

- [API Reference](API-Reference.md)
- [How to use the Python API](Python-API.md)
- [How to use the Unity Environment Registry](Unity-Environment-Registry.md)
- [Wrapping Learning Environment as a Gym (+Baselines/Dopamine Integration)](../gym-unity/README.md)

## Translations

To make the Unity ML-Agents Toolkit accessible to the global research and Unity
developer communities, we're attempting to create and maintain translations of
our documentation. We've started with translating a subset of the documentation
to one language (Chinese), but we hope to continue translating more pages and to
other languages. Consequently, we welcome any enhancements and improvements from
the community.

- [Chinese](localized/zh-CN/)
- [Korean](localized/KR/)

## Deprecated Docs

We no longer use them ourselves and so they may not be up-to-date. We've decided
to keep them up just in case they are helpful to you.

- [Windows Anaconda Installation](Installation-Anaconda-Windows.md)
- [Using Docker](Using-Docker.md)
- [Training on the Cloud with Amazon Web Services](Training-on-Amazon-Web-Service.md)
- [Training on the Cloud with Microsoft Azure](Training-on-Microsoft-Azure.md)
- [Using the Video Recorder](https://github.com/Unity-Technologies/video-recorder)
