//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api UHost ReinstallUHostInstance

package uhost

import (
	"encoding/base64"

	"github.com/ucloud/ucloud-sdk-go/ucloud"
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// ReinstallUHostInstanceRequest is request schema for ReinstallUHostInstance action
type ReinstallUHostInstanceRequest struct {
	request.CommonBase

	// 可用区。参见 [可用区列表](../summary/regionlist.html)
	// Zone *string `required:"false"`

	// UHost实例资源ID 参见 [DescribeUHostInstance](describe_uhost_instance.html)
	UHostId *string `required:"true"`

	// 如果创建UHost实例时LoginMode为Password，则必须填写，如果LoginMode为KeyPair，不需要填写 （密码格式使用BASE64编码；LoginMode不可变更）
	Password *string `required:"false"`

	// 镜像Id，默认使用原镜像 参见 [DescribeImage](describe_image.html)
	ImageId *string `required:"false"`

	// 系统盘大小。 单位：GB， 范围[20,100]， 步长：10
	BootDiskSpace *int `required:"false"`

	// 是否保留数据盘，保留：Yes，不报留：No， 默认：Yes；如果是从Windows重装为Linux或反之，则无法保留数据盘
	ReserveDisk *string `required:"false"`

	// 云灾备指明191
	ResourceType *int `required:"false"`

	// 针对非私有子网主机，可自定义DNS。n可为0-2
	DNSServers []string `required:"false"`
}

// ReinstallUHostInstanceResponse is response schema for ReinstallUHostInstance action
type ReinstallUHostInstanceResponse struct {
	response.CommonBase

	// UHost实例资源ID
	UhostId string
}

// NewReinstallUHostInstanceRequest will create request of ReinstallUHostInstance action.
func (c *UHostClient) NewReinstallUHostInstanceRequest() *ReinstallUHostInstanceRequest {
	req := &ReinstallUHostInstanceRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// ReinstallUHostInstance - 重新安装指定UHost实例的操作系统
func (c *UHostClient) ReinstallUHostInstance(req *ReinstallUHostInstanceRequest) (*ReinstallUHostInstanceResponse, error) {
	var err error
	var res ReinstallUHostInstanceResponse
	var reqImmutable = *req
	reqImmutable.Password = ucloud.String(base64.StdEncoding.EncodeToString([]byte(ucloud.StringValue(req.Password))))

	err = c.Client.InvokeAction("ReinstallUHostInstance", &reqImmutable, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
