//Code is generated by ucloud code generator, don't modify it by hand, it will cause undefined behaviors.
//go:generate ucloud-gen-go-api VPC DescribeSubnet

package vpc

import (
	"github.com/ucloud/ucloud-sdk-go/ucloud/request"
	"github.com/ucloud/ucloud-sdk-go/ucloud/response"
)

// DescribeSubnetRequest is request schema for DescribeSubnet action
type DescribeSubnetRequest struct {
	request.CommonBase

	// [公共参数] 地域。 参见 [地域和可用区列表](../summary/regionlist.html)
	// Region *string `required:"true"`

	// [公共参数] 项目ID。不填写为默认项目，子帐号必须填写。 请参考[GetProjectList接口](../summary/get_project_list.html)
	// ProjectId *string `required:"false"`

	// 子网id数组，适用于一次查询多个子网信息
	SubnetIds []string `required:"false"`

	// 子网id，适用于一次查询一个子网信息
	SubnetId *string `required:"false"`

	// VPC资源id
	VPCId *string `required:"false"`

	// 业务组名称，默认为Default
	Tag *string `required:"false"`

	// 业务组
	BusinessId *string `required:"false"`

	// 偏移量，默认为0
	Offset *int `required:"false"`

	// 列表长度，默认为20
	Limit *int `required:"false"`
}

// DescribeSubnetResponse is response schema for DescribeSubnet action
type DescribeSubnetResponse struct {
	response.CommonBase

	// 子网总数量
	TotalCount int

	// 子网信息数组
	DataSet []VPCSubnetInfoSet
}

// NewDescribeSubnetRequest will create request of DescribeSubnet action.
func (c *VPCClient) NewDescribeSubnetRequest() *DescribeSubnetRequest {
	req := &DescribeSubnetRequest{}

	// setup request with client config
	c.Client.SetupRequest(req)

	// setup retryable with default retry policy (retry for non-create action and common error)
	req.SetRetryable(true)
	return req
}

// DescribeSubnet - 获取子网信息
func (c *VPCClient) DescribeSubnet(req *DescribeSubnetRequest) (*DescribeSubnetResponse, error) {
	var err error
	var res DescribeSubnetResponse

	err = c.Client.InvokeAction("DescribeSubnet", req, &res)
	if err != nil {
		return &res, err
	}

	return &res, nil
}
