---
layout: "docs"
page_title: "strrev - Functions - Configuration Language"
sidebar_current: "configuration-functions-string-strrev"
description: |-
  The strrev function reverses a string.
---

# `strrev` Function

`strrev` reverses the characters in a string.
Note that the characters are treated as _Unicode characters_ (in technical terms, Unicode [grapheme cluster boundaries](https://unicode.org/reports/tr29/#Grapheme_Cluster_Boundaries) are respected).

```hcl
strrev(string)
```

## Examples

```
> strrev("hello")
olleh
> strrev("a ☃")
☃ a
```

## Related Functions

* [`reverse`](../collection/reverse.html) reverses a sequence.
