local _, ns = ...
local B, C, L, DB = unpack(ns)
local module = B:GetModule("Maps")

-- https://github.com/fang2hou/WindToolsScripts/blob/master/MapOverlay
module.RawMapData = {
	[119] = { -- 北风苔原
		["W186H276X272Y237"]     = "270870,270743",
		["W203H209X662Y11"]      = "270848",
		["W244H214X325Y140"]     = "270785",
		["W244H319X397Y66"]      = "270900,270819",
		["W259H302X457Y264"]     = "270903,270781,270794,270855",
		["W260H278X329Y237"]     = "270851,270871,270795,270769",
		["W267H378X153Y238"]     = "270822,270894,270835,270784",
		["W289H279X707Y181"]     = "270765,270824,270887,270801",
		["W290H292X712Y15"]      = "270826,270865,270759,270763",
		["W375H342X480Y0"]       = "270869,270890,270764,270762",
		["W382H258X293Y383"]     = "270761,270879,270880,270787",
		["W385H316X509Y214"]     = "270898,270840,270899,270812",
		["W396H203X314Y0"]       = "270806,270810",
		["W460H381X50Y0"]        = "270821,270758,270797,270775",
	},
	[120] = { -- 龙骨荒野
		["W188H211X374Y208"]     = "271192",
		["W196H218X543Y362"]     = "271358",
		["W213H219X403Y0"]       = "271232",
		["W214H261X614Y358"]     = "271313,271133",
		["W226H212X661Y264"]     = "271378",
		["W229H259X487Y0"]       = "271146,271257",
		["W229H299X42Y187"]      = "271267,271201",
		["W235H337X134Y165"]     = "271254,271233",
		["W235H354X569Y7"]       = "271149,271222",
		["W236H218X258Y203"]     = "271170",
		["W258H225X433Y118"]     = "271239,271157",
		["W299H278X703Y7"]       = "271351,271270,271175,271330",
		["W301H286X698Y332"]     = "271280,271346,271164,271387",
		["W304H203X256Y104"]     = "271352,271244",
		["W306H242X210Y0"]       = "271187,271231",
		["W311H272X691Y160"]     = "271333,271199,271364,271162",
		["W317H353X453Y219"]     = "271205,271248,271252,271236",
		["W356H300X217Y313"]     = "271322,271298,271290,271337",
	},
	[121] = { -- 灰熊丘陵
		["W249H235X232Y129"]     = "271764",
		["W274H207X18Y461"]      = "271794,271778",
		["W278H290X217Y244"]     = "271801,271773,271779,271806",
		["W283H247X176Y421"]     = "271789,271812",
		["W294H227X358Y187"]     = "271785,271817",
		["W324H265X548Y137"]     = "271790,271765,271766,271767",
		["W328H260X331Y32"]      = "271809,271771,271772,271776",
		["W329H246X509Y0"]       = "271769,271770",
		["W332H294X17Y307"]      = "271768,271783,271795,271810",
		["W351H284X607Y41"]      = "271791,271807,271774,271796",
		["W356H224X7Y207"]       = "271781,271784",
		["W382H285X0Y46"]        = "271792,271775,271813,271797",
		["W455H400X547Y257"]     = "271798,271780,271814,271799",
		["W475H362X312Y294"]     = "271803,271788,271816,271805",
	},
	[122] = { -- 嚎风峡湾
		["W174H173X576Y170"]     = "271946",
		["W177H191X342Y351"]     = "271992",
		["W178H208X595Y240"]     = "271945",
		["W181H178X490Y161"]     = "271993",
		["W187H263X397Y208"]     = "271980,271994",
		["W193H201X668Y223"]     = "271950",
		["W213H256X283Y203"]     = "271976",
		["W222H168X222Y100"]     = "271959",
		["W223H209X354Y0"]       = "271957",
		["W223H338X664Y25"]      = "271956,271974",
		["W232H216X585Y336"]     = "271941",
		["W238H232X343Y108"]     = "271984",
		["W242H189X225Y0"]       = "271954",
		["W244H305X621Y327"]     = "271969,271989",
		["W248H382X477Y216"]     = "271985,271968",
		["W251H192X490Y0"]       = "271970",
		["W263H265X99Y37"]       = "271940,271975,271953,271991",
		["W266H210X420Y57"]      = "271952,271967",
		["W284H308X415Y360"]     = "271997,271998,271963,271964",
		["W298H306X572Y0"]       = "271977,271978,271979,271958",
		["W333H265X99Y278"]      = "271962,271987,271983,271988",
		["W347H220X90Y180"]      = "271986,271960",
		["W350H258X168Y410"]     = "271965,271966,271972,271973",
	},
	[123] = { -- 冰冠冰川
		["W204H268X0Y167"]       = "254677,254678",
		["W219H283X218Y291"]     = "254688,254689",
		["W223H207X444Y276"]     = "254695",
		["W223H399X321Y15"]      = "254690,254691",
		["W227H210X327Y305"]     = "254687",
		["W238H240X217Y50"]      = "254692",
		["W245H239X690Y267"]     = "254679",
		["W248H243X538Y181"]     = "254684",
		["W269H217X715Y390"]     = "254693,254694",
		["W283H231X558Y329"]     = "254685,254686",
		["W300H343X626Y31"]      = "254680,254681,254682,254683",
		["W308H202X392Y466"]     = "254659,254660",
		["W308H212X342Y392"]     = "254657,254658",
		["W314H224X616Y30"]      = "294026,294027",
		["W373H375X355Y37"]      = "254653,254654,254655,254656",
		["W393H474X22Y122"]      = "254673,254674,254675,254676",
	},
	[124] = { -- 索拉查盆地
		["W207H235X427Y244"] = "272524",
		["W233H286X705Y236"] = "272529,272506",
		["W239H313X265Y355"] = "272530,272516",
		["W249H248X172Y135"] = "272507",
		["W268H288X138Y58"] = "272517,272534,272496,272502",
		["W293H229X396Y51"] = "272500,272501",
		["W294H327X308Y34"] = "272523,272487,272539,272532",
		["W312H369X501Y134"] = "272494,272495,272504,272533",
		["W322H265X596Y92"] = "272521,272515,272522,272499",
		["W329H293X76Y375"] = "272509,272491,272520,272484",
		["W455H316X82Y186"] = "272535,272518,272490,272519",
		["W468H329X359Y339"] = "272498,272531,272510,272541",
	},
	[125] = { -- 风暴峭壁
		["W169H164X239Y301"]     = "272922",
		["W180H239X214Y144"]     = "272933",
		["W182H270X570Y113"]     = "272927,272910",
		["W184H191X395Y470"]     = "272909",
		["W205H232X162Y143"]     = "272920",
		["W210H179X316Y296"]     = "272945",
		["W221H200X108Y206"]     = "272906",
		["W228H158X98Y318"]      = "272924",
		["W244H220X134Y429"]     = "272919",
		["W251H200X242Y468"]     = "272921",
		["W305H298X339Y370"]     = "272904,272925,272926,272952",
		["W306H484X627Y179"]     = "272934,272923,272908,272930",
		["W309H383X481Y285"]     = "272939,272953,272905,272935",
		["W322H195X109Y375"]     = "272948,272950",
		["W363H341X292Y122"]     = "272912,272913,272914,272946",
		["W369H265X218Y0"]       = "272943,272944,272931,272917",
	},
	[126] = { -- 祖达克
		["W218H291X174Y191"]     = "273324,273292",
		["W237H248X288Y168"]     = "273329",
		["W247H304X431Y127"]     = "273322,273320",
		["W249H258X479Y241"]     = "273304,273305",
		["W261H288X607Y251"]     = "273309,273286,273310,273328",
		["W265H257X533Y345"]     = "273296,273300,273285,273287",
		["W266H254X289Y287"]     = "273330,273291",
		["W272H268X0Y247"]       = "273318,273298,273336,273303",
		["W286H265X326Y358"]     = "273311,273297,273331,273317",
		["W302H231X380Y437"]     = "273323,273289",
		["W307H256X7Y412"]       = "273326,273333",
		["W311H317X575Y88"]      = "273325,273307,273308,273319",
		["W321H305X181Y363"]     = "273312,273332,273282,273302",
		["W336H297X629Y0"]       = "273295,273301,273321,273288",
	},
	[127] = {
		["W512H416X252Y252"]     = "272721,272732,272715,272722",
		["W512H512X251Y4"]       = "272716,272728,272723,272733",
	},
	[132] = { -- 晶歌森林
		["W252H260X0Y91"]        = "270966,271005",
		["W264H303X0Y176"]       = "270987,270962,270973,270997",
		["W288H222X0Y0"]         = "253268,271000",
		["W416H424X0Y244"]       = "270970,270961,270971,270996",
		["W446H369X536Y40"]      = "253267,270960,270995,270989",
		["W502H477X500Y105"]     = "253269,270985,253270,270986",
		["W544H668X129Y0"]       = "253264,271003,270968,270965,253265,253266,271002,271004,270984",
		["W558H285X444Y383"]     = "253271,253272,270974,270975,271001,270980",
	},
	[179] = { -- 失落群岛
		["W142H133X377Y359"] = "440843",
		["W156H142X433Y11"] = "440842",
		["W159H230X264Y144"] = "440863",
		["W168H205X416Y368"] = "440853",
		["W172H175X189Y408"] = "440859",
		["W173H180X351Y21"] = "440840",
		["W177H172X129Y348"] = "440838",
		["W190H186X416Y131"] = "440860",
		["W210H258X492Y161"] = "440852,440851",
		["W212H193X279Y68"] = "440862",
		["W212H216X440Y452"] = "440854",
		["W221H211X508Y345"] = "440850",
		["W222H190X244Y458"] = "440841",
		["W231H216X213Y325"] = "440861",
		["W248H209X462Y43"] = "440839",
		["W305H288X323Y185"] = "440855,440856,440857,440858",
		["W350H517X581Y21"] = "440844,440845,440846,440847,440848,440849",
	},
	[184] = { -- 吉尔尼斯
		["W177H219X293Y449"] = "438477",
		["W194H236X167Y352"] = "438476",
		["W210H166X261Y427"] = "438440",
		["W222H268X393Y386"] = "438482,438483",
		["W244H241X141Y202"] = "438475",
		["W267H314X387Y0"] = "438484,438485,438486,438487",
		["W280H224X504Y394"] = "438498,438499",
		["W280H342X298Y95"] = "438478,438479,438480,438481",
		["W281H351X639Y43"] = "438443,438444,438445,438446",
		["W282H263X483Y210"] = "438447,438448,438449,438450",
		["W282H298X482Y14"] = "438488,438489,438490,438491",
		["W286H178X272Y333"] = "438441,438442",
		["W321H203X516Y465"] = "438492,438493",
		["W328H336X160Y0"] = "438500,438501,438502,438503",
		["W350H345X652Y290"] = "438494,438495,438496,438497",
	},
	[199] = { -- 科赞
		["W1002H664X0Y4"] = "466830,466834,466835,466836,466837,466838,466839,466840,466841,466831,466832,466833",
		["W168H213X317Y232"] = "440632",
		["W250H307X383Y260"] = "440626,440627",
		["W303H452X0Y41"] = "440618,440619,440620,440621",
		["W351H301X180Y367"] = "440610,440611,440612,440613",
		["W354H360X586Y308"] = "440622,440623,440624,440625",
		["W376H343X98Y325"] = "440614,440615,440616,440617",
		["W592H202X219Y108"] = "440633,440634,440635",
		["W694H290X163Y148"] = "440604,440605,440606,440607,440608,440609",
	},
	[204] = { -- 南贫瘠之地
		["W269H211X398Y457"] = "440745,440746",
		["W384H248X274Y307"] = "440747,440748",
		["W216H172X423Y251"] = "440749",
		["W242H195X269Y436"] = "440750",
		["W218H178X300Y64"] = "440753",
		["W280H279X548Y147"] = "440754,440755,440756,440757",
		["W285H171X244Y286"] = "440759,440760",
		["W355H226X289Y117"] = "440761,440762",
		["W254H214X267Y196"] = "440763",
		["W315H170X201Y0"] = "440751,440752",
	},
	[206] = { -- 瓦丝琪尔，科尔普萨之森
		["W220H189X528Y228"] = "440974",
		["W227H207X399Y280"] = "440977",
		["W278H315X210Y35"] = "440984,440985,440986,440987",
		["W291H206X380Y43"] = "440982,440983",
		["W311H217X451Y325"] = "440975,440976",
		["W316H267X456Y401"] = "440978,440979,440980,440981",
		["W340H225X365Y162"] = "440988,440989",
	},
	[209] = { -- 瓦丝琪尔，烁光海床
		["W225H250X415Y183"] = "440973",
		["W267H374X266Y280"] = "440955,440956,440957,440958",
		["W298H251X315Y110"] = "440963,440964",
		["W306H293X162Y210"] = "440969,440970,440971,440972",
		["W363H262X275Y32"] = "440959,440960,440961,440962",
		["W370H385X412Y283"] = "440965,440966,440967,440968",
		["W371H394X50Y263"] = "440947,440948,440949,440950",
		["W491H470X497Y0"] = "440951,440952,440953,440954",
	},
	[210] = { -- 瓦丝琪尔，无底海渊
		["W197H223X554Y175"] = "440998",
		["W272H180X270Y222"] = "440992,440993",
		["W286H269X460Y261"] = "440994,440995,440996,440997",
		["W335H223X407Y445"] = "440990,440991",
		["W339H278X400Y0"] = "441003,441004,441005,441006",
		["W349H361X217Y268"] = "440999,441000,441001,441002",
		["W480H319X150Y32"] = "441007,441008,441009,441010",
	},
	[212] = { -- 深岩之洲
		["W237H198X297Y384"] = "438312",
		["W274H156X434Y0"] = "438306,438307",
		["W292H285X458Y383"] = "438294,438295,438296,438297",
		["W355H345X287Y177"] = "438298,438299,438300,438301",
		["W370H285X0Y146"] = "438280,438281,438282,438283",
		["W371H354X0Y314"] = "438290,438291,438292,438293",
		["W378H359X20Y0"] = "438276,438277,438278,438279",
		["W411H248X570Y420"] = "438310,438311",
		["W430H230X141Y438"] = "438308,438309",
		["W454H343X549Y297"] = "438272,438273,438274,438275",
		["W462H400X540Y12"] = "438268,438269,438270,438271",
		["W467H273X85Y0"] = "438302,438303,438304,438305",
		["W516H287X448Y0"] = "438284,438285,438286,438287,438288,438289",
	},
	[215] = { -- 荆棘谷海角
		["W225H255X289Y341"] = "438740",
		["W271H204X528Y73"] = "438741,438742",
		["W238H260X345Y0"] = "438743,438744",
		["W240H264X471Y404"] = "438747,438748",
		["W253H242X408Y248"] = "438749",
		["W246H221X292Y213"] = "438750",
		["W184H176X533Y181"] = "438751",
		["W155H221X468Y119"] = "438752",
		["W244H209X452Y0"] = "438753",
		["W236H276X340Y392"] = "438754,438755",
		["W356H221X208Y116"] = "438745,438746",
	},
	[216] = { -- 吉尔尼斯2
		["W177H219X293Y449"] = "438541",
		["W194H236X167Y352"] = "438540",
		["W210H166X261Y427"] = "438504",
		["W222H268X393Y386"] = "438546,438547",
		["W244H241X141Y202"] = "438539",
		["W250H298X482Y14"] = "438552,438553",
		["W267H314X387Y0"] = "438548,438549,438550,438551",
		["W280H224X504Y394"] = "438562,438563",
		["W280H342X298Y95"] = "438542,438543,438544,438545",
		["W281H351X639Y43"] = "438507,438508,438509,438510",
		["W282H263X483Y210"] = "438523,438524,438525,438526",
		["W286H178X272Y333"] = "438505,438506",
		["W321H203X516Y465"] = "438556,438557",
		["W328H336X160Y0"] = "438564,438565,438566,438567",
		["W350H345X652Y290"] = "438558,438559,438560,438561",
	},
	[220] = { -- 吉尔尼斯3
		["W177H219X293Y449"] = "438605",
		["W194H236X167Y352"] = "438604",
		["W210H166X261Y427"] = "438568",
		["W222H268X393Y386"] = "438610,438611",
		["W244H241X141Y202"] = "438603",
		["W267H314X387Y0"] = "438612,438613,438614,438615",
		["W280H224X504Y394"] = "438626,438627",
		["W280H342X298Y95"] = "438606,438607,438608,438609",
		["W281H351X639Y43"] = "438571,438572,438573,438574",
		["W282H263X483Y210"] = "438587,438588,438589,438590",
		["W282H298X482Y14"] = "438616,438617,438618,438619",
		["W286H178X272Y333"] = "438569,438570",
		["W321H203X516Y465"] = "438620,438621",
		["W328H336X160Y0"] = "438628,438629,438630,438631",
		["W350H345X652Y290"] = "438622,438623,438624,438625",
	},
	[227] = { -- 海加尔山
		["W270H173X303Y197"] = "438698,438699",
		["W270H300X320Y5"] = "438686,438687,438688,438689,438686,438687,438688,438689,438686,438687,438688,438689",
		["W272H334X622Y320"] = "438700,438701,438702,438703",
		["W277H232X139Y436"] = "438722,438723",
		["W282H418X6Y78"] = "438690,438691,438692,438693",
		["W291H321X116Y17"] = "438724,438725,438726,438727",
		["W320H471X682Y128"] = "438694,438695,438696,438697",
		["W365H264X411Y216"] = "438732,438733,438734,438735",
		["W419H290X318Y378"] = "438736,438737,438738,438739",
		["W441H319X52Y253"] = "438728,438729,438730,438731,438728,438729,438730,438731",
		["W537H323X392Y0"] = "438716,438717,438718,438719,438720,438721",
	},
	[228] = { -- 吉尔尼斯废墟
		["W1002H668X0Y0"] = "464052,464056,464057,464058,464059,464060,464061,464062,464063,464053,464054,464055,464052,464056,464057,464058,464059,464060,464061,464062,464063,464053,464054,464055,464052,464056,464057,464058,464059,464060,464061,464062,464063,464053,464054,464055,464052,464056,464057,464058,464059,464060,464061,464062,464063,464053,464054,464055,464052,464056,464057,464058,464059,464060,464061,464062,464063,464053,464054,464055",
	},
	[252] = { -- 暮光高地2
		["W143H141X344Y89"] = "458560",
		["W165H199X327Y356"] = "458579",
		["W174H190X291Y89"] = "458554",
		["W175H180X269Y179"] = "458572",
		["W177H159X302Y306"] = "458587",
		["W182H195X370Y447"] = "458548",
		["W191H198X205Y232"] = "458589",
		["W194H170X543Y220"] = "458555",
		["W197H218X395Y367"] = "458552",
		["W198H201X622Y169"] = "458570",
		["W199H212X312Y192"] = "458574",
		["W203H208X387Y268"] = "458547",
		["W206H182X296Y0"] = "458569",
		["W211H210X498Y121"] = "458571",
		["W214H190X358Y0"] = "458588",
		["W215H157X416Y205"] = "458546",
		["W215H181X499Y265"] = "458553",
		["W220H227X697Y403"] = "458558",
		["W226H232X654Y0"] = "458573",
		["W230H276X83Y223"] = "458556,458557",
		["W238H229X374Y93"] = "458580",
		["W239H232X482Y330"] = "458559",
		["W251H207X631Y245"] = "458551",
		["W260H202X610Y345"] = "458581,458582",
		["W283H206X76Y120"] = "458549,458550",
		["W308H267X482Y0"] = "458561,458562,458563,458564",
		["W324H264X71Y16"] = "458583,458584,458585,458586",
		["W342H288X436Y380"] = "458565,458566,458567,458568",
		["W361H354X151Y314"] = "458575,458576,458577,458578",
	},
	[260] = { -- 奥丹姆
		["W150H159X545Y193"] = "458658",
		["W151H144X479Y215"] = "458668",
		["W160H193X406Y174"] = "458641",
		["W161H236X647Y15"] = "458663",
		["W164H185X471Y277"] = "458634",
		["W196H170X551Y121"] = "458646",
		["W202H169X341Y402"] = "458635",
		["W203H215X542Y0"] = "458638",
		["W203H249X217Y289"] = "458653",
		["W206H204X657Y349"] = "458664",
		["W209H254X407Y384"] = "458643",
		["W213H195X656Y473"] = "458665",
		["W228H227X411Y67"] = "458650",
		["W233H321X527Y291"] = "458639,458640",
		["W237H194X583Y162"] = "458642",
		["W237H316X752Y170"] = "458661,458662",
		["W249H243X264Y136"] = "458649",
		["W269H203X340Y282"] = "458647,458648",
		["W269H242X599Y184"] = "458636,458637",
		["W270H229X229Y433"] = "458666,458667",
		["W278H173X365Y0"] = "458651,458652",
		["W296H209X132Y127"] = "458659,458660",
		["W312H289X28Y221"] = "458654,458655,458656,458657",
		["W400H224X110Y0"] = "458644,458645",
	},
	[338] = { -- 暮光高地
		["W143H141X344Y89"] = "458604",
		["W165H199X327Y356"] = "458623,458623",
		["W174H190X291Y89"] = "458598",
		["W175H180X269Y179"] = "458616",
		["W177H159X302Y306"] = "458631",
		["W182H195X370Y447"] = "458592",
		["W191H198X205Y232"] = "458633",
		["W194H170X543Y220"] = "458599",
		["W197H218X395Y367"] = "458596",
		["W198H201X622Y169"] = "458614",
		["W199H212X312Y192"] = "458618",
		["W203H208X387Y268"] = "458591",
		["W206H182X296Y0"] = "458613",
		["W211H210X498Y121"] = "458615",
		["W214H190X358Y0"] = "458632",
		["W215H157X416Y205"] = "458590",
		["W215H181X499Y265"] = "458597",
		["W220H227X697Y403"] = "458602",
		["W226H232X654Y0"] = "458617",
		["W230H276X83Y223"] = "458600,458601",
		["W238H229X374Y93"] = "458624",
		["W239H232X482Y330"] = "458603",
		["W251H207X631Y245"] = "458595",
		["W260H202X610Y345"] = "458625,458626",
		["W283H206X76Y120"] = "458593,458594",
		["W308H267X482Y0"] = "458605,458606,458607,458608",
		["W324H264X71Y16"] = "458627,458628,458629,458630",
		["W342H288X436Y380"] = "458609,458610,458611,458612",
		["W361H354X151Y314"] = "458619,458620,458621,458622",
	},
	[339] = { -- 安其拉
		["W887H668X115Y0"] = "462974,462978,462979,462980,462981,462982,462983,462984,462985,462975,462976,462977",
	},
	[498] = { -- 尘泥沼泽2
		["W206H200X656Y21"] = "656197",
		["W270H353X428Y0"] = "656230,656231,656232,656233",
		["W279H301X358Y169"] = "656202,656203,656204,656205",
		["W305H247X542Y223"] = "656224,656225",
		["W317H230X137Y188"] = "656222,656223",
		["W344H183X199Y0"] = "656198,656199",
		["W384H249X133Y59"] = "656200,656201",
		["W433H351X109Y313"] = "656218,656219,656220,656221",
		["W436H299X359Y369"] = "656226,656227,656228,656229",
	},
	[1194] = { -- 杜隆塔尔
		["W254H258X304Y312"] = "271443,440585",
		["W192H184X457Y406"] = "271426",
		["W330H255X429Y413"] = "271437,440582",
		["W210H200X462Y298"] = "271440",
		["W224H227X431Y157"] = "271421",
		["W248H158X302Y264"] = "271422",
		["W220H218X295Y48"] = "271439",
		["W236H196X415Y60"] = "271428",
		["W208H157X438Y0"] = "271427",
		["W259H165X309Y0"] = "271435,271442",
		["W162H157X399Y440"] = "440583",
		["W244H222X282Y174"] = "440584",
		["W259H165X309Y0"] = "271435,271442",
	},
	[1200] = { -- 莫高雷
		["W172H205X248Y321"] = "272176",
		["W174H185X449Y340"] = "272180",
		["W186H185X514Y43"] = "272169",
		["W186H216X448Y101"] = "272177",
		["W187H165X435Y224"] = "272185",
		["W190H172X331Y0"] = "272172",
		["W201H167X333Y202"] = "272178",
		["W208H300X530Y138"] = "272186,457475",
		["W218H192X226Y220"] = "272181",
		["W222H202X400Y0"] = "272179",
		["W237H184X201Y0"] = "457473",
		["W260H243X527Y291"] = "272170,457474",
		["W302H223X319Y273"] = "272173,457470",
		["W373H259X208Y62"] = "272187,272171,457476,457477",
		["W446H264X286Y401"] = "272168,272165,457471,457472",
	},
	[1202] = { -- 贫瘠之地
		["W278H209X511Y7"] = "270553,438214",
		["W257H249X403Y6"] = "270564,438223",
		["W241H195X290Y104"] = "270554",
		["W283H270X116Y57"] = "270572,438218,438219,438220",
		["W446H256X100Y208"] = "270560,438221",
		["W243H217X448Y127"] = "270584",
		["W207H332X555Y129"] = "270569,438215",
		["W239H231X481Y254"] = "270574",
		["W233H193X362Y275"] = "270559",
		["W336H289X344Y379"] = "270565,438224,438225,438226",
		["W219H175X547Y379"] = "270585",
		["W315H212X556Y456"] = "270573,438222",
		["W261H216X258Y6"] = "438216,438217",
		["W377H325X152Y318"] = "438227,438228,438229,438230",
	},
	[1205] = {
		["W285H230X276Y0"]   = "768728,768729",
		["W235H200X462Y77"]  = "768753",
		["W300H300X26Y262"]  = "769201,769202,769203,769204",
		["W330H265X44Y403"]  = "768734,768735,768736,768737",
		["W160H175X225Y478"] = "768731",
		["W165H197X314Y471"] = "768752",
		["W190H170X317Y372"] = "768732",
		["W200H200X406Y279"] = "768730",
		["W255H255X270Y197"] = "768739",
		["W255H320X462Y307"] = "768744,768745",
		["W280H240X334Y162"] = "768723,769200",
		["W195H288X399Y380"] = "768721,768722",
		["W220H280X196Y131"] = "768738,769205",
		["W350H370X626Y253"] = "768717,768718,768719,768720",
		["W370H300X549Y105"] = "768748,768749,768750,768751",
	},
	[1206] = { -- 阿拉希高地
		["W220H287X85Y24"] = "270347,438168",
		["W227H268X132Y105"] = "270351,438179",
		["W249H278X171Y123"] = "270349,438167",
		["W284H306X21Y269"] = "270358,438181,438182,438183",
		["W273H268X77Y400"] = "270361,438170,438171,438172",
		["W228H227X201Y312"] = "270346",
		["W237H252X261Y416"] = "270348",
		["W252H258X327Y367"] = "270342,438166",
		["W196H270X293Y145"] = "270352,438180",
		["W260H220X476Y359"] = "270353,438184",
		["W306H248X430Y249"] = "270343,438175",
		["W210H227X404Y144"] = "270350",
		["W183H238X506Y126"] = "270360",
		["W270H271X581Y118"] = "270336,438176,438177,438178",
		["W215H188X332Y273"] = "438169",
		["W212H305X0Y144"] = "438173,438174",
	},
	[1207] = { -- 荒芜之地
		["W342H353X230Y315"] = "270522,270550,270528,270536",
		["W285H223X230Y68"] = "270543,442224",
		["W252H353X0Y66"] = "270529,442225",
		["W339H347X0Y281"] = "270520,442228,442229,442230",
		["W236H260X504Y19"] = "270530,442231",
		["W209H196X411Y116"] = "270532",
		["W469H613X533Y55"] = "270534,270551,270546,270535,442236,442237",
		["W214H285X144Y99"] = "270525,270521",
		["W266H210X336Y0"] = "442238,442239",
		["W328H313X175Y178"] = "442232,442233,442234,442235",
		["W252H353X0Y66"] = "270529,442225",
	},
	[1209] = { -- 诅咒之地
		["W272H206X258Y0"] = "391435,438231",
		["W295H205X530Y6"] = "391432,438232",
		["W218H183X459Y97"] = "391430",
		["W238H195X225Y110"] = "391425",
		["W235H188X327Y182"] = "391434",
		["W308H226X144Y175"] = "391429,391428",
		["W168H170X375Y102"] = "391431",
		["W195H199X436Y0"] = "438233",
		["W240H270X578Y91"] = "438234,438235",
		["W233H266X386Y374"] = "438236,438237",
		["W199H191X333Y474"] = "438238",
		["W370H298X368Y179"] = "438239,438240,438241,438242",
		["W268H354X533Y268"] = "438243,438244,438245,438246",
		["W348H357X132Y311"] = "438247,438248,438249,438250",
	},
	[1210] = { -- 提瑞斯法林地
		["W250H279X752Y150"] = "272999,440935",
		["W161H234X692Y99"] = "272996",
		["W175H210X686Y232"] = "273000",
		["W242H179X594Y324"] = "273006",
		["W210H292X573Y122"] = "273009,273002",
		["W190H214X477Y129"] = "273020",
		["W199H182X480Y252"] = "273015",
		["W212H177X418Y317"] = "273016",
		["W225H281X347Y325"] = "273003,440921",
		["W285H260X324Y90"] = "273019,440914,440915,440916",
		["W286H225X201Y192"] = "273017,440930",
		["W431H407X9Y207"] = "273001,440918,440919,440920",
		["W179H169X389Y255"] = "440917",
		["W390H267X423Y359"] = "440922,440923,440924,440925",
		["W262H262X740Y47"] = "440926,440927,440928,440929",
		["W293H338X709Y330"] = "440931,440932,440933,440934",
	},
	[1211] = { -- 银松森林
		["W227H172X236Y0"] = "272610",
		["W352H302X581Y15"] = "272600,440729,440730,440731",
		["W218H200X341Y157"] = "272620",
		["W217H198X483Y212"] = "272598",
		["W251H167X312Y249"] = "272616",
		["W283H243X509Y250"] = "272614,440725",
		["W179H165X337Y337"] = "272613",
		["W409H162X318Y506"] = "272609,440743",
		["W318H263X505Y405"] = "272599,440726,440727,440728",
		["W361H175X445Y0"] = "440732,440733",
		["W174H199X323Y68"] = "440735",
		["W281H345X147Y0"] = "440736,440737,440738,440739",
		["W255H180X349Y429"] = "440740",
		["W176H152X471Y156"] = "440741",
		["W162H172X461Y77"] = "440744",
	},
	[1212] = { -- 西瘟疫之地
		["W492H314X510Y354"] = "273119,273092,273112,273093",
		["W194H208X601Y390"] = "273107",
		["W368H220X261Y448"] = "273108,273101",
		["W316H316X48Y235"] = "273120,441020,441021,441022",
		["W241H212X229Y228"] = "273113",
		["W169H195X472Y332"] = "273102",
		["W359H182X231Y123"] = "273114,441017",
		["W432H271X235Y0"] = "273095,273111,273100,273090",
		["W241H252X495Y213"] = "273094",
		["W185H230X551Y151"] = "273121",
		["W311H436X533Y0"] = "273122,273103,441023,441024",
		["W464H325X96Y343"] = "441011,441012,441013,441014",
		["W325H192X300Y232"] = "441015,441016",
	},
	[1213] = { -- 东瘟疫之地
		["W228H273X774Y102"] = "442674,442675",
		["W238H231X382Y151"] = "271523",
		["W186H213X493Y289"] = "271544",
		["W202H191X258Y351"] = "271548",
		["W248H206X211Y462"] = "271514",
		["W181H176X541Y184"] = "271542",
		["W266H241X462Y427"] = "271532,442676",
		["W196H220X687Y271"] = "271533",
		["W265H232X570Y61"] = "271520,442678",
		["W250H192X401Y69"] = "271521",
		["W328H253X144Y40"] = "271518,271527",
		["W277H175X351Y0"] = "271535,442679",
		["W264H373X738Y295"] = "442680,442681,442682,442683",
		["W310H178X118Y0"] = "271529,442684",
		["W258H320X0Y10"] = "271522,442685,442686,442687",
		["W274H216X183Y211"] = "271536,442688",
		["W182H320X383Y348"] = "442692,442693",
		["W202H202X133Y335"] = "271551",
		["W297H299X650Y55"] = "271537,442689,442690,442691",
		["W177H266X595Y263"] = "271543,271530",
		["W280H211X56Y457"] = "271512,442694",
		["W262H526X0Y100"] = "271538,271513,442695,442696,442697,442698",
		["W214H254X651Y414"] = "271553",
		["W286H176X528Y0"] = "271554,442699",
	},
	[1214] = { -- 希尔斯布莱德丘陵
		["W180H182X287Y399"] = "450628",
		["W447H263X555Y68"] = "450629,450630,450631,450632",
		["W135H160X426Y224"] = "450633",
		["W134H124X463Y101"] = "450634",
		["W316H238X102Y137"] = "450635,450636",
		["W258H113X341Y0"] = "450637,450638",
		["W147H160X425Y279"] = "450639",
		["W269H258X542Y410"] = "450640,450641,450642,450643",
		["W437H451X565Y217"] = "450644,450645,450646,450647",
		["W155H147X451Y140"] = "450648",
		["W116H129X344Y254"] = "450649",
		["W171H136X359Y191"] = "450650",
		["W302H175X191Y302"] = "450651,450652",
		["W250H167X194Y216"] = "450665",
		["W158H169X321Y42"] = "450666",
		["W204H244X502Y373"] = "450667",
		["W144H139X200Y505"] = "450668",
		["W189H181X347Y85"] = "450669",
		["W148H120X413Y55"] = "450670",
		["W148H146X484Y166"] = "450671",
		["W312H254X59Y310"] = "450672,450673",
		["W229H219X383Y352"] = "450674",
		["W275H193X505Y44"] = "450675,450676",
		["W165H203X494Y226"] = "450677",
		["W105H148X390Y255"] = "450678",
		["W212H160X441Y0"] = "450679",
		["W302H175X191Y302"] = "450651,450652",
	},
	[1215] = { -- 辛特兰
		["W238H267X0Y236"] = "271917,440597",
		["W191H278X133Y105"] = "271927,440600",
		["W241H211X220Y181"] = "271928",
		["W240H196X220Y379"] = "271937",
		["W199H212X286Y269"] = "271934",
		["W208H204X367Y159"] = "271910",
		["W199H199X390Y252"] = "271929",
		["W225H196X357Y343"] = "271922",
		["W303H311X475Y5"] = "271908,271935,271936,271909",
		["W176H235X490Y195"] = "271933",
		["W281H261X565Y208"] = "271915,271921,440601,440602",
		["W287H289X487Y334"] = "271912,271920,440598,440599",
		["W244H401X677Y267"] = "271938,271916",
		["W226H225X152Y284"] = "440603",
	},
	[1216] = { -- 丹莫罗
		["W437H249X50Y227"] = "271398,438347",
		["W198H251X663Y288"] = "271408",
		["W218H234X760Y268"] = "271409",
		["W249H183X595Y225"] = "271389",
		["W184H188X449Y220"] = "271417",
		["W211H160X374Y287"] = "271400",
		["W225H276X360Y340"] = "271406,438340",
		["W376H347X398Y0"] = "271410,271396,438352,438353",
		["W398H302X100Y366"] = "438341,438342,438343,438344",
		["W226H335X469Y256"] = "438345,438346",
		["W409H318X0Y27"] = "438348,438349,438350,438351",
		["W308H335X630Y0"] = "438354,438355,438356,438357",
		["W171H234X397Y132"] = "445524",
		["W171H234X397Y132"] = "445524",
		["W236H358X263Y0"] = "271392,442671",
		["W174H249X579Y306"] = "271401",
		["W237H366X765Y43"] = "442672,442673",
	},
	[1220] = { -- 灼热峡谷
		["W375H307X0Y361"] = "254503,254504,450680,450681",
		["W304H244X243Y424"] = "450682,450683",
		["W392H355X588Y0"] = "254505,254506,254507,254508",
		["W365H393X0Y75"] = "254509,254510,254511,254512",
		["W441H266X531Y241"] = "450684,450685,450686,450687",
		["W481H360X232Y171"] = "254529,254530,254531,254532",
		["W429H301X255Y38"] = "450692,450693,450694,450695",
		["W571H308X413Y360"] = "254527,254528,450688,450689,450690,450691",
	},
	[1224] = { -- 燃烧平原
		["W182H360X0Y0"] = "270938,455906",
		["W281H388X79Y0"] = "270919,270911,455907,455908",
		["W298H410X419Y258"] = "270920,270914,270908,270929",
		["W320H385X235Y0"] = "270912,270909,455909,455910",
		["W362H431X0Y237"] = "270941,270925,270926,270917",
		["W274H263X568Y151"] = "270927,455911,455912,455913",
		["W383H413X615Y255"] = "270906,270918,270936,270942",
		["W274H413X253Y255"] = "270933,270943,270921,270928",
		["W324H354X421Y0"] = "270922,270934,270923,270937",
		["W350H341X646Y7"] = "270944,270910,270935,270945",
	},
	[1228] = { -- 艾尔文森林
		["W220H207X417Y327"] = "271560",
		["W230H206X396Y430"] = "271582",
		["W269H248X240Y420"] = "271576,438414",
		["W269H313X116Y355"] = "438426,438427,438428,438429",
		["W270H241X529Y287"] = "271573,438425",
		["W276H231X247Y294"] = "271567,438415",
		["W285H194X708Y442"] = "271557,271583",
		["W287H216X532Y424"] = "271559,438412",
		["W294H243X703Y292"] = "271578,438413",
		["W295H296X355Y138"] = "271572,438416,438418,438417",
		["W340H272X552Y186"] = "271584,271565,438419,438420",
		["W512H422X0Y0"] = "438421,438422,438423,438424",
	},
	[1233] = { -- 逆风小径
		["W617H522X83Y0"] = "271075,271076,271080,271081,440573,440574,440575,440576,440577",
		["W350H449X433Y208"] = "271092,271085,271086,271089",
		["W513H358X92Y310"] = "271095,271079,440578,440579,440580,440581",
	},
	[1235] = { -- 暮色森林
		["W189H307X0Y152"] = "271453,271454",
		["W299H296X32Y348"] = "271444,271483,438377,438378",
		["W323H309X91Y132"] = "271473,271463,271467,271464",
		["W268H282X228Y355"] = "271448,271456,438391,438392",
		["W233H248X401Y396"] = "271449",
		["W279H399X497Y112"] = "271470,271477,438379,438380",
		["W291H263X539Y368"] = "271455,438382,438383,438384",
		["W329H314X640Y128"] = "271471,271461,271450,271451",
		["W219H182X661Y122"] = "271466",
		["W931H235X71Y26"] = "271481,271460,271474,271468",
		["W205H157X96Y292"] = "438381",
		["W291H244X627Y344"] = "438385,438386",
		["W320H388X314Y101"] = "438387,438388,438389,438390",
	},
	[1236] = { -- 洛克莫丹
		["W294H249X549Y52"] = "252880,252881",
		["W330H474X340Y81"] = "252894,252895,252896,252897",
		["W225H252X221Y0"] = "252884",
		["W319H289X16Y0"] = "252882,252883,440638,440639",
		["W349H292X570Y209"] = "252890,252891,252892,252893",
		["W397H291X481Y296"] = "252866,252867,440636,440637",
		["W273H230X245Y324"] = "252862,252863",
		["W455H295X0Y146"] = "252898,440644,440645,440646",
		["W273H294X177Y345"] = "252886,252887,440640,440641",
		["W310H345X0Y311"] = "252899,440647,440648,440649",
		["W333H200X339Y0"] = "440642,440643",
	},
	[1237] = { -- 赤脊山
		["W323H406X0Y256"] = "272364,272348,272358,272359",
		["W392H352X148Y316"] = "272344,272354,272350,272339",
		["W464H250X81Y214"] = "272335,272343",
		["W410H256X0Y110"] = "272351,272340",
		["W413H292X37Y0"] = "272362,272356,440664,440665",
		["W357H246X214Y0"] = "272357,272342",
		["W228H247X350Y139"] = "272334",
		["W427H291X451Y377"] = "272369,272363,440666,440667",
		["W316H182X525Y302"] = "272347,272371",
		["W428H463X574Y0"] = "272372,440661,440662,440663",
		["W189H193X445Y286"] = "440660",
		["W306H324X688Y283"] = "440668,440669,440670,440671",
		["W228H420X480Y0"] = "440672,440673",
	},
	[1238] = { -- 北荆棘谷
		["W239H205X397Y243"] = "440794",
		["W157H173X387Y246"] = "440805",
		["W167H179X298Y228"] = "440797",
		["W234H206X543Y253"] = "440806",
		["W240H228X413Y95"] = "440800",
		["W139H150X354Y184"] = "440798",
		["W159H137X267Y168"] = "440793",
		["W236H224X140Y208"] = "440812",
		["W228H265X158Y0"] = "440810,440811",
		["W227H190X306Y63"] = "440807",
		["W302H166X306Y0"] = "440808,440809",
		["W244H238X499Y0"] = "440799",
		["W376H560X626Y0"] = "440813,440814,440815,440816,440817,440818",
		["W190H176X566Y164"] = "440795",
		["W230H170X398Y375"] = "440796",
		["W324H263X9Y22"] = "440819,440820,440821,440822",
		["W350H259X488Y364"] = "440801,440802,440803,440804",
	},
	[1239] = { -- 悲伤沼泽
		["W229H418X703Y80"] = "272739,272746",
		["W238H343X194Y236"] = "272747,272763",
		["W257H229X575Y238"] = "272772,272760",
		["W262H193X600Y0"] = "442700,442701",
		["W266H284X161Y79"] = "272736,442717,442718,442719",
		["W268H285X0Y80"] = "272759,272750,442713,442714",
		["W268H316X7Y242"] = "442702,442703,442704,442705",
		["W292H360X331Y24"] = "272768,272770,442720,442721",
		["W330H342X478Y0"] = "442706,442707,442708,442709",
		["W347H303X540Y360"] = "272740,272773,442715,442716",
		["W357H308X297Y258"] = "272742,272751,272752,272764",
		["W402H668X600Y0"] = "272756,272737,272769,442710,442711,442712",
	},
	[1240] = { -- 西部荒野
		["W202H179X474Y0"] = "273143",
		["W197H213X394Y0"] = "273145",
		["W244H237X451Y81"] = "273146",
		["W202H224X348Y118"] = "273126",
		["W235H306X199Y79"] = "273149,441025",
		["W193H273X531Y200"] = "273125,441031",
		["W229H265X404Y226"] = "273137,441027",
		["W232H213X308Y325"] = "273130",
		["W346H222X167Y263"] = "273129,273133",
		["W201H195X203Y376"] = "273142",
		["W211H167X221Y477"] = "273141",
		["W292H273X303Y395"] = "273124,441028,441029,441030",
		["W317H261X480Y378"] = "273131,273134,441032,441033",
		["W196H229X311Y0"] = "441026",
		["W184H217X294Y168"] = "441034",
	},
	[1243] = { -- 湿地
		["W325H363X0Y297"] = "273156,441044,441045,441046",
		["W301H232X37Y240"] = "273163,441035",
		["W321H248X31Y102"] = "273171,441036",
		["W298H447X185Y195"] = "273155,441055,441056,441057",
		["W276H243X121Y63"] = "273178,273167",
		["W185H224X372Y76"] = "273173",
		["W257H185X356Y7"] = "273164,441041",
		["W236H256X359Y201"] = "273159",
		["W258H207X371Y335"] = "273174,441054",
		["W369H235X506Y232"] = "273177,441047",
		["W256H245X599Y123"] = "273181",
		["W329H228X506Y34"] = "441037,441038",
		["W298H215X346Y419"] = "441039,441040",
		["W250H269X460Y102"] = "441042,441043",
		["W250H282X218Y0"] = "441048,441049",
		["W300H316X532Y352"] = "441050,441051,441052,441053",
	},
	[1244] = { -- 泰达希尔
		["W140H210X345Y243"] = "272807",
		["W144H226X432Y109"] = "440837",
		["W165H249X382Y83"] = "272822",
		["W175H235X374Y221"] = "272826",
		["W178H186X466Y237"] = "440833",
		["W187H196X544Y217"] = "272815",
		["W194H244X276Y90"] = "272830",
		["W198H181X347Y355"] = "272814",
		["W241H217X481Y104"] = "272811",
		["W289H202X422Y310"] = "272810,440834",
		["W317H220X329Y448"] = "440835,440836",
		["W298H337X149Y181"] = "272806,272812,440831,440832",
	},
	[1247] = { -- 黑海岸
		["W203H194X280Y182"] = "438259",
		["W244H201X207Y467"] = "438258",
		["W245H147X565Y0"] = "438262",
		["W250H241X596Y16"] = "438261",
		["W200H263X517Y28"] = "271043,438260",
		["W303H185X277Y483"] = "271044,438263",
		["W314H193X280Y378"] = "438264,438265",
		["W326H145X294Y330"] = "271045,438251",
		["W328H250X305Y118"] = "438266,438267",
		["W330H192X300Y239"] = "438252,438253",
		["W277H281X391Y54"] = "438254,438255,438256,438257",
	},
	[1248] = { -- 灰谷
		["W262H390X0Y0"] = "270376,437333,437334,437335",
		["W184H232X112Y148"] = "270380",
		["W314H241X255Y78"] = "270389,437336",
		["W251H271X255Y164"] = "270386,437312",
		["W236H271X210Y331"] = "270398,437328",
		["W325H239X473Y97"] = "270400,437327",
		["W231H256X481Y221"] = "270402",
		["W287H276X529Y385"] = "270375,437313,437314,437315",
		["W221H257X595Y253"] = "270401,437321",
		["W235H236X696Y154"] = "270388",
		["W166H211X836Y148"] = "270387",
		["W231H223X771Y265"] = "270390",
		["W277H333X714Y317"] = "270405,437316,437317,437318",
		["W246H361X188Y0"] = "437319,437320",
		["W244H251X143Y0"] = "437322",
		["W347H308X338Y335"] = "437323,437324,437325,437326",
		["W306H283X40Y275"] = "437329,437330,437331,437332",
		["W203H310X377Y121"] = "437337,437338",
	},
	[1249] = { -- 千针石林
		["W317H252X169Y116"] = "272962,442240",
		["W436H271X276Y186"] = "272954,442241,442242,442243",
		["W246H380X0Y134"] = "272968,442244",
		["W361H314X298Y0"] = "442245,442246,442247,442248",
		["W246H256X756Y412"] = "442250",
		["W431H410X571Y49"] = "442251,442252,442253,442254",
		["W272H232X136Y0"] = "272963,442255",
		["W411H411X591Y257"] = "442256,442257,442258,442259",
		["W280H325X0Y0"] = "442268,442269,442270,442271",
	},
	[1250] = { -- 石爪山脉
		["W305H244X265Y0"] = "272632,272641",
		["W244H247X417Y143"] = "272624",
		["W277H274X199Y368"] = "272633,272647,440774,440775",
		["W222H222X353Y285"] = "272646",
		["W374H287X533Y179"] = "272630,272649,272642,272636",
		["W194H156X532Y512"] = "272628",
		["W267H352X468Y263"] = "272648,272634,272635,272623",
		["W211H131X618Y537"] = "272650",
		["W290H297X220Y189"] = "440764,440765,440766,440767",
		["W241H192X366Y95"] = "440768",
		["W322H220X602Y448"] = "440769,440770",
		["W183H196X588Y341"] = "440771",
		["W221H235X367Y411"] = "440772",
		["W210H189X252Y121"] = "440773",
		["W265H206X654Y369"] = "440776,440777",
		["W164H258X479Y401"] = "440778,440779",
		["W176H189X516Y289"] = "440780",
	},
	[1251] = { -- 凄凉之地
		["W292H266X637Y402"] = "271105,438324,438325,438326",
		["W326H311X381Y357"] = "271108,271112,271113,271109",
		["W274H196X207Y472"] = "271122,438317",
		["W222H299X142Y369"] = "271125,438327",
		["W250H215X360Y273"] = "271127",
		["W321H275X170Y196"] = "271106,271129,438338,438339",
		["W220H205X440Y49"] = "271111",
		["W317H293X655Y0"] = "271104,271124,438322,438323",
		["W231H257X573Y0"] = "271114,438320",
		["W274H145X399Y0"] = "271126,438336",
		["W312H285X415Y156"] = "438313,438314,438315,438316",
		["W289H244X613Y170"] = "438318,438319",
		["W161H141X210Y0"] = "438321",
		["W309H349X589Y319"] = "438328,438329,438330,438331",
		["W338H342X208Y24"] = "438332,438333,438334,438335",
		["W212H186X275Y376"] = "438337",
	},
	[1252] = { -- 菲拉斯
		["W350H334X271Y0"] = "271705,271686,440594,440595",
		["W194H304X375Y343"] = "271700,271682",
		["W265H284X485Y101"] = "271687,440587,440588,440589",
		["W206H237X467Y354"] = "271699",
		["W174H220X671Y181"] = "271675",
		["W192H157X663Y116"] = "271696",
		["W207H209X756Y191"] = "271680",
		["W172H198X568Y287"] = "440586",
		["W217H192X362Y237"] = "440590",
		["W191H179X457Y281"] = "440591",
		["W159H218X607Y170"] = "440592",
		["W208H204X186Y229"] = "440593",
		["W232H206X652Y298"] = "440596",
	},
	[1253] = { -- 尘泥沼泽
		["W305H247X542Y223"] = "271500,438407",
		["W270H353X428Y0"] = "271507,271504,438410,438411",
		["W436H299X359Y369"] = "271503,271509,438408,438409",
		["W206H200X656Y21"] = "271494",
		["W344H183X199Y0"] = "438393,438394",
		["W384H249X133Y59"] = "438395,438396",
		["W279H301X358Y169"] = "438397,438398,438399,438400",
		["W433H351X109Y313"] = "438401,438402,438403,438404",
		["W317H230X137Y188"] = "438405,438406",
	},
	[1254] = { -- 塔纳利斯
		["W221H293X185Y280"] = "272781,440827",
		["W232H211X301Y349"] = "272784",
		["W224H216X431Y452"] = "272801",
		["W173H163X380Y341"] = "272798",
		["W225H187X448Y364"] = "272805",
		["W274H186X437Y289"] = "272795,440826",
		["W231H177X305Y257"] = "272782",
		["W179H190X258Y211"] = "272792",
		["W195H163X413Y211"] = "272800",
		["W255H194X297Y148"] = "272799",
		["W213H173X507Y238"] = "272789",
		["W189H180X412Y92"] = "272774",
		["W214H149X293Y99"] = "272776",
		["W315H190X184Y0"] = "272788,440830",
		["W254H341X479Y9"] = "440823,440824",
		["W178H243X615Y201"] = "440825",
		["W269H190X255Y431"] = "440828,440829",
	},
	[1259] = { -- 艾萨拉
		["W206H329X316Y168"] = "270412,438210",
		["W321H247X477Y0"] = "270432,438192",
		["W306H337X684Y22"] = "270434,438211,438212,438213",
		["W218H237X228Y229"] = "270414",
		["W295H267X476Y401"] = "270410,438204,438205,438206",
		["W210H232X245Y377"] = "270409",
		["W256H224X113Y141"] = "438185",
		["W587H381X395Y127"] = "438186,438187,438188,438189,438190,438191",
		["W260H267X204Y53"] = "438193,438194,438195,438196",
		["W243H262X343Y3"] = "438197,438198",
		["W250H230X70Y222"] = "438199",
		["W352H274X22Y344"] = "438200,438201,438202,438203",
		["W219H193X575Y121"] = "438207",
		["W207H232X407Y403"] = "438208",
		["W184H213X353Y396"] = "438209",
	},
	[1260] = { -- 费伍德森林
		["W307H161X471Y0"] = "271660,438432",
		["W209H226X531Y57"] = "271653",
		["W261H273X406Y55"] = "271673,438433,438434,438435",
		["W263H199X303Y9"] = "271652,438436",
		["W343H250X243Y107"] = "271665,438439",
		["W345H192X220Y231"] = "271666,438430",
		["W319H176X234Y317"] = "271669,438437",
		["W268H214X278Y359"] = "271664,438438",
		["W229H210X288Y458"] = "271663",
		["W274H212X394Y382"] = "271659,438431",
		["W173H163X410Y505"] = "271658",
		["W187H176X476Y484"] = "271657",
	},
	[1261] = { -- 安戈洛环形山
		["W321H288X356Y192"] = "273042,273065,273050,273036",
		["W309H277X145Y226"] = "273043,273075,273069,273061",
		["W316H293X162Y357"] = "273046,273053,273071,273047",
		["W381H274X335Y384"] = "273059,273066,273073,273054",
		["W263H412X573Y256"] = "273072,273039,273037,273063",
		["W197H222X706Y201"] = "273051",
		["W432H294X305Y0"] = "273052,273062,273057,273058",
		["W224H191X557Y0"] = "440936",
		["W204H170X462Y330"] = "440937",
		["W186H185X328Y179"] = "440938",
		["W337H321X565Y39"] = "440939,440940,440941,440942",
		["W332H332X157Y0"] = "440943,440944,440945,440946",
	},
	[1263] = { -- 月光林地
		["W431H319X219Y273"] = "252844,252845,252846,252847",
		["W346H244X370Y135"] = "440650,440651",
		["W271H296X209Y91"] = "440652,440653,440654,440655",
		["W275H346X542Y210"] = "440656,440657,440658,440659",
	},
	[1264] = { -- 希利苏斯
		["W329H246X126Y0"] = "272581,272562",
		["W405H267X345Y4"] = "272565,272566,272577,272546",
		["W309H243X550Y181"] = "272580,272544",
		["W542H367X0Y206"] = "272559,272543,272574,272575,440718,440719",
		["W489H358X380Y310"] = "272567,272547,272555,272548",
		["W580H213X0Y455"] = "272564,272553,440720",
		["W292H260X427Y143"] = "440714,440715,440716,440717",
		["W315H285X614Y0"] = "440721,440722,440723,440724",
		["W434H231X100Y151"] = "272573,272545",
	},
	[1266] = { -- 冬泉谷
		["W194H229X482Y195"] = "273191",
		["W376H289X93Y118"] = "273202,445578,445579,445580",
		["W332H268X304Y0"] = "273184,445581,445582,445583",
		["W317H183X424Y474"] = "273198,445584",
		["W249H217X581Y314"] = "273206",
		["W271H258X372Y268"] = "273192,445585,445586,445587",
		["W257H238X399Y340"] = "273185,445588",
		["W254H150X556Y439"] = "273199",
		["W367H340X229Y33"] = "273207,445589,445590,445591",
		["W333H255X500Y17"] = "273203,445592",
		["W362H252X92Y302"] = "273187,445593",
		["W221H209X588Y181"] = "273200",
	},
	[1273] = { -- 亚特兰大山谷
		["W270H240X348Y13"]  = "270331,270325",
		["W235H290X399Y375"] = "270314,270315",
		["W300H300X335Y172"] = "270320,270321,270322,270323",
	},
	[1628] = { -- 永歌森林
		["W512H512X195Y5"]   = "271619,271602,271589,271638",
		["W512H512X440Y87"]  = "271632,271600,271617,271618",
		["W128H193X554Y475"] = "271603",
		["W128H197X584Y471"] = "271598",
		["W128H248X511Y420"] = "271592",
		["W128H253X183Y415"] = "271625",
		["W128H256X292Y319"] = "271633",
		["W128H256X580Y399"] = "271630",
		["W256H128X231Y404"] = "271627",
		["W256H128X243Y469"] = "271635",
		["W256H128X255Y507"] = "271596",
		["W256H128X524Y359"] = "271591",
		["W256H128X539Y305"] = "271628",
		["W256H172X378Y496"] = "271614",
		["W256H174X464Y494"] = "271615",
		["W256H256X215Y298"] = "271601",
		["W256H256X307Y136"] = "271608",
		["W256H256X324Y384"] = "271599",
		["W256H256X361Y298"] = "271637",
		["W256H256X386Y386"] = "271612",
		["W256H256X460Y373"] = "271588",
		["W256H256X474Y314"] = "271610",
		["W256H256X605Y253"] = "271604",
		["W256H256X669Y228"] = "271586",
		["W256H353X648Y315"] = "271587,271590",
	},
	[1629] = { -- 幽魂之地
		["W512H512X44Y0"]    = "271726,271756,271727,271710",
		["W256H256X585Y0"]   = "271761",
		["W256H512X365Y2"]   = "271762,271751",
		["W427H256X575Y0"]   = "271735,271736",
		["W512H256X326Y0"]   = "271729,271707",
		["W512H256X460Y0"]   = "271731,271719",
		["W256H512X60Y117"]  = "271754,271733",
		["W256H256X40Y287"]  = "271752",
		["W512H293X95Y375"]  = "271721,271725,271714,271737",
		["W256H256X184Y238"] = "271744",
		["W256H256X210Y126"] = "271716",
		["W256H262X364Y406"] = "271711,271717",
		["W256H449X340Y219"] = "271740,271730",
		["W256H512X448Y150"] = "271741,271723",
		["W429H256X573Y136"] = "271715,271745",
		["W404H436X598Y232"] = "271742,271728,271758,271706",
		["W512H431X466Y237"] = "271712,271757,271713,271734",
	},
	[1631] = { -- 秘蓝岛
		["W256H128X356Y0"]   = "270493",
		["W256H256X291Y3"]   = "270510",
		["W512H512X74Y85"]   = "270475,270515,270495,270505",
		["W256H256X365Y49"]  = "270488",
		["W256H256X488Y24"]  = "270474",
		["W256H222X23Y446"]  = "270498",
		["W128H256X462Y349"] = "270497",
		["W256H247X220Y421"] = "270482",
		["W256H256X174Y363"] = "270492",
		["W256H256X176Y303"] = "270463",
		["W256H256X281Y305"] = "270509",
		["W256H256X352Y378"] = "270481",
		["W256H256X383Y249"] = "270513",
		["W256H256X449Y183"] = "270508",
		["W256H256X507Y350"] = "270512",
		["W256H256X515Y279"] = "270476",
		["W475H512X527Y104"] = "270511,270483,270489,270484",
	},
	[1633] = { -- 地狱火半岛
		["W512H256X477Y6"]   = "271867,271842",
		["W256H256X34Y142"]  = "271836",
		["W256H378X25Y290"]  = "271850,271864",
		["W256H512X326Y45"]  = "271840,271849",
		["W512H512X38Y152"]  = "271851,271841,271865,271853",
		["W512H512X478Y25"]  = "271863,271857,271845,271839",
		["W256H256X182Y412"] = "271830",
		["W256H256X206Y110"] = "271835",
		["W256H256X467Y154"] = "271852",
		["W256H256X469Y298"] = "271848",
		["W256H256X705Y368"] = "271843",
		["W256H260X308Y408"] = "271838,271861",
		["W256H458X338Y210"] = "271855,271833",
		["W256H512X579Y128"] = "271866,271821",
		["W256H512X737Y156"] = "271854,271825",
		["W422H238X580Y430"] = "271826,271822",
		["W512H255X261Y413"] = "271856,271820",
		["W512H342X183Y326"] = "271862,271844,271823,271831",
	},
	[1635] = { -- 赞加沼泽
		["W256H128X124Y0"]   = "273241",
		["W256H256X88Y50"]   = "273235",
		["W256H256X81Y152"]  = "273222",
		["W256H256X31Y339"]  = "273262",
		["W512H256X20Y202"]  = "273248,273279",
		["W256H512X219Y51"]  = "273268,273226",
		["W256H512X329Y25"]  = "273223,273272",
		["W256H512X462Y90"]  = "273253,273242",
		["W256H207X720Y461"] = "273266",
		["W256H256X175Y232"] = "273267",
		["W256H256X342Y249"] = "273233",
		["W256H256X512Y303"] = "273271",
		["W256H256X596Y412"] = "273280",
		["W256H343X141Y325"] = "273224,273225",
		["W256H512X569Y112"] = "273249,273238",
		["W308H256X694Y321"] = "273276,273246",
		["W286H512X716Y128"] = "273243,273273,273250,273251",
		["W512H336X314Y332"] = "273221,273269,273236,273277",
	},
	[1637] = { -- 影月谷
		["W512H512X348Y8"]   = "272467,272465,272422,272453",
		["W512H512X116Y35"]  = "272428,272424,272433,272445",
		["W512H512X394Y90"]  = "272459,272438,272463,272447",
		["W256H256X520Y93"]  = "272421",
		["W256H256X143Y256"] = "272431",
		["W256H256X554Y308"] = "272461",
		["W256H512X290Y129"] = "272451,272471",
		["W492H223X510Y445"] = "272442,272443",
		["W396H512X606Y126"] = "272429,272470,272446,272450",
		["W512H358X343Y310"] = "272454,272426,272439,272455",
		["W512H410X469Y258"] = "272448,272449,272469,272452",
		["W512H439X168Y229"] = "272430,272460,272434,272435",
		["W512H512X104Y155"] = "272436,272440,272441,272427",
	},
	[1638] = { -- 刀锋山
		["W256H256X422Y0"]   = "270665",
		["W256H256X585Y0"]   = "270651",
		["W256H256X286Y28"]  = "270625",
		["W256H256X412Y95"]  = "270631",
		["W256H256X527Y81"]  = "270611",
		["W256H256X673Y71"]  = "270626",
		["W512H256X214Y55"]  = "270621,270633",
		["W256H512X479Y98"]  = "270616,270617",
		["W256H128X563Y151"] = "270643",
		["W256H240X271Y428"] = "270622",
		["W256H254X446Y414"] = "270642",
		["W256H256X254Y176"] = "270663",
		["W256H256X439Y210"] = "270649",
		["W256H256X623Y147"] = "270666",
		["W256H256X629Y406"] = "270667",
		["W256H256X658Y297"] = "270655",
		["W256H256X733Y109"] = "270609",
		["W256H297X342Y371"] = "270669,270657",
		["W256H318X289Y350"] = "270638,270630",
		["W256H336X533Y332"] = "270612,270658",
		["W256H396X405Y272"] = "270664,270659",
		["W256H410X554Y258"] = "270629,270606",
		["W256H419X512Y249"] = "270644,270610",
		["W256H462X166Y206"] = "270652,270653",
		["W256H507X314Y161"] = "270619,270620",
		["W416H256X586Y147"] = "270628,270605",
		["W512H252X144Y416"] = "270662,270632",
	},
	[1639] = { -- 秘血岛
		["W128H128X180Y216"] = "270671",
		["W239H256X763Y256"] = "270710",
		["W256H185X309Y483"] = "270718",
		["W256H198X503Y470"] = "270687",
		["W256H256X205Y39"] = "270701",
		["W256H256X221Y136"] = "270676",
		["W256H256X232Y242"] = "270703",
		["W256H256X250Y404"] = "270739",
		["W256H256X293Y285"] = "270728",
		["W256H256X297Y136"] = "270733",
		["W256H256X302Y27"] = "270727",
		["W256H256X367Y209"] = "270679",
		["W256H256X414Y406"] = "270700",
		["W256H256X437Y258"] = "270698",
		["W256H256X451Y29"] = "270734",
		["W256H256X481Y117"] = "270720",
		["W256H256X546Y410"] = "270699",
		["W256H256X555Y87"] = "270741",
		["W256H256X556Y216"] = "270740",
		["W256H256X598Y338"] = "270677",
		["W256H256X613Y82"] = "270709",
		["W256H256X637Y0"] = "270714",
		["W256H256X657Y78"] = "270712",
		["W256H256X729Y54"] = "270682",
		["W256H512X44Y62"] = "270690,270729",
		["W485H141X517Y527"] = "270711,270723",
		["W512H242X177Y426"] = "270674,270731",
		["W512H430X43Y238"] = "270692,270673,270702,270672",
	},
	[1640] = { -- 纳格兰
		["W256H256X157Y32"]  = "272235",
		["W256H256X277Y54"]  = "272242",
		["W256H256X351Y52"]  = "272237",
		["W256H256X598Y79"]  = "272232",
		["W256H256X504Y53"]  = "272208",
		["W256H512X10Y107"]  = "272199,272200",
		["W512H420X36Y248"]  = "272224,272233,272191,272212",
		["W256H241X558Y427"] = "272204",
		["W256H256X162Y154"] = "272198",
		["W256H256X219Y199"] = "272231",
		["W256H256X335Y193"] = "272213",
		["W256H256X387Y390"] = "272220",
		["W256H256X391Y258"] = "272230",
		["W256H256X431Y143"] = "272188",
		["W256H256X532Y363"] = "272236",
		["W256H256X533Y267"] = "272206",
		["W256H256X666Y233"] = "272244",
		["W256H334X660Y334"] = "272196,272197",
		["W512H334X168Y334"] = "272205,272229,272190,272238",
	},
	[1641] = { -- 泰罗卡森林
		["W256H256X116Y4"]   = "272878",
		["W256H256X314Y0"]   = "272837",
		["W512H512X104Y4"]   = "272861,272831,272883,272838",
		["W256H256X478Y19"]  = "272880",
		["W256H512X455Y34"]  = "272879,272834",
		["W128H256X316Y268"] = "272840",
		["W256H208X321Y460"] = "272889",
		["W256H234X247Y434"] = "272843",
		["W256H256X222Y362"] = "272846",
		["W256H256X245Y289"] = "272881",
		["W256H256X310Y345"] = "272887",
		["W256H256X377Y272"] = "272836",
		["W256H256X397Y165"] = "272839",
		["W256H256X417Y327"] = "272873",
		["W256H256X480Y277"] = "272866",
		["W256H256X505Y154"] = "272886",
		["W256H256X521Y275"] = "272835",
		["W256H367X103Y301"] = "272844,272847",
		["W512H256X143Y171"] = "272851,272867",
		["W385H512X617Y149"] = "272860,272855,272850,272856",
		["W512H320X449Y348"] = "272876,272888,272857,272877",
	},
	[1642] = { -- 虚空风暴
		["W256H256X229Y38"]  = "272263",
		["W256H256X237Y22"]  = "272273",
		["W256H256X396Y10"]  = "272269",
		["W256H256X411Y20"]  = "272248",
		["W512H256X354Y49"]  = "272296,272294",
		["W256H128X241Y388"] = "272255",
		["W256H145X490Y523"] = "272274",
		["W256H179X357Y489"] = "272288",
		["W256H213X239Y455"] = "272292",
		["W256H217X454Y451"] = "272253",
		["W256H256X132Y294"] = "272262",
		["W256H256X171Y155"] = "272247",
		["W256H256X253Y301"] = "272283",
		["W256H256X298Y134"] = "272285",
		["W256H256X328Y397"] = "272280",
		["W256H256X356Y261"] = "272249",
		["W256H256X465Y336"] = "272260",
		["W256H256X481Y208"] = "272264",
		["W256H256X513Y138"] = "272282",
		["W256H256X644Y173"] = "272287",
		["W256H387X147Y281"] = "272279,272265",
		["W409H384X593Y284"] = "272267,272254,272268,272284",
	},
	[1646] = { -- 奎尔丹纳斯岛
		["W512H512X251Y4"]   = "272716,272728,272723,272733",
		["W512H416X252Y252"] = "272721,272732,272715,272722",
	},
}