import type { TranslationMessages } from '../types';

const en: TranslationMessages = {
  // App
  appName: 'MrRSS',

  // Sidebar
  allArticles: 'All Articles',
  unread: 'Unread',
  favorites: 'Favorites',
  readLater: 'Read Later',
  imageGallery: 'Image Gallery',
  uncategorized: 'Uncategorized',
  searchFeeds: 'Search feeds...',
  addFeed: 'Add Feed',
  settings: 'Settings',

  // Article List
  articles: 'Articles',
  refresh: 'Refresh',
  markAllRead: 'Mark All as Read',
  search: 'Search...',
  noArticles: 'No articles found.',

  // Article Detail
  back: 'Back',
  markAsUnread: 'Mark as Unread',
  markAsRead: 'Mark as Read',
  toggleFavorite: 'Toggle Favorite',
  addToFavorite: 'Add to Favorites',
  removeFromFavorite: 'Remove from Favorites',
  addToReadLater: 'Add to Read Later',
  removeFromReadLater: 'Remove from Read Later',
  openInBrowser: 'Open in Browser',
  viewOriginal: 'View Original',
  viewContent: 'View Content',
  renderContent: 'Render Content',
  close: 'Close',
  zoomIn: 'Zoom In',
  zoomOut: 'Zoom Out',
  imageViewerHelp: 'Use mouse wheel or +/- keys to zoom • Drag to move • ESC to close',
  imageViewerHelpExtended:
    'Use mouse wheel or +/- keys to zoom • Drag to move • Ctrl+S to save • ESC to close',
  downloadImage: 'Download Image',
  viewImage: 'View Image',
  podcastAudio: 'Podcast Audio',
  play: 'Play',
  pause: 'Pause',
  downloadAudio: 'Download Audio File',
  audioPlaybackError:
    'Failed to play audio. The file may be unavailable or in an unsupported format.',
  youtubeVideo: 'YouTube Video',
  openInYouTube: 'Open in YouTube',
  videoLoadError: 'Failed to load video. Please try opening it in YouTube.',
  hideTranslations: 'Hide Translations',
  showTranslations: 'Show Translations',

  // Context Menu
  unsubscribe: 'Unsubscribe',
  editSubscription: 'Edit Subscription',
  renameCategory: 'Rename Category',
  markAllAsReadFeed: 'Mark All as Read',
  addToFavorites: 'Add to Favorites',
  removeFromFavorites: 'Remove from Favorites',
  hideArticle: 'Hide Article',
  unhideArticle: 'Unhide Article',
  selectArticle: 'Select an article to start reading',
  showOriginal: 'Show Original Webpage',
  openWebsite: 'Open Website',
  discoverFeeds: 'Discover Feeds',
  toggleSidebar: 'Toggle Sidebar',

  // Feed Discovery
  fromFeed: 'From Feed',
  discovering: 'Discovering feeds...',
  noFriendLinksFound: 'No friend links found',
  discoveryFailed: 'Discovery failed',
  foundFeeds: 'Found {count} feeds',
  deselectAll: 'Deselect All',
  recentArticles: 'Recent Articles',
  startDiscovery: 'Click to start discovery',
  subscribeSelected: 'Subscribe Selected',
  feedsSubscribedSuccess: '{count} feeds subscribed successfully',
  feedsSubscribedPartial: '{successful} feeds subscribed, {failed} failed',
  errorSubscribingFeeds: 'Error subscribing to feeds',
  discoverAllFeeds: 'Discover All Feeds',
  discoveringAllFeeds: 'Discovering feeds from all subscriptions...',
  discoveryComplete: 'Discovery complete',
  alreadyDiscovered: 'Already discovered',
  markAsDiscovered: 'Mark as discovered',
  feedsWord: 'feeds',
  preparing: 'Preparing',
  analyzingFeed: 'Analyzing feed',
  searchingFriendLinks: 'Searching for friend links',
  checkingFeeds: 'Checking RSS feeds',
  pleaseWait: 'Please wait, this may take a few minutes',
  discoverAllFeedsDesc:
    "Automatically discover new feeds from all your subscriptions that haven't been scanned yet",
  subscribing: 'Subscribing',
  fetchingHomepage: 'Fetching homepage',
  analyzingLinks: 'Analyzing discovered links',
  preparingDiscovery: 'Preparing discovery',
  loadingFeeds: 'Loading feeds',
  analyzingFeeds: 'Analyzing feeds',
  scanningFriendLinks: 'Scanning for friend links',
  validatingRSS: 'Validating RSS feeds',
  checkingRssFeed: 'Checking RSS feed',
  processingFeed: 'Processing feed {current} of {total}',
  foundPotentialLinks: 'Found {count} potential blog links',
  fetchingFriendPage: 'Fetching friend links page',
  checkingSite: 'Checking site',
  foundSoFar: 'Found {count} feeds so far',

  // Settings Modal
  settingsTitle: 'Settings',
  general: 'General',
  feeds: 'Feeds',
  about: 'About',

  // General Settings
  appearance: 'Appearance',
  theme: 'Theme',
  themeDesc: 'Choose your preferred color scheme',
  light: 'Light',
  dark: 'Dark',
  auto: 'Auto (Follow System)',
  darkMode: 'Dark Mode',
  darkModeDesc: 'Switch between light and dark themes',
  updates: 'Updates',
  autoUpdateInterval: 'Auto-update Interval',
  autoUpdateIntervalDesc: 'How often to check for new articles (in minutes)',
  refreshMode: 'Refresh Mode',
  refreshModeDesc: 'Choose between fixed interval or intelligent refresh scheduling',
  fixedInterval: 'Fixed Interval',
  intelligentInterval: 'Intelligent Interval',
  fixedIntervalDesc: 'Use the same interval for all feeds',
  intelligentIntervalDesc: 'Adjust refresh frequency based on feed activity (5min-3hr)',
  lastArticleUpdate: 'Last Article Update',
  lastArticleUpdateDesc: 'Last time articles were refreshed',
  never: 'Never',
  justNow: 'Just now',
  minutesAgo: '{count} min ago',
  hoursAgo: '{count} hours ago',
  daysAgo: '{count} days ago',
  noContent: 'No content available for this article',
  defaultViewMode: 'Default Article View',
  defaultViewModeDesc: 'Choose how to display articles by default',
  viewModeOriginal: 'Original Webpage',
  viewModeRendered: 'Rendered Content',
  showHiddenArticles: 'Show Hidden Articles',
  showHiddenArticlesDesc: 'Display articles that have been hidden',
  showArticlePreviewImages: 'Show Preview Images',
  showArticlePreviewImagesDesc: 'Display preview images in the article list',
  imageGalleryFeature: 'Image Gallery Feature',
  imageGalleryEnabled: 'Enable Image Gallery',
  imageGalleryEnabledDesc: 'Enable image waterfall mode for image-focused feeds',
  startupOnBoot: 'Start on System Boot',
  startupOnBootDesc: 'Automatically start MrRSS when your computer starts',
  closeToTray: 'Minimize to Tray on Close',
  closeToTrayDesc: 'Hide the window to the system tray instead of quitting',
  database: 'Database',
  autoCleanup: 'Auto Cleanup',
  autoCleanupDesc: 'Automatically remove old articles to save space',
  maxCacheSize: 'Max Cache Size',
  maxCacheSizeDesc: 'Maximum database size before cleanup (in MB)',
  maxArticleAge: 'Max Article Age',
  maxArticleAgeDesc: 'Delete articles older than this many days (except favorites)',
  mediaCache: 'Media Cache',
  mediaCacheEnabled: 'Enable Media Cache',
  mediaCacheEnabledDesc:
    'Cache media files locally to avoid broken links from anti-hotlinking protection',
  mediaCacheMaxSize: 'Max Cache Size',
  mediaCacheMaxSizeDesc: 'Maximum media cache size (in MB)',
  mediaCacheMaxAge: 'Max Cache Age',
  mediaCacheMaxAgeDesc: 'Delete cached media older than this many days',
  currentCacheSize: 'Current cache size',
  mediaCacheCleanup: 'Clean Media Cache',
  mediaCacheCleanupDesc: 'Remove old cached media files',
  cleanupMediaCache: 'Clean Cache',
  days: 'days',
  translation: 'Translation',
  enableTranslation: 'Enable Translation',
  enableTranslationDesc: 'Automatically translate article titles to your preferred language',
  translationProvider: 'Translation Provider',
  translationProviderDesc: 'Choose the translation service to use',
  googleTranslate: 'Google Translate',
  googleTranslateEndpoint: 'Google Translate Endpoint',
  googleTranslateEndpointDesc: 'Select the Google Translate API endpoint to use',
  googleTranslateEndpointDefault: 'Default (translate.googleapis.com)',
  googleTranslateEndpointAlternate: 'Alternate (clients5.google.com)',
  deeplApi: 'DeepL Translate',
  deeplApiKey: 'DeepL API Key',
  deeplApiKeyDesc: 'Enter your DeepL API key for translation',
  deeplApiKeyPlaceholder: 'Enter your DeepL API key',
  baiduTranslate: 'Baidu Translate',
  baiduAppId: 'Baidu App ID',
  baiduAppIdDesc: 'Enter your Baidu Translate App ID',
  baiduAppIdPlaceholder: 'Enter your App ID',
  baiduSecretKey: 'Baidu Secret Key',
  baiduSecretKeyDesc: 'Enter your Baidu Translate Secret Key',
  baiduSecretKeyPlaceholder: 'Enter your Secret Key',
  aiTranslation: 'AI Translation',
  aiApiKey: 'AI API Key',
  aiApiKeyDesc: 'Enter your AI service API key (OpenAI, Claude, etc.)',
  aiApiKeyPlaceholder: 'Enter your API key',
  aiEndpoint: 'API Endpoint',
  aiEndpointDesc: 'API endpoint URL (leave empty for OpenAI default)',
  aiEndpointPlaceholder: 'https://api.openai.com/v1',
  aiModel: 'Model Name',
  aiModelDesc: 'AI model to use for translation',
  aiModelPlaceholder: 'gpt-4o-mini',
  aiSystemPrompt: 'Custom System Prompt',
  aiSystemPromptDesc: 'Custom system prompt for AI translation',
  aiSystemPromptPlaceholder:
    'Default: You are a translator. Translate the given text accurately. Output ONLY the translated text, nothing else.',
  targetLanguage: 'Target Language',
  targetLanguageDesc: 'Language to translate article titles to',
  language: 'Language',
  languageDesc: 'Select interface language',

  // Summary
  summary: 'Summary',
  enableSummary: 'Enable Auto Summary',
  enableSummaryDesc: 'Automatically generate article summaries',
  summaryProvider: 'Summary Provider',
  summaryProviderDesc: 'Choose how to generate article summaries',
  localAlgorithm: 'Local Algorithm',
  aiSummary: 'AI Summary',
  summaryAiApiKey: 'AI API Key',
  summaryAiApiKeyDesc: 'Enter your AI service API key (OpenAI, Claude, etc.)',
  summaryAiApiKeyPlaceholder: 'Enter your API key',
  summaryAiEndpoint: 'API Endpoint',
  summaryAiEndpointDesc: 'API endpoint URL (leave empty for OpenAI default)',
  summaryAiEndpointPlaceholder: 'https://api.openai.com/v1',
  summaryAiModel: 'Model Name',
  summaryAiModelDesc: 'AI model to use for summarization',
  summaryAiModelPlaceholder: 'gpt-4o-mini',
  summaryAiSystemPrompt: 'Custom System Prompt',
  summaryAiSystemPromptDesc: 'Custom system prompt for AI summarization',
  summaryAiSystemPromptPlaceholder:
    'Default: You are a summarizer. Generate a concise summary of the given text. Output ONLY the summary, nothing else.',
  summaryLength: 'Summary Length',
  summaryLengthDesc: 'Control the length of generated summaries',
  summaryLengthShort: 'Short',
  summaryLengthMedium: 'Medium',
  summaryLengthLong: 'Long',
  generatingSummary: 'Generating summary...',
  articleSummary: 'Article Summary',
  summaryTooShort: 'Article is too short to generate a meaningful summary',
  noSummaryAvailable: 'Summary not available',
  generateSummary: 'Generate Summary',
  translating: 'Translating...',
  translatingContent: 'Translating content...',
  autoTranslateEnabled: 'Auto-translate enabled',
  originalContent: 'Original',

  // Languages
  english: 'English',
  spanish: 'Spanish',
  french: 'French',
  german: 'German',
  chinese: 'Chinese',
  japanese: 'Japanese',

  // Proxy Settings
  proxySettings: 'Proxy Settings',
  enableProxy: 'Enable Proxy',
  enableProxyDesc: 'Use a proxy server for fetching feeds and articles',
  proxyType: 'Proxy Type',
  proxyTypeDesc: 'Select the proxy protocol to use',
  proxyHost: 'Proxy Host',
  proxyHostDesc: 'Proxy server hostname or IP address',
  proxyHostPlaceholder: 'proxy.example.com',
  proxyPort: 'Proxy Port',
  proxyPortDesc: 'Proxy server port number',
  proxyPortPlaceholder: '8080',
  proxyUsername: 'Proxy Username',
  proxyUsernameDesc: 'Username for proxy authentication (optional)',
  proxyUsernamePlaceholder: 'username',
  proxyPassword: 'Proxy Password',
  proxyPasswordDesc: 'Password for proxy authentication (optional)',
  proxyPasswordPlaceholder: 'password',
  httpProxy: 'HTTP',
  httpsProxy: 'HTTPS',
  socks5Proxy: 'SOCKS5',
  proxyCredentialsRequired: 'Proxy requires valid host and port',
  invalidProxyUrl: 'Invalid proxy URL format',

  // Feeds Settings
  dataManagement: 'Data Management',
  importOPML: 'Import OPML',
  exportOPML: 'Export OPML',
  cleanDatabase: 'Clean Database',
  manageFeeds: 'Manage Feeds',
  deleteSelected: 'Delete Selected',
  moveSelected: 'Move Selected',
  selectAll: 'Select All',
  edit: 'Edit',
  delete: 'Delete',

  // About
  aboutApp: 'A simple, modern RSS reader.',
  version: 'Version',
  viewOnGitHub: 'View on GitHub',
  checkForUpdates: 'Check for Updates',
  checking: 'Checking...',
  upToDate: 'You are using the latest version',
  updateAvailable: 'Update available',
  currentVersion: 'Current version',
  latestVersion: 'Latest version',
  downloadUpdate: 'Download Update',
  downloading: 'Downloading...',
  downloadComplete: 'Download complete',
  installingUpdate: 'Installing update...',
  updateWillRestart: 'The application will restart to install the update',
  downloadFailed: 'Download failed',
  installFailed: 'Installation failed',
  releaseNotes: 'Release Notes',
  errorCheckingUpdates: 'Error checking for updates',

  // Modals
  addNewFeed: 'Add New Feed',
  editFeed: 'Edit Feed',
  rssUrl: 'RSS URL',
  rssUrlPlaceholder: 'https://example.com/rss',
  category: 'Category',
  categoryOptional: 'Category (Optional)',
  categoryPlaceholder: 'e.g. Tech/News',
  title: 'Title',
  titlePlaceholder: 'Custom feed title',
  optional: 'Optional',
  required: 'Required',
  feedProxy: 'Feed Proxy',
  feedProxyDesc: 'Configure proxy settings for this feed (overrides global setting)',
  useGlobalProxy: 'Use Global Proxy',
  useCustomProxy: 'Use Custom Proxy',
  noProxy: 'No Proxy',
  customProxyUrl: 'Custom Proxy URL',
  customProxyUrlPlaceholder: 'http://proxy.example.com:8080',
  feedProxyType: 'Proxy Type',
  feedProxyHost: 'Proxy Host',
  feedProxyPort: 'Proxy Port',
  feedProxyUsername: 'Username (Optional)',
  feedProxyPassword: 'Password (Optional)',
  feedRefreshMode: 'Refresh Mode',
  feedRefreshModeDesc: 'How this feed should be refreshed',
  useGlobalRefresh: 'Use Global Setting',
  useFixedInterval: 'Fixed Interval',
  useIntelligentInterval: 'Intelligent Interval',
  useCustomInterval: 'Custom Interval',
  feedRefreshInterval: 'Refresh Interval',
  feedRefreshIntervalDesc: 'Custom refresh interval for this feed',
  feedRefreshIntervalPlaceholder: 'Minutes',
  minutesShort: 'min',
  requiredField: 'This field is required',
  fieldCannotBeEmpty: 'This field cannot be empty',
  invalidFormat: 'Invalid format',
  translationCredentialsRequired: 'Translation service requires API key or credentials',
  summaryCredentialsRequired: 'AI summary requires API key',
  addSubscription: 'Add Subscription',
  saveChanges: 'Save Changes',
  adding: 'Adding...',
  saving: 'Saving...',
  saveSettings: 'Save Settings',

  // Confirm Dialogs
  confirm: 'Confirm',
  cancel: 'Cancel',
  deleteFeedTitle: 'Delete Feed',
  deleteFeedMessage: 'Are you sure you want to delete this feed?',
  deleteMultipleFeedsTitle: 'Delete Multiple Feeds',
  deleteMultipleFeedsMessage: 'Are you sure you want to delete {count} feeds?',
  unsubscribeTitle: 'Unsubscribe',
  unsubscribeMessage: 'Are you sure you want to unsubscribe from {name}?',
  cleanDatabaseTitle: 'Clean Database',
  cleanDatabaseMessage: 'This will delete all articles except read and favorited ones. Continue?',
  clean: 'Clean',
  cleaning: 'Cleaning...',

  // Toast Messages
  feedAddedSuccess: 'Feed added successfully',
  feedUpdatedSuccess: 'Feed updated successfully',
  feedDeletedSuccess: 'Feed deleted successfully',
  feedsDeletedSuccess: 'Feeds deleted successfully',
  feedsMovedSuccess: 'Feeds moved successfully',
  unsubscribedSuccess: 'Successfully unsubscribed',
  markedAllAsRead: 'All articles marked as read',
  clearReadLater: 'Clear Read Later',
  clearedReadLater: 'Read Later list cleared',
  databaseCleanedSuccess: 'Database cleaned up successfully. {count} articles deleted.',
  opmlImportedSuccess: 'OPML Imported. Feeds will appear shortly.',
  errorSavingSettings: 'Error saving settings',
  errorAddingFeed: 'Error adding feed',
  errorUpdatingFeed: 'Error updating feed',
  errorCleaningDatabase: 'Error cleaning up database',
  importFailed: 'Import failed: {error}',
  errorTranslating:
    'Translation failed. Please check your network connection and translation settings.',
  errorTranslatingTitle: 'Failed to translate article title',
  errorTranslatingContent: 'Failed to translate content',

  // Loading Messages
  loadingContent: 'Loading content',
  fetchingArticleContent: 'Fetching article content from RSS feed...',
  noContentAvailable: 'No content available',

  // Prompts
  enterCategoryName: 'Enter new category name:',
  customCategory: 'Custom Category...',
  moveFeeds: 'Move Feeds',
  move: 'Move',

  // Article Filter
  filter: 'Filter',
  filterArticles: 'Filter Articles',
  addCondition: 'Add Condition',
  clearFilters: 'Clear Filters',
  clear: 'Clear',
  applyFilters: 'Apply Filters',
  noFiltersApplied: 'No filters applied',
  feedName: 'Feed Name',
  feedCategory: 'Feed Category',
  articleTitle: 'Article Title',
  dateRange: 'Date Range',
  publishedAfter: 'Published On/After',
  publishedBefore: 'Published On/Before',
  readStatus: 'Read Status',
  favoriteStatus: 'Favorite Status',
  hiddenStatus: 'Hidden Status',
  readLaterStatus: 'Read Later Status',
  yes: 'Yes',
  no: 'No',
  contains: 'Contains',
  exactMatch: 'Is',
  and: 'AND',
  or: 'OR',
  not: 'NOT',
  filterCondition: 'Condition',
  filterField: 'Field',
  filterOperator: 'Operator',
  filterValue: 'Value',
  removeCondition: 'Remove',
  selectItems: 'Select items',
  itemsSelected: '{count} items selected',
  filtersActive: '{count} filter(s) active',
  andNMore: 'and {count} more',

  // Keyboard Shortcuts
  shortcuts: 'Shortcuts',
  shortcutsDesc: 'Customize keyboard shortcuts for common actions',
  shortcutNavigation: 'Navigation',
  shortcutArticles: 'Articles',
  shortcutOther: 'Other',
  nextArticle: 'Next Article',
  previousArticle: 'Previous Article',
  openArticle: 'Open Article',
  closeArticle: 'Close Article',
  toggleReadStatus: 'Toggle Read Status',
  toggleFavoriteStatus: 'Toggle Favorite',
  openInBrowserShortcut: 'Open in Browser',
  toggleContentView: 'Toggle Content View',
  refreshFeedsShortcut: 'Refresh Feeds',
  markAllReadShortcut: 'Mark All as Read',
  openSettingsShortcut: 'Open Settings',
  addFeedShortcut: 'Add Feed',
  focusSearch: 'Focus Search',
  focusFeedSearch: 'Focus Feed Search',
  toggleFilter: 'Toggle Article Filter',
  goToAllArticles: 'Go to All Articles',
  goToUnread: 'Go to Unread',
  goToFavorites: 'Go to Favorites',
  goToReadLater: 'Go to Read Later',
  toggleReadLaterStatus: 'Toggle Read Later',
  pressKey: 'Press key...',
  resetToDefault: 'Reset to Default',
  shortcutConflict: 'This shortcut is already in use',
  shortcutCleared: 'Shortcut cleared',
  shortcutUpdated: 'Shortcut updated',
  escToClear: 'Press Escape to clear',

  // Rules
  rules: 'Rules',
  rulesDesc: 'Create automation rules to automatically perform actions on articles',
  addRule: 'Add Rule',
  editRule: 'Edit Rule',
  deleteRule: 'Delete Rule',
  noRules: 'No rules defined',

  // Network
  network: 'Network',
  noRulesHint: 'Create a rule to automatically process articles',
  ruleEnabled: 'Enabled',
  ruleDisabled: 'Disabled',
  ruleCondition: 'Condition',
  ruleActions: 'Actions',
  ruleName: 'Rule Name',
  ruleNamePlaceholder: 'e.g., Auto-favorite tech news',
  selectCondition: 'Select Condition',
  selectActions: 'Select Actions',
  conditionAlways: 'Always (all articles)',
  conditionIf: 'If',
  actionFavorite: 'Add to Favorites',
  actionUnfavorite: 'Remove from Favorites',
  actionHide: 'Hide Article',
  actionUnhide: 'Unhide Article',
  actionMarkRead: 'Mark as Read',
  actionMarkUnread: 'Mark as Unread',
  actionReadLater: 'Add to Read Later',
  actionRemoveReadLater: 'Remove from Read Later',
  addAction: 'Add Action',
  removeAction: 'Remove Action',
  ruleDeleteConfirmTitle: 'Delete Rule',
  ruleDeleteConfirmMessage: 'Are you sure you want to delete this rule?',
  ruleSavedSuccess: 'Rule saved successfully',
  ruleDeletedSuccess: 'Rule deleted successfully',
  ruleAppliedSuccess: 'Rule applied to {count} articles',
  applyRuleNow: 'Apply Now',
  applyingRule: 'Applying...',
  noActionsSelected: 'Please select at least one action',
  thenDo: 'then',

  // Custom Script Support
  feedSource: 'Feed Source',
  customScript: 'Custom Script',
  selectScript: 'Select Script',
  selectScriptPlaceholder: 'Select a script...',
  noScriptsFound: 'No scripts found in the scripts folder.',
  openScriptsFolder: 'Open Scripts Folder',
  scriptHelp:
    'Scripts should output valid RSS/Atom XML. Supported: Python, Shell, PowerShell, Node.js, Ruby.',
  scriptsFolderOpened: 'Scripts folder opened',
  scriptDocumentation: 'View Documentation',
  useCustomScript: 'Use custom script',
  useRssUrl: 'Use RSS URL',

  // Feed Management
  refreshFeed: 'Refresh Feed',
  feedRefreshStarted: 'Feed refresh started',
  sortByName: 'Name',
  sortByDate: 'Date Added',
  sortByCategory: 'Category',
  hideFromTimeline: 'Hide from Timeline',
  hideFromTimelineDesc: 'Hide this feed\'s articles from "All Articles" and "Unread" views',
  imageMode: 'Image Mode',
  imageModeDesc: 'Display this feed in image gallery view instead of article list',
  advancedSettings: 'Advanced Settings',
  showAdvancedSettings: 'Show Advanced Settings',
  hideAdvancedSettings: 'Hide Advanced Settings',

  // Network Settings
  networkSettings: 'Network Settings',
  networkSettingsDescription:
    'Automatic network speed detection to optimize parallel feed refresh performance',
  bandwidthLabel: 'Bandwidth',
  latencyLabel: 'Latency',
  bandwidthMbps: 'Mbps',
  latencyMs: 'ms',
  lastDetection: 'Last Detection',
  reDetectNetwork: 'Re-detect',
  detecting: 'Detecting...',
  networkDetectionComplete: 'Network detection complete',
  networkDetectionFailed: 'Network detection failed',
};

export default en;
