import type { TranslationMessages } from '../types';

const zh: TranslationMessages = {
  // App
  appName: 'MrRSS',

  // Sidebar
  allArticles: '所有文章',
  unread: '未读',
  favorites: '收藏',
  readLater: '稍后阅读',
  imageGallery: '图片库',
  uncategorized: '未分类',
  searchFeeds: '搜索订阅源...',
  addFeed: '添加订阅',
  settings: '设置',

  // Article List
  articles: '文章',
  refresh: '刷新',
  markAllRead: '全部已读',
  search: '搜索...',
  noArticles: '未找到文章。',

  // Article Detail
  back: '返回',
  markAsUnread: '标记为未读',
  markAsRead: '标记为已读',
  toggleFavorite: '切换收藏',
  addToFavorite: '添加到收藏',
  removeFromFavorite: '取消收藏',
  addToReadLater: '添加到稍后阅读',
  removeFromReadLater: '从稍后阅读中移除',
  openInBrowser: '在浏览器中打开',
  viewOriginal: '查看原网页',
  viewContent: '查看内容',
  renderContent: '渲染内容',
  close: '关闭',
  zoomIn: '放大',
  zoomOut: '缩小',
  imageViewerHelp: '使用鼠标滚轮或 +/- 键缩放 • 拖动移动 • ESC 关闭',
  imageViewerHelpExtended: '使用鼠标滚轮或 +/- 键缩放 • 拖动移动 • Ctrl+S 保存 • ESC 关闭',
  downloadImage: '下载图片',
  viewImage: '查看图片',
  podcastAudio: '播客音频',
  play: '播放',
  pause: '暂停',
  downloadAudio: '下载音频文件',
  audioPlaybackError: '无法播放音频。文件可能不可用或格式不受支持。',
  youtubeVideo: 'YouTube 视频',
  openInYouTube: '在 YouTube 中打开',
  videoLoadError: '无法加载视频。请尝试在 YouTube 中打开。',
  hideTranslations: '隐藏翻译',
  showTranslations: '显示翻译',

  // Context Menu
  unsubscribe: '取消订阅',
  editSubscription: '编辑订阅',
  renameCategory: '重命名分类',
  markAllAsReadFeed: '全部已读',
  addToFavorites: '添加到收藏',
  removeFromFavorites: '从收藏中移除',
  hideArticle: '隐藏文章',
  unhideArticle: '取消隐藏',
  selectArticle: '选择一篇文章开始阅读',
  showOriginal: '显示原网页',
  openWebsite: '打开网站',
  discoverFeeds: '发现订阅源',
  toggleSidebar: '切换侧边栏',

  // Feed Discovery
  fromFeed: '来自订阅源',
  discovering: '正在发现订阅源...',
  noFriendLinksFound: '未找到友链',
  discoveryFailed: '发现失败',
  foundFeeds: '找到 {count} 个订阅源',
  deselectAll: '取消全选',
  recentArticles: '最近文章',
  startDiscovery: '点击开始发现',
  subscribeSelected: '订阅选中',
  feedsSubscribedSuccess: '成功订阅 {count} 个订阅源',
  feedsSubscribedPartial: '成功订阅 {successful} 个，失败 {failed} 个',
  errorSubscribingFeeds: '订阅时出错',
  discoverAllFeeds: '发现所有订阅源',
  discoveringAllFeeds: '正在从所有订阅中发现新订阅源...',
  discoveryComplete: '发现完成',
  alreadyDiscovered: '已发现',
  markAsDiscovered: '标记为已发现',
  feedsWord: '个订阅源',
  preparing: '准备中',
  analyzingFeed: '正在分析订阅源',
  searchingFriendLinks: '正在搜索友链',
  checkingFeeds: '正在检查 RSS 订阅',
  pleaseWait: '请稍候，这可能需要几分钟时间',
  discoverAllFeedsDesc: '自动从所有尚未扫描的订阅源中发现新的订阅',
  subscribing: '正在订阅',
  fetchingHomepage: '正在获取主页',
  analyzingLinks: '正在分析发现的链接',
  preparingDiscovery: '正在准备发现',
  loadingFeeds: '正在加载订阅源',
  analyzingFeeds: '正在分析订阅源',
  scanningFriendLinks: '正在扫描友链',
  validatingRSS: '正在验证 RSS 订阅',
  checkingRssFeed: '正在检查 RSS 订阅',
  processingFeed: '正在处理第 {current}/{total} 个订阅源',
  foundPotentialLinks: '找到 {count} 个潜在博客链接',
  fetchingFriendPage: '正在获取友链页面',
  checkingSite: '正在检查站点',
  foundSoFar: '已找到 {count} 个订阅源',

  // Settings Modal
  settingsTitle: '设置',
  general: '常规',
  feeds: '订阅源',
  about: '关于',

  // General Settings
  appearance: '外观',
  theme: '主题',
  themeDesc: '选择您喜欢的配色方案',
  light: '亮色',
  dark: '暗色',
  auto: '自动（跟随系统）',
  darkMode: '暗色模式',
  darkModeDesc: '在亮色和暗色主题之间切换',
  updates: '更新',
  autoUpdateInterval: '自动更新间隔',
  autoUpdateIntervalDesc: '检查新文章的频率（分钟）',
  refreshMode: '刷新模式',
  refreshModeDesc: '选择固定间隔或智能刷新调度',
  fixedInterval: '固定间隔',
  intelligentInterval: '智能间隔',
  fixedIntervalDesc: '对所有订阅源使用相同的间隔',
  intelligentIntervalDesc: '根据订阅源活跃度调整刷新频率（5分钟-3小时）',
  lastArticleUpdate: '最后更新时间',
  lastArticleUpdateDesc: '上次刷新文章的时间',
  never: '从未',
  justNow: '刚刚',
  minutesAgo: '{count}分钟前',
  hoursAgo: '{count}小时前',
  daysAgo: '{count}天前',
  noContent: '此文章没有内容',
  defaultViewMode: '默认文章视图',
  defaultViewModeDesc: '选择默认显示文章的方式',
  viewModeOriginal: '原始网页',
  viewModeRendered: '渲染内容',
  showHiddenArticles: '显示隐藏文章',
  showHiddenArticlesDesc: '显示已被隐藏的文章',
  showArticlePreviewImages: '显示预览图片',
  showArticlePreviewImagesDesc: '在文章列表中显示预览图片',
  imageGalleryFeature: '图片库功能',
  imageGalleryEnabled: '启用图片库',
  imageGalleryEnabledDesc: '为图片类订阅源启用图片瀑布流模式',
  startupOnBoot: '开机自启动',
  startupOnBootDesc: '电脑启动时自动启动 MrRSS',
  closeToTray: '关闭时最小化到托盘',
  closeToTrayDesc: '点击关闭时隐藏到系统托盘并继续运行',
  database: '数据库',
  autoCleanup: '自动清理',
  autoCleanupDesc: '自动删除旧文章以节省空间',
  maxCacheSize: '最大缓存大小',
  maxCacheSizeDesc: '清理前的最大数据库大小（MB）',
  maxArticleAge: '最大文章保留天数',
  maxArticleAgeDesc: '删除超过此天数的旧文章（收藏文章除外）',
  mediaCache: '媒体缓存',
  mediaCacheEnabled: '启用媒体缓存',
  mediaCacheEnabledDesc: '本地缓存媒体文件以避免防盗链保护导致的链接失效',
  mediaCacheMaxSize: '最大缓存大小',
  mediaCacheMaxSizeDesc: '媒体缓存最大大小（MB）',
  mediaCacheMaxAge: '最大缓存保留天数',
  mediaCacheMaxAgeDesc: '删除超过此天数的缓存媒体',
  currentCacheSize: '当前缓存大小',
  mediaCacheCleanup: '清理媒体缓存',
  mediaCacheCleanupDesc: '删除旧的缓存媒体文件',
  cleanupMediaCache: '清理缓存',
  days: '天',
  translation: '翻译',
  enableTranslation: '启用翻译',
  enableTranslationDesc: '自动将文章标题翻译为您的首选语言',
  translationProvider: '翻译提供商',
  translationProviderDesc: '选择要使用的翻译服务',
  googleTranslate: '谷歌翻译',
  googleTranslateEndpoint: '谷歌翻译端点',
  googleTranslateEndpointDesc: '选择要使用的谷歌翻译 API 端点',
  googleTranslateEndpointDefault: '默认 (translate.googleapis.com)',
  googleTranslateEndpointAlternate: '备用 (clients5.google.com)',
  deeplApi: 'DeepL 翻译',
  deeplApiKey: 'DeepL API 密钥',
  deeplApiKeyDesc: '输入您的 DeepL API 密钥用于翻译',
  deeplApiKeyPlaceholder: '输入您的 DeepL API 密钥',
  baiduTranslate: '百度翻译',
  baiduAppId: '百度 App ID',
  baiduAppIdDesc: '输入您的百度翻译 App ID',
  baiduAppIdPlaceholder: '输入您的 App ID',
  baiduSecretKey: '百度密钥',
  baiduSecretKeyDesc: '输入您的百度翻译密钥',
  baiduSecretKeyPlaceholder: '输入您的密钥',
  aiTranslation: 'AI 翻译',
  aiApiKey: 'AI API 密钥',
  aiApiKeyDesc: '输入您的 AI 服务 API 密钥（OpenAI、Claude 等）',
  aiApiKeyPlaceholder: '输入您的 API 密钥',
  aiEndpoint: 'API 端点',
  aiEndpointDesc: 'API 端点 URL（留空使用 OpenAI 默认值）',
  aiEndpointPlaceholder: 'https://api.openai.com/v1',
  aiModel: '模型名称',
  aiModelDesc: '用于翻译的 AI 模型',
  aiModelPlaceholder: 'gpt-4o-mini',
  aiSystemPrompt: '自定义系统提示词',
  aiSystemPromptDesc: 'AI 翻译的自定义系统提示词',
  aiSystemPromptPlaceholder:
    '默认：你是一个翻译器。准确翻译给定的文本。只输出翻译的文本，不要输出其他内容。',
  targetLanguage: '目标语言',
  targetLanguageDesc: '将文章标题翻译为此语言',
  language: '语言',
  languageDesc: '选择界面语言',

  // Summary
  summary: '摘要',
  enableSummary: '启用自动摘要',
  enableSummaryDesc: '自动生成文章摘要',
  summaryProvider: '摘要提供商',
  summaryProviderDesc: '选择如何生成文章摘要',
  localAlgorithm: '本地算法',
  aiSummary: 'AI 摘要',
  summaryAiApiKey: 'AI API 密钥',
  summaryAiApiKeyDesc: '输入您的 AI 服务 API 密钥（OpenAI、Claude 等）',
  summaryAiApiKeyPlaceholder: '输入您的 API 密钥',
  summaryAiEndpoint: 'API 端点',
  summaryAiEndpointDesc: 'API 端点 URL（留空使用 OpenAI 默认值）',
  summaryAiEndpointPlaceholder: 'https://api.openai.com/v1',
  summaryAiModel: '模型名称',
  summaryAiModelDesc: '用于摘要的 AI 模型',
  summaryAiModelPlaceholder: 'gpt-4o-mini',
  summaryAiSystemPrompt: '自定义系统提示词',
  summaryAiSystemPromptDesc: 'AI 摘要的自定义系统提示词',
  summaryAiSystemPromptPlaceholder:
    '默认：你是一个摘要生成器。生成给定文本的简洁摘要。只输出摘要，不要输出其他内容。',
  summaryLength: '摘要长度',
  summaryLengthDesc: '控制生成摘要的长度',
  summaryLengthShort: '短',
  summaryLengthMedium: '中',
  summaryLengthLong: '长',
  generatingSummary: '正在生成摘要...',
  articleSummary: '文章摘要',
  summaryTooShort: '文章太短，无法生成有效摘要',
  noSummaryAvailable: '摘要不可用',
  generateSummary: '生成摘要',
  translating: '翻译中...',
  translatingContent: '正在翻译内容...',
  autoTranslateEnabled: '自动翻译已启用',
  originalContent: '原文',

  // Languages
  english: '英语',
  spanish: '西班牙语',
  french: '法语',
  german: '德语',
  chinese: '中文',
  japanese: '日语',

  // Proxy Settings
  proxySettings: '代理设置',
  enableProxy: '启用代理',
  enableProxyDesc: '使用代理服务器获取订阅和文章',
  proxyType: '代理类型',
  proxyTypeDesc: '选择要使用的代理协议',
  proxyHost: '代理主机',
  proxyHostDesc: '代理服务器主机名或 IP 地址',
  proxyHostPlaceholder: 'proxy.example.com',
  proxyPort: '代理端口',
  proxyPortDesc: '代理服务器端口号',
  proxyPortPlaceholder: '8080',
  proxyUsername: '代理用户名',
  proxyUsernameDesc: '代理身份验证用户名（可选）',
  proxyUsernamePlaceholder: '用户名',
  proxyPassword: '代理密码',
  proxyPasswordDesc: '代理身份验证密码（可选）',
  proxyPasswordPlaceholder: '密码',
  httpProxy: 'HTTP',
  httpsProxy: 'HTTPS',
  socks5Proxy: 'SOCKS5',
  proxyCredentialsRequired: '代理需要有效的主机和端口',
  invalidProxyUrl: '无效的代理 URL 格式',

  // Feeds Settings
  dataManagement: '数据管理',
  importOPML: '导入 OPML',
  exportOPML: '导出 OPML',
  cleanDatabase: '清理数据库',
  manageFeeds: '管理订阅源',
  deleteSelected: '删除选中',
  moveSelected: '移动选中',
  selectAll: '全选',
  edit: '编辑',
  delete: '删除',

  // About
  aboutApp: '一个简洁、现代的 RSS 阅读器。',
  version: '版本',
  viewOnGitHub: '在 GitHub 上查看',
  checkForUpdates: '检查更新',
  checking: '检查中...',
  upToDate: '您正在使用最新版本',
  updateAvailable: '有可用更新',
  currentVersion: '当前版本',
  latestVersion: '最新版本',
  downloadUpdate: '下载更新',
  downloading: '下载中...',
  downloadComplete: '下载完成',
  installingUpdate: '正在安装更新...',
  updateWillRestart: '应用程序将重启以安装更新',
  downloadFailed: '下载失败',
  installFailed: '安装失败',
  releaseNotes: '发行说明',
  errorCheckingUpdates: '检查更新时出错',

  // Modals
  addNewFeed: '添加新订阅',
  editFeed: '编辑订阅',
  rssUrl: 'RSS 地址',
  rssUrlPlaceholder: 'https://example.com/rss',
  category: '分类',
  categoryOptional: '分类（可选）',
  categoryPlaceholder: '例如：科技/新闻',
  title: '标题',
  titlePlaceholder: '自定义订阅标题',
  optional: '可选',
  required: '必填',
  feedProxy: '订阅源代理',
  feedProxyDesc: '为此订阅源配置代理设置（覆盖全局设置）',
  useGlobalProxy: '使用全局代理',
  useCustomProxy: '使用自定义代理',
  noProxy: '不使用代理',
  customProxyUrl: '自定义代理 URL',
  customProxyUrlPlaceholder: 'http://proxy.example.com:8080',
  feedProxyType: '代理类型',
  feedProxyHost: '代理主机',
  feedProxyPort: '代理端口',
  feedProxyUsername: '用户名（可选）',
  feedProxyPassword: '密码（可选）',
  feedRefreshMode: '刷新模式',
  feedRefreshModeDesc: '此订阅源的刷新方式',
  useGlobalRefresh: '使用全局设置',
  useFixedInterval: '固定间隔',
  useIntelligentInterval: '智能间隔',
  useCustomInterval: '自定义间隔',
  feedRefreshInterval: '刷新间隔',
  feedRefreshIntervalDesc: '此订阅源的自定义刷新间隔',
  feedRefreshIntervalPlaceholder: '分钟',
  minutesShort: '分钟',
  requiredField: '此项为必填项',
  fieldCannotBeEmpty: '此字段不能为空',
  invalidFormat: '格式不正确',
  translationCredentialsRequired: '翻译服务需要提供 API 密钥或凭据',
  summaryCredentialsRequired: 'AI 摘要需要提供 API 密钥',
  addSubscription: '添加订阅',
  saveChanges: '保存更改',
  adding: '添加中...',
  saving: '保存中...',
  saveSettings: '保存设置',

  // Confirm Dialogs
  confirm: '确认',
  cancel: '取消',
  deleteFeedTitle: '删除订阅',
  deleteFeedMessage: '确定要删除这个订阅吗？',
  deleteMultipleFeedsTitle: '删除多个订阅',
  deleteMultipleFeedsMessage: '确定要删除 {count} 个订阅吗？',
  unsubscribeTitle: '取消订阅',
  unsubscribeMessage: '确定要取消订阅 {name} 吗？',
  cleanDatabaseTitle: '清理数据库',
  cleanDatabaseMessage: '这将删除除已读和已收藏外的所有文章。是否继续？',
  clean: '清理',
  cleaning: '清理中...',

  // Toast Messages
  feedAddedSuccess: '订阅添加成功',
  feedUpdatedSuccess: '订阅更新成功',
  feedDeletedSuccess: '订阅删除成功',
  feedsDeletedSuccess: '订阅删除成功',
  feedsMovedSuccess: '订阅移动成功',
  unsubscribedSuccess: '取消订阅成功',
  markedAllAsRead: '所有文章已标记为已读',
  clearReadLater: '清空稍后阅读',
  clearedReadLater: '稍后阅读列表已清空',
  databaseCleanedSuccess: '数据库清理成功。已删除 {count} 篇文章。',
  opmlImportedSuccess: 'OPML 已导入。订阅源即将显示。',
  errorSavingSettings: '保存设置时出错',
  errorAddingFeed: '添加订阅时出错',
  errorUpdatingFeed: '更新订阅时出错',
  errorCleaningDatabase: '清理数据库时出错',
  importFailed: '导入失败：{error}',
  errorTranslating: '翻译失败。请检查网络连接和翻译设置。',
  errorTranslatingTitle: '翻译文章标题失败',
  errorTranslatingContent: '翻译内容失败',

  // Loading Messages
  loadingContent: '加载内容中',
  fetchingArticleContent: '正在从 RSS 源获取文章内容...',
  noContentAvailable: '无可用内容',

  // Prompts
  enterCategoryName: '输入新的分类名称：',
  customCategory: '自定义分类...',
  moveFeeds: '移动订阅',
  move: '移动',

  // Article Filter
  filter: '过滤',
  filterArticles: '过滤文章',
  addCondition: '添加条件',
  clearFilters: '清除过滤',
  clear: '清除',
  applyFilters: '应用过滤',
  noFiltersApplied: '未应用过滤条件',
  feedName: '订阅源名称',
  feedCategory: '订阅源分类',
  articleTitle: '文章标题',
  dateRange: '日期范围',
  publishedAfter: '发布于此日期及之后',
  publishedBefore: '发布于此日期及之前',
  readStatus: '已读状态',
  favoriteStatus: '收藏状态',
  hiddenStatus: '隐藏状态',
  readLaterStatus: '稍后阅读状态',
  yes: '是',
  no: '否',
  contains: '包含',
  exactMatch: '是',
  and: '且',
  or: '或',
  not: '非',
  filterCondition: '条件',
  filterField: '字段',
  filterOperator: '运算符',
  filterValue: '值',
  removeCondition: '删除',
  selectItems: '选择项目',
  itemsSelected: '已选择 {count} 项',
  filtersActive: '已启用 {count} 个过滤条件',
  andNMore: '等 {count} 个',

  // Keyboard Shortcuts
  shortcuts: '快捷键',
  shortcutsDesc: '自定义常用操作的键盘快捷键',
  shortcutNavigation: '导航',
  shortcutArticles: '文章',
  shortcutOther: '其他',
  nextArticle: '下一篇文章',
  previousArticle: '上一篇文章',
  openArticle: '打开文章',
  closeArticle: '关闭文章',
  toggleReadStatus: '切换已读状态',
  toggleFavoriteStatus: '切换收藏',
  openInBrowserShortcut: '在浏览器中打开',
  toggleContentView: '切换内容视图',
  refreshFeedsShortcut: '刷新订阅',
  markAllReadShortcut: '全部标记为已读',
  openSettingsShortcut: '打开设置',
  addFeedShortcut: '添加订阅',
  focusSearch: '聚焦搜索',
  focusFeedSearch: '聚焦订阅源搜索',
  toggleFilter: '切换文章过滤',
  goToAllArticles: '转到所有文章',
  goToUnread: '转到未读',
  goToFavorites: '转到收藏',
  goToReadLater: '转到稍后阅读',
  toggleReadLaterStatus: '切换稍后阅读',
  pressKey: '按下按键...',
  resetToDefault: '恢复默认',
  shortcutConflict: '此快捷键已被使用',
  shortcutCleared: '快捷键已清除',
  shortcutUpdated: '快捷键已更新',
  escToClear: '按 Escape 清除',

  // Rules
  rules: '规则',
  rulesDesc: '创建自动化规则，自动对文章执行操作',
  addRule: '添加规则',
  editRule: '编辑规则',
  deleteRule: '删除规则',
  noRules: '暂无规则',

  // Network
  network: '网络',
  noRulesHint: '创建规则以自动处理文章',
  ruleEnabled: '已启用',
  ruleDisabled: '已禁用',
  ruleCondition: '条件',
  ruleActions: '操作',
  ruleName: '规则名称',
  ruleNamePlaceholder: '例如：自动收藏科技新闻',
  selectCondition: '选择条件',
  selectActions: '选择操作',
  conditionAlways: '始终（所有文章）',
  conditionIf: '如果',
  actionFavorite: '添加到收藏',
  actionUnfavorite: '取消收藏',
  actionHide: '隐藏文章',
  actionUnhide: '取消隐藏',
  actionMarkRead: '标记为已读',
  actionMarkUnread: '标记为未读',
  actionReadLater: '添加到稍后阅读',
  actionRemoveReadLater: '从稍后阅读中移除',
  addAction: '添加操作',
  removeAction: '删除操作',
  ruleDeleteConfirmTitle: '删除规则',
  ruleDeleteConfirmMessage: '确定要删除此规则吗？',
  ruleSavedSuccess: '规则保存成功',
  ruleDeletedSuccess: '规则删除成功',
  ruleAppliedSuccess: '规则已应用于 {count} 篇文章',
  applyRuleNow: '立即应用',
  applyingRule: '应用中...',
  noActionsSelected: '请至少选择一个操作',
  thenDo: '则',

  // Custom Script Support
  feedSource: '订阅源类型',
  customScript: '自定义脚本',
  selectScript: '选择脚本',
  selectScriptPlaceholder: '选择一个脚本...',
  noScriptsFound: '脚本文件夹中未找到脚本。',
  openScriptsFolder: '打开脚本文件夹',
  scriptHelp: '脚本应输出有效的 RSS/Atom XML。支持：Python、Shell、PowerShell、Node.js、Ruby。',
  scriptsFolderOpened: '脚本文件夹已打开',
  scriptDocumentation: '查看文档',
  useCustomScript: '使用自定义脚本',
  useRssUrl: '使用 RSS 地址',

  // Feed Management
  refreshFeed: '刷新订阅源',
  feedRefreshStarted: '订阅源刷新已开始',
  sortByName: '名称',
  sortByDate: '添加时间',
  sortByCategory: '分类',
  hideFromTimeline: '从时间线隐藏',
  hideFromTimelineDesc: '在"所有文章"和"未读"视图中隐藏此订阅源的文章',
  imageMode: '图片模式',
  imageModeDesc: '以图片库视图而非文章列表展示此订阅源',
  advancedSettings: '高级设置',
  showAdvancedSettings: '显示高级设置',
  hideAdvancedSettings: '隐藏高级设置',

  // Network Settings
  networkSettings: '网络设置',
  networkSettingsDescription: '自动检测网络速度以优化并行刷新订阅源的性能',
  bandwidthLabel: '带宽',
  latencyLabel: '延迟',
  bandwidthMbps: '兆每秒',
  latencyMs: '毫秒',
  lastDetection: '上次检测',
  reDetectNetwork: '重新检测',
  detecting: '检测中...',
  networkDetectionComplete: '网络检测完成',
  networkDetectionFailed: '网络检测失败',
};

export default zh;
