// Package summary provides text summarization using local algorithms.
// It implements TF-IDF and TextRank-based sentence scoring for extractive summarization.
package summary

// SummaryLength represents the desired length of the summary
type SummaryLength string

const (
	// Short summary with fewer sentences
	Short SummaryLength = "short"
	// Medium summary with moderate sentences
	Medium SummaryLength = "medium"
	// Long summary with more sentences
	Long SummaryLength = "long"
)

// MinContentLength is the minimum text length required for meaningful summarization
const MinContentLength = 200

// MinSentenceCount is the minimum number of sentences required for summarization
const MinSentenceCount = 3

// MaxInputCharsForAI is the maximum number of characters to send to AI for summarization.
// 4000 characters ≈ 1000 tokens for most languages (average 4 chars/token), leaving room for
// system prompt and response within typical 8k token context windows. This limits token usage
// while providing enough context for a good summary.
const MaxInputCharsForAI = 4000

// Target word counts for different summary lengths
// For Chinese text, each Chinese character is roughly equivalent to one English word
const (
	ShortTargetWords  = 50  // ~50 words or Chinese characters
	MediumTargetWords = 100 // ~100 words or Chinese characters
	LongTargetWords   = 150 // ~150 words or Chinese characters
)

// SummaryResult contains the generated summary and metadata
type SummaryResult struct {
	Summary       string `json:"summary"`
	SentenceCount int    `json:"sentence_count"`
	IsTooShort    bool   `json:"is_too_short"`
}

// scoredSentence holds a sentence with its calculated score and position
type scoredSentence struct {
	text     string
	score    float64
	position int
}
