#!/bin/bash
#
# Example script for MrRSS - Shell RSS Feed Generator
#
# This script demonstrates how to create a custom RSS feed script using Bash.
# Place this file in the MrRSS scripts directory and select it when adding a new feed.
#
# The script outputs valid RSS 2.0 XML to stdout.

# Get current date in RFC 2822 format
CURRENT_DATE=$(date -u +"%a, %d %b %Y %H:%M:%S GMT")

# Generate RSS feed
cat << EOF
<?xml version="1.0" encoding="UTF-8"?>
<rss version="2.0">
  <channel>
    <title>Example Shell Feed</title>
    <link>https://github.com/WCY-dt/MrRSS</link>
    <description>An example feed generated by a shell script</description>
    <lastBuildDate>${CURRENT_DATE}</lastBuildDate>
    <item>
      <title>Welcome to MrRSS Custom Scripts</title>
      <link>https://github.com/WCY-dt/MrRSS</link>
      <description>This is an example article generated by a custom shell script.</description>
      <pubDate>${CURRENT_DATE}</pubDate>
    </item>
    <item>
      <title>How to Create Custom Feed Scripts</title>
      <link>https://github.com/WCY-dt/MrRSS/blob/main/docs/CUSTOM_SCRIPTS.md</link>
      <description>Learn how to create your own custom scripts to fetch content from any source.</description>
      <pubDate>${CURRENT_DATE}</pubDate>
    </item>
  </channel>
</rss>
EOF
