import datetime
import pytz
test_date_range_short = [
    datetime.datetime(2016, 5, 13, 23, 44, 19, 55552, tzinfo=pytz.utc),
    """
Timestamp,Interface Name,Point ID,Flow (MWH),Positive Limit (MWH),Negative Limit (MWH)
05/13/2016 00:00,CENTRAL EAST - VC,23330,2310.91,2410,-9999
05/13/2016 00:00,DYSINGER EAST,23326,679.17,3150,-9999
05/13/2016 00:00,MOSES SOUTH,23319,1342.15,2850,-1600
05/13/2016 00:00,SCH - HQ - NY,23324,895,1000,0
05/13/2016 00:00,SCH - HQ_CEDARS,325274,95,190,-40
05/13/2016 00:00,SCH - HQ_IMPORT_EXPORT,325376,630,1310,-9999
05/13/2016 00:00,SCH - NE - NY,23318,-641.5,1400,-1600
05/13/2016 00:00,SCH - NPX_1385,325277,79,200,-200
05/13/2016 00:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:00,SCH - OH - NY,23317,802.15,1100,-1900
05/13/2016 00:00,SCH - PJ - NY,23316,-19.88,2300,-800
05/13/2016 00:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:00,SCH - PJM_NEPTUNE,325305,500,660,-660
05/13/2016 00:00,SCH - PJM_VFT,325658,145,315,-315
05/13/2016 00:00,SPR/DUN-SOUTH,23320,1339.1,4350,-9999
05/13/2016 00:00,TOTAL EAST,23314,3465.32,6500,-9999
05/13/2016 00:00,UPNY CONED,23315,1312.71,4850,-9999
05/13/2016 00:00,WEST CENTRAL,23312,400.02,9999,-9999
05/13/2016 00:05,CENTRAL EAST - VC,23330,2309.25,2410,-9999
05/13/2016 00:05,DYSINGER EAST,23326,558.9,3150,-9999
05/13/2016 00:05,MOSES SOUTH,23319,1414.65,2850,-1600
05/13/2016 00:05,SCH - HQ - NY,23324,867,1000,0
05/13/2016 00:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:05,SCH - HQ_IMPORT_EXPORT,325376,608,1310,-9999
05/13/2016 00:05,SCH - NE - NY,23318,-541.8,1400,-1600
05/13/2016 00:05,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:05,SCH - OH - NY,23317,802.06,1100,-1900
05/13/2016 00:05,SCH - PJ - NY,23316,-35.73,2300,-800
05/13/2016 00:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:05,SCH - PJM_NEPTUNE,325305,339,660,-660
05/13/2016 00:05,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 00:05,SPR/DUN-SOUTH,23320,1184.49,4350,-9999
05/13/2016 00:05,TOTAL EAST,23314,3456.41,6500,-9999
05/13/2016 00:05,UPNY CONED,23315,1326.23,4850,-9999
05/13/2016 00:05,WEST CENTRAL,23312,287.8,9999,-9999
05/13/2016 00:10,CENTRAL EAST - VC,23330,2304.12,2410,-9999
05/13/2016 00:10,DYSINGER EAST,23326,595.52,3150,-9999
05/13/2016 00:10,MOSES SOUTH,23319,1436.75,2850,-1600
05/13/2016 00:10,SCH - HQ - NY,23324,867,1000,0
05/13/2016 00:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:10,SCH - HQ_IMPORT_EXPORT,325376,608,1310,-9999
05/13/2016 00:10,SCH - NE - NY,23318,-541.64,1400,-1600
05/13/2016 00:10,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:10,SCH - OH - NY,23317,802.4,1100,-1900
05/13/2016 00:10,SCH - PJ - NY,23316,-36.01,2300,-800
05/13/2016 00:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:10,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:10,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 00:10,SPR/DUN-SOUTH,23320,1166.81,4350,-9999
05/13/2016 00:10,TOTAL EAST,23314,3443.14,6500,-9999
05/13/2016 00:10,UPNY CONED,23315,1298.47,4850,-9999
05/13/2016 00:10,WEST CENTRAL,23312,328.61,9999,-9999
05/13/2016 00:15,CENTRAL EAST - VC,23330,2309.16,2410,-9999
05/13/2016 00:15,DYSINGER EAST,23326,633.89,3150,-9999
05/13/2016 00:15,MOSES SOUTH,23319,1331.31,2850,-1600
05/13/2016 00:15,SCH - HQ - NY,23324,848,1000,0
05/13/2016 00:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:15,SCH - HQ_IMPORT_EXPORT,325376,589,1310,-9999
05/13/2016 00:15,SCH - NE - NY,23318,-504.77,1400,-1600
05/13/2016 00:15,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:15,SCH - OH - NY,23317,802.28,1100,-1900
05/13/2016 00:15,SCH - PJ - NY,23316,-51.54,2300,-800
05/13/2016 00:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:15,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:15,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 00:15,SPR/DUN-SOUTH,23320,1231.61,4350,-9999
05/13/2016 00:15,TOTAL EAST,23314,3418.39,6500,-9999
05/13/2016 00:15,UPNY CONED,23315,1357.3,4850,-9999
05/13/2016 00:15,WEST CENTRAL,23312,368.34,9999,-9999
05/13/2016 00:20,CENTRAL EAST - VC,23330,2258.23,2360,-9999
05/13/2016 00:20,DYSINGER EAST,23326,596.42,3150,-9999
05/13/2016 00:20,MOSES SOUTH,23319,1323.25,2850,-1600
05/13/2016 00:20,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:20,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:20,SCH - NE - NY,23318,-470.88,1400,-1600
05/13/2016 00:20,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:20,SCH - OH - NY,23317,802.92,1100,-1900
05/13/2016 00:20,SCH - PJ - NY,23316,-66.04,2300,-800
05/13/2016 00:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:20,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 00:20,SPR/DUN-SOUTH,23320,1150.02,4350,-9999
05/13/2016 00:20,TOTAL EAST,23314,3273.9,6500,-9999
05/13/2016 00:20,UPNY CONED,23315,1279.21,4850,-9999
05/13/2016 00:20,WEST CENTRAL,23312,335.48,9999,-9999
05/13/2016 00:25,CENTRAL EAST - VC,23330,2254.29,2360,-9999
05/13/2016 00:25,DYSINGER EAST,23326,592.11,3150,-9999
05/13/2016 00:25,MOSES SOUTH,23319,1287.88,2850,-1600
05/13/2016 00:25,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:25,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:25,SCH - NE - NY,23318,-467.82,1400,-1600
05/13/2016 00:25,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:25,SCH - OH - NY,23317,802.97,1100,-1900
05/13/2016 00:25,SCH - PJ - NY,23316,-67.38,2300,-800
05/13/2016 00:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:25,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 00:25,SPR/DUN-SOUTH,23320,1172.69,4350,-9999
05/13/2016 00:25,TOTAL EAST,23314,3224.62,6500,-9999
05/13/2016 00:25,UPNY CONED,23315,1317.51,4850,-9999
05/13/2016 00:25,WEST CENTRAL,23312,338.23,9999,-9999
05/13/2016 00:30,CENTRAL EAST - VC,23330,2253.76,2360,-9999
05/13/2016 00:30,DYSINGER EAST,23326,454.19,3150,-9999
05/13/2016 00:30,MOSES SOUTH,23319,1283.93,2850,-1600
05/13/2016 00:30,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:30,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:30,SCH - NE - NY,23318,-485.57,1400,-1600
05/13/2016 00:30,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:30,SCH - OH - NY,23317,802.46,1100,-1900
05/13/2016 00:30,SCH - PJ - NY,23316,-68.12,2300,-800
05/13/2016 00:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:30,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:30,SCH - PJM_VFT,325658,234,315,-315
05/13/2016 00:30,SPR/DUN-SOUTH,23320,1214.95,4350,-9999
05/13/2016 00:30,TOTAL EAST,23314,3175.25,6500,-9999
05/13/2016 00:30,UPNY CONED,23315,1355.34,4850,-9999
05/13/2016 00:30,WEST CENTRAL,23312,205.3,9999,-9999
05/13/2016 00:35,CENTRAL EAST - VC,23330,2223.07,2330,-9999
05/13/2016 00:35,DYSINGER EAST,23326,479.24,3150,-9999
05/13/2016 00:35,MOSES SOUTH,23319,1270.46,2850,-1600
05/13/2016 00:35,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:35,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:35,SCH - NE - NY,23318,-504.53,1400,-1600
05/13/2016 00:35,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:35,SCH - OH - NY,23317,803.01,1100,-1900
05/13/2016 00:35,SCH - PJ - NY,23316,-69.78,2300,-800
05/13/2016 00:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:35,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:35,SCH - PJM_VFT,325658,178,315,-315
05/13/2016 00:35,SPR/DUN-SOUTH,23320,1197.08,4350,-9999
05/13/2016 00:35,TOTAL EAST,23314,3094.97,6500,-9999
05/13/2016 00:35,UPNY CONED,23315,1326.41,4850,-9999
05/13/2016 00:35,WEST CENTRAL,23312,231.13,9999,-9999
05/13/2016 00:40,CENTRAL EAST - VC,23330,2221.85,2330,-9999
05/13/2016 00:40,DYSINGER EAST,23326,453.98,3150,-9999
05/13/2016 00:40,MOSES SOUTH,23319,1255.82,2850,-1600
05/13/2016 00:40,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:40,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:40,SCH - NE - NY,23318,-504.64,1400,-1600
05/13/2016 00:40,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:40,SCH - OH - NY,23317,803.04,1100,-1900
05/13/2016 00:40,SCH - PJ - NY,23316,-67.95,2300,-800
05/13/2016 00:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:40,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:40,SCH - PJM_VFT,325658,178,315,-315
05/13/2016 00:40,SPR/DUN-SOUTH,23320,1198.13,4350,-9999
05/13/2016 00:40,TOTAL EAST,23314,3088.16,6500,-9999
05/13/2016 00:40,UPNY CONED,23315,1315.39,4850,-9999
05/13/2016 00:40,WEST CENTRAL,23312,208.98,9999,-9999
05/13/2016 00:45,CENTRAL EAST - VC,23330,2227.5,2330,-9999
05/13/2016 00:45,DYSINGER EAST,23326,490.74,3150,-9999
05/13/2016 00:45,MOSES SOUTH,23319,1254.35,2850,-1600
05/13/2016 00:45,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:45,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:45,SCH - NE - NY,23318,-504.69,1400,-1600
05/13/2016 00:45,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:45,SCH - OH - NY,23317,802.58,1100,-1900
05/13/2016 00:45,SCH - PJ - NY,23316,-67.38,2300,-800
05/13/2016 00:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:45,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:45,SCH - PJM_VFT,325658,219,315,-315
05/13/2016 00:45,SPR/DUN-SOUTH,23320,1224.85,4350,-9999
05/13/2016 00:45,TOTAL EAST,23314,3193.92,6500,-9999
05/13/2016 00:45,UPNY CONED,23315,1344.34,4850,-9999
05/13/2016 00:45,WEST CENTRAL,23312,248.61,9999,-9999
05/13/2016 00:50,CENTRAL EAST - VC,23330,2270.11,2330,-9999
05/13/2016 00:50,DYSINGER EAST,23326,349.21,3150,-9999
05/13/2016 00:50,MOSES SOUTH,23319,1071.76,2850,-1600
05/13/2016 00:50,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:50,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:50,SCH - NE - NY,23318,-504.72,1400,-1600
05/13/2016 00:50,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:50,SCH - OH - NY,23317,802.96,1100,-1900
05/13/2016 00:50,SCH - PJ - NY,23316,-69.29,2300,-800
05/13/2016 00:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:50,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:50,SCH - PJM_VFT,325658,260,315,-315
05/13/2016 00:50,SPR/DUN-SOUTH,23320,725.32,4350,-9999
05/13/2016 00:50,TOTAL EAST,23314,2495.52,6500,-9999
05/13/2016 00:50,UPNY CONED,23315,728.26,4850,-9999
05/13/2016 00:50,WEST CENTRAL,23312,108.39,9999,-9999
05/13/2016 00:55,CENTRAL EAST - VC,23330,2236.09,2330,-9999
05/13/2016 00:55,DYSINGER EAST,23326,227.21,3150,-9999
05/13/2016 00:55,MOSES SOUTH,23319,1093.48,2850,-1600
05/13/2016 00:55,SCH - HQ - NY,23324,829,1000,0
05/13/2016 00:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 00:55,SCH - HQ_IMPORT_EXPORT,325376,570,1310,-9999
05/13/2016 00:55,SCH - NE - NY,23318,-504.72,1400,-1600
05/13/2016 00:55,SCH - NPX_1385,325277,50,200,-200
05/13/2016 00:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 00:55,SCH - OH - NY,23317,803.08,1100,-1900
05/13/2016 00:55,SCH - PJ - NY,23316,-69.29,2300,-800
05/13/2016 00:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 00:55,SCH - PJM_NEPTUNE,325305,340,660,-660
05/13/2016 00:55,SCH - PJM_VFT,325658,260,315,-315
05/13/2016 00:55,SPR/DUN-SOUTH,23320,786.42,4350,-9999
05/13/2016 00:55,TOTAL EAST,23314,2496.93,6500,-9999
05/13/2016 00:55,UPNY CONED,23315,761.62,4850,-9999
05/13/2016 00:55,WEST CENTRAL,23312,-10.31,9999,-9999
05/13/2016 01:00,CENTRAL EAST - VC,23330,2230.59,2330,-9999
05/13/2016 01:00,DYSINGER EAST,23326,232.94,3150,-9999
05/13/2016 01:00,MOSES SOUTH,23319,1029.68,2850,-1600
05/13/2016 01:00,SCH - HQ - NY,23324,837,1000,0
05/13/2016 01:00,SCH - HQ_CEDARS,325274,95,190,-40
05/13/2016 01:00,SCH - HQ_IMPORT_EXPORT,325376,578,1310,-9999
05/13/2016 01:00,SCH - NE - NY,23318,-503.65,1400,-1600
05/13/2016 01:00,SCH - NPX_1385,325277,94,200,-200
05/13/2016 01:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:00,SCH - OH - NY,23317,803.52,1100,-1900
05/13/2016 01:00,SCH - PJ - NY,23316,-67.16,2300,-800
05/13/2016 01:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:00,SCH - PJM_NEPTUNE,325305,224,660,-660
05/13/2016 01:00,SCH - PJM_VFT,325658,226,315,-315
05/13/2016 01:00,SPR/DUN-SOUTH,23320,721.97,4350,-9999
05/13/2016 01:00,TOTAL EAST,23314,2461.09,6500,-9999
05/13/2016 01:00,UPNY CONED,23315,778.7,4850,-9999
05/13/2016 01:00,WEST CENTRAL,23312,-.23,9999,-9999
05/13/2016 01:05,CENTRAL EAST - VC,23330,2223.85,2330,-9999
05/13/2016 01:05,DYSINGER EAST,23326,327.06,3150,-9999
05/13/2016 01:05,MOSES SOUTH,23319,895.5,2850,-1600
05/13/2016 01:05,SCH - HQ - NY,23324,846,1000,0
05/13/2016 01:05,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:05,SCH - HQ_IMPORT_EXPORT,325376,587,1310,-9999
05/13/2016 01:05,SCH - NE - NY,23318,-503.76,1400,-1600
05/13/2016 01:05,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:05,SCH - OH - NY,23317,803.84,1100,-1900
05/13/2016 01:05,SCH - PJ - NY,23316,-63.97,2300,-800
05/13/2016 01:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:05,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:05,SCH - PJM_VFT,325658,193,315,-315
05/13/2016 01:05,SPR/DUN-SOUTH,23320,737.45,4350,-9999
05/13/2016 01:05,TOTAL EAST,23314,2381.42,6500,-9999
05/13/2016 01:05,UPNY CONED,23315,761.39,4850,-9999
05/13/2016 01:05,WEST CENTRAL,23312,101.54,9999,-9999
05/13/2016 01:10,CENTRAL EAST - VC,23330,2215.69,2330,-9999
05/13/2016 01:10,DYSINGER EAST,23326,169.28,3150,-9999
05/13/2016 01:10,MOSES SOUTH,23319,909.56,2850,-1600
05/13/2016 01:10,SCH - HQ - NY,23324,846,1000,0
05/13/2016 01:10,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:10,SCH - HQ_IMPORT_EXPORT,325376,587,1310,-9999
05/13/2016 01:10,SCH - NE - NY,23318,-503.66,1400,-1600
05/13/2016 01:10,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:10,SCH - OH - NY,23317,803.91,1100,-1900
05/13/2016 01:10,SCH - PJ - NY,23316,-64.38,2300,-800
05/13/2016 01:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:10,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:10,SCH - PJM_VFT,325658,193,315,-315
05/13/2016 01:10,SPR/DUN-SOUTH,23320,717.23,4350,-9999
05/13/2016 01:10,TOTAL EAST,23314,2260.77,6500,-9999
05/13/2016 01:10,UPNY CONED,23315,730.44,4850,-9999
05/13/2016 01:10,WEST CENTRAL,23312,-54.34,9999,-9999
05/13/2016 01:15,CENTRAL EAST - VC,23330,2199.69,2300,-9999
05/13/2016 01:15,DYSINGER EAST,23326,38.97,3150,-9999
05/13/2016 01:15,MOSES SOUTH,23319,955.59,2850,-1600
05/13/2016 01:15,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:15,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:15,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:15,SCH - NE - NY,23318,-429,1400,-1600
05/13/2016 01:15,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:15,SCH - OH - NY,23317,803.24,1100,-1900
05/13/2016 01:15,SCH - PJ - NY,23316,-68.47,2300,-800
05/13/2016 01:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:15,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:15,SCH - PJM_VFT,325658,241,315,-315
05/13/2016 01:15,SPR/DUN-SOUTH,23320,750.52,4350,-9999
05/13/2016 01:15,TOTAL EAST,23314,2299.28,6500,-9999
05/13/2016 01:15,UPNY CONED,23315,832.51,4850,-9999
05/13/2016 01:15,WEST CENTRAL,23312,-184.3,9999,-9999
05/13/2016 01:20,CENTRAL EAST - VC,23330,2198.3,2300,-9999
05/13/2016 01:20,DYSINGER EAST,23326,-74.14,3150,-9999
05/13/2016 01:20,MOSES SOUTH,23319,982.16,2850,-1600
05/13/2016 01:20,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:20,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:20,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:20,SCH - NE - NY,23318,-346.34,1400,-1600
05/13/2016 01:20,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:20,SCH - OH - NY,23317,802.85,1100,-1900
05/13/2016 01:20,SCH - PJ - NY,23316,-81.44,2300,-800
05/13/2016 01:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:20,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:20,SPR/DUN-SOUTH,23320,824.17,4350,-9999
05/13/2016 01:20,TOTAL EAST,23314,2244.62,6500,-9999
05/13/2016 01:20,UPNY CONED,23315,885.55,4850,-9999
05/13/2016 01:20,WEST CENTRAL,23312,-296.86,9999,-9999
05/13/2016 01:25,CENTRAL EAST - VC,23330,2189.06,2300,-9999
05/13/2016 01:25,DYSINGER EAST,23326,-43.44,3150,-9999
05/13/2016 01:25,MOSES SOUTH,23319,767.58,2850,-1600
05/13/2016 01:25,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:25,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:25,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:25,SCH - NE - NY,23318,-348.4,1400,-1600
05/13/2016 01:25,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:25,SCH - OH - NY,23317,802.89,1100,-1900
05/13/2016 01:25,SCH - PJ - NY,23316,-79.15,2300,-800
05/13/2016 01:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:25,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:25,SPR/DUN-SOUTH,23320,861.62,4350,-9999
05/13/2016 01:25,TOTAL EAST,23314,2100.97,6500,-9999
05/13/2016 01:25,UPNY CONED,23315,903.75,4850,-9999
05/13/2016 01:25,WEST CENTRAL,23312,-263.56,9999,-9999
05/13/2016 01:30,CENTRAL EAST - VC,23330,2197.14,2300,-9999
05/13/2016 01:30,DYSINGER EAST,23326,49.03,3150,-9999
05/13/2016 01:30,MOSES SOUTH,23319,794.56,2850,-1600
05/13/2016 01:30,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:30,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:30,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:30,SCH - NE - NY,23318,-343.23,1400,-1600
05/13/2016 01:30,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:30,SCH - OH - NY,23317,803.3,1100,-1900
05/13/2016 01:30,SCH - PJ - NY,23316,-110.88,2300,-800
05/13/2016 01:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:30,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:30,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:30,SPR/DUN-SOUTH,23320,621.19,4350,-9999
05/13/2016 01:30,TOTAL EAST,23314,2189.02,6500,-9999
05/13/2016 01:30,UPNY CONED,23315,660.3,4850,-9999
05/13/2016 01:30,WEST CENTRAL,23312,-166.71,9999,-9999
05/13/2016 01:35,CENTRAL EAST - VC,23330,2198.66,2300,-9999
05/13/2016 01:35,DYSINGER EAST,23326,34.06,3150,-9999
05/13/2016 01:35,MOSES SOUTH,23319,905.28,2850,-1600
05/13/2016 01:35,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:35,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:35,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:35,SCH - NE - NY,23318,-341.73,1400,-1600
05/13/2016 01:35,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:35,SCH - OH - NY,23317,803.72,1100,-1900
05/13/2016 01:35,SCH - PJ - NY,23316,-138.06,2300,-800
05/13/2016 01:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:35,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:35,SPR/DUN-SOUTH,23320,597.93,4350,-9999
05/13/2016 01:35,TOTAL EAST,23314,2214.89,6500,-9999
05/13/2016 01:35,UPNY CONED,23315,641.02,4850,-9999
05/13/2016 01:35,WEST CENTRAL,23312,-182.24,9999,-9999
05/13/2016 01:40,CENTRAL EAST - VC,23330,2190.32,2300,-9999
05/13/2016 01:40,DYSINGER EAST,23326,-6.19,3150,-9999
05/13/2016 01:40,MOSES SOUTH,23319,904.28,2850,-1600
05/13/2016 01:40,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:40,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:40,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:40,SCH - NE - NY,23318,-343.43,1400,-1600
05/13/2016 01:40,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:40,SCH - OH - NY,23317,803.88,1100,-1900
05/13/2016 01:40,SCH - PJ - NY,23316,-136.26,2300,-800
05/13/2016 01:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:40,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:40,SPR/DUN-SOUTH,23320,579.97,4350,-9999
05/13/2016 01:40,TOTAL EAST,23314,2177.73,6500,-9999
05/13/2016 01:40,UPNY CONED,23315,598.82,4850,-9999
05/13/2016 01:40,WEST CENTRAL,23312,-223.16,9999,-9999
05/13/2016 01:45,CENTRAL EAST - VC,23330,2200.76,2300,-9999
05/13/2016 01:45,DYSINGER EAST,23326,-57.15,3150,-9999
05/13/2016 01:45,MOSES SOUTH,23319,884.65,2850,-1600
05/13/2016 01:45,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:45,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:45,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:45,SCH - NE - NY,23318,-400.76,1400,-1600
05/13/2016 01:45,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:45,SCH - OH - NY,23317,803.73,1100,-1900
05/13/2016 01:45,SCH - PJ - NY,23316,-175.17,2300,-800
05/13/2016 01:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:45,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:45,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:45,SPR/DUN-SOUTH,23320,470.26,4350,-9999
05/13/2016 01:45,TOTAL EAST,23314,2096.76,6500,-9999
05/13/2016 01:45,UPNY CONED,23315,485.62,4850,-9999
05/13/2016 01:45,WEST CENTRAL,23312,-276.67,9999,-9999
05/13/2016 01:50,CENTRAL EAST - VC,23330,2200.37,2300,-9999
05/13/2016 01:50,DYSINGER EAST,23326,-41.66,3150,-9999
05/13/2016 01:50,MOSES SOUTH,23319,965.73,2850,-1600
05/13/2016 01:50,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:50,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:50,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:50,SCH - NE - NY,23318,-462.53,1400,-1600
05/13/2016 01:50,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:50,SCH - OH - NY,23317,803.85,1100,-1900
05/13/2016 01:50,SCH - PJ - NY,23316,-212.32,2300,-800
05/13/2016 01:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:50,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:50,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:50,SPR/DUN-SOUTH,23320,443.65,4350,-9999
05/13/2016 01:50,TOTAL EAST,23314,2099.39,6500,-9999
05/13/2016 01:50,UPNY CONED,23315,459.46,4850,-9999
05/13/2016 01:50,WEST CENTRAL,23312,-261.67,9999,-9999
05/13/2016 01:55,CENTRAL EAST - VC,23330,2192,2300,-9999
05/13/2016 01:55,DYSINGER EAST,23326,-73.33,3150,-9999
05/13/2016 01:55,MOSES SOUTH,23319,1042.75,2850,-1600
05/13/2016 01:55,SCH - HQ - NY,23324,845,1000,0
05/13/2016 01:55,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 01:55,SCH - HQ_IMPORT_EXPORT,325376,586,1310,-9999
05/13/2016 01:55,SCH - NE - NY,23318,-462.65,1400,-1600
05/13/2016 01:55,SCH - NPX_1385,325277,138,200,-200
05/13/2016 01:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 01:55,SCH - OH - NY,23317,803.92,1100,-1900
05/13/2016 01:55,SCH - PJ - NY,23316,-211.39,2300,-800
05/13/2016 01:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 01:55,SCH - PJM_NEPTUNE,325305,109,660,-660
05/13/2016 01:55,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 01:55,SPR/DUN-SOUTH,23320,455.21,4350,-9999
05/13/2016 01:55,TOTAL EAST,23314,2123.62,6500,-9999
05/13/2016 01:55,UPNY CONED,23315,464.49,4850,-9999
05/13/2016 01:55,WEST CENTRAL,23312,-292.14,9999,-9999
05/13/2016 02:00,CENTRAL EAST - VC,23330,2196.85,2300,-9999
05/13/2016 02:00,DYSINGER EAST,23326,-129.42,3150,-9999
05/13/2016 02:00,MOSES SOUTH,23319,1115.98,2850,-1600
05/13/2016 02:00,SCH - HQ - NY,23324,784,1000,0
05/13/2016 02:00,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:00,SCH - HQ_IMPORT_EXPORT,325376,525,1310,-9999
05/13/2016 02:00,SCH - NE - NY,23318,-417.73,1400,-1600
05/13/2016 02:00,SCH - NPX_1385,325277,79,200,-200
05/13/2016 02:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:00,SCH - OH - NY,23317,582.89,1100,-1900
05/13/2016 02:00,SCH - PJ - NY,23316,-164.85,2300,-800
05/13/2016 02:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:00,SCH - PJM_NEPTUNE,325305,84,660,-660
05/13/2016 02:00,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:00,SPR/DUN-SOUTH,23320,481.23,4350,-9999
05/13/2016 02:00,TOTAL EAST,23314,2115.07,6500,-9999
05/13/2016 02:00,UPNY CONED,23315,576.83,4850,-9999
05/13/2016 02:00,WEST CENTRAL,23312,-346.49,9999,-9999
05/13/2016 02:05,CENTRAL EAST - VC,23330,2198.77,2300,-9999
05/13/2016 02:05,DYSINGER EAST,23326,.17,3150,-9999
05/13/2016 02:05,MOSES SOUTH,23319,1013.24,2850,-1600
05/13/2016 02:05,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:05,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:05,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:05,SCH - NE - NY,23318,-372.65,1400,-1600
05/13/2016 02:05,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:05,SCH - OH - NY,23317,362.03,1100,-1900
05/13/2016 02:05,SCH - PJ - NY,23316,-115.81,2300,-800
05/13/2016 02:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:05,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:05,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:05,SPR/DUN-SOUTH,23320,471.04,4350,-9999
05/13/2016 02:05,TOTAL EAST,23314,2069.19,6500,-9999
05/13/2016 02:05,UPNY CONED,23315,613.32,4850,-9999
05/13/2016 02:05,WEST CENTRAL,23312,-211.45,9999,-9999
05/13/2016 02:10,CENTRAL EAST - VC,23330,2194.61,2300,-9999
05/13/2016 02:10,DYSINGER EAST,23326,108.64,3150,-9999
05/13/2016 02:10,MOSES SOUTH,23319,982.37,2850,-1600
05/13/2016 02:10,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:10,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:10,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:10,SCH - NE - NY,23318,-372.57,1400,-1600
05/13/2016 02:10,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:10,SCH - OH - NY,23317,357.83,1100,-1900
05/13/2016 02:10,SCH - PJ - NY,23316,-111.3,2300,-800
05/13/2016 02:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:10,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:10,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:10,SPR/DUN-SOUTH,23320,463.45,4350,-9999
05/13/2016 02:10,TOTAL EAST,23314,2062.42,6500,-9999
05/13/2016 02:10,UPNY CONED,23315,599.48,4850,-9999
05/13/2016 02:10,WEST CENTRAL,23312,-97.94,9999,-9999
05/13/2016 02:15,CENTRAL EAST - VC,23330,2197.57,2300,-9999
05/13/2016 02:15,DYSINGER EAST,23326,60.86,3150,-9999
05/13/2016 02:15,MOSES SOUTH,23319,949.74,2850,-1600
05/13/2016 02:15,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:15,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:15,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:15,SCH - NE - NY,23318,-351.57,1400,-1600
05/13/2016 02:15,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:15,SCH - OH - NY,23317,361.84,1100,-1900
05/13/2016 02:15,SCH - PJ - NY,23316,-116.99,2300,-800
05/13/2016 02:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:15,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:15,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:15,SPR/DUN-SOUTH,23320,465.28,4350,-9999
05/13/2016 02:15,TOTAL EAST,23314,2105.47,6500,-9999
05/13/2016 02:15,UPNY CONED,23315,655.52,4850,-9999
05/13/2016 02:15,WEST CENTRAL,23312,-146.19,9999,-9999
05/13/2016 02:20,CENTRAL EAST - VC,23330,2192.52,2300,-9999
05/13/2016 02:20,DYSINGER EAST,23326,-33.09,3150,-9999
05/13/2016 02:20,MOSES SOUTH,23319,941.4,2850,-1600
05/13/2016 02:20,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:20,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:20,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:20,SCH - NE - NY,23318,-330.62,1400,-1600
05/13/2016 02:20,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:20,SCH - OH - NY,23317,361.13,1100,-1900
05/13/2016 02:20,SCH - PJ - NY,23316,-115.12,2300,-800
05/13/2016 02:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:20,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:20,SPR/DUN-SOUTH,23320,504.59,4350,-9999
05/13/2016 02:20,TOTAL EAST,23314,2113.21,6500,-9999
05/13/2016 02:20,UPNY CONED,23315,703.37,4850,-9999
05/13/2016 02:20,WEST CENTRAL,23312,-242.03,9999,-9999
05/13/2016 02:25,CENTRAL EAST - VC,23330,2188.41,2300,-9999
05/13/2016 02:25,DYSINGER EAST,23326,-82.92,3150,-9999
05/13/2016 02:25,MOSES SOUTH,23319,962.17,2850,-1600
05/13/2016 02:25,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:25,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:25,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:25,SCH - NE - NY,23318,-330.68,1400,-1600
05/13/2016 02:25,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:25,SCH - OH - NY,23317,361.23,1100,-1900
05/13/2016 02:25,SCH - PJ - NY,23316,-112.52,2300,-800
05/13/2016 02:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:25,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:25,SPR/DUN-SOUTH,23320,495.81,4350,-9999
05/13/2016 02:25,TOTAL EAST,23314,2112.96,6500,-9999
05/13/2016 02:25,UPNY CONED,23315,700.3,4850,-9999
05/13/2016 02:25,WEST CENTRAL,23312,-289.98,9999,-9999
05/13/2016 02:30,CENTRAL EAST - VC,23330,2183.8,2300,-9999
05/13/2016 02:30,DYSINGER EAST,23326,-176.87,3150,-9999
05/13/2016 02:30,MOSES SOUTH,23319,995.7,2850,-1600
05/13/2016 02:30,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:30,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:30,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:30,SCH - NE - NY,23318,-339.69,1400,-1600
05/13/2016 02:30,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:30,SCH - OH - NY,23317,361.53,1100,-1900
05/13/2016 02:30,SCH - PJ - NY,23316,-113.98,2300,-800
05/13/2016 02:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:30,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:30,SCH - PJM_VFT,325658,294,315,-315
05/13/2016 02:30,SPR/DUN-SOUTH,23320,477.49,4350,-9999
05/13/2016 02:30,TOTAL EAST,23314,2046.89,6500,-9999
05/13/2016 02:30,UPNY CONED,23315,649.74,4850,-9999
05/13/2016 02:30,WEST CENTRAL,23312,-382,9999,-9999
05/13/2016 02:35,CENTRAL EAST - VC,23330,2191.07,2300,-9999
05/13/2016 02:35,DYSINGER EAST,23326,-210.63,3150,-9999
05/13/2016 02:35,MOSES SOUTH,23319,1073.63,2850,-1600
05/13/2016 02:35,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:35,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:35,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:35,SCH - NE - NY,23318,-348.67,1400,-1600
05/13/2016 02:35,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:35,SCH - OH - NY,23317,361.42,1100,-1900
05/13/2016 02:35,SCH - PJ - NY,23316,-114.85,2300,-800
05/13/2016 02:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:35,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:35,SCH - PJM_VFT,325658,298,315,-315
05/13/2016 02:35,SPR/DUN-SOUTH,23320,478.66,4350,-9999
05/13/2016 02:35,TOTAL EAST,23314,2085.84,6500,-9999
05/13/2016 02:35,UPNY CONED,23315,659.27,4850,-9999
05/13/2016 02:35,WEST CENTRAL,23312,-414.66,9999,-9999
05/13/2016 02:40,CENTRAL EAST - VC,23330,2199.14,2300,-9999
05/13/2016 02:40,DYSINGER EAST,23326,-100.61,3150,-9999
05/13/2016 02:40,MOSES SOUTH,23319,1039.72,2850,-1600
05/13/2016 02:40,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:40,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:40,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:40,SCH - NE - NY,23318,-348.62,1400,-1600
05/13/2016 02:40,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:40,SCH - OH - NY,23317,361.72,1100,-1900
05/13/2016 02:40,SCH - PJ - NY,23316,-114.55,2300,-800
05/13/2016 02:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:40,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:40,SCH - PJM_VFT,325658,298,315,-315
05/13/2016 02:40,SPR/DUN-SOUTH,23320,476.57,4350,-9999
05/13/2016 02:40,TOTAL EAST,23314,2113.83,6500,-9999
05/13/2016 02:40,UPNY CONED,23315,701.84,4850,-9999
05/13/2016 02:40,WEST CENTRAL,23312,-301.27,9999,-9999
05/13/2016 02:45,CENTRAL EAST - VC,23330,2190.79,2300,-9999
05/13/2016 02:45,DYSINGER EAST,23326,-133.86,3150,-9999
05/13/2016 02:45,MOSES SOUTH,23319,1015.8,2850,-1600
05/13/2016 02:45,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:45,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:45,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:45,SCH - NE - NY,23318,-369.44,1400,-1600
05/13/2016 02:45,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:45,SCH - OH - NY,23317,361.86,1100,-1900
05/13/2016 02:45,SCH - PJ - NY,23316,-116.18,2300,-800
05/13/2016 02:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:45,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:45,SCH - PJM_VFT,325658,294,315,-315
05/13/2016 02:45,SPR/DUN-SOUTH,23320,423.39,4350,-9999
05/13/2016 02:45,TOTAL EAST,23314,2014.43,6500,-9999
05/13/2016 02:45,UPNY CONED,23315,603.85,4850,-9999
05/13/2016 02:45,WEST CENTRAL,23312,-332.72,9999,-9999
05/13/2016 02:50,CENTRAL EAST - VC,23330,2192.96,2300,-9999
05/13/2016 02:50,DYSINGER EAST,23326,-211.54,3150,-9999
05/13/2016 02:50,MOSES SOUTH,23319,981.94,2850,-1600
05/13/2016 02:50,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:50,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:50,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:50,SCH - NE - NY,23318,-391.29,1400,-1600
05/13/2016 02:50,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:50,SCH - OH - NY,23317,360.54,1100,-1900
05/13/2016 02:50,SCH - PJ - NY,23316,-114.48,2300,-800
05/13/2016 02:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:50,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:50,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:50,SPR/DUN-SOUTH,23320,468.07,4350,-9999
05/13/2016 02:50,TOTAL EAST,23314,2122.67,6500,-9999
05/13/2016 02:50,UPNY CONED,23315,635.72,4850,-9999
05/13/2016 02:50,WEST CENTRAL,23312,-412.06,9999,-9999
05/13/2016 02:55,CENTRAL EAST - VC,23330,2196.17,2300,-9999
05/13/2016 02:55,DYSINGER EAST,23326,-249.22,3150,-9999
05/13/2016 02:55,MOSES SOUTH,23319,981.01,2850,-1600
05/13/2016 02:55,SCH - HQ - NY,23324,724,1000,0
05/13/2016 02:55,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 02:55,SCH - HQ_IMPORT_EXPORT,325376,465,1310,-9999
05/13/2016 02:55,SCH - NE - NY,23318,-391.28,1400,-1600
05/13/2016 02:55,SCH - NPX_1385,325277,20,200,-200
05/13/2016 02:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 02:55,SCH - OH - NY,23317,359.7,1100,-1900
05/13/2016 02:55,SCH - PJ - NY,23316,-116.83,2300,-800
05/13/2016 02:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 02:55,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 02:55,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 02:55,SPR/DUN-SOUTH,23320,492.22,4350,-9999
05/13/2016 02:55,TOTAL EAST,23314,2196.25,6500,-9999
05/13/2016 02:55,UPNY CONED,23315,664.81,4850,-9999
05/13/2016 02:55,WEST CENTRAL,23312,-452.07,9999,-9999
05/13/2016 03:00,CENTRAL EAST - VC,23330,2197.21,2300,-9999
05/13/2016 03:00,DYSINGER EAST,23326,-302.53,3150,-9999
05/13/2016 03:00,MOSES SOUTH,23319,1062.05,2850,-1600
05/13/2016 03:00,SCH - HQ - NY,23324,764,1000,0
05/13/2016 03:00,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:00,SCH - HQ_IMPORT_EXPORT,325376,505,1310,-9999
05/13/2016 03:00,SCH - NE - NY,23318,-291.57,1400,-1600
05/13/2016 03:00,SCH - NPX_1385,325277,62,200,-200
05/13/2016 03:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:00,SCH - OH - NY,23317,242.78,1100,-1900
05/13/2016 03:00,SCH - PJ - NY,23316,-132.53,2300,-800
05/13/2016 03:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:00,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:00,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:00,SPR/DUN-SOUTH,23320,523.6,4350,-9999
05/13/2016 03:00,TOTAL EAST,23314,2132.8,6500,-9999
05/13/2016 03:00,UPNY CONED,23315,681.54,4850,-9999
05/13/2016 03:00,WEST CENTRAL,23312,-508.44,9999,-9999
05/13/2016 03:05,CENTRAL EAST - VC,23330,2198.67,2300,-9999
05/13/2016 03:05,DYSINGER EAST,23326,-272.98,3150,-9999
05/13/2016 03:05,MOSES SOUTH,23319,1114.87,2850,-1600
05/13/2016 03:05,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:05,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:05,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:05,SCH - NE - NY,23318,-191.85,1400,-1600
05/13/2016 03:05,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:05,SCH - OH - NY,23317,125.84,1100,-1900
05/13/2016 03:05,SCH - PJ - NY,23316,-150.76,2300,-800
05/13/2016 03:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:05,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:05,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:05,SPR/DUN-SOUTH,23320,609.18,4350,-9999
05/13/2016 03:05,TOTAL EAST,23314,2108.28,6500,-9999
05/13/2016 03:05,UPNY CONED,23315,735.01,4850,-9999
05/13/2016 03:05,WEST CENTRAL,23312,-479,9999,-9999
05/13/2016 03:10,CENTRAL EAST - VC,23330,2205.36,2310,-9999
05/13/2016 03:10,DYSINGER EAST,23326,-171.1,3150,-9999
05/13/2016 03:10,MOSES SOUTH,23319,1101.57,2850,-1600
05/13/2016 03:10,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:10,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:10,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:10,SCH - NE - NY,23318,-192.41,1400,-1600
05/13/2016 03:10,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:10,SCH - OH - NY,23317,126.28,1100,-1900
05/13/2016 03:10,SCH - PJ - NY,23316,-151.49,2300,-800
05/13/2016 03:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:10,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:10,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:10,SPR/DUN-SOUTH,23320,591.77,4350,-9999
05/13/2016 03:10,TOTAL EAST,23314,2122.27,6500,-9999
05/13/2016 03:10,UPNY CONED,23315,715.41,4850,-9999
05/13/2016 03:10,WEST CENTRAL,23312,-374.22,9999,-9999
05/13/2016 03:15,CENTRAL EAST - VC,23330,2204.36,2310,-9999
05/13/2016 03:15,DYSINGER EAST,23326,-198.81,3150,-9999
05/13/2016 03:15,MOSES SOUTH,23319,1070.08,2850,-1600
05/13/2016 03:15,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:15,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:15,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:15,SCH - NE - NY,23318,-162.3,1400,-1600
05/13/2016 03:15,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:15,SCH - OH - NY,23317,125.66,1100,-1900
05/13/2016 03:15,SCH - PJ - NY,23316,-150.65,2300,-800
05/13/2016 03:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:15,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:15,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:15,SPR/DUN-SOUTH,23320,667.93,4350,-9999
05/13/2016 03:15,TOTAL EAST,23314,2156.23,6500,-9999
05/13/2016 03:15,UPNY CONED,23315,777.28,4850,-9999
05/13/2016 03:15,WEST CENTRAL,23312,-400.72,9999,-9999
05/13/2016 03:20,CENTRAL EAST - VC,23330,2206.62,2310,-9999
05/13/2016 03:20,DYSINGER EAST,23326,-205.35,3150,-9999
05/13/2016 03:20,MOSES SOUTH,23319,1078.81,2850,-1600
05/13/2016 03:20,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:20,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:20,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:20,SCH - NE - NY,23318,-129.14,1400,-1600
05/13/2016 03:20,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:20,SCH - OH - NY,23317,125.41,1100,-1900
05/13/2016 03:20,SCH - PJ - NY,23316,-154.63,2300,-800
05/13/2016 03:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:20,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:20,SPR/DUN-SOUTH,23320,720.68,4350,-9999
05/13/2016 03:20,TOTAL EAST,23314,2182.6,6500,-9999
05/13/2016 03:20,UPNY CONED,23315,839.14,4850,-9999
05/13/2016 03:20,WEST CENTRAL,23312,-409.28,9999,-9999
05/13/2016 03:25,CENTRAL EAST - VC,23330,2207.15,2310,-9999
05/13/2016 03:25,DYSINGER EAST,23326,-152.38,3150,-9999
05/13/2016 03:25,MOSES SOUTH,23319,1103.37,2850,-1600
05/13/2016 03:25,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:25,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:25,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:25,SCH - NE - NY,23318,-128.32,1400,-1600
05/13/2016 03:25,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:25,SCH - OH - NY,23317,125.49,1100,-1900
05/13/2016 03:25,SCH - PJ - NY,23316,-157.25,2300,-800
05/13/2016 03:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:25,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:25,SPR/DUN-SOUTH,23320,692.54,4350,-9999
05/13/2016 03:25,TOTAL EAST,23314,2234.91,6500,-9999
05/13/2016 03:25,UPNY CONED,23315,816.61,4850,-9999
05/13/2016 03:25,WEST CENTRAL,23312,-357.71,9999,-9999
05/13/2016 03:30,CENTRAL EAST - VC,23330,2199.36,2310,-9999
05/13/2016 03:30,DYSINGER EAST,23326,-192.58,3150,-9999
05/13/2016 03:30,MOSES SOUTH,23319,1112.43,2850,-1600
05/13/2016 03:30,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:30,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:30,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:30,SCH - NE - NY,23318,-130.52,1400,-1600
05/13/2016 03:30,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:30,SCH - OH - NY,23317,125.41,1100,-1900
05/13/2016 03:30,SCH - PJ - NY,23316,-141.87,2300,-800
05/13/2016 03:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:30,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:30,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:30,SPR/DUN-SOUTH,23320,672.22,4350,-9999
05/13/2016 03:30,TOTAL EAST,23314,2222.22,6500,-9999
05/13/2016 03:30,UPNY CONED,23315,801.46,4850,-9999
05/13/2016 03:30,WEST CENTRAL,23312,-398.52,9999,-9999
05/13/2016 03:35,CENTRAL EAST - VC,23330,2199.03,2310,-9999
05/13/2016 03:35,DYSINGER EAST,23326,-195.85,3150,-9999
05/13/2016 03:35,MOSES SOUTH,23319,1107.93,2850,-1600
05/13/2016 03:35,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:35,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:35,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:35,SCH - NE - NY,23318,-131.1,1400,-1600
05/13/2016 03:35,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:35,SCH - OH - NY,23317,125.32,1100,-1900
05/13/2016 03:35,SCH - PJ - NY,23316,-128.31,2300,-800
05/13/2016 03:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:35,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:35,SPR/DUN-SOUTH,23320,670.23,4350,-9999
05/13/2016 03:35,TOTAL EAST,23314,2247.01,6500,-9999
05/13/2016 03:35,UPNY CONED,23315,819.72,4850,-9999
05/13/2016 03:35,WEST CENTRAL,23312,-399.68,9999,-9999
05/13/2016 03:40,CENTRAL EAST - VC,23330,2202.82,2310,-9999
05/13/2016 03:40,DYSINGER EAST,23326,-225.34,3150,-9999
05/13/2016 03:40,MOSES SOUTH,23319,1069.7,2850,-1600
05/13/2016 03:40,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:40,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:40,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:40,SCH - NE - NY,23318,-132.11,1400,-1600
05/13/2016 03:40,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:40,SCH - OH - NY,23317,125.11,1100,-1900
05/13/2016 03:40,SCH - PJ - NY,23316,-128.03,2300,-800
05/13/2016 03:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:40,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:40,SPR/DUN-SOUTH,23320,664.75,4350,-9999
05/13/2016 03:40,TOTAL EAST,23314,2231.31,6500,-9999
05/13/2016 03:40,UPNY CONED,23315,820.58,4850,-9999
05/13/2016 03:40,WEST CENTRAL,23312,-427.91,9999,-9999
05/13/2016 03:45,CENTRAL EAST - VC,23330,2197.87,2310,-9999
05/13/2016 03:45,DYSINGER EAST,23326,-245.54,3150,-9999
05/13/2016 03:45,MOSES SOUTH,23319,1051.05,2850,-1600
05/13/2016 03:45,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:45,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:45,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:45,SCH - NE - NY,23318,-129.45,1400,-1600
05/13/2016 03:45,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:45,SCH - OH - NY,23317,124.6,1100,-1900
05/13/2016 03:45,SCH - PJ - NY,23316,-108.87,2300,-800
05/13/2016 03:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:45,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:45,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:45,SPR/DUN-SOUTH,23320,745.7,4350,-9999
05/13/2016 03:45,TOTAL EAST,23314,2334.95,6500,-9999
05/13/2016 03:45,UPNY CONED,23315,894.62,4850,-9999
05/13/2016 03:45,WEST CENTRAL,23312,-449.14,9999,-9999
05/13/2016 03:50,CENTRAL EAST - VC,23330,2194.85,2310,-9999
05/13/2016 03:50,DYSINGER EAST,23326,-275.21,3150,-9999
05/13/2016 03:50,MOSES SOUTH,23319,1055.64,2850,-1600
05/13/2016 03:50,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:50,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:50,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:50,SCH - NE - NY,23318,-130.66,1400,-1600
05/13/2016 03:50,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:50,SCH - OH - NY,23317,124.81,1100,-1900
05/13/2016 03:50,SCH - PJ - NY,23316,-88.57,2300,-800
05/13/2016 03:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:50,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:50,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:50,SPR/DUN-SOUTH,23320,718.21,4350,-9999
05/13/2016 03:50,TOTAL EAST,23314,2287,6500,-9999
05/13/2016 03:50,UPNY CONED,23315,859.04,4850,-9999
05/13/2016 03:50,WEST CENTRAL,23312,-480.36,9999,-9999
05/13/2016 03:55,CENTRAL EAST - VC,23330,2204.06,2310,-9999
05/13/2016 03:55,DYSINGER EAST,23326,-305.34,3150,-9999
05/13/2016 03:55,MOSES SOUTH,23319,1072.1,2850,-1600
05/13/2016 03:55,SCH - HQ - NY,23324,804,1000,0
05/13/2016 03:55,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 03:55,SCH - HQ_IMPORT_EXPORT,325376,545,1310,-9999
05/13/2016 03:55,SCH - NE - NY,23318,-132.71,1400,-1600
05/13/2016 03:55,SCH - NPX_1385,325277,104,200,-200
05/13/2016 03:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 03:55,SCH - OH - NY,23317,124.62,1100,-1900
05/13/2016 03:55,SCH - PJ - NY,23316,-85.65,2300,-800
05/13/2016 03:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 03:55,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 03:55,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 03:55,SPR/DUN-SOUTH,23320,708.99,4350,-9999
05/13/2016 03:55,TOTAL EAST,23314,2300.28,6500,-9999
05/13/2016 03:55,UPNY CONED,23315,849.02,4850,-9999
05/13/2016 03:55,WEST CENTRAL,23312,-511.19,9999,-9999
05/13/2016 04:00,CENTRAL EAST - VC,23330,2198.18,2310,-9999
05/13/2016 04:00,DYSINGER EAST,23326,-293.47,3150,-9999
05/13/2016 04:00,MOSES SOUTH,23319,1113.13,2850,-1600
05/13/2016 04:00,SCH - HQ - NY,23324,828,1000,0
05/13/2016 04:00,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:00,SCH - HQ_IMPORT_EXPORT,325376,569,1310,-9999
05/13/2016 04:00,SCH - NE - NY,23318,-137.76,1400,-1600
05/13/2016 04:00,SCH - NPX_1385,325277,121,200,-200
05/13/2016 04:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:00,SCH - OH - NY,23317,115.85,1100,-1900
05/13/2016 04:00,SCH - PJ - NY,23316,-67.26,2300,-800
05/13/2016 04:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:00,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:00,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:00,SPR/DUN-SOUTH,23320,711.13,4350,-9999
05/13/2016 04:00,TOTAL EAST,23314,2316.11,6500,-9999
05/13/2016 04:00,UPNY CONED,23315,829.61,4850,-9999
05/13/2016 04:00,WEST CENTRAL,23312,-500.08,9999,-9999
05/13/2016 04:05,CENTRAL EAST - VC,23330,2196.72,2310,-9999
05/13/2016 04:05,DYSINGER EAST,23326,-306.28,3150,-9999
05/13/2016 04:05,MOSES SOUTH,23319,1148.59,2850,-1600
05/13/2016 04:05,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:05,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:05,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:05,SCH - NE - NY,23318,-147.07,1400,-1600
05/13/2016 04:05,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:05,SCH - OH - NY,23317,106.93,1100,-1900
05/13/2016 04:05,SCH - PJ - NY,23316,-41.32,2300,-800
05/13/2016 04:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:05,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:05,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:05,SPR/DUN-SOUTH,23320,707.6,4350,-9999
05/13/2016 04:05,TOTAL EAST,23314,2329.49,6500,-9999
05/13/2016 04:05,UPNY CONED,23315,811.51,4850,-9999
05/13/2016 04:05,WEST CENTRAL,23312,-515.7,9999,-9999
05/13/2016 04:10,CENTRAL EAST - VC,23330,2204.02,2310,-9999
05/13/2016 04:10,DYSINGER EAST,23326,-327.88,3150,-9999
05/13/2016 04:10,MOSES SOUTH,23319,1144.41,2850,-1600
05/13/2016 04:10,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:10,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:10,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:10,SCH - NE - NY,23318,-144.43,1400,-1600
05/13/2016 04:10,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:10,SCH - OH - NY,23317,106.86,1100,-1900
05/13/2016 04:10,SCH - PJ - NY,23316,-43.91,2300,-800
05/13/2016 04:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:10,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:10,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:10,SPR/DUN-SOUTH,23320,687.78,4350,-9999
05/13/2016 04:10,TOTAL EAST,23314,2312.37,6500,-9999
05/13/2016 04:10,UPNY CONED,23315,792.72,4850,-9999
05/13/2016 04:10,WEST CENTRAL,23312,-538.68,9999,-9999
05/13/2016 04:15,CENTRAL EAST - VC,23330,2207.6,2310,-9999
05/13/2016 04:15,DYSINGER EAST,23326,-320.06,3150,-9999
05/13/2016 04:15,MOSES SOUTH,23319,1128.79,2850,-1600
05/13/2016 04:15,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:15,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:15,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:15,SCH - NE - NY,23318,-127.26,1400,-1600
05/13/2016 04:15,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:15,SCH - OH - NY,23317,106.64,1100,-1900
05/13/2016 04:15,SCH - PJ - NY,23316,-45.47,2300,-800
05/13/2016 04:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:15,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:15,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:15,SPR/DUN-SOUTH,23320,715.06,4350,-9999
05/13/2016 04:15,TOTAL EAST,23314,2333.05,6500,-9999
05/13/2016 04:15,UPNY CONED,23315,830.05,4850,-9999
05/13/2016 04:15,WEST CENTRAL,23312,-531.48,9999,-9999
05/13/2016 04:20,CENTRAL EAST - VC,23330,2204.65,2310,-9999
05/13/2016 04:20,DYSINGER EAST,23326,-285.89,3150,-9999
05/13/2016 04:20,MOSES SOUTH,23319,1122.02,2850,-1600
05/13/2016 04:20,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:20,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:20,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:20,SCH - NE - NY,23318,-109.44,1400,-1600
05/13/2016 04:20,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:20,SCH - OH - NY,23317,106.74,1100,-1900
05/13/2016 04:20,SCH - PJ - NY,23316,-45.1,2300,-800
05/13/2016 04:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:20,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:20,SPR/DUN-SOUTH,23320,724.62,4350,-9999
05/13/2016 04:20,TOTAL EAST,23314,2329.81,6500,-9999
05/13/2016 04:20,UPNY CONED,23315,840.74,4850,-9999
05/13/2016 04:20,WEST CENTRAL,23312,-498.29,9999,-9999
05/13/2016 04:25,CENTRAL EAST - VC,23330,2204.42,2310,-9999
05/13/2016 04:25,DYSINGER EAST,23326,-283.49,3150,-9999
05/13/2016 04:25,MOSES SOUTH,23319,1127.26,2850,-1600
05/13/2016 04:25,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:25,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:25,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:25,SCH - NE - NY,23318,-108.36,1400,-1600
05/13/2016 04:25,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:25,SCH - OH - NY,23317,106.57,1100,-1900
05/13/2016 04:25,SCH - PJ - NY,23316,-46.25,2300,-800
05/13/2016 04:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:25,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:25,SPR/DUN-SOUTH,23320,737.07,4350,-9999
05/13/2016 04:25,TOTAL EAST,23314,2368.73,6500,-9999
05/13/2016 04:25,UPNY CONED,23315,865.61,4850,-9999
05/13/2016 04:25,WEST CENTRAL,23312,-497.13,9999,-9999
05/13/2016 04:30,CENTRAL EAST - VC,23330,2195.18,2310,-9999
05/13/2016 04:30,DYSINGER EAST,23326,-362.07,3150,-9999
05/13/2016 04:30,MOSES SOUTH,23319,1216.24,2850,-1600
05/13/2016 04:30,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:30,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:30,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:30,SCH - NE - NY,23318,-82.04,1400,-1600
05/13/2016 04:30,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:30,SCH - OH - NY,23317,106.86,1100,-1900
05/13/2016 04:30,SCH - PJ - NY,23316,-10.41,2300,-800
05/13/2016 04:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:30,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:30,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:30,SPR/DUN-SOUTH,23320,723.54,4350,-9999
05/13/2016 04:30,TOTAL EAST,23314,2342.56,6500,-9999
05/13/2016 04:30,UPNY CONED,23315,848.67,4850,-9999
05/13/2016 04:30,WEST CENTRAL,23312,-581.53,9999,-9999
05/13/2016 04:35,CENTRAL EAST - VC,23330,2195.41,2310,-9999
05/13/2016 04:35,DYSINGER EAST,23326,-453.87,3150,-9999
05/13/2016 04:35,MOSES SOUTH,23319,1258.86,2850,-1600
05/13/2016 04:35,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:35,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:35,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:35,SCH - NE - NY,23318,-57.65,1400,-1600
05/13/2016 04:35,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:35,SCH - OH - NY,23317,106.74,1100,-1900
05/13/2016 04:35,SCH - PJ - NY,23316,23.66,2300,-800
05/13/2016 04:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:35,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:35,SPR/DUN-SOUTH,23320,723.42,4350,-9999
05/13/2016 04:35,TOTAL EAST,23314,2308.11,6500,-9999
05/13/2016 04:35,UPNY CONED,23315,849.84,4850,-9999
05/13/2016 04:35,WEST CENTRAL,23312,-679.63,9999,-9999
05/13/2016 04:40,CENTRAL EAST - VC,23330,2201.22,2310,-9999
05/13/2016 04:40,DYSINGER EAST,23326,-510.36,3150,-9999
05/13/2016 04:40,MOSES SOUTH,23319,1277.89,2850,-1600
05/13/2016 04:40,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:40,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:40,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:40,SCH - NE - NY,23318,-59.56,1400,-1600
05/13/2016 04:40,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:40,SCH - OH - NY,23317,106.86,1100,-1900
05/13/2016 04:40,SCH - PJ - NY,23316,26.93,2300,-800
05/13/2016 04:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:40,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:40,SPR/DUN-SOUTH,23320,682.72,4350,-9999
05/13/2016 04:40,TOTAL EAST,23314,2255.02,6500,-9999
05/13/2016 04:40,UPNY CONED,23315,805.98,4850,-9999
05/13/2016 04:40,WEST CENTRAL,23312,-736.95,9999,-9999
05/13/2016 04:45,CENTRAL EAST - VC,23330,2209.46,2310,-9999
05/13/2016 04:45,DYSINGER EAST,23326,-365.95,3150,-9999
05/13/2016 04:45,MOSES SOUTH,23319,1262.85,2850,-1600
05/13/2016 04:45,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:45,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:45,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:45,SCH - NE - NY,23318,-100.99,1400,-1600
05/13/2016 04:45,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:45,SCH - OH - NY,23317,107.26,1100,-1900
05/13/2016 04:45,SCH - PJ - NY,23316,11.98,2300,-800
05/13/2016 04:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:45,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:45,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:45,SPR/DUN-SOUTH,23320,674.49,4350,-9999
05/13/2016 04:45,TOTAL EAST,23314,2335.13,6500,-9999
05/13/2016 04:45,UPNY CONED,23315,822.63,4850,-9999
05/13/2016 04:45,WEST CENTRAL,23312,-587.55,9999,-9999
05/13/2016 04:50,CENTRAL EAST - VC,23330,2208.44,2310,-9999
05/13/2016 04:50,DYSINGER EAST,23326,-375.53,3150,-9999
05/13/2016 04:50,MOSES SOUTH,23319,1248.98,2850,-1600
05/13/2016 04:50,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:50,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:50,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:50,SCH - NE - NY,23318,-145.5,1400,-1600
05/13/2016 04:50,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:50,SCH - OH - NY,23317,107.07,1100,-1900
05/13/2016 04:50,SCH - PJ - NY,23316,.4,2300,-800
05/13/2016 04:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:50,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:50,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:50,SPR/DUN-SOUTH,23320,603.8,4350,-9999
05/13/2016 04:50,TOTAL EAST,23314,2304.34,6500,-9999
05/13/2016 04:50,UPNY CONED,23315,754.61,4850,-9999
05/13/2016 04:50,WEST CENTRAL,23312,-599.19,9999,-9999
05/13/2016 04:55,CENTRAL EAST - VC,23330,2208.14,2310,-9999
05/13/2016 04:55,DYSINGER EAST,23326,-356.14,3150,-9999
05/13/2016 04:55,MOSES SOUTH,23319,1226.01,2850,-1600
05/13/2016 04:55,SCH - HQ - NY,23324,853,1000,0
05/13/2016 04:55,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 04:55,SCH - HQ_IMPORT_EXPORT,325376,594,1310,-9999
05/13/2016 04:55,SCH - NE - NY,23318,-146.71,1400,-1600
05/13/2016 04:55,SCH - NPX_1385,325277,139,200,-200
05/13/2016 04:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 04:55,SCH - OH - NY,23317,106.8,1100,-1900
05/13/2016 04:55,SCH - PJ - NY,23316,.51,2300,-800
05/13/2016 04:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 04:55,SCH - PJM_NEPTUNE,325305,60,660,-660
05/13/2016 04:55,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 04:55,SPR/DUN-SOUTH,23320,601.01,4350,-9999
05/13/2016 04:55,TOTAL EAST,23314,2325.62,6500,-9999
05/13/2016 04:55,UPNY CONED,23315,777.18,4850,-9999
05/13/2016 04:55,WEST CENTRAL,23312,-590.47,9999,-9999
05/13/2016 05:00,CENTRAL EAST - VC,23330,2207.7,2310,-9999
05/13/2016 05:00,DYSINGER EAST,23326,-358.2,3150,-9999
05/13/2016 05:00,MOSES SOUTH,23319,1256.03,2850,-1600
05/13/2016 05:00,SCH - HQ - NY,23324,888,1000,0
05/13/2016 05:00,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:00,SCH - HQ_IMPORT_EXPORT,325376,629,1310,-9999
05/13/2016 05:00,SCH - NE - NY,23318,-65.91,1400,-1600
05/13/2016 05:00,SCH - NPX_1385,325277,82,200,-200
05/13/2016 05:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:00,SCH - OH - NY,23317,324.45,1100,-1900
05/13/2016 05:00,SCH - PJ - NY,23316,-119.68,2300,-800
05/13/2016 05:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:00,SCH - PJM_NEPTUNE,325305,74,660,-660
05/13/2016 05:00,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:00,SPR/DUN-SOUTH,23320,546.62,4350,-9999
05/13/2016 05:00,TOTAL EAST,23314,2274.11,6500,-9999
05/13/2016 05:00,UPNY CONED,23315,786.85,4850,-9999
05/13/2016 05:00,WEST CENTRAL,23312,-600.75,9999,-9999
05/13/2016 05:05,CENTRAL EAST - VC,23330,2219.74,2320,-9999
05/13/2016 05:05,DYSINGER EAST,23326,-469.5,3150,-9999
05/13/2016 05:05,MOSES SOUTH,23319,1284.7,2850,-1600
05/13/2016 05:05,SCH - HQ - NY,23324,923,1000,0
05/13/2016 05:05,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:05,SCH - HQ_IMPORT_EXPORT,325376,664,1310,-9999
05/13/2016 05:05,SCH - NE - NY,23318,9.77,1400,-1600
05/13/2016 05:05,SCH - NPX_1385,325277,24,200,-200
05/13/2016 05:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:05,SCH - OH - NY,23317,542.09,1100,-1900
05/13/2016 05:05,SCH - PJ - NY,23316,-236.48,2300,-800
05/13/2016 05:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:05,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:05,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:05,SPR/DUN-SOUTH,23320,574.48,4350,-9999
05/13/2016 05:05,TOTAL EAST,23314,2327.46,6500,-9999
05/13/2016 05:05,UPNY CONED,23315,864.69,4850,-9999
05/13/2016 05:05,WEST CENTRAL,23312,-721.15,9999,-9999
05/13/2016 05:10,CENTRAL EAST - VC,23330,2219.64,2320,-9999
05/13/2016 05:10,DYSINGER EAST,23326,-406.98,3150,-9999
05/13/2016 05:10,MOSES SOUTH,23319,1263.97,2850,-1600
05/13/2016 05:10,SCH - HQ - NY,23324,923,1000,0
05/13/2016 05:10,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:10,SCH - HQ_IMPORT_EXPORT,325376,664,1310,-9999
05/13/2016 05:10,SCH - NE - NY,23318,12.82,1400,-1600
05/13/2016 05:10,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:10,SCH - OH - NY,23317,541.95,1100,-1900
05/13/2016 05:10,SCH - PJ - NY,23316,-240.4,2300,-800
05/13/2016 05:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:10,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:10,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:10,SPR/DUN-SOUTH,23320,638.14,4350,-9999
05/13/2016 05:10,TOTAL EAST,23314,2363.73,6500,-9999
05/13/2016 05:10,UPNY CONED,23315,954.67,4850,-9999
05/13/2016 05:10,WEST CENTRAL,23312,-663.49,9999,-9999
05/13/2016 05:15,CENTRAL EAST - VC,23330,2198.9,2320,-9999
05/13/2016 05:15,DYSINGER EAST,23326,-351.68,3150,-9999
05/13/2016 05:15,MOSES SOUTH,23319,1268.8,2850,-1600
05/13/2016 05:15,SCH - HQ - NY,23324,923,1000,0
05/13/2016 05:15,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:15,SCH - HQ_IMPORT_EXPORT,325376,664,1310,-9999
05/13/2016 05:15,SCH - NE - NY,23318,-22.42,1400,-1600
05/13/2016 05:15,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:15,SCH - OH - NY,23317,542.48,1100,-1900
05/13/2016 05:15,SCH - PJ - NY,23316,-193.66,2300,-800
05/13/2016 05:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:15,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:15,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:15,SPR/DUN-SOUTH,23320,596.35,4350,-9999
05/13/2016 05:15,TOTAL EAST,23314,2341.55,6500,-9999
05/13/2016 05:15,UPNY CONED,23315,928.85,4850,-9999
05/13/2016 05:15,WEST CENTRAL,23312,-612.13,9999,-9999
05/13/2016 05:20,CENTRAL EAST - VC,23330,2206.53,2320,-9999
05/13/2016 05:20,DYSINGER EAST,23326,-189.51,3150,-9999
05/13/2016 05:20,MOSES SOUTH,23319,1286.89,2850,-1600
05/13/2016 05:20,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:20,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:20,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:20,SCH - NE - NY,23318,-61.25,1400,-1600
05/13/2016 05:20,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:20,SCH - OH - NY,23317,543.12,1100,-1900
05/13/2016 05:20,SCH - PJ - NY,23316,-143.69,2300,-800
05/13/2016 05:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:20,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:20,SPR/DUN-SOUTH,23320,556.61,4350,-9999
05/13/2016 05:20,TOTAL EAST,23314,2415.71,6500,-9999
05/13/2016 05:20,UPNY CONED,23315,909.82,4850,-9999
05/13/2016 05:20,WEST CENTRAL,23312,-456.91,9999,-9999
05/13/2016 05:25,CENTRAL EAST - VC,23330,2218.62,2320,-9999
05/13/2016 05:25,DYSINGER EAST,23326,-249.63,3150,-9999
05/13/2016 05:25,MOSES SOUTH,23319,1256.25,2850,-1600
05/13/2016 05:25,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:25,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:25,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:25,SCH - NE - NY,23318,-59.85,1400,-1600
05/13/2016 05:25,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:25,SCH - OH - NY,23317,542.43,1100,-1900
05/13/2016 05:25,SCH - PJ - NY,23316,-146.38,2300,-800
05/13/2016 05:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:25,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:25,SPR/DUN-SOUTH,23320,563.92,4350,-9999
05/13/2016 05:25,TOTAL EAST,23314,2382.72,6500,-9999
05/13/2016 05:25,UPNY CONED,23315,898.71,4850,-9999
05/13/2016 05:25,WEST CENTRAL,23312,-524.38,9999,-9999
05/13/2016 05:30,CENTRAL EAST - VC,23330,2211.37,2320,-9999
05/13/2016 05:30,DYSINGER EAST,23326,-223.76,3150,-9999
05/13/2016 05:30,MOSES SOUTH,23319,1289.27,2850,-1600
05/13/2016 05:30,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:30,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:30,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:30,SCH - NE - NY,23318,-62.72,1400,-1600
05/13/2016 05:30,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:30,SCH - OH - NY,23317,543.2,1100,-1900
05/13/2016 05:30,SCH - PJ - NY,23316,-143.08,2300,-800
05/13/2016 05:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:30,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:30,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:30,SPR/DUN-SOUTH,23320,539.52,4350,-9999
05/13/2016 05:30,TOTAL EAST,23314,2314.13,6500,-9999
05/13/2016 05:30,UPNY CONED,23315,927.89,4850,-9999
05/13/2016 05:30,WEST CENTRAL,23312,-506.11,9999,-9999
05/13/2016 05:35,CENTRAL EAST - VC,23330,2218.62,2320,-9999
05/13/2016 05:35,DYSINGER EAST,23326,-61.89,3150,-9999
05/13/2016 05:35,MOSES SOUTH,23319,1266.4,2850,-1600
05/13/2016 05:35,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:35,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:35,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:35,SCH - NE - NY,23318,-61.5,1400,-1600
05/13/2016 05:35,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:35,SCH - OH - NY,23317,543.17,1100,-1900
05/13/2016 05:35,SCH - PJ - NY,23316,-143.98,2300,-800
05/13/2016 05:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:35,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:35,SPR/DUN-SOUTH,23320,624.44,4350,-9999
05/13/2016 05:35,TOTAL EAST,23314,2394.59,6500,-9999
05/13/2016 05:35,UPNY CONED,23315,1030.1,4850,-9999
05/13/2016 05:35,WEST CENTRAL,23312,-348.93,9999,-9999
05/13/2016 05:40,CENTRAL EAST - VC,23330,2218.87,2320,-9999
05/13/2016 05:40,DYSINGER EAST,23326,2.71,3150,-9999
05/13/2016 05:40,MOSES SOUTH,23319,1265.26,2850,-1600
05/13/2016 05:40,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:40,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:40,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:40,SCH - NE - NY,23318,-59.04,1400,-1600
05/13/2016 05:40,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:40,SCH - OH - NY,23317,543.19,1100,-1900
05/13/2016 05:40,SCH - PJ - NY,23316,-147.93,2300,-800
05/13/2016 05:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:40,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:40,SPR/DUN-SOUTH,23320,697.23,4350,-9999
05/13/2016 05:40,TOTAL EAST,23314,2446.99,6500,-9999
05/13/2016 05:40,UPNY CONED,23315,1084.44,4850,-9999
05/13/2016 05:40,WEST CENTRAL,23312,-287.87,9999,-9999
05/13/2016 05:45,CENTRAL EAST - VC,23330,2218.23,2320,-9999
05/13/2016 05:45,DYSINGER EAST,23326,60.92,3150,-9999
05/13/2016 05:45,MOSES SOUTH,23319,1256.15,2850,-1600
05/13/2016 05:45,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:45,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:45,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:45,SCH - NE - NY,23318,-87.43,1400,-1600
05/13/2016 05:45,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:45,SCH - OH - NY,23317,543.04,1100,-1900
05/13/2016 05:45,SCH - PJ - NY,23316,-149.3,2300,-800
05/13/2016 05:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:45,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:45,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:45,SPR/DUN-SOUTH,23320,805.12,4350,-9999
05/13/2016 05:45,TOTAL EAST,23314,2512.86,6500,-9999
05/13/2016 05:45,UPNY CONED,23315,1188.93,4850,-9999
05/13/2016 05:45,WEST CENTRAL,23312,-232.93,9999,-9999
05/13/2016 05:50,CENTRAL EAST - VC,23330,2215.24,2320,-9999
05/13/2016 05:50,DYSINGER EAST,23326,42.2,3150,-9999
05/13/2016 05:50,MOSES SOUTH,23319,1240.42,2850,-1600
05/13/2016 05:50,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:50,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:50,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:50,SCH - NE - NY,23318,-118.91,1400,-1600
05/13/2016 05:50,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:50,SCH - OH - NY,23317,542.46,1100,-1900
05/13/2016 05:50,SCH - PJ - NY,23316,-144.65,2300,-800
05/13/2016 05:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:50,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:50,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:50,SPR/DUN-SOUTH,23320,825.66,4350,-9999
05/13/2016 05:50,TOTAL EAST,23314,2570.44,6500,-9999
05/13/2016 05:50,UPNY CONED,23315,1219.4,4850,-9999
05/13/2016 05:50,WEST CENTRAL,23312,-257.84,9999,-9999
05/13/2016 05:55,CENTRAL EAST - VC,23330,2218.63,2320,-9999
05/13/2016 05:55,DYSINGER EAST,23326,30.88,3150,-9999
05/13/2016 05:55,MOSES SOUTH,23319,1233.01,2850,-1600
05/13/2016 05:55,SCH - HQ - NY,23324,924,1000,0
05/13/2016 05:55,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 05:55,SCH - HQ_IMPORT_EXPORT,325376,665,1310,-9999
05/13/2016 05:55,SCH - NE - NY,23318,-121.46,1400,-1600
05/13/2016 05:55,SCH - NPX_1385,325277,25,200,-200
05/13/2016 05:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 05:55,SCH - OH - NY,23317,541.98,1100,-1900
05/13/2016 05:55,SCH - PJ - NY,23316,-142.16,2300,-800
05/13/2016 05:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 05:55,SCH - PJM_NEPTUNE,325305,89,660,-660
05/13/2016 05:55,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 05:55,SPR/DUN-SOUTH,23320,854.43,4350,-9999
05/13/2016 05:55,TOTAL EAST,23314,2630.41,6500,-9999
05/13/2016 05:55,UPNY CONED,23315,1285.55,4850,-9999
05/13/2016 05:55,WEST CENTRAL,23312,-274.21,9999,-9999
05/13/2016 06:00,CENTRAL EAST - VC,23330,2244.18,2345,-9999
05/13/2016 06:00,DYSINGER EAST,23326,-110.82,3150,-9999
05/13/2016 06:00,MOSES SOUTH,23319,1279.15,2850,-1600
05/13/2016 06:00,SCH - HQ - NY,23324,962,1000,0
05/13/2016 06:00,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:00,SCH - HQ_IMPORT_EXPORT,325376,703,1310,-9999
05/13/2016 06:00,SCH - NE - NY,23318,-219.57,1400,-1600
05/13/2016 06:00,SCH - NPX_1385,325277,57,200,-200
05/13/2016 06:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:00,SCH - OH - NY,23317,560.64,1100,-1900
05/13/2016 06:00,SCH - PJ - NY,23316,-158.35,2300,-800
05/13/2016 06:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:00,SCH - PJM_NEPTUNE,325305,264,660,-660
05/13/2016 06:00,SCH - PJM_VFT,325658,145,315,-315
05/13/2016 06:00,SPR/DUN-SOUTH,23320,996.6,4350,-9999
05/13/2016 06:00,TOTAL EAST,23314,2547.21,6500,-9999
05/13/2016 06:00,UPNY CONED,23315,1277.98,4850,-9999
05/13/2016 06:00,WEST CENTRAL,23312,-420.89,9999,-9999
05/13/2016 06:05,CENTRAL EAST - VC,23330,2243.29,2345,-9999
05/13/2016 06:05,DYSINGER EAST,23326,-29.84,3150,-9999
05/13/2016 06:05,MOSES SOUTH,23319,1335.5,2850,-1600
05/13/2016 06:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:05,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:05,SCH - NE - NY,23318,-319.39,1400,-1600
05/13/2016 06:05,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:05,SCH - OH - NY,23317,580.87,1100,-1900
05/13/2016 06:05,SCH - PJ - NY,23316,-169.53,2300,-800
05/13/2016 06:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:05,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:05,SCH - PJM_VFT,325658,0,315,-315
05/13/2016 06:05,SPR/DUN-SOUTH,23320,1122.65,4350,-9999
05/13/2016 06:05,TOTAL EAST,23314,2590.64,6500,-9999
05/13/2016 06:05,UPNY CONED,23315,1237.8,4850,-9999
05/13/2016 06:05,WEST CENTRAL,23312,-357.39,9999,-9999
05/13/2016 06:10,CENTRAL EAST - VC,23330,2243.93,2345,-9999
05/13/2016 06:10,DYSINGER EAST,23326,-18.82,3150,-9999
05/13/2016 06:10,MOSES SOUTH,23319,1406.49,2850,-1600
05/13/2016 06:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:10,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:10,SCH - NE - NY,23318,-319.38,1400,-1600
05/13/2016 06:10,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:10,SCH - OH - NY,23317,581.15,1100,-1900
05/13/2016 06:10,SCH - PJ - NY,23316,-169.57,2300,-800
05/13/2016 06:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:10,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:10,SCH - PJM_VFT,325658,0,315,-315
05/13/2016 06:10,SPR/DUN-SOUTH,23320,1107.57,4350,-9999
05/13/2016 06:10,TOTAL EAST,23314,2550.11,6500,-9999
05/13/2016 06:10,UPNY CONED,23315,1241,4850,-9999
05/13/2016 06:10,WEST CENTRAL,23312,-361.94,9999,-9999
05/13/2016 06:15,CENTRAL EAST - VC,23330,2244.49,2345,-9999
05/13/2016 06:15,DYSINGER EAST,23326,57.21,3150,-9999
05/13/2016 06:15,MOSES SOUTH,23319,1452.37,2850,-1600
05/13/2016 06:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:15,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:15,SCH - NE - NY,23318,-364.5,1400,-1600
05/13/2016 06:15,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:15,SCH - OH - NY,23317,581.37,1100,-1900
05/13/2016 06:15,SCH - PJ - NY,23316,-156.04,2300,-800
05/13/2016 06:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:15,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:15,SCH - PJM_VFT,325658,0,315,-315
05/13/2016 06:15,SPR/DUN-SOUTH,23320,1049.26,4350,-9999
05/13/2016 06:15,TOTAL EAST,23314,2601.47,6500,-9999
05/13/2016 06:15,UPNY CONED,23315,1197.48,4850,-9999
05/13/2016 06:15,WEST CENTRAL,23312,-293.9,9999,-9999
05/13/2016 06:20,CENTRAL EAST - VC,23330,2230.65,2345,-9999
05/13/2016 06:20,DYSINGER EAST,23326,-181.99,3150,-9999
05/13/2016 06:20,MOSES SOUTH,23319,1461.03,2850,-1600
05/13/2016 06:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:20,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:20,SCH - NE - NY,23318,-410.02,1400,-1600
05/13/2016 06:20,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:20,SCH - OH - NY,23317,580.79,1100,-1900
05/13/2016 06:20,SCH - PJ - NY,23316,-142.02,2300,-800
05/13/2016 06:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:20,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:20,SCH - PJM_VFT,325658,0,315,-315
05/13/2016 06:20,SPR/DUN-SOUTH,23320,884.97,4350,-9999
05/13/2016 06:20,TOTAL EAST,23314,2442.98,6500,-9999
05/13/2016 06:20,UPNY CONED,23315,1011.35,4850,-9999
05/13/2016 06:20,WEST CENTRAL,23312,-542.17,9999,-9999
05/13/2016 06:25,CENTRAL EAST - VC,23330,2244.22,2345,-9999
05/13/2016 06:25,DYSINGER EAST,23326,-73.21,3150,-9999
05/13/2016 06:25,MOSES SOUTH,23319,1457.46,2850,-1600
05/13/2016 06:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:25,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:25,SCH - NE - NY,23318,-410.09,1400,-1600
05/13/2016 06:25,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:25,SCH - OH - NY,23317,580.93,1100,-1900
05/13/2016 06:25,SCH - PJ - NY,23316,-143.97,2300,-800
05/13/2016 06:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:25,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:25,SCH - PJM_VFT,325658,0,315,-315
05/13/2016 06:25,SPR/DUN-SOUTH,23320,934.85,4350,-9999
05/13/2016 06:25,TOTAL EAST,23314,2509.29,6500,-9999
05/13/2016 06:25,UPNY CONED,23315,1071.97,4850,-9999
05/13/2016 06:25,WEST CENTRAL,23312,-439.38,9999,-9999
05/13/2016 06:30,CENTRAL EAST - VC,23330,2243.54,2345,-9999
05/13/2016 06:30,DYSINGER EAST,23326,82.17,3150,-9999
05/13/2016 06:30,MOSES SOUTH,23319,1444.29,2850,-1600
05/13/2016 06:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:30,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:30,SCH - NE - NY,23318,-500.49,1400,-1600
05/13/2016 06:30,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:30,SCH - OH - NY,23317,581.19,1100,-1900
05/13/2016 06:30,SCH - PJ - NY,23316,-144.12,2300,-800
05/13/2016 06:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:30,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:30,SCH - PJM_VFT,325658,145,315,-315
05/13/2016 06:30,SPR/DUN-SOUTH,23320,864.15,4350,-9999
05/13/2016 06:30,TOTAL EAST,23314,2588.63,6500,-9999
05/13/2016 06:30,UPNY CONED,23315,1052.96,4850,-9999
05/13/2016 06:30,WEST CENTRAL,23312,-288.08,9999,-9999
05/13/2016 06:35,CENTRAL EAST - VC,23330,2238.32,2345,-9999
05/13/2016 06:35,DYSINGER EAST,23326,62.48,3150,-9999
05/13/2016 06:35,MOSES SOUTH,23319,1478,2850,-1600
05/13/2016 06:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:35,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:35,SCH - NE - NY,23318,-590.22,1400,-1600
05/13/2016 06:35,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:35,SCH - OH - NY,23317,581.4,1100,-1900
05/13/2016 06:35,SCH - PJ - NY,23316,-143.14,2300,-800
05/13/2016 06:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:35,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 06:35,SPR/DUN-SOUTH,23320,719.49,4350,-9999
05/13/2016 06:35,TOTAL EAST,23314,2519.39,6500,-9999
05/13/2016 06:35,UPNY CONED,23315,916.2,4850,-9999
05/13/2016 06:35,WEST CENTRAL,23312,-316.37,9999,-9999
05/13/2016 06:40,CENTRAL EAST - VC,23330,2239.91,2345,-9999
05/13/2016 06:40,DYSINGER EAST,23326,-14.64,3150,-9999
05/13/2016 06:40,MOSES SOUTH,23319,1491.86,2850,-1600
05/13/2016 06:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:40,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:40,SCH - NE - NY,23318,-590.14,1400,-1600
05/13/2016 06:40,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:40,SCH - OH - NY,23317,581.4,1100,-1900
05/13/2016 06:40,SCH - PJ - NY,23316,-144.35,2300,-800
05/13/2016 06:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:40,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 06:40,SPR/DUN-SOUTH,23320,704.86,4350,-9999
05/13/2016 06:40,TOTAL EAST,23314,2421.91,6500,-9999
05/13/2016 06:40,UPNY CONED,23315,910.91,4850,-9999
05/13/2016 06:40,WEST CENTRAL,23312,-403.52,9999,-9999
05/13/2016 06:45,CENTRAL EAST - VC,23330,2236.15,2345,-9999
05/13/2016 06:45,DYSINGER EAST,23326,-15.99,3150,-9999
05/13/2016 06:45,MOSES SOUTH,23319,1505.41,2850,-1600
05/13/2016 06:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:45,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:45,SCH - NE - NY,23318,-647.17,1400,-1600
05/13/2016 06:45,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:45,SCH - OH - NY,23317,581.78,1100,-1900
05/13/2016 06:45,SCH - PJ - NY,23316,-142.84,2300,-800
05/13/2016 06:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:45,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:45,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 06:45,SPR/DUN-SOUTH,23320,644.27,4350,-9999
05/13/2016 06:45,TOTAL EAST,23314,2352.15,6500,-9999
05/13/2016 06:45,UPNY CONED,23315,856.25,4850,-9999
05/13/2016 06:45,WEST CENTRAL,23312,-412.3,9999,-9999
05/13/2016 06:50,CENTRAL EAST - VC,23330,2243.63,2345,-9999
05/13/2016 06:50,DYSINGER EAST,23326,58.21,3150,-9999
05/13/2016 06:50,MOSES SOUTH,23319,1490.77,2850,-1600
05/13/2016 06:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:50,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:50,SCH - NE - NY,23318,-704,1400,-1600
05/13/2016 06:50,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:50,SCH - OH - NY,23317,581.7,1100,-1900
05/13/2016 06:50,SCH - PJ - NY,23316,-143.19,2300,-800
05/13/2016 06:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:50,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:50,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 06:50,SPR/DUN-SOUTH,23320,645.75,4350,-9999
05/13/2016 06:50,TOTAL EAST,23314,2399,6500,-9999
05/13/2016 06:50,UPNY CONED,23315,888.02,4850,-9999
05/13/2016 06:50,WEST CENTRAL,23312,-343.67,9999,-9999
05/13/2016 06:55,CENTRAL EAST - VC,23330,2241.28,2345,-9999
05/13/2016 06:55,DYSINGER EAST,23326,80.71,3150,-9999
05/13/2016 06:55,MOSES SOUTH,23319,1474.99,2850,-1600
05/13/2016 06:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 06:55,SCH - HQ_CEDARS,325274,0,190,-40
05/13/2016 06:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 06:55,SCH - NE - NY,23318,-704.05,1400,-1600
05/13/2016 06:55,SCH - NPX_1385,325277,89,200,-200
05/13/2016 06:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 06:55,SCH - OH - NY,23317,581.81,1100,-1900
05/13/2016 06:55,SCH - PJ - NY,23316,-143.84,2300,-800
05/13/2016 06:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 06:55,SCH - PJM_NEPTUNE,325305,440,660,-660
05/13/2016 06:55,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 06:55,SPR/DUN-SOUTH,23320,674.09,4350,-9999
05/13/2016 06:55,TOTAL EAST,23314,2371.65,6500,-9999
05/13/2016 06:55,UPNY CONED,23315,919.72,4850,-9999
05/13/2016 06:55,WEST CENTRAL,23312,-328.75,9999,-9999
05/13/2016 07:00,CENTRAL EAST - VC,23330,2235.86,2345,-9999
05/13/2016 07:00,DYSINGER EAST,23326,-36.3,3150,-9999
05/13/2016 07:00,MOSES SOUTH,23319,1547.53,2850,-1600
05/13/2016 07:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:00,SCH - HQ_CEDARS,325274,95,190,-40
05/13/2016 07:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:00,SCH - NE - NY,23318,-803.67,1400,-1600
05/13/2016 07:00,SCH - NPX_1385,325277,44,200,-200
05/13/2016 07:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:00,SCH - OH - NY,23317,570.7,1100,-1900
05/13/2016 07:00,SCH - PJ - NY,23316,-144.69,2300,-800
05/13/2016 07:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:00,SCH - PJM_NEPTUNE,325305,524,660,-660
05/13/2016 07:00,SCH - PJM_VFT,325658,302,315,-315
05/13/2016 07:00,SPR/DUN-SOUTH,23320,636.79,4350,-9999
05/13/2016 07:00,TOTAL EAST,23314,2328.31,6500,-9999
05/13/2016 07:00,UPNY CONED,23315,882.9,4850,-9999
05/13/2016 07:00,WEST CENTRAL,23312,-456.15,9999,-9999
05/13/2016 07:05,CENTRAL EAST - VC,23330,2241.77,2345,-9999
05/13/2016 07:05,DYSINGER EAST,23326,-137.08,3150,-9999
05/13/2016 07:05,MOSES SOUTH,23319,1641.36,2850,-1600
05/13/2016 07:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:05,SCH - NE - NY,23318,-903.16,1400,-1600
05/13/2016 07:05,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:05,SCH - OH - NY,23317,559.58,1100,-1900
05/13/2016 07:05,SCH - PJ - NY,23316,-145.97,2300,-800
05/13/2016 07:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:05,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:05,SCH - PJM_VFT,325658,315,315,-315
05/13/2016 07:05,SPR/DUN-SOUTH,23320,611.89,4350,-9999
05/13/2016 07:05,TOTAL EAST,23314,2288.56,6500,-9999
05/13/2016 07:05,UPNY CONED,23315,847.37,4850,-9999
05/13/2016 07:05,WEST CENTRAL,23312,-568.7,9999,-9999
05/13/2016 07:10,CENTRAL EAST - VC,23330,2244.4,2345,-9999
05/13/2016 07:10,DYSINGER EAST,23326,-71.74,3150,-9999
05/13/2016 07:10,MOSES SOUTH,23319,1647.88,2850,-1600
05/13/2016 07:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:10,SCH - NE - NY,23318,-902.77,1400,-1600
05/13/2016 07:10,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:10,SCH - OH - NY,23317,559.78,1100,-1900
05/13/2016 07:10,SCH - PJ - NY,23316,-148.22,2300,-800
05/13/2016 07:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:10,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:10,SCH - PJM_VFT,325658,315,315,-315
05/13/2016 07:10,SPR/DUN-SOUTH,23320,610.01,4350,-9999
05/13/2016 07:10,TOTAL EAST,23314,2267.99,6500,-9999
05/13/2016 07:10,UPNY CONED,23315,864.14,4850,-9999
05/13/2016 07:10,WEST CENTRAL,23312,-513.53,9999,-9999
05/13/2016 07:15,CENTRAL EAST - VC,23330,2242.11,2345,-9999
05/13/2016 07:15,DYSINGER EAST,23326,-59.69,3150,-9999
05/13/2016 07:15,MOSES SOUTH,23319,1625.98,2850,-1600
05/13/2016 07:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:15,SCH - NE - NY,23318,-934.36,1400,-1600
05/13/2016 07:15,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:15,SCH - OH - NY,23317,559.59,1100,-1900
05/13/2016 07:15,SCH - PJ - NY,23316,-145.71,2300,-800
05/13/2016 07:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:15,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:15,SCH - PJM_VFT,325658,302,315,-315
05/13/2016 07:15,SPR/DUN-SOUTH,23320,689.97,4350,-9999
05/13/2016 07:15,TOTAL EAST,23314,2243.07,6500,-9999
05/13/2016 07:15,UPNY CONED,23315,907.19,4850,-9999
05/13/2016 07:15,WEST CENTRAL,23312,-503.02,9999,-9999
05/13/2016 07:20,CENTRAL EAST - VC,23330,2244.33,2345,-9999
05/13/2016 07:20,DYSINGER EAST,23326,63.3,3150,-9999
05/13/2016 07:20,MOSES SOUTH,23319,1602.41,2850,-1600
05/13/2016 07:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:20,SCH - NE - NY,23318,-965.41,1400,-1600
05/13/2016 07:20,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:20,SCH - OH - NY,23317,559.39,1100,-1900
05/13/2016 07:20,SCH - PJ - NY,23316,-145.51,2300,-800
05/13/2016 07:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:20,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 07:20,SPR/DUN-SOUTH,23320,586.58,4350,-9999
05/13/2016 07:20,TOTAL EAST,23314,2352.17,6500,-9999
05/13/2016 07:20,UPNY CONED,23315,830.34,4850,-9999
05/13/2016 07:20,WEST CENTRAL,23312,-383.68,9999,-9999
05/13/2016 07:25,CENTRAL EAST - VC,23330,2243.02,2345,-9999
05/13/2016 07:25,DYSINGER EAST,23326,20.2,3150,-9999
05/13/2016 07:25,MOSES SOUTH,23319,1592.88,2850,-1600
05/13/2016 07:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:25,SCH - NE - NY,23318,-965.39,1400,-1600
05/13/2016 07:25,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:25,SCH - OH - NY,23317,559.28,1100,-1900
05/13/2016 07:25,SCH - PJ - NY,23316,-146.25,2300,-800
05/13/2016 07:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:25,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 07:25,SPR/DUN-SOUTH,23320,610.21,4350,-9999
05/13/2016 07:25,TOTAL EAST,23314,2288.75,6500,-9999
05/13/2016 07:25,UPNY CONED,23315,862.22,4850,-9999
05/13/2016 07:25,WEST CENTRAL,23312,-433.99,9999,-9999
05/13/2016 07:30,CENTRAL EAST - VC,23330,2241.64,2345,-9999
05/13/2016 07:30,DYSINGER EAST,23326,16.98,3150,-9999
05/13/2016 07:30,MOSES SOUTH,23319,1594.14,2850,-1600
05/13/2016 07:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:30,SCH - NE - NY,23318,-965.48,1400,-1600
05/13/2016 07:30,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:30,SCH - OH - NY,23317,559.1,1100,-1900
05/13/2016 07:30,SCH - PJ - NY,23316,-145.81,2300,-800
05/13/2016 07:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:30,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:30,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 07:30,SPR/DUN-SOUTH,23320,637.35,4350,-9999
05/13/2016 07:30,TOTAL EAST,23314,2296.87,6500,-9999
05/13/2016 07:30,UPNY CONED,23315,874.38,4850,-9999
05/13/2016 07:30,WEST CENTRAL,23312,-444.58,9999,-9999
05/13/2016 07:35,CENTRAL EAST - VC,23330,2238.12,2345,-9999
05/13/2016 07:35,DYSINGER EAST,23326,44.82,3150,-9999
05/13/2016 07:35,MOSES SOUTH,23319,1564.68,2850,-1600
05/13/2016 07:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:35,SCH - NE - NY,23318,-965.39,1400,-1600
05/13/2016 07:35,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:35,SCH - OH - NY,23317,559.22,1100,-1900
05/13/2016 07:35,SCH - PJ - NY,23316,-145.19,2300,-800
05/13/2016 07:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:35,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 07:35,SPR/DUN-SOUTH,23320,641.9,4350,-9999
05/13/2016 07:35,TOTAL EAST,23314,2293.12,6500,-9999
05/13/2016 07:35,UPNY CONED,23315,863.56,4850,-9999
05/13/2016 07:35,WEST CENTRAL,23312,-416.31,9999,-9999
05/13/2016 07:40,CENTRAL EAST - VC,23330,2243.17,2345,-9999
05/13/2016 07:40,DYSINGER EAST,23326,82.32,3150,-9999
05/13/2016 07:40,MOSES SOUTH,23319,1579.46,2850,-1600
05/13/2016 07:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:40,SCH - NE - NY,23318,-965.77,1400,-1600
05/13/2016 07:40,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:40,SCH - OH - NY,23317,559.11,1100,-1900
05/13/2016 07:40,SCH - PJ - NY,23316,-144.23,2300,-800
05/13/2016 07:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:40,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 07:40,SPR/DUN-SOUTH,23320,650.65,4350,-9999
05/13/2016 07:40,TOTAL EAST,23314,2338.95,6500,-9999
05/13/2016 07:40,UPNY CONED,23315,881.38,4850,-9999
05/13/2016 07:40,WEST CENTRAL,23312,-380.92,9999,-9999
05/13/2016 07:45,CENTRAL EAST - VC,23330,2241.57,2345,-9999
05/13/2016 07:45,DYSINGER EAST,23326,141.52,3150,-9999
05/13/2016 07:45,MOSES SOUTH,23319,1555.59,2850,-1600
05/13/2016 07:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:45,SCH - NE - NY,23318,-985.47,1400,-1600
05/13/2016 07:45,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:45,SCH - OH - NY,23317,559.06,1100,-1900
05/13/2016 07:45,SCH - PJ - NY,23316,-144.75,2300,-800
05/13/2016 07:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:45,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:45,SCH - PJM_VFT,325658,299,315,-315
05/13/2016 07:45,SPR/DUN-SOUTH,23320,672.16,4350,-9999
05/13/2016 07:45,TOTAL EAST,23314,2379.8,6500,-9999
05/13/2016 07:45,UPNY CONED,23315,828.97,4850,-9999
05/13/2016 07:45,WEST CENTRAL,23312,-324.86,9999,-9999
05/13/2016 07:50,CENTRAL EAST - VC,23330,2244.74,2345,-9999
05/13/2016 07:50,DYSINGER EAST,23326,314.82,3150,-9999
05/13/2016 07:50,MOSES SOUTH,23319,1479.45,2850,-1600
05/13/2016 07:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:50,SCH - NE - NY,23318,-1005.26,1400,-1600
05/13/2016 07:50,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:50,SCH - OH - NY,23317,559.31,1100,-1900
05/13/2016 07:50,SCH - PJ - NY,23316,-148.34,2300,-800
05/13/2016 07:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:50,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:50,SCH - PJM_VFT,325658,309,315,-315
05/13/2016 07:50,SPR/DUN-SOUTH,23320,658.07,4350,-9999
05/13/2016 07:50,TOTAL EAST,23314,2383.23,6500,-9999
05/13/2016 07:50,UPNY CONED,23315,812.43,4850,-9999
05/13/2016 07:50,WEST CENTRAL,23312,-151.4,9999,-9999
05/13/2016 07:55,CENTRAL EAST - VC,23330,2239.84,2345,-9999
05/13/2016 07:55,DYSINGER EAST,23326,267.82,3150,-9999
05/13/2016 07:55,MOSES SOUTH,23319,1468.6,2850,-1600
05/13/2016 07:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 07:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 07:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 07:55,SCH - NE - NY,23318,-1005.25,1400,-1600
05/13/2016 07:55,SCH - NPX_1385,325277,0,200,-200
05/13/2016 07:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 07:55,SCH - OH - NY,23317,559.02,1100,-1900
05/13/2016 07:55,SCH - PJ - NY,23316,-145.67,2300,-800
05/13/2016 07:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 07:55,SCH - PJM_NEPTUNE,325305,609,660,-660
05/13/2016 07:55,SCH - PJM_VFT,325658,309,315,-315
05/13/2016 07:55,SPR/DUN-SOUTH,23320,672.48,4350,-9999
05/13/2016 07:55,TOTAL EAST,23314,2371.22,6500,-9999
05/13/2016 07:55,UPNY CONED,23315,841.77,4850,-9999
05/13/2016 07:55,WEST CENTRAL,23312,-201.64,9999,-9999
05/13/2016 08:00,CENTRAL EAST - VC,23330,2243.71,2345,-9999
05/13/2016 08:00,DYSINGER EAST,23326,277.64,3150,-9999
05/13/2016 08:00,MOSES SOUTH,23319,1461.34,2850,-1600
05/13/2016 08:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:00,SCH - NE - NY,23318,-971.82,1400,-1600
05/13/2016 08:00,SCH - NPX_1385,325277,49,200,-200
05/13/2016 08:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:00,SCH - OH - NY,23317,395.49,1100,-1900
05/13/2016 08:00,SCH - PJ - NY,23316,-124.72,2300,-800
05/13/2016 08:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:00,SCH - PJM_NEPTUNE,325305,634,660,-660
05/13/2016 08:00,SCH - PJM_VFT,325658,299,315,-315
05/13/2016 08:00,SPR/DUN-SOUTH,23320,767.55,4350,-9999
05/13/2016 08:00,TOTAL EAST,23314,2395.93,6500,-9999
05/13/2016 08:00,UPNY CONED,23315,866.26,4850,-9999
05/13/2016 08:00,WEST CENTRAL,23312,-195.66,9999,-9999
05/13/2016 08:05,CENTRAL EAST - VC,23330,2244.69,2345,-9999
05/13/2016 08:05,DYSINGER EAST,23326,372.54,3150,-9999
05/13/2016 08:05,MOSES SOUTH,23319,1458.91,2850,-1600
05/13/2016 08:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:05,SCH - NE - NY,23318,-938.94,1400,-1600
05/13/2016 08:05,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:05,SCH - OH - NY,23317,233.24,1100,-1900
05/13/2016 08:05,SCH - PJ - NY,23316,-103.6,2300,-800
05/13/2016 08:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:05,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:05,SPR/DUN-SOUTH,23320,816.75,4350,-9999
05/13/2016 08:05,TOTAL EAST,23314,2357.52,6500,-9999
05/13/2016 08:05,UPNY CONED,23315,867.19,4850,-9999
05/13/2016 08:05,WEST CENTRAL,23312,-105.22,9999,-9999
05/13/2016 08:10,CENTRAL EAST - VC,23330,2245.57,2345,-9999
05/13/2016 08:10,DYSINGER EAST,23326,486.2,3150,-9999
05/13/2016 08:10,MOSES SOUTH,23319,1483.34,2850,-1600
05/13/2016 08:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:10,SCH - NE - NY,23318,-939.09,1400,-1600
05/13/2016 08:10,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:10,SCH - OH - NY,23317,233.8,1100,-1900
05/13/2016 08:10,SCH - PJ - NY,23316,-105.66,2300,-800
05/13/2016 08:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:10,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:10,SPR/DUN-SOUTH,23320,775.11,4350,-9999
05/13/2016 08:10,TOTAL EAST,23314,2338.29,6500,-9999
05/13/2016 08:10,UPNY CONED,23315,834.42,4850,-9999
05/13/2016 08:10,WEST CENTRAL,23312,4.53,9999,-9999
05/13/2016 08:15,CENTRAL EAST - VC,23330,2241.92,2345,-9999
05/13/2016 08:15,DYSINGER EAST,23326,497.45,3150,-9999
05/13/2016 08:15,MOSES SOUTH,23319,1485.29,2850,-1600
05/13/2016 08:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:15,SCH - NE - NY,23318,-939.04,1400,-1600
05/13/2016 08:15,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:15,SCH - OH - NY,23317,233.52,1100,-1900
05/13/2016 08:15,SCH - PJ - NY,23316,-104.14,2300,-800
05/13/2016 08:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:15,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:15,SPR/DUN-SOUTH,23320,757.38,4350,-9999
05/13/2016 08:15,TOTAL EAST,23314,2384.57,6500,-9999
05/13/2016 08:15,UPNY CONED,23315,829.01,4850,-9999
05/13/2016 08:15,WEST CENTRAL,23312,16.35,9999,-9999
05/13/2016 08:20,CENTRAL EAST - VC,23330,2236.24,2345,-9999
05/13/2016 08:20,DYSINGER EAST,23326,229.71,3150,-9999
05/13/2016 08:20,MOSES SOUTH,23319,1481.31,2850,-1600
05/13/2016 08:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:20,SCH - NE - NY,23318,-939.76,1400,-1600
05/13/2016 08:20,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:20,SCH - OH - NY,23317,232.51,1100,-1900
05/13/2016 08:20,SCH - PJ - NY,23316,-105.96,2300,-800
05/13/2016 08:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:20,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:20,SPR/DUN-SOUTH,23320,789.57,4350,-9999
05/13/2016 08:20,TOTAL EAST,23314,2333.3,6500,-9999
05/13/2016 08:20,UPNY CONED,23315,868.76,4850,-9999
05/13/2016 08:20,WEST CENTRAL,23312,-253.14,9999,-9999
05/13/2016 08:25,CENTRAL EAST - VC,23330,2243.38,2345,-9999
05/13/2016 08:25,DYSINGER EAST,23326,376.12,3150,-9999
05/13/2016 08:25,MOSES SOUTH,23319,1490.4,2850,-1600
05/13/2016 08:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:25,SCH - NE - NY,23318,-940.02,1400,-1600
05/13/2016 08:25,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:25,SCH - OH - NY,23317,232.78,1100,-1900
05/13/2016 08:25,SCH - PJ - NY,23316,-104.27,2300,-800
05/13/2016 08:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:25,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:25,SPR/DUN-SOUTH,23320,748.47,4350,-9999
05/13/2016 08:25,TOTAL EAST,23314,2406.62,6500,-9999
05/13/2016 08:25,UPNY CONED,23315,841.31,4850,-9999
05/13/2016 08:25,WEST CENTRAL,23312,-106.87,9999,-9999
05/13/2016 08:30,CENTRAL EAST - VC,23330,2240.34,2345,-9999
05/13/2016 08:30,DYSINGER EAST,23326,387.77,3150,-9999
05/13/2016 08:30,MOSES SOUTH,23319,1474.03,2850,-1600
05/13/2016 08:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:30,SCH - NE - NY,23318,-933.95,1400,-1600
05/13/2016 08:30,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:30,SCH - OH - NY,23317,232.73,1100,-1900
05/13/2016 08:30,SCH - PJ - NY,23316,-103.6,2300,-800
05/13/2016 08:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:30,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:30,SPR/DUN-SOUTH,23320,765.62,4350,-9999
05/13/2016 08:30,TOTAL EAST,23314,2413.15,6500,-9999
05/13/2016 08:30,UPNY CONED,23315,851.75,4850,-9999
05/13/2016 08:30,WEST CENTRAL,23312,-96.93,9999,-9999
05/13/2016 08:35,CENTRAL EAST - VC,23330,2238.66,2345,-9999
05/13/2016 08:35,DYSINGER EAST,23326,345.16,3150,-9999
05/13/2016 08:35,MOSES SOUTH,23319,1481.98,2850,-1600
05/13/2016 08:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:35,SCH - NE - NY,23318,-928.93,1400,-1600
05/13/2016 08:35,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:35,SCH - OH - NY,23317,232.59,1100,-1900
05/13/2016 08:35,SCH - PJ - NY,23316,-102.12,2300,-800
05/13/2016 08:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:35,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:35,SPR/DUN-SOUTH,23320,786.94,4350,-9999
05/13/2016 08:35,TOTAL EAST,23314,2409.24,6500,-9999
05/13/2016 08:35,UPNY CONED,23315,871.15,4850,-9999
05/13/2016 08:35,WEST CENTRAL,23312,-143.7,9999,-9999
05/13/2016 08:40,CENTRAL EAST - VC,23330,2238.82,2345,-9999
05/13/2016 08:40,DYSINGER EAST,23326,275.71,3150,-9999
05/13/2016 08:40,MOSES SOUTH,23319,1485.8,2850,-1600
05/13/2016 08:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:40,SCH - NE - NY,23318,-928.99,1400,-1600
05/13/2016 08:40,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:40,SCH - OH - NY,23317,232.42,1100,-1900
05/13/2016 08:40,SCH - PJ - NY,23316,-104.99,2300,-800
05/13/2016 08:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:40,SCH - PJM_VFT,325658,290,315,-315
05/13/2016 08:40,SPR/DUN-SOUTH,23320,804.47,4350,-9999
05/13/2016 08:40,TOTAL EAST,23314,2379.84,6500,-9999
05/13/2016 08:40,UPNY CONED,23315,891.08,4850,-9999
05/13/2016 08:40,WEST CENTRAL,23312,-216.55,9999,-9999
05/13/2016 08:45,CENTRAL EAST - VC,23330,2241.59,2345,-9999
05/13/2016 08:45,DYSINGER EAST,23326,340.18,3150,-9999
05/13/2016 08:45,MOSES SOUTH,23319,1495.99,2850,-1600
05/13/2016 08:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:45,SCH - NE - NY,23318,-933.99,1400,-1600
05/13/2016 08:45,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:45,SCH - OH - NY,23317,232.42,1100,-1900
05/13/2016 08:45,SCH - PJ - NY,23316,-104.25,2300,-800
05/13/2016 08:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:45,SCH - PJM_VFT,325658,299,315,-315
05/13/2016 08:45,SPR/DUN-SOUTH,23320,786.72,4350,-9999
05/13/2016 08:45,TOTAL EAST,23314,2441.27,6500,-9999
05/13/2016 08:45,UPNY CONED,23315,875.7,4850,-9999
05/13/2016 08:45,WEST CENTRAL,23312,-153.67,9999,-9999
05/13/2016 08:50,CENTRAL EAST - VC,23330,2240.56,2345,-9999
05/13/2016 08:50,DYSINGER EAST,23326,322.78,3150,-9999
05/13/2016 08:50,MOSES SOUTH,23319,1502.73,2850,-1600
05/13/2016 08:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:50,SCH - NE - NY,23318,-940.04,1400,-1600
05/13/2016 08:50,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:50,SCH - OH - NY,23317,232.39,1100,-1900
05/13/2016 08:50,SCH - PJ - NY,23316,-104.47,2300,-800
05/13/2016 08:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:50,SCH - PJM_VFT,325658,309,315,-315
05/13/2016 08:50,SPR/DUN-SOUTH,23320,801.7,4350,-9999
05/13/2016 08:50,TOTAL EAST,23314,2422.5,6500,-9999
05/13/2016 08:50,UPNY CONED,23315,882.37,4850,-9999
05/13/2016 08:50,WEST CENTRAL,23312,-175.1,9999,-9999
05/13/2016 08:55,CENTRAL EAST - VC,23330,2238.43,2345,-9999
05/13/2016 08:55,DYSINGER EAST,23326,327.09,3150,-9999
05/13/2016 08:55,MOSES SOUTH,23319,1498.06,2850,-1600
05/13/2016 08:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 08:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 08:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 08:55,SCH - NE - NY,23318,-940.03,1400,-1600
05/13/2016 08:55,SCH - NPX_1385,325277,99,200,-200
05/13/2016 08:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 08:55,SCH - OH - NY,23317,232.52,1100,-1900
05/13/2016 08:55,SCH - PJ - NY,23316,-105.12,2300,-800
05/13/2016 08:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 08:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 08:55,SCH - PJM_VFT,325658,309,315,-315
05/13/2016 08:55,SPR/DUN-SOUTH,23320,798.29,4350,-9999
05/13/2016 08:55,TOTAL EAST,23314,2423.73,6500,-9999
05/13/2016 08:55,UPNY CONED,23315,878.08,4850,-9999
05/13/2016 08:55,WEST CENTRAL,23312,-173.87,9999,-9999
05/13/2016 09:00,CENTRAL EAST - VC,23330,2239.22,2345,-9999
05/13/2016 09:00,DYSINGER EAST,23326,198.86,3150,-9999
05/13/2016 09:00,MOSES SOUTH,23319,1486.8,2850,-1600
05/13/2016 09:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:00,SCH - NE - NY,23318,-893.98,1400,-1600
05/13/2016 09:00,SCH - NPX_1385,325277,146,200,-200
05/13/2016 09:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:00,SCH - OH - NY,23317,234.27,1100,-1900
05/13/2016 09:00,SCH - PJ - NY,23316,-116.77,2300,-800
05/13/2016 09:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:00,SCH - PJM_VFT,325658,294,315,-315
05/13/2016 09:00,SPR/DUN-SOUTH,23320,838.15,4350,-9999
05/13/2016 09:00,TOTAL EAST,23314,2402.86,6500,-9999
05/13/2016 09:00,UPNY CONED,23315,860.07,4850,-9999
05/13/2016 09:00,WEST CENTRAL,23312,-302.58,9999,-9999
05/13/2016 09:05,CENTRAL EAST - VC,23330,2242.65,2345,-9999
05/13/2016 09:05,DYSINGER EAST,23326,219.13,3150,-9999
05/13/2016 09:05,MOSES SOUTH,23319,1528.08,2850,-1600
05/13/2016 09:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:05,SCH - NE - NY,23318,-849.13,1400,-1600
05/13/2016 09:05,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:05,SCH - OH - NY,23317,236.5,1100,-1900
05/13/2016 09:05,SCH - PJ - NY,23316,-128.5,2300,-800
05/13/2016 09:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:05,SCH - PJM_VFT,325658,279,315,-315
05/13/2016 09:05,SPR/DUN-SOUTH,23320,887.88,4350,-9999
05/13/2016 09:05,TOTAL EAST,23314,2380.09,6500,-9999
05/13/2016 09:05,UPNY CONED,23315,880.46,4850,-9999
05/13/2016 09:05,WEST CENTRAL,23312,-280.64,9999,-9999
05/13/2016 09:10,CENTRAL EAST - VC,23330,2239.71,2345,-9999
05/13/2016 09:10,DYSINGER EAST,23326,214.7,3150,-9999
05/13/2016 09:10,MOSES SOUTH,23319,1543.15,2850,-1600
05/13/2016 09:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:10,SCH - NE - NY,23318,-849.34,1400,-1600
05/13/2016 09:10,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:10,SCH - OH - NY,23317,236.58,1100,-1900
05/13/2016 09:10,SCH - PJ - NY,23316,-130.56,2300,-800
05/13/2016 09:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:10,SCH - PJM_VFT,325658,279,315,-315
05/13/2016 09:10,SPR/DUN-SOUTH,23320,889.02,4350,-9999
05/13/2016 09:10,TOTAL EAST,23314,2353.96,6500,-9999
05/13/2016 09:10,UPNY CONED,23315,902.49,4850,-9999
05/13/2016 09:10,WEST CENTRAL,23312,-286.41,9999,-9999
05/13/2016 09:15,CENTRAL EAST - VC,23330,2241.04,2345,-9999
05/13/2016 09:15,DYSINGER EAST,23326,283.13,3150,-9999
05/13/2016 09:15,MOSES SOUTH,23319,1543.61,2850,-1600
05/13/2016 09:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:15,SCH - NE - NY,23318,-844.16,1400,-1600
05/13/2016 09:15,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:15,SCH - OH - NY,23317,236.83,1100,-1900
05/13/2016 09:15,SCH - PJ - NY,23316,-128.94,2300,-800
05/13/2016 09:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:15,SCH - PJM_VFT,325658,265,315,-315
05/13/2016 09:15,SPR/DUN-SOUTH,23320,953.93,4350,-9999
05/13/2016 09:15,TOTAL EAST,23314,2308.84,6500,-9999
05/13/2016 09:15,UPNY CONED,23315,901.87,4850,-9999
05/13/2016 09:15,WEST CENTRAL,23312,-220.56,9999,-9999
05/13/2016 09:20,CENTRAL EAST - VC,23330,2238.5,2345,-9999
05/13/2016 09:20,DYSINGER EAST,23326,249.17,3150,-9999
05/13/2016 09:20,MOSES SOUTH,23319,1550.17,2850,-1600
05/13/2016 09:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:20,SCH - NE - NY,23318,-839.1,1400,-1600
05/13/2016 09:20,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:20,SCH - OH - NY,23317,236.86,1100,-1900
05/13/2016 09:20,SCH - PJ - NY,23316,-130.59,2300,-800
05/13/2016 09:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:20,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:20,SPR/DUN-SOUTH,23320,987.38,4350,-9999
05/13/2016 09:20,TOTAL EAST,23314,2283.34,6500,-9999
05/13/2016 09:20,UPNY CONED,23315,902.36,4850,-9999
05/13/2016 09:20,WEST CENTRAL,23312,-257.9,9999,-9999
05/13/2016 09:25,CENTRAL EAST - VC,23330,2238.37,2345,-9999
05/13/2016 09:25,DYSINGER EAST,23326,174.73,3150,-9999
05/13/2016 09:25,MOSES SOUTH,23319,1549.33,2850,-1600
05/13/2016 09:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:25,SCH - NE - NY,23318,-839.05,1400,-1600
05/13/2016 09:25,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:25,SCH - OH - NY,23317,236.65,1100,-1900
05/13/2016 09:25,SCH - PJ - NY,23316,-132.15,2300,-800
05/13/2016 09:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:25,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:25,SPR/DUN-SOUTH,23320,981.52,4350,-9999
05/13/2016 09:25,TOTAL EAST,23314,2253.46,6500,-9999
05/13/2016 09:25,UPNY CONED,23315,894.41,4850,-9999
05/13/2016 09:25,WEST CENTRAL,23312,-334.82,9999,-9999
05/13/2016 09:30,CENTRAL EAST - VC,23330,2230.08,2345,-9999
05/13/2016 09:30,DYSINGER EAST,23326,224.5,3150,-9999
05/13/2016 09:30,MOSES SOUTH,23319,1543.41,2850,-1600
05/13/2016 09:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:30,SCH - NE - NY,23318,-864.14,1400,-1600
05/13/2016 09:30,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:30,SCH - OH - NY,23317,236.83,1100,-1900
05/13/2016 09:30,SCH - PJ - NY,23316,-96.54,2300,-800
05/13/2016 09:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:30,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:30,SPR/DUN-SOUTH,23320,981.07,4350,-9999
05/13/2016 09:30,TOTAL EAST,23314,2317.22,6500,-9999
05/13/2016 09:30,UPNY CONED,23315,906.88,4850,-9999
05/13/2016 09:30,WEST CENTRAL,23312,-283.65,9999,-9999
05/13/2016 09:35,CENTRAL EAST - VC,23330,2229.76,2345,-9999
05/13/2016 09:35,DYSINGER EAST,23326,215.14,3150,-9999
05/13/2016 09:35,MOSES SOUTH,23319,1522.63,2850,-1600
05/13/2016 09:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:35,SCH - NE - NY,23318,-889.16,1400,-1600
05/13/2016 09:35,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:35,SCH - OH - NY,23317,236.77,1100,-1900
05/13/2016 09:35,SCH - PJ - NY,23316,-61.99,2300,-800
05/13/2016 09:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:35,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:35,SPR/DUN-SOUTH,23320,991.63,4350,-9999
05/13/2016 09:35,TOTAL EAST,23314,2375.06,6500,-9999
05/13/2016 09:35,UPNY CONED,23315,914.74,4850,-9999
05/13/2016 09:35,WEST CENTRAL,23312,-291.57,9999,-9999
05/13/2016 09:40,CENTRAL EAST - VC,23330,2241.79,2345,-9999
05/13/2016 09:40,DYSINGER EAST,23326,204.82,3150,-9999
05/13/2016 09:40,MOSES SOUTH,23319,1526.59,2850,-1600
05/13/2016 09:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:40,SCH - NE - NY,23318,-889.06,1400,-1600
05/13/2016 09:40,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:40,SCH - OH - NY,23317,236.6,1100,-1900
05/13/2016 09:40,SCH - PJ - NY,23316,-65.51,2300,-800
05/13/2016 09:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:40,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:40,SPR/DUN-SOUTH,23320,987.04,4350,-9999
05/13/2016 09:40,TOTAL EAST,23314,2372.35,6500,-9999
05/13/2016 09:40,UPNY CONED,23315,914.57,4850,-9999
05/13/2016 09:40,WEST CENTRAL,23312,-303.8,9999,-9999
05/13/2016 09:45,CENTRAL EAST - VC,23330,2244.17,2345,-9999
05/13/2016 09:45,DYSINGER EAST,23326,321.84,3150,-9999
05/13/2016 09:45,MOSES SOUTH,23319,1497.86,2850,-1600
05/13/2016 09:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:45,SCH - NE - NY,23318,-851.14,1400,-1600
05/13/2016 09:45,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:45,SCH - OH - NY,23317,236.46,1100,-1900
05/13/2016 09:45,SCH - PJ - NY,23316,-63.26,2300,-800
05/13/2016 09:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:45,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:45,SPR/DUN-SOUTH,23320,1017.43,4350,-9999
05/13/2016 09:45,TOTAL EAST,23314,2478.95,6500,-9999
05/13/2016 09:45,UPNY CONED,23315,961.56,4850,-9999
05/13/2016 09:45,WEST CENTRAL,23312,-189.97,9999,-9999
05/13/2016 09:50,CENTRAL EAST - VC,23330,2240.71,2345,-9999
05/13/2016 09:50,DYSINGER EAST,23326,342.71,3150,-9999
05/13/2016 09:50,MOSES SOUTH,23319,1496.55,2850,-1600
05/13/2016 09:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:50,SCH - NE - NY,23318,-814.28,1400,-1600
05/13/2016 09:50,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:50,SCH - OH - NY,23317,236.49,1100,-1900
05/13/2016 09:50,SCH - PJ - NY,23316,-65.57,2300,-800
05/13/2016 09:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:50,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:50,SPR/DUN-SOUTH,23320,1031.76,4350,-9999
05/13/2016 09:50,TOTAL EAST,23314,2481.13,6500,-9999
05/13/2016 09:50,UPNY CONED,23315,969.22,4850,-9999
05/13/2016 09:50,WEST CENTRAL,23312,-171.03,9999,-9999
05/13/2016 09:55,CENTRAL EAST - VC,23330,2241.63,2345,-9999
05/13/2016 09:55,DYSINGER EAST,23326,407.16,3150,-9999
05/13/2016 09:55,MOSES SOUTH,23319,1528.68,2850,-1600
05/13/2016 09:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 09:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 09:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 09:55,SCH - NE - NY,23318,-814.35,1400,-1600
05/13/2016 09:55,SCH - NPX_1385,325277,194,200,-200
05/13/2016 09:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 09:55,SCH - OH - NY,23317,236.65,1100,-1900
05/13/2016 09:55,SCH - PJ - NY,23316,-64.83,2300,-800
05/13/2016 09:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 09:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 09:55,SCH - PJM_VFT,325658,252,315,-315
05/13/2016 09:55,SPR/DUN-SOUTH,23320,1013.4,4350,-9999
05/13/2016 09:55,TOTAL EAST,23314,2500.8,6500,-9999
05/13/2016 09:55,UPNY CONED,23315,949.7,4850,-9999
05/13/2016 09:55,WEST CENTRAL,23312,-111.73,9999,-9999
05/13/2016 10:00,CENTRAL EAST - VC,23330,2228.5,2345,-9999
05/13/2016 10:00,DYSINGER EAST,23326,287.25,3150,-9999
05/13/2016 10:00,MOSES SOUTH,23319,1523.06,2850,-1600
05/13/2016 10:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:00,SCH - NE - NY,23318,-777.44,1400,-1600
05/13/2016 10:00,SCH - NPX_1385,325277,179,200,-200
05/13/2016 10:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:00,SCH - OH - NY,23317,371.83,1100,-1900
05/13/2016 10:00,SCH - PJ - NY,23316,-87.47,2300,-800
05/13/2016 10:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:00,SCH - PJM_VFT,325658,182,315,-315
05/13/2016 10:00,SPR/DUN-SOUTH,23320,1021.73,4350,-9999
05/13/2016 10:00,TOTAL EAST,23314,2469.34,6500,-9999
05/13/2016 10:00,UPNY CONED,23315,922.97,4850,-9999
05/13/2016 10:00,WEST CENTRAL,23312,-232.08,9999,-9999
05/13/2016 10:05,CENTRAL EAST - VC,23330,2223.72,2345,-9999
05/13/2016 10:05,DYSINGER EAST,23326,180.6,3150,-9999
05/13/2016 10:05,MOSES SOUTH,23319,1535.28,2850,-1600
05/13/2016 10:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:05,SCH - NE - NY,23318,-740.42,1400,-1600
05/13/2016 10:05,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:05,SCH - OH - NY,23317,507.86,1100,-1900
05/13/2016 10:05,SCH - PJ - NY,23316,-110.51,2300,-800
05/13/2016 10:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:05,SCH - PJM_VFT,325658,113,315,-315
05/13/2016 10:05,SPR/DUN-SOUTH,23320,1052.39,4350,-9999
05/13/2016 10:05,TOTAL EAST,23314,2481.95,6500,-9999
05/13/2016 10:05,UPNY CONED,23315,979.11,4850,-9999
05/13/2016 10:05,WEST CENTRAL,23312,-338.36,9999,-9999
05/13/2016 10:10,CENTRAL EAST - VC,23330,2239.97,2345,-9999
05/13/2016 10:10,DYSINGER EAST,23326,192.37,3150,-9999
05/13/2016 10:10,MOSES SOUTH,23319,1573.94,2850,-1600
05/13/2016 10:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:10,SCH - NE - NY,23318,-740.27,1400,-1600
05/13/2016 10:10,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:10,SCH - OH - NY,23317,507.88,1100,-1900
05/13/2016 10:10,SCH - PJ - NY,23316,-111.18,2300,-800
05/13/2016 10:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:10,SCH - PJM_VFT,325658,113,315,-315
05/13/2016 10:10,SPR/DUN-SOUTH,23320,1027.13,4350,-9999
05/13/2016 10:10,TOTAL EAST,23314,2453.94,6500,-9999
05/13/2016 10:10,UPNY CONED,23315,967.92,4850,-9999
05/13/2016 10:10,WEST CENTRAL,23312,-328.57,9999,-9999
05/13/2016 10:15,CENTRAL EAST - VC,23330,2243.14,2345,-9999
05/13/2016 10:15,DYSINGER EAST,23326,292.19,3150,-9999
05/13/2016 10:15,MOSES SOUTH,23319,1537.12,2850,-1600
05/13/2016 10:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:15,SCH - NE - NY,23318,-730.28,1400,-1600
05/13/2016 10:15,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:15,SCH - OH - NY,23317,508,1100,-1900
05/13/2016 10:15,SCH - PJ - NY,23316,-112.34,2300,-800
05/13/2016 10:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:15,SCH - PJM_VFT,325658,127,315,-315
05/13/2016 10:15,SPR/DUN-SOUTH,23320,942.51,4350,-9999
05/13/2016 10:15,TOTAL EAST,23314,2459.29,6500,-9999
05/13/2016 10:15,UPNY CONED,23315,976.54,4850,-9999
05/13/2016 10:15,WEST CENTRAL,23312,-228.87,9999,-9999
05/13/2016 10:20,CENTRAL EAST - VC,23330,2240.1,2345,-9999
05/13/2016 10:20,DYSINGER EAST,23326,324.28,3150,-9999
05/13/2016 10:20,MOSES SOUTH,23319,1524.8,2850,-1600
05/13/2016 10:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:20,SCH - NE - NY,23318,-720.38,1400,-1600
05/13/2016 10:20,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:20,SCH - OH - NY,23317,508.13,1100,-1900
05/13/2016 10:20,SCH - PJ - NY,23316,-113.3,2300,-800
05/13/2016 10:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:20,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:20,SPR/DUN-SOUTH,23320,954.13,4350,-9999
05/13/2016 10:20,TOTAL EAST,23314,2469.01,6500,-9999
05/13/2016 10:20,UPNY CONED,23315,992.26,4850,-9999
05/13/2016 10:20,WEST CENTRAL,23312,-198.56,9999,-9999
05/13/2016 10:25,CENTRAL EAST - VC,23330,2237.91,2345,-9999
05/13/2016 10:25,DYSINGER EAST,23326,368.48,3150,-9999
05/13/2016 10:25,MOSES SOUTH,23319,1544.47,2850,-1600
05/13/2016 10:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:25,SCH - NE - NY,23318,-720.43,1400,-1600
05/13/2016 10:25,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:25,SCH - OH - NY,23317,508.46,1100,-1900
05/13/2016 10:25,SCH - PJ - NY,23316,-115.17,2300,-800
05/13/2016 10:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:25,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:25,SPR/DUN-SOUTH,23320,945.63,4350,-9999
05/13/2016 10:25,TOTAL EAST,23314,2442.15,6500,-9999
05/13/2016 10:25,UPNY CONED,23315,968.65,4850,-9999
05/13/2016 10:25,WEST CENTRAL,23312,-153.33,9999,-9999
05/13/2016 10:30,CENTRAL EAST - VC,23330,2237.88,2345,-9999
05/13/2016 10:30,DYSINGER EAST,23326,251.85,3150,-9999
05/13/2016 10:30,MOSES SOUTH,23319,1557.72,2850,-1600
05/13/2016 10:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:30,SCH - NE - NY,23318,-810.23,1400,-1600
05/13/2016 10:30,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:30,SCH - OH - NY,23317,508.19,1100,-1900
05/13/2016 10:30,SCH - PJ - NY,23316,-109.92,2300,-800
05/13/2016 10:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:30,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:30,SPR/DUN-SOUTH,23320,984.96,4350,-9999
05/13/2016 10:30,TOTAL EAST,23314,2412.89,6500,-9999
05/13/2016 10:30,UPNY CONED,23315,953.57,4850,-9999
05/13/2016 10:30,WEST CENTRAL,23312,-269.41,9999,-9999
05/13/2016 10:35,CENTRAL EAST - VC,23330,2238.77,2345,-9999
05/13/2016 10:35,DYSINGER EAST,23326,206.71,3150,-9999
05/13/2016 10:35,MOSES SOUTH,23319,1559.4,2850,-1600
05/13/2016 10:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:35,SCH - NE - NY,23318,-899.46,1400,-1600
05/13/2016 10:35,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:35,SCH - OH - NY,23317,508.22,1100,-1900
05/13/2016 10:35,SCH - PJ - NY,23316,-115.34,2300,-800
05/13/2016 10:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:35,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:35,SPR/DUN-SOUTH,23320,974.45,4350,-9999
05/13/2016 10:35,TOTAL EAST,23314,2376.04,6500,-9999
05/13/2016 10:35,UPNY CONED,23315,952.52,4850,-9999
05/13/2016 10:35,WEST CENTRAL,23312,-316.38,9999,-9999
05/13/2016 10:40,CENTRAL EAST - VC,23330,2302.8,2405,-9999
05/13/2016 10:40,DYSINGER EAST,23326,299.34,3150,-9999
05/13/2016 10:40,MOSES SOUTH,23319,1578.36,2850,-1600
05/13/2016 10:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:40,SCH - NE - NY,23318,-899.46,1400,-1600
05/13/2016 10:40,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:40,SCH - OH - NY,23317,508.22,1100,-1900
05/13/2016 10:40,SCH - PJ - NY,23316,-112.75,2300,-800
05/13/2016 10:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:40,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:40,SPR/DUN-SOUTH,23320,963.06,4350,-9999
05/13/2016 10:40,TOTAL EAST,23314,2482.94,6500,-9999
05/13/2016 10:40,UPNY CONED,23315,937.13,4850,-9999
05/13/2016 10:40,WEST CENTRAL,23312,-225.14,9999,-9999
05/13/2016 10:45,CENTRAL EAST - VC,23330,2319.29,2435,-9999
05/13/2016 10:45,DYSINGER EAST,23326,259.83,3150,-9999
05/13/2016 10:45,MOSES SOUTH,23319,1574.22,2850,-1600
05/13/2016 10:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:45,SCH - NE - NY,23318,-867.48,1400,-1600
05/13/2016 10:45,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:45,SCH - OH - NY,23317,508.29,1100,-1900
05/13/2016 10:45,SCH - PJ - NY,23316,-80.7,2300,-800
05/13/2016 10:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:45,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:45,SPR/DUN-SOUTH,23320,1035.07,4350,-9999
05/13/2016 10:45,TOTAL EAST,23314,2464.69,6500,-9999
05/13/2016 10:45,UPNY CONED,23315,1006.4,4850,-9999
05/13/2016 10:45,WEST CENTRAL,23312,-266.79,9999,-9999
05/13/2016 10:50,CENTRAL EAST - VC,23330,2322.1,2435,-9999
05/13/2016 10:50,DYSINGER EAST,23326,316.57,3150,-9999
05/13/2016 10:50,MOSES SOUTH,23319,1597.52,2850,-1600
05/13/2016 10:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:50,SCH - NE - NY,23318,-837.02,1400,-1600
05/13/2016 10:50,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:50,SCH - OH - NY,23317,508.42,1100,-1900
05/13/2016 10:50,SCH - PJ - NY,23316,-45.6,2300,-800
05/13/2016 10:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:50,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:50,SPR/DUN-SOUTH,23320,1042.96,4350,-9999
05/13/2016 10:50,TOTAL EAST,23314,2494.98,6500,-9999
05/13/2016 10:50,UPNY CONED,23315,1023.09,4850,-9999
05/13/2016 10:50,WEST CENTRAL,23312,-212.2,9999,-9999
05/13/2016 10:55,CENTRAL EAST - VC,23330,2334.1,2435,-9999
05/13/2016 10:55,DYSINGER EAST,23326,389.27,3150,-9999
05/13/2016 10:55,MOSES SOUTH,23319,1576.02,2850,-1600
05/13/2016 10:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 10:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 10:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 10:55,SCH - NE - NY,23318,-837.29,1400,-1600
05/13/2016 10:55,SCH - NPX_1385,325277,164,200,-200
05/13/2016 10:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 10:55,SCH - OH - NY,23317,508.22,1100,-1900
05/13/2016 10:55,SCH - PJ - NY,23316,-49.17,2300,-800
05/13/2016 10:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 10:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 10:55,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 10:55,SPR/DUN-SOUTH,23320,1034.14,4350,-9999
05/13/2016 10:55,TOTAL EAST,23314,2562.03,6500,-9999
05/13/2016 10:55,UPNY CONED,23315,1014.59,4850,-9999
05/13/2016 10:55,WEST CENTRAL,23312,-143.03,9999,-9999
05/13/2016 11:00,CENTRAL EAST - VC,23330,2311.21,2435,-9999
05/13/2016 11:00,DYSINGER EAST,23326,387.86,3150,-9999
05/13/2016 11:00,MOSES SOUTH,23319,1570.78,2850,-1600
05/13/2016 11:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:00,SCH - NE - NY,23318,-788.41,1400,-1600
05/13/2016 11:00,SCH - NPX_1385,325277,129,200,-200
05/13/2016 11:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:00,SCH - OH - NY,23317,533.47,1100,-1900
05/13/2016 11:00,SCH - PJ - NY,23316,-36.37,2300,-800
05/13/2016 11:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:00,SCH - PJM_VFT,325658,102,315,-315
05/13/2016 11:00,SPR/DUN-SOUTH,23320,1082.03,4350,-9999
05/13/2016 11:00,TOTAL EAST,23314,2564.16,6500,-9999
05/13/2016 11:00,UPNY CONED,23315,1087.63,4850,-9999
05/13/2016 11:00,WEST CENTRAL,23312,-143.6,9999,-9999
05/13/2016 11:05,CENTRAL EAST - VC,23330,2311.79,2435,-9999
05/13/2016 11:05,DYSINGER EAST,23326,270.63,3150,-9999
05/13/2016 11:05,MOSES SOUTH,23319,1577.49,2850,-1600
05/13/2016 11:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:05,SCH - NE - NY,23318,-740.56,1400,-1600
05/13/2016 11:05,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:05,SCH - OH - NY,23317,558.06,1100,-1900
05/13/2016 11:05,SCH - PJ - NY,23316,-23.31,2300,-800
05/13/2016 11:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:05,SCH - PJM_VFT,325658,61,315,-315
05/13/2016 11:05,SPR/DUN-SOUTH,23320,1126.71,4350,-9999
05/13/2016 11:05,TOTAL EAST,23314,2596.87,6500,-9999
05/13/2016 11:05,UPNY CONED,23315,1176.68,4850,-9999
05/13/2016 11:05,WEST CENTRAL,23312,-260.24,9999,-9999
05/13/2016 11:10,CENTRAL EAST - VC,23330,2327.87,2435,-9999
05/13/2016 11:10,DYSINGER EAST,23326,430.26,3150,-9999
05/13/2016 11:10,MOSES SOUTH,23319,1596.93,2850,-1600
05/13/2016 11:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:10,SCH - NE - NY,23318,-740.58,1400,-1600
05/13/2016 11:10,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:10,SCH - OH - NY,23317,558.23,1100,-1900
05/13/2016 11:10,SCH - PJ - NY,23316,-23.77,2300,-800
05/13/2016 11:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:10,SCH - PJM_VFT,325658,62,315,-315
05/13/2016 11:10,SPR/DUN-SOUTH,23320,1139.86,4350,-9999
05/13/2016 11:10,TOTAL EAST,23314,2699.58,6500,-9999
05/13/2016 11:10,UPNY CONED,23315,1196,4850,-9999
05/13/2016 11:10,WEST CENTRAL,23312,-102.27,9999,-9999
05/13/2016 11:15,CENTRAL EAST - VC,23330,2321.18,2435,-9999
05/13/2016 11:15,DYSINGER EAST,23326,363.84,3150,-9999
05/13/2016 11:15,MOSES SOUTH,23319,1507.65,2850,-1600
05/13/2016 11:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:15,SCH - NE - NY,23318,-785.36,1400,-1600
05/13/2016 11:15,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:15,SCH - OH - NY,23317,558.2,1100,-1900
05/13/2016 11:15,SCH - PJ - NY,23316,-10.66,2300,-800
05/13/2016 11:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:15,SCH - PJM_VFT,325658,60,315,-315
05/13/2016 11:15,SPR/DUN-SOUTH,23320,1127.83,4350,-9999
05/13/2016 11:15,TOTAL EAST,23314,2650.87,6500,-9999
05/13/2016 11:15,UPNY CONED,23315,1157.22,4850,-9999
05/13/2016 11:15,WEST CENTRAL,23312,-168.54,9999,-9999
05/13/2016 11:20,CENTRAL EAST - VC,23330,2391.52,2495,-9999
05/13/2016 11:20,DYSINGER EAST,23326,453.21,3150,-9999
05/13/2016 11:20,MOSES SOUTH,23319,1529.24,2850,-1600
05/13/2016 11:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:20,SCH - NE - NY,23318,-831.24,1400,-1600
05/13/2016 11:20,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:20,SCH - OH - NY,23317,558.14,1100,-1900
05/13/2016 11:20,SCH - PJ - NY,23316,.25,2300,-800
05/13/2016 11:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:20,SCH - PJM_VFT,325658,59,315,-315
05/13/2016 11:20,SPR/DUN-SOUTH,23320,1167.33,4350,-9999
05/13/2016 11:20,TOTAL EAST,23314,2784.22,6500,-9999
05/13/2016 11:20,UPNY CONED,23315,1204.45,4850,-9999
05/13/2016 11:20,WEST CENTRAL,23312,-79.82,9999,-9999
05/13/2016 11:25,CENTRAL EAST - VC,23330,2386.74,2495,-9999
05/13/2016 11:25,DYSINGER EAST,23326,411.32,3150,-9999
05/13/2016 11:25,MOSES SOUTH,23319,1671.87,2850,-1600
05/13/2016 11:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:25,SCH - NE - NY,23318,-831.17,1400,-1600
05/13/2016 11:25,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:25,SCH - OH - NY,23317,558.48,1100,-1900
05/13/2016 11:25,SCH - PJ - NY,23316,.69,2300,-800
05/13/2016 11:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:25,SCH - PJM_VFT,325658,59,315,-315
05/13/2016 11:25,SPR/DUN-SOUTH,23320,1141.37,4350,-9999
05/13/2016 11:25,TOTAL EAST,23314,2780.6,6500,-9999
05/13/2016 11:25,UPNY CONED,23315,1161.88,4850,-9999
05/13/2016 11:25,WEST CENTRAL,23312,-125.38,9999,-9999
05/13/2016 11:30,CENTRAL EAST - VC,23330,2377.66,2495,-9999
05/13/2016 11:30,DYSINGER EAST,23326,307.06,3150,-9999
05/13/2016 11:30,MOSES SOUTH,23319,1811.28,2850,-1600
05/13/2016 11:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:30,SCH - NE - NY,23318,-785.54,1400,-1600
05/13/2016 11:30,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:30,SCH - OH - NY,23317,558.34,1100,-1900
05/13/2016 11:30,SCH - PJ - NY,23316,-11.84,2300,-800
05/13/2016 11:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:30,SCH - PJM_VFT,325658,42,315,-315
05/13/2016 11:30,SPR/DUN-SOUTH,23320,1082.02,4350,-9999
05/13/2016 11:30,TOTAL EAST,23314,2827.15,6500,-9999
05/13/2016 11:30,UPNY CONED,23315,1178.14,4850,-9999
05/13/2016 11:30,WEST CENTRAL,23312,-232.97,9999,-9999
05/13/2016 11:35,CENTRAL EAST - VC,23330,2392.28,2495,-9999
05/13/2016 11:35,DYSINGER EAST,23326,290.4,3150,-9999
05/13/2016 11:35,MOSES SOUTH,23319,1743.25,2850,-1600
05/13/2016 11:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:35,SCH - NE - NY,23318,-740.61,1400,-1600
05/13/2016 11:35,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:35,SCH - OH - NY,23317,558.14,1100,-1900
05/13/2016 11:35,SCH - PJ - NY,23316,-23.27,2300,-800
05/13/2016 11:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:35,SCH - PJM_VFT,325658,24,315,-315
05/13/2016 11:35,SPR/DUN-SOUTH,23320,1222.01,4350,-9999
05/13/2016 11:35,TOTAL EAST,23314,2842.56,6500,-9999
05/13/2016 11:35,UPNY CONED,23315,1302.22,4850,-9999
05/13/2016 11:35,WEST CENTRAL,23312,-248.18,9999,-9999
05/13/2016 11:40,CENTRAL EAST - VC,23330,2392.76,2495,-9999
05/13/2016 11:40,DYSINGER EAST,23326,412.14,3150,-9999
05/13/2016 11:40,MOSES SOUTH,23319,1647.5,2850,-1600
05/13/2016 11:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:40,SCH - NE - NY,23318,-740.63,1400,-1600
05/13/2016 11:40,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:40,SCH - OH - NY,23317,558.29,1100,-1900
05/13/2016 11:40,SCH - PJ - NY,23316,-24.57,2300,-800
05/13/2016 11:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:40,SCH - PJM_VFT,325658,25,315,-315
05/13/2016 11:40,SPR/DUN-SOUTH,23320,1248.78,4350,-9999
05/13/2016 11:40,TOTAL EAST,23314,2845.38,6500,-9999
05/13/2016 11:40,UPNY CONED,23315,1290.85,4850,-9999
05/13/2016 11:40,WEST CENTRAL,23312,-123.5,9999,-9999
05/13/2016 11:45,CENTRAL EAST - VC,23330,2388.42,2495,-9999
05/13/2016 11:45,DYSINGER EAST,23326,436.27,3150,-9999
05/13/2016 11:45,MOSES SOUTH,23319,1627.65,2850,-1600
05/13/2016 11:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:45,SCH - NE - NY,23318,-755.49,1400,-1600
05/13/2016 11:45,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:45,SCH - OH - NY,23317,558.29,1100,-1900
05/13/2016 11:45,SCH - PJ - NY,23316,-24.62,2300,-800
05/13/2016 11:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:45,SCH - PJM_VFT,325658,83,315,-315
05/13/2016 11:45,SPR/DUN-SOUTH,23320,1089.97,4350,-9999
05/13/2016 11:45,TOTAL EAST,23314,2844.65,6500,-9999
05/13/2016 11:45,UPNY CONED,23315,1153.14,4850,-9999
05/13/2016 11:45,WEST CENTRAL,23312,-98.93,9999,-9999
05/13/2016 11:50,CENTRAL EAST - VC,23330,2417.9,2525,-9999
05/13/2016 11:50,DYSINGER EAST,23326,393.38,3150,-9999
05/13/2016 11:50,MOSES SOUTH,23319,1625.16,2850,-1600
05/13/2016 11:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:50,SCH - NE - NY,23318,-771.04,1400,-1600
05/13/2016 11:50,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:50,SCH - OH - NY,23317,558.11,1100,-1900
05/13/2016 11:50,SCH - PJ - NY,23316,-25.82,2300,-800
05/13/2016 11:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:50,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 11:50,SPR/DUN-SOUTH,23320,1011.87,4350,-9999
05/13/2016 11:50,TOTAL EAST,23314,2819.88,6500,-9999
05/13/2016 11:50,UPNY CONED,23315,1093.48,4850,-9999
05/13/2016 11:50,WEST CENTRAL,23312,-137,9999,-9999
05/13/2016 11:55,CENTRAL EAST - VC,23330,2416.25,2525,-9999
05/13/2016 11:55,DYSINGER EAST,23326,367.78,3150,-9999
05/13/2016 11:55,MOSES SOUTH,23319,1641.03,2850,-1600
05/13/2016 11:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 11:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 11:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 11:55,SCH - NE - NY,23318,-771.17,1400,-1600
05/13/2016 11:55,SCH - NPX_1385,325277,94,200,-200
05/13/2016 11:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 11:55,SCH - OH - NY,23317,558.08,1100,-1900
05/13/2016 11:55,SCH - PJ - NY,23316,-23.01,2300,-800
05/13/2016 11:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 11:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 11:55,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 11:55,SPR/DUN-SOUTH,23320,1007.32,4350,-9999
05/13/2016 11:55,TOTAL EAST,23314,2810.7,6500,-9999
05/13/2016 11:55,UPNY CONED,23315,1098.89,4850,-9999
05/13/2016 11:55,WEST CENTRAL,23312,-163.6,9999,-9999
05/13/2016 12:00,CENTRAL EAST - VC,23330,2424.89,2525,-9999
05/13/2016 12:00,DYSINGER EAST,23326,381.47,3150,-9999
05/13/2016 12:00,MOSES SOUTH,23319,1634.29,2850,-1600
05/13/2016 12:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:00,SCH - NE - NY,23318,-871.16,1400,-1600
05/13/2016 12:00,SCH - NPX_1385,325277,84,200,-200
05/13/2016 12:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:00,SCH - OH - NY,23317,526.87,1100,-1900
05/13/2016 12:00,SCH - PJ - NY,23316,-42.18,2300,-800
05/13/2016 12:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:00,SCH - PJM_VFT,325658,113,315,-315
05/13/2016 12:00,SPR/DUN-SOUTH,23320,952.7,4350,-9999
05/13/2016 12:00,TOTAL EAST,23314,2819.69,6500,-9999
05/13/2016 12:00,UPNY CONED,23315,1058.21,4850,-9999
05/13/2016 12:00,WEST CENTRAL,23312,-147.62,9999,-9999
05/13/2016 12:05,CENTRAL EAST - VC,23330,2413.26,2525,-9999
05/13/2016 12:05,DYSINGER EAST,23326,476.59,3150,-9999
05/13/2016 12:05,MOSES SOUTH,23319,1668.65,2850,-1600
05/13/2016 12:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:05,SCH - NE - NY,23318,-970.9,1400,-1600
05/13/2016 12:05,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:05,SCH - OH - NY,23317,496.71,1100,-1900
05/13/2016 12:05,SCH - PJ - NY,23316,-61.4,2300,-800
05/13/2016 12:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:05,SCH - PJM_VFT,325658,85,315,-315
05/13/2016 12:05,SPR/DUN-SOUTH,23320,932.8,4350,-9999
05/13/2016 12:05,TOTAL EAST,23314,2938.64,6500,-9999
05/13/2016 12:05,UPNY CONED,23315,1042.29,4850,-9999
05/13/2016 12:05,WEST CENTRAL,23312,-54.16,9999,-9999
05/13/2016 12:10,CENTRAL EAST - VC,23330,2416.61,2525,-9999
05/13/2016 12:10,DYSINGER EAST,23326,470.97,3150,-9999
05/13/2016 12:10,MOSES SOUTH,23319,1637.58,2850,-1600
05/13/2016 12:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:10,SCH - NE - NY,23318,-970.27,1400,-1600
05/13/2016 12:10,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:10,SCH - OH - NY,23317,496.78,1100,-1900
05/13/2016 12:10,SCH - PJ - NY,23316,-62.64,2300,-800
05/13/2016 12:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:10,SCH - PJM_VFT,325658,85,315,-315
05/13/2016 12:10,SPR/DUN-SOUTH,23320,953.91,4350,-9999
05/13/2016 12:10,TOTAL EAST,23314,2849.49,6500,-9999
05/13/2016 12:10,UPNY CONED,23315,1068.25,4850,-9999
05/13/2016 12:10,WEST CENTRAL,23312,-60.19,9999,-9999
05/13/2016 12:15,CENTRAL EAST - VC,23330,2416.71,2525,-9999
05/13/2016 12:15,DYSINGER EAST,23326,415.94,3150,-9999
05/13/2016 12:15,MOSES SOUTH,23319,1639.87,2850,-1600
05/13/2016 12:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:15,SCH - NE - NY,23318,-957.28,1400,-1600
05/13/2016 12:15,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:15,SCH - OH - NY,23317,496.65,1100,-1900
05/13/2016 12:15,SCH - PJ - NY,23316,-63.29,2300,-800
05/13/2016 12:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:15,SCH - PJM_VFT,325658,113,315,-315
05/13/2016 12:15,SPR/DUN-SOUTH,23320,885.93,4350,-9999
05/13/2016 12:15,TOTAL EAST,23314,2855.35,6500,-9999
05/13/2016 12:15,UPNY CONED,23315,1000.21,4850,-9999
05/13/2016 12:15,WEST CENTRAL,23312,-110.88,9999,-9999
05/13/2016 12:20,CENTRAL EAST - VC,23330,2412.27,2525,-9999
05/13/2016 12:20,DYSINGER EAST,23326,329.6,3150,-9999
05/13/2016 12:20,MOSES SOUTH,23319,1655.03,2850,-1600
05/13/2016 12:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:20,SCH - NE - NY,23318,-945.34,1400,-1600
05/13/2016 12:20,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:20,SCH - OH - NY,23317,496.66,1100,-1900
05/13/2016 12:20,SCH - PJ - NY,23316,-61.72,2300,-800
05/13/2016 12:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:20,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:20,SPR/DUN-SOUTH,23320,855.88,4350,-9999
05/13/2016 12:20,TOTAL EAST,23314,2798.41,6500,-9999
05/13/2016 12:20,UPNY CONED,23315,1032.09,4850,-9999
05/13/2016 12:20,WEST CENTRAL,23312,-194.54,9999,-9999
05/13/2016 12:25,CENTRAL EAST - VC,23330,2411.84,2525,-9999
05/13/2016 12:25,DYSINGER EAST,23326,245.98,3150,-9999
05/13/2016 12:25,MOSES SOUTH,23319,1653.86,2850,-1600
05/13/2016 12:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:25,SCH - NE - NY,23318,-945.4,1400,-1600
05/13/2016 12:25,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:25,SCH - OH - NY,23317,496.71,1100,-1900
05/13/2016 12:25,SCH - PJ - NY,23316,-62.2,2300,-800
05/13/2016 12:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:25,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:25,SPR/DUN-SOUTH,23320,832.9,4350,-9999
05/13/2016 12:25,TOTAL EAST,23314,2748.84,6500,-9999
05/13/2016 12:25,UPNY CONED,23315,1015.91,4850,-9999
05/13/2016 12:25,WEST CENTRAL,23312,-278.57,9999,-9999
05/13/2016 12:30,CENTRAL EAST - VC,23330,2409.15,2525,-9999
05/13/2016 12:30,DYSINGER EAST,23326,233.54,3150,-9999
05/13/2016 12:30,MOSES SOUTH,23319,1596.86,2850,-1600
05/13/2016 12:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:30,SCH - NE - NY,23318,-1037.19,1400,-1600
05/13/2016 12:30,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:30,SCH - OH - NY,23317,496.95,1100,-1900
05/13/2016 12:30,SCH - PJ - NY,23316,-47.45,2300,-800
05/13/2016 12:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:30,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:30,SPR/DUN-SOUTH,23320,822.39,4350,-9999
05/13/2016 12:30,TOTAL EAST,23314,2740.98,6500,-9999
05/13/2016 12:30,UPNY CONED,23315,985.52,4850,-9999
05/13/2016 12:30,WEST CENTRAL,23312,-288.7,9999,-9999
05/13/2016 12:35,CENTRAL EAST - VC,23330,2413.38,2525,-9999
05/13/2016 12:35,DYSINGER EAST,23326,338.9,3150,-9999
05/13/2016 12:35,MOSES SOUTH,23319,1578.74,2850,-1600
05/13/2016 12:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:35,SCH - NE - NY,23318,-1129.82,1400,-1600
05/13/2016 12:35,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:35,SCH - OH - NY,23317,497.12,1100,-1900
05/13/2016 12:35,SCH - PJ - NY,23316,-38.83,2300,-800
05/13/2016 12:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:35,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:35,SPR/DUN-SOUTH,23320,766.38,4350,-9999
05/13/2016 12:35,TOTAL EAST,23314,2806.8,6500,-9999
05/13/2016 12:35,UPNY CONED,23315,914.57,4850,-9999
05/13/2016 12:35,WEST CENTRAL,23312,-183.82,9999,-9999
05/13/2016 12:40,CENTRAL EAST - VC,23330,2416.68,2525,-9999
05/13/2016 12:40,DYSINGER EAST,23326,325.29,3150,-9999
05/13/2016 12:40,MOSES SOUTH,23319,1574.28,2850,-1600
05/13/2016 12:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:40,SCH - NE - NY,23318,-1129.62,1400,-1600
05/13/2016 12:40,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:40,SCH - OH - NY,23317,497.29,1100,-1900
05/13/2016 12:40,SCH - PJ - NY,23316,-37.76,2300,-800
05/13/2016 12:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:40,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:40,SPR/DUN-SOUTH,23320,802.94,4350,-9999
05/13/2016 12:40,TOTAL EAST,23314,2739.74,6500,-9999
05/13/2016 12:40,UPNY CONED,23315,946.4,4850,-9999
05/13/2016 12:40,WEST CENTRAL,23312,-198.21,9999,-9999
05/13/2016 12:45,CENTRAL EAST - VC,23330,2415.5,2525,-9999
05/13/2016 12:45,DYSINGER EAST,23326,367.12,3150,-9999
05/13/2016 12:45,MOSES SOUTH,23319,1579.2,2850,-1600
05/13/2016 12:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:45,SCH - NE - NY,23318,-1196.76,1400,-1600
05/13/2016 12:45,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:45,SCH - OH - NY,23317,497.34,1100,-1900
05/13/2016 12:45,SCH - PJ - NY,23316,-24.75,2300,-800
05/13/2016 12:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:45,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:45,SPR/DUN-SOUTH,23320,808.21,4350,-9999
05/13/2016 12:45,TOTAL EAST,23314,2782.99,6500,-9999
05/13/2016 12:45,UPNY CONED,23315,827.23,4850,-9999
05/13/2016 12:45,WEST CENTRAL,23312,-157.4,9999,-9999
05/13/2016 12:50,CENTRAL EAST - VC,23330,2412.72,2525,-9999
05/13/2016 12:50,DYSINGER EAST,23326,307.35,3150,-9999
05/13/2016 12:50,MOSES SOUTH,23319,1549.84,2850,-1600
05/13/2016 12:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:50,SCH - NE - NY,23318,-1264.38,1400,-1600
05/13/2016 12:50,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:50,SCH - OH - NY,23317,497.05,1100,-1900
05/13/2016 12:50,SCH - PJ - NY,23316,-12.44,2300,-800
05/13/2016 12:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:50,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:50,SPR/DUN-SOUTH,23320,807.36,4350,-9999
05/13/2016 12:50,TOTAL EAST,23314,2814.25,6500,-9999
05/13/2016 12:50,UPNY CONED,23315,816.18,4850,-9999
05/13/2016 12:50,WEST CENTRAL,23312,-218.18,9999,-9999
05/13/2016 12:55,CENTRAL EAST - VC,23330,2418.64,2525,-9999
05/13/2016 12:55,DYSINGER EAST,23326,326.91,3150,-9999
05/13/2016 12:55,MOSES SOUTH,23319,1559,2850,-1600
05/13/2016 12:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 12:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 12:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 12:55,SCH - NE - NY,23318,-1264.4,1400,-1600
05/13/2016 12:55,SCH - NPX_1385,325277,75,200,-200
05/13/2016 12:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 12:55,SCH - OH - NY,23317,497.03,1100,-1900
05/13/2016 12:55,SCH - PJ - NY,23316,-10.53,2300,-800
05/13/2016 12:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 12:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 12:55,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 12:55,SPR/DUN-SOUTH,23320,814.6,4350,-9999
05/13/2016 12:55,TOTAL EAST,23314,2837.7,6500,-9999
05/13/2016 12:55,UPNY CONED,23315,808.28,4850,-9999
05/13/2016 12:55,WEST CENTRAL,23312,-198.48,9999,-9999
05/13/2016 13:00,CENTRAL EAST - VC,23330,2420.61,2525,-9999
05/13/2016 13:00,DYSINGER EAST,23326,351.65,3150,-9999
05/13/2016 13:00,MOSES SOUTH,23319,1553.65,2850,-1600
05/13/2016 13:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:00,SCH - NE - NY,23318,-1165.04,1400,-1600
05/13/2016 13:00,SCH - NPX_1385,325277,62,200,-200
05/13/2016 13:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:00,SCH - OH - NY,23317,502.05,1100,-1900
05/13/2016 13:00,SCH - PJ - NY,23316,-133.56,2300,-800
05/13/2016 13:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:00,SCH - PJM_VFT,325658,105,315,-315
05/13/2016 13:00,SPR/DUN-SOUTH,23320,944.79,4350,-9999
05/13/2016 13:00,TOTAL EAST,23314,2734.35,6500,-9999
05/13/2016 13:00,UPNY CONED,23315,912.13,4850,-9999
05/13/2016 13:00,WEST CENTRAL,23312,-174.68,9999,-9999
05/13/2016 13:05,CENTRAL EAST - VC,23330,2419.97,2525,-9999
05/13/2016 13:05,DYSINGER EAST,23326,469.87,3150,-9999
05/13/2016 13:05,MOSES SOUTH,23319,1557.51,2850,-1600
05/13/2016 13:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:05,SCH - NE - NY,23318,-1066.02,1400,-1600
05/13/2016 13:05,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:05,SCH - OH - NY,23317,507.23,1100,-1900
05/13/2016 13:05,SCH - PJ - NY,23316,-257.6,2300,-800
05/13/2016 13:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:05,SCH - PJM_VFT,325658,69,315,-315
05/13/2016 13:05,SPR/DUN-SOUTH,23320,965.47,4350,-9999
05/13/2016 13:05,TOTAL EAST,23314,2698.41,6500,-9999
05/13/2016 13:05,UPNY CONED,23315,964.77,4850,-9999
05/13/2016 13:05,WEST CENTRAL,23312,-56.66,9999,-9999
05/13/2016 13:10,CENTRAL EAST - VC,23330,2422.12,2525,-9999
05/13/2016 13:10,DYSINGER EAST,23326,545.02,3150,-9999
05/13/2016 13:10,MOSES SOUTH,23319,1558.46,2850,-1600
05/13/2016 13:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:10,SCH - NE - NY,23318,-1065.98,1400,-1600
05/13/2016 13:10,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:10,SCH - OH - NY,23317,507.27,1100,-1900
05/13/2016 13:10,SCH - PJ - NY,23316,-256.77,2300,-800
05/13/2016 13:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:10,SCH - PJM_VFT,325658,69,315,-315
05/13/2016 13:10,SPR/DUN-SOUTH,23320,974.89,4350,-9999
05/13/2016 13:10,TOTAL EAST,23314,2764.79,6500,-9999
05/13/2016 13:10,UPNY CONED,23315,992.81,4850,-9999
05/13/2016 13:10,WEST CENTRAL,23312,25.55,9999,-9999
05/13/2016 13:15,CENTRAL EAST - VC,23330,2415.59,2525,-9999
05/13/2016 13:15,DYSINGER EAST,23326,494.38,3150,-9999
05/13/2016 13:15,MOSES SOUTH,23319,1552.49,2850,-1600
05/13/2016 13:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:15,SCH - NE - NY,23318,-1151.27,1400,-1600
05/13/2016 13:15,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:15,SCH - OH - NY,23317,507.18,1100,-1900
05/13/2016 13:15,SCH - PJ - NY,23316,-257.18,2300,-800
05/13/2016 13:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:15,SCH - PJM_VFT,325658,105,315,-315
05/13/2016 13:15,SPR/DUN-SOUTH,23320,892.7,4350,-9999
05/13/2016 13:15,TOTAL EAST,23314,2726.38,6500,-9999
05/13/2016 13:15,UPNY CONED,23315,926.46,4850,-9999
05/13/2016 13:15,WEST CENTRAL,23312,-24.08,9999,-9999
05/13/2016 13:20,CENTRAL EAST - VC,23330,2414.46,2525,-9999
05/13/2016 13:20,DYSINGER EAST,23326,468.88,3150,-9999
05/13/2016 13:20,MOSES SOUTH,23319,1569.96,2850,-1600
05/13/2016 13:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:20,SCH - NE - NY,23318,-1237.34,1400,-1600
05/13/2016 13:20,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:20,SCH - OH - NY,23317,507.21,1100,-1900
05/13/2016 13:20,SCH - PJ - NY,23316,-260.48,2300,-800
05/13/2016 13:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:20,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:20,SPR/DUN-SOUTH,23320,806.4,4350,-9999
05/13/2016 13:20,TOTAL EAST,23314,2699.93,6500,-9999
05/13/2016 13:20,UPNY CONED,23315,840.4,4850,-9999
05/13/2016 13:20,WEST CENTRAL,23312,-48,9999,-9999
05/13/2016 13:25,CENTRAL EAST - VC,23330,2413.35,2525,-9999
05/13/2016 13:25,DYSINGER EAST,23326,295.24,3150,-9999
05/13/2016 13:25,MOSES SOUTH,23319,1570.13,2850,-1600
05/13/2016 13:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:25,SCH - NE - NY,23318,-1237.11,1400,-1600
05/13/2016 13:25,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:25,SCH - OH - NY,23317,507.15,1100,-1900
05/13/2016 13:25,SCH - PJ - NY,23316,-257.8,2300,-800
05/13/2016 13:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:25,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:25,SPR/DUN-SOUTH,23320,877.8,4350,-9999
05/13/2016 13:25,TOTAL EAST,23314,2559.51,6500,-9999
05/13/2016 13:25,UPNY CONED,23315,924.69,4850,-9999
05/13/2016 13:25,WEST CENTRAL,23312,-223.66,9999,-9999
05/13/2016 13:28,CENTRAL EAST - VC,23330,2347.54,2465,-9999
05/13/2016 13:28,DYSINGER EAST,23326,397.08,3150,-9999
05/13/2016 13:28,MOSES SOUTH,23319,1521.48,2850,-1600
05/13/2016 13:28,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:28,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:28,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:28,SCH - NE - NY,23318,-1262.47,1400,-1600
05/13/2016 13:28,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:28,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:28,SCH - OH - NY,23317,507.76,1100,-1900
05/13/2016 13:28,SCH - PJ - NY,23316,-252.98,2300,-800
05/13/2016 13:28,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:28,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:28,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:28,SPR/DUN-SOUTH,23320,819.52,4350,-9999
05/13/2016 13:28,TOTAL EAST,23314,2360.63,6500,-9999
05/13/2016 13:28,UPNY CONED,23315,847.55,4850,-9999
05/13/2016 13:28,WEST CENTRAL,23312,-126.16,9999,-9999
05/13/2016 13:29,CENTRAL EAST - VC,23330,2349.24,2465,-9999
05/13/2016 13:29,DYSINGER EAST,23326,462.31,3150,-9999
05/13/2016 13:29,MOSES SOUTH,23319,1517.55,2850,-1600
05/13/2016 13:29,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:29,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:29,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:29,SCH - NE - NY,23318,-1271.6,1400,-1600
05/13/2016 13:29,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:29,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:29,SCH - OH - NY,23317,507.9,1100,-1900
05/13/2016 13:29,SCH - PJ - NY,23316,-253.96,2300,-800
05/13/2016 13:29,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:29,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:29,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:29,SPR/DUN-SOUTH,23320,817.15,4350,-9999
05/13/2016 13:29,TOTAL EAST,23314,2398.27,6500,-9999
05/13/2016 13:29,UPNY CONED,23315,844.33,4850,-9999
05/13/2016 13:29,WEST CENTRAL,23312,-61.24,9999,-9999
05/13/2016 13:40,CENTRAL EAST - VC,23330,2365.93,2465,-9999
05/13/2016 13:40,DYSINGER EAST,23326,413.06,3150,-9999
05/13/2016 13:40,MOSES SOUTH,23319,1496.2,2850,-1600
05/13/2016 13:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:40,SCH - NE - NY,23318,-1322.87,1400,-1600
05/13/2016 13:40,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:40,SCH - OH - NY,23317,508.25,1100,-1900
05/13/2016 13:40,SCH - PJ - NY,23316,-247.57,2300,-800
05/13/2016 13:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:40,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:40,SPR/DUN-SOUTH,23320,783.38,4350,-9999
05/13/2016 13:40,TOTAL EAST,23314,2432.98,6500,-9999
05/13/2016 13:40,UPNY CONED,23315,812.57,4850,-9999
05/13/2016 13:40,WEST CENTRAL,23312,-108.97,9999,-9999
05/13/2016 13:45,CENTRAL EAST - VC,23330,2346.02,2465,-9999
05/13/2016 13:45,DYSINGER EAST,23326,400.92,3150,-9999
05/13/2016 13:45,MOSES SOUTH,23319,1471.65,2850,-1600
05/13/2016 13:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:45,SCH - NE - NY,23318,-1284.08,1400,-1600
05/13/2016 13:45,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:45,SCH - OH - NY,23317,508.31,1100,-1900
05/13/2016 13:45,SCH - PJ - NY,23316,-214.21,2300,-800
05/13/2016 13:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:45,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:45,SPR/DUN-SOUTH,23320,713.02,4350,-9999
05/13/2016 13:45,TOTAL EAST,23314,2439.66,6500,-9999
05/13/2016 13:45,UPNY CONED,23315,736.5,4850,-9999
05/13/2016 13:45,WEST CENTRAL,23312,-119.22,9999,-9999
05/13/2016 13:50,CENTRAL EAST - VC,23330,2349.18,2465,-9999
05/13/2016 13:50,DYSINGER EAST,23326,414.62,3150,-9999
05/13/2016 13:50,MOSES SOUTH,23319,1452.41,2850,-1600
05/13/2016 13:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:50,SCH - NE - NY,23318,-1246.34,1400,-1600
05/13/2016 13:50,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:50,SCH - OH - NY,23317,508.39,1100,-1900
05/13/2016 13:50,SCH - PJ - NY,23316,-187.71,2300,-800
05/13/2016 13:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:50,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:50,SPR/DUN-SOUTH,23320,657.78,4350,-9999
05/13/2016 13:50,TOTAL EAST,23314,2438.21,6500,-9999
05/13/2016 13:50,UPNY CONED,23315,680.76,4850,-9999
05/13/2016 13:50,WEST CENTRAL,23312,-105.45,9999,-9999
05/13/2016 13:55,CENTRAL EAST - VC,23330,2361.37,2465,-9999
05/13/2016 13:55,DYSINGER EAST,23326,418.21,3150,-9999
05/13/2016 13:55,MOSES SOUTH,23319,1444.38,2850,-1600
05/13/2016 13:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 13:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 13:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 13:55,SCH - NE - NY,23318,-1246.42,1400,-1600
05/13/2016 13:55,SCH - NPX_1385,325277,50,200,-200
05/13/2016 13:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 13:55,SCH - OH - NY,23317,508.44,1100,-1900
05/13/2016 13:55,SCH - PJ - NY,23316,-185.53,2300,-800
05/13/2016 13:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 13:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 13:55,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 13:55,SPR/DUN-SOUTH,23320,672.05,4350,-9999
05/13/2016 13:55,TOTAL EAST,23314,2421.48,6500,-9999
05/13/2016 13:55,UPNY CONED,23315,689.5,4850,-9999
05/13/2016 13:55,WEST CENTRAL,23312,-103.81,9999,-9999
05/13/2016 14:00,CENTRAL EAST - VC,23330,2358.45,2465,-9999
05/13/2016 14:00,DYSINGER EAST,23326,442.38,3150,-9999
05/13/2016 14:00,MOSES SOUTH,23319,1435.63,2850,-1600
05/13/2016 14:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:00,SCH - NE - NY,23318,-1245.77,1400,-1600
05/13/2016 14:00,SCH - NPX_1385,325277,82,200,-200
05/13/2016 14:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:00,SCH - OH - NY,23317,531.72,1100,-1900
05/13/2016 14:00,SCH - PJ - NY,23316,-188.53,2300,-800
05/13/2016 14:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:00,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:00,SPR/DUN-SOUTH,23320,697.46,4350,-9999
05/13/2016 14:00,TOTAL EAST,23314,2389.14,6500,-9999
05/13/2016 14:00,UPNY CONED,23315,637.98,4850,-9999
05/13/2016 14:00,WEST CENTRAL,23312,-80.67,9999,-9999
05/13/2016 14:05,CENTRAL EAST - VC,23330,2354.83,2465,-9999
05/13/2016 14:05,DYSINGER EAST,23326,472.24,3150,-9999
05/13/2016 14:05,MOSES SOUTH,23319,1423.39,2850,-1600
05/13/2016 14:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:05,SCH - NE - NY,23318,-1245.78,1400,-1600
05/13/2016 14:05,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:05,SCH - OH - NY,23317,555.96,1100,-1900
05/13/2016 14:05,SCH - PJ - NY,23316,-190.72,2300,-800
05/13/2016 14:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:05,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:05,SPR/DUN-SOUTH,23320,694.1,4350,-9999
05/13/2016 14:05,TOTAL EAST,23314,2399.59,6500,-9999
05/13/2016 14:05,UPNY CONED,23315,601.2,4850,-9999
05/13/2016 14:05,WEST CENTRAL,23312,-49.91,9999,-9999
05/13/2016 14:10,CENTRAL EAST - VC,23330,2355.35,2465,-9999
05/13/2016 14:10,DYSINGER EAST,23326,465.59,3150,-9999
05/13/2016 14:10,MOSES SOUTH,23319,1432.09,2850,-1600
05/13/2016 14:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:10,SCH - NE - NY,23318,-1246.02,1400,-1600
05/13/2016 14:10,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:10,SCH - OH - NY,23317,556.16,1100,-1900
05/13/2016 14:10,SCH - PJ - NY,23316,-189.98,2300,-800
05/13/2016 14:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:10,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:10,SPR/DUN-SOUTH,23320,718.29,4350,-9999
05/13/2016 14:10,TOTAL EAST,23314,2356.13,6500,-9999
05/13/2016 14:10,UPNY CONED,23315,630.12,4850,-9999
05/13/2016 14:10,WEST CENTRAL,23312,-54.97,9999,-9999
05/13/2016 14:15,CENTRAL EAST - VC,23330,2358.18,2465,-9999
05/13/2016 14:15,DYSINGER EAST,23326,495.09,3150,-9999
05/13/2016 14:15,MOSES SOUTH,23319,1428.13,2850,-1600
05/13/2016 14:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:15,SCH - NE - NY,23318,-1255.2,1400,-1600
05/13/2016 14:15,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:15,SCH - OH - NY,23317,555.99,1100,-1900
05/13/2016 14:15,SCH - PJ - NY,23316,-189.21,2300,-800
05/13/2016 14:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:15,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:15,SPR/DUN-SOUTH,23320,728.1,4350,-9999
05/13/2016 14:15,TOTAL EAST,23314,2427.5,6500,-9999
05/13/2016 14:15,UPNY CONED,23315,652.04,4850,-9999
05/13/2016 14:15,WEST CENTRAL,23312,-27.53,9999,-9999
05/13/2016 14:20,CENTRAL EAST - VC,23330,2358.31,2465,-9999
05/13/2016 14:20,DYSINGER EAST,23326,575.45,3150,-9999
05/13/2016 14:20,MOSES SOUTH,23319,1422.45,2850,-1600
05/13/2016 14:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:20,SCH - NE - NY,23318,-1265.31,1400,-1600
05/13/2016 14:20,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:20,SCH - OH - NY,23317,556.29,1100,-1900
05/13/2016 14:20,SCH - PJ - NY,23316,-188.32,2300,-800
05/13/2016 14:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:20,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:20,SPR/DUN-SOUTH,23320,734.74,4350,-9999
05/13/2016 14:20,TOTAL EAST,23314,2467.59,6500,-9999
05/13/2016 14:20,UPNY CONED,23315,658.32,4850,-9999
05/13/2016 14:20,WEST CENTRAL,23312,54.49,9999,-9999
05/13/2016 14:25,CENTRAL EAST - VC,23330,2351.74,2465,-9999
05/13/2016 14:25,DYSINGER EAST,23326,469.31,3150,-9999
05/13/2016 14:25,MOSES SOUTH,23319,1421.07,2850,-1600
05/13/2016 14:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:25,SCH - NE - NY,23318,-1265.2,1400,-1600
05/13/2016 14:25,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:25,SCH - OH - NY,23317,556.02,1100,-1900
05/13/2016 14:25,SCH - PJ - NY,23316,-188.5,2300,-800
05/13/2016 14:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:25,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:25,SPR/DUN-SOUTH,23320,736.52,4350,-9999
05/13/2016 14:25,TOTAL EAST,23314,2462.42,6500,-9999
05/13/2016 14:25,UPNY CONED,23315,652.19,4850,-9999
05/13/2016 14:25,WEST CENTRAL,23312,-51.4,9999,-9999
05/13/2016 14:30,CENTRAL EAST - VC,23330,2352.54,2465,-9999
05/13/2016 14:30,DYSINGER EAST,23326,375.22,3150,-9999
05/13/2016 14:30,MOSES SOUTH,23319,1436.09,2850,-1600
05/13/2016 14:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:30,SCH - NE - NY,23318,-1290.69,1400,-1600
05/13/2016 14:30,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:30,SCH - OH - NY,23317,555.93,1100,-1900
05/13/2016 14:30,SCH - PJ - NY,23316,-189.24,2300,-800
05/13/2016 14:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:30,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:30,SPR/DUN-SOUTH,23320,734.63,4350,-9999
05/13/2016 14:30,TOTAL EAST,23314,2405.73,6500,-9999
05/13/2016 14:30,UPNY CONED,23315,603.63,4850,-9999
05/13/2016 14:30,WEST CENTRAL,23312,-143.45,9999,-9999
05/13/2016 14:35,CENTRAL EAST - VC,23330,2355.38,2465,-9999
05/13/2016 14:35,DYSINGER EAST,23326,343.49,3150,-9999
05/13/2016 14:35,MOSES SOUTH,23319,1436.98,2850,-1600
05/13/2016 14:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:35,SCH - NE - NY,23318,-1316.86,1400,-1600
05/13/2016 14:35,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:35,SCH - OH - NY,23317,555.74,1100,-1900
05/13/2016 14:35,SCH - PJ - NY,23316,-188.12,2300,-800
05/13/2016 14:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:35,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:35,SPR/DUN-SOUTH,23320,726.48,4350,-9999
05/13/2016 14:35,TOTAL EAST,23314,2406,6500,-9999
05/13/2016 14:35,UPNY CONED,23315,583.88,4850,-9999
05/13/2016 14:35,WEST CENTRAL,23312,-173.04,9999,-9999
05/13/2016 14:40,CENTRAL EAST - VC,23330,2355.15,2465,-9999
05/13/2016 14:40,DYSINGER EAST,23326,312.73,3150,-9999
05/13/2016 14:40,MOSES SOUTH,23319,1416.13,2850,-1600
05/13/2016 14:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:40,SCH - NE - NY,23318,-1317.12,1400,-1600
05/13/2016 14:40,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:40,SCH - OH - NY,23317,555.45,1100,-1900
05/13/2016 14:40,SCH - PJ - NY,23316,-188.24,2300,-800
05/13/2016 14:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:40,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:40,SPR/DUN-SOUTH,23320,756.38,4350,-9999
05/13/2016 14:40,TOTAL EAST,23314,2451.74,6500,-9999
05/13/2016 14:40,UPNY CONED,23315,599.83,4850,-9999
05/13/2016 14:40,WEST CENTRAL,23312,-202.61,9999,-9999
05/13/2016 14:45,CENTRAL EAST - VC,23330,2356.76,2465,-9999
05/13/2016 14:45,DYSINGER EAST,23326,279.72,3150,-9999
05/13/2016 14:45,MOSES SOUTH,23319,1436.91,2850,-1600
05/13/2016 14:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:45,SCH - NE - NY,23318,-1347.29,1400,-1600
05/13/2016 14:45,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:45,SCH - OH - NY,23317,555.86,1100,-1900
05/13/2016 14:45,SCH - PJ - NY,23316,-189.38,2300,-800
05/13/2016 14:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:45,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:45,SPR/DUN-SOUTH,23320,768.14,4350,-9999
05/13/2016 14:45,TOTAL EAST,23314,2379.72,6500,-9999
05/13/2016 14:45,UPNY CONED,23315,631.55,4850,-9999
05/13/2016 14:45,WEST CENTRAL,23312,-240.9,9999,-9999
05/13/2016 14:50,CENTRAL EAST - VC,23330,2359.07,2465,-9999
05/13/2016 14:50,DYSINGER EAST,23326,297.96,3150,-9999
05/13/2016 14:50,MOSES SOUTH,23319,1328.42,2850,-1600
05/13/2016 14:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:50,SCH - NE - NY,23318,-1377.04,1400,-1600
05/13/2016 14:50,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:50,SCH - OH - NY,23317,555.6,1100,-1900
05/13/2016 14:50,SCH - PJ - NY,23316,-187.83,2300,-800
05/13/2016 14:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:50,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:50,SPR/DUN-SOUTH,23320,763.68,4350,-9999
05/13/2016 14:50,TOTAL EAST,23314,2368.04,6500,-9999
05/13/2016 14:50,UPNY CONED,23315,621.99,4850,-9999
05/13/2016 14:50,WEST CENTRAL,23312,-220.22,9999,-9999
05/13/2016 14:55,CENTRAL EAST - VC,23330,2359.82,2465,-9999
05/13/2016 14:55,DYSINGER EAST,23326,313.63,3150,-9999
05/13/2016 14:55,MOSES SOUTH,23319,1403.5,2850,-1600
05/13/2016 14:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 14:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 14:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 14:55,SCH - NE - NY,23318,-1377.03,1400,-1600
05/13/2016 14:55,SCH - NPX_1385,325277,114,200,-200
05/13/2016 14:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 14:55,SCH - OH - NY,23317,556.41,1100,-1900
05/13/2016 14:55,SCH - PJ - NY,23316,-188.65,2300,-800
05/13/2016 14:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 14:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 14:55,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 14:55,SPR/DUN-SOUTH,23320,756.83,4350,-9999
05/13/2016 14:55,TOTAL EAST,23314,2321.75,6500,-9999
05/13/2016 14:55,UPNY CONED,23315,574.23,4850,-9999
05/13/2016 14:55,WEST CENTRAL,23312,-202.93,9999,-9999
05/13/2016 15:00,CENTRAL EAST - VC,23330,2354.08,2465,-9999
05/13/2016 15:00,DYSINGER EAST,23326,233.78,3150,-9999
05/13/2016 15:00,MOSES SOUTH,23319,1481.96,2850,-1600
05/13/2016 15:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:00,SCH - NE - NY,23318,-1277.36,1400,-1600
05/13/2016 15:00,SCH - NPX_1385,325277,69,200,-200
05/13/2016 15:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:00,SCH - OH - NY,23317,556.65,1100,-1900
05/13/2016 15:00,SCH - PJ - NY,23316,-175.69,2300,-800
05/13/2016 15:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:00,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:00,SPR/DUN-SOUTH,23320,803.07,4350,-9999
05/13/2016 15:00,TOTAL EAST,23314,2289.21,6500,-9999
05/13/2016 15:00,UPNY CONED,23315,638.83,4850,-9999
05/13/2016 15:00,WEST CENTRAL,23312,-280.64,9999,-9999
05/13/2016 15:05,CENTRAL EAST - VC,23330,2353.89,2465,-9999
05/13/2016 15:05,DYSINGER EAST,23326,285.82,3150,-9999
05/13/2016 15:05,MOSES SOUTH,23319,1464.71,2850,-1600
05/13/2016 15:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:05,SCH - NE - NY,23318,-1178.09,1400,-1600
05/13/2016 15:05,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:05,SCH - OH - NY,23317,556.78,1100,-1900
05/13/2016 15:05,SCH - PJ - NY,23316,-158.75,2300,-800
05/13/2016 15:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:05,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:05,SPR/DUN-SOUTH,23320,786.4,4350,-9999
05/13/2016 15:05,TOTAL EAST,23314,2313.86,6500,-9999
05/13/2016 15:05,UPNY CONED,23315,707.04,4850,-9999
05/13/2016 15:05,WEST CENTRAL,23312,-225.17,9999,-9999
05/13/2016 15:10,CENTRAL EAST - VC,23330,2365.16,2465,-9999
05/13/2016 15:10,DYSINGER EAST,23326,464.23,3150,-9999
05/13/2016 15:10,MOSES SOUTH,23319,1431.16,2850,-1600
05/13/2016 15:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:10,SCH - NE - NY,23318,-1177.94,1400,-1600
05/13/2016 15:10,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:10,SCH - OH - NY,23317,557.35,1100,-1900
05/13/2016 15:10,SCH - PJ - NY,23316,-162.01,2300,-800
05/13/2016 15:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:10,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:10,SPR/DUN-SOUTH,23320,765.73,4350,-9999
05/13/2016 15:10,TOTAL EAST,23314,2335.69,6500,-9999
05/13/2016 15:10,UPNY CONED,23315,688.15,4850,-9999
05/13/2016 15:10,WEST CENTRAL,23312,-41.58,9999,-9999
05/13/2016 15:15,CENTRAL EAST - VC,23330,2357.59,2465,-9999
05/13/2016 15:15,DYSINGER EAST,23326,383.12,3150,-9999
05/13/2016 15:15,MOSES SOUTH,23319,1434.25,2850,-1600
05/13/2016 15:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:15,SCH - NE - NY,23318,-1140.95,1400,-1600
05/13/2016 15:15,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:15,SCH - OH - NY,23317,556.96,1100,-1900
05/13/2016 15:15,SCH - PJ - NY,23316,-158,2300,-800
05/13/2016 15:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:15,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:15,SPR/DUN-SOUTH,23320,798.42,4350,-9999
05/13/2016 15:15,TOTAL EAST,23314,2317.86,6500,-9999
05/13/2016 15:15,UPNY CONED,23315,722,4850,-9999
05/13/2016 15:15,WEST CENTRAL,23312,-121.79,9999,-9999
05/13/2016 15:20,CENTRAL EAST - VC,23330,2358.61,2465,-9999
05/13/2016 15:20,DYSINGER EAST,23326,353.16,3150,-9999
05/13/2016 15:20,MOSES SOUTH,23319,1441.09,2850,-1600
05/13/2016 15:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:20,SCH - NE - NY,23318,-1104.15,1400,-1600
05/13/2016 15:20,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:20,SCH - OH - NY,23317,557.42,1100,-1900
05/13/2016 15:20,SCH - PJ - NY,23316,-158.75,2300,-800
05/13/2016 15:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:20,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:20,SPR/DUN-SOUTH,23320,850.43,4350,-9999
05/13/2016 15:20,TOTAL EAST,23314,2231.35,6500,-9999
05/13/2016 15:20,UPNY CONED,23315,748.85,4850,-9999
05/13/2016 15:20,WEST CENTRAL,23312,-151.84,9999,-9999
05/13/2016 15:25,CENTRAL EAST - VC,23330,2359.63,2465,-9999
05/13/2016 15:25,DYSINGER EAST,23326,324.39,3150,-9999
05/13/2016 15:25,MOSES SOUTH,23319,1423.48,2850,-1600
05/13/2016 15:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:25,SCH - NE - NY,23318,-1103.99,1400,-1600
05/13/2016 15:25,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:25,SCH - OH - NY,23317,556.98,1100,-1900
05/13/2016 15:25,SCH - PJ - NY,23316,-160.18,2300,-800
05/13/2016 15:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:25,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:25,SPR/DUN-SOUTH,23320,866.57,4350,-9999
05/13/2016 15:25,TOTAL EAST,23314,2274.46,6500,-9999
05/13/2016 15:25,UPNY CONED,23315,757.2,4850,-9999
05/13/2016 15:25,WEST CENTRAL,23312,-176.49,9999,-9999
05/13/2016 15:30,CENTRAL EAST - VC,23330,2347.69,2465,-9999
05/13/2016 15:30,DYSINGER EAST,23326,273.66,3150,-9999
05/13/2016 15:30,MOSES SOUTH,23319,1431.02,2850,-1600
05/13/2016 15:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:30,SCH - NE - NY,23318,-1133.78,1400,-1600
05/13/2016 15:30,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:30,SCH - OH - NY,23317,556.91,1100,-1900
05/13/2016 15:30,SCH - PJ - NY,23316,-126.41,2300,-800
05/13/2016 15:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:30,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:30,SPR/DUN-SOUTH,23320,860.65,4350,-9999
05/13/2016 15:30,TOTAL EAST,23314,2298.42,6500,-9999
05/13/2016 15:30,UPNY CONED,23315,753.26,4850,-9999
05/13/2016 15:30,WEST CENTRAL,23312,-222.51,9999,-9999
05/13/2016 15:35,CENTRAL EAST - VC,23330,2346.87,2465,-9999
05/13/2016 15:35,DYSINGER EAST,23326,265.98,3150,-9999
05/13/2016 15:35,MOSES SOUTH,23319,1409.37,2850,-1600
05/13/2016 15:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:35,SCH - NE - NY,23318,-1163.66,1400,-1600
05/13/2016 15:35,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:35,SCH - OH - NY,23317,556.8,1100,-1900
05/13/2016 15:35,SCH - PJ - NY,23316,-94.37,2300,-800
05/13/2016 15:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:35,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:35,SPR/DUN-SOUTH,23320,840.59,4350,-9999
05/13/2016 15:35,TOTAL EAST,23314,2350.23,6500,-9999
05/13/2016 15:35,UPNY CONED,23315,734.7,4850,-9999
05/13/2016 15:35,WEST CENTRAL,23312,-227.08,9999,-9999
05/13/2016 15:40,CENTRAL EAST - VC,23330,2361.64,2465,-9999
05/13/2016 15:40,DYSINGER EAST,23326,231.5,3150,-9999
05/13/2016 15:40,MOSES SOUTH,23319,1408.03,2850,-1600
05/13/2016 15:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:40,SCH - NE - NY,23318,-1163.47,1400,-1600
05/13/2016 15:40,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:40,SCH - OH - NY,23317,556.97,1100,-1900
05/13/2016 15:40,SCH - PJ - NY,23316,-97.1,2300,-800
05/13/2016 15:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:40,SCH - PJM_VFT,325658,142,315,-315
05/13/2016 15:40,SPR/DUN-SOUTH,23320,887.21,4350,-9999
05/13/2016 15:40,TOTAL EAST,23314,2301.77,6500,-9999
05/13/2016 15:40,UPNY CONED,23315,782.66,4850,-9999
05/13/2016 15:40,WEST CENTRAL,23312,-261.72,9999,-9999
05/13/2016 15:45,CENTRAL EAST - VC,23330,2358.88,2465,-9999
05/13/2016 15:45,DYSINGER EAST,23326,202.11,3150,-9999
05/13/2016 15:45,MOSES SOUTH,23319,1430.45,2850,-1600
05/13/2016 15:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:45,SCH - NE - NY,23318,-1178.42,1400,-1600
05/13/2016 15:45,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:45,SCH - OH - NY,23317,557.11,1100,-1900
05/13/2016 15:45,SCH - PJ - NY,23316,-82.23,2300,-800
05/13/2016 15:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:45,SCH - PJM_VFT,325658,132,315,-315
05/13/2016 15:45,SPR/DUN-SOUTH,23320,871.41,4350,-9999
05/13/2016 15:45,TOTAL EAST,23314,2282.19,6500,-9999
05/13/2016 15:45,UPNY CONED,23315,766.6,4850,-9999
05/13/2016 15:45,WEST CENTRAL,23312,-287.49,9999,-9999
05/13/2016 15:50,CENTRAL EAST - VC,23330,2360.41,2465,-9999
05/13/2016 15:50,DYSINGER EAST,23326,223.73,3150,-9999
05/13/2016 15:50,MOSES SOUTH,23319,1403.39,2850,-1600
05/13/2016 15:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:50,SCH - NE - NY,23318,-1193.39,1400,-1600
05/13/2016 15:50,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:50,SCH - OH - NY,23317,557.07,1100,-1900
05/13/2016 15:50,SCH - PJ - NY,23316,-71.09,2300,-800
05/13/2016 15:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:50,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 15:50,SPR/DUN-SOUTH,23320,880.66,4350,-9999
05/13/2016 15:50,TOTAL EAST,23314,2323.29,6500,-9999
05/13/2016 15:50,UPNY CONED,23315,773.78,4850,-9999
05/13/2016 15:50,WEST CENTRAL,23312,-260.68,9999,-9999
05/13/2016 15:55,CENTRAL EAST - VC,23330,2365.09,2465,-9999
05/13/2016 15:55,DYSINGER EAST,23326,307.11,3150,-9999
05/13/2016 15:55,MOSES SOUTH,23319,1394.65,2850,-1600
05/13/2016 15:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 15:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 15:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 15:55,SCH - NE - NY,23318,-1193.84,1400,-1600
05/13/2016 15:55,SCH - NPX_1385,325277,25,200,-200
05/13/2016 15:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 15:55,SCH - OH - NY,23317,557.24,1100,-1900
05/13/2016 15:55,SCH - PJ - NY,23316,-70.79,2300,-800
05/13/2016 15:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 15:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 15:55,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 15:55,SPR/DUN-SOUTH,23320,867.9,4350,-9999
05/13/2016 15:55,TOTAL EAST,23314,2368.32,6500,-9999
05/13/2016 15:55,UPNY CONED,23315,774.34,4850,-9999
05/13/2016 15:55,WEST CENTRAL,23312,-175.81,9999,-9999
05/13/2016 16:00,CENTRAL EAST - VC,23330,2351.38,2465,-9999
05/13/2016 16:00,DYSINGER EAST,23326,286.68,3150,-9999
05/13/2016 16:00,MOSES SOUTH,23319,1377.29,2850,-1600
05/13/2016 16:00,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:00,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:00,SCH - NE - NY,23318,-1276.61,1400,-1600
05/13/2016 16:00,SCH - NPX_1385,325277,30,200,-200
05/13/2016 16:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:00,SCH - OH - NY,23317,558.04,1100,-1900
05/13/2016 16:00,SCH - PJ - NY,23316,-62.11,2300,-800
05/13/2016 16:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:00,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:00,SPR/DUN-SOUTH,23320,735.42,4350,-9999
05/13/2016 16:00,TOTAL EAST,23314,2417.37,6500,-9999
05/13/2016 16:00,UPNY CONED,23315,629.87,4850,-9999
05/13/2016 16:00,WEST CENTRAL,23312,-194.4,9999,-9999
05/13/2016 16:05,CENTRAL EAST - VC,23330,2350.59,2465,-9999
05/13/2016 16:05,DYSINGER EAST,23326,116.31,3150,-9999
05/13/2016 16:05,MOSES SOUTH,23319,1383.76,2850,-1600
05/13/2016 16:05,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:05,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:05,SCH - NE - NY,23318,-1359.83,1400,-1600
05/13/2016 16:05,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:05,SCH - OH - NY,23317,559.75,1100,-1900
05/13/2016 16:05,SCH - PJ - NY,23316,-54.45,2300,-800
05/13/2016 16:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:05,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:05,SPR/DUN-SOUTH,23320,752.89,4350,-9999
05/13/2016 16:05,TOTAL EAST,23314,2331.61,6500,-9999
05/13/2016 16:05,UPNY CONED,23315,664.83,4850,-9999
05/13/2016 16:05,WEST CENTRAL,23312,-363.74,9999,-9999
05/13/2016 16:10,CENTRAL EAST - VC,23330,2364.27,2465,-9999
05/13/2016 16:10,DYSINGER EAST,23326,250.08,3150,-9999
05/13/2016 16:10,MOSES SOUTH,23319,1379.88,2850,-1600
05/13/2016 16:10,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:10,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:10,SCH - NE - NY,23318,-1359.8,1400,-1600
05/13/2016 16:10,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:10,SCH - OH - NY,23317,560.24,1100,-1900
05/13/2016 16:10,SCH - PJ - NY,23316,-52.15,2300,-800
05/13/2016 16:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:10,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:10,SPR/DUN-SOUTH,23320,762.1,4350,-9999
05/13/2016 16:10,TOTAL EAST,23314,2347.39,6500,-9999
05/13/2016 16:10,UPNY CONED,23315,686.96,4850,-9999
05/13/2016 16:10,WEST CENTRAL,23312,-228.1,9999,-9999
05/13/2016 16:15,CENTRAL EAST - VC,23330,2363.72,2465,-9999
05/13/2016 16:15,DYSINGER EAST,23326,285.71,3150,-9999
05/13/2016 16:15,MOSES SOUTH,23319,1355.12,2850,-1600
05/13/2016 16:15,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:15,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:15,SCH - NE - NY,23318,-1377.8,1400,-1600
05/13/2016 16:15,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:15,SCH - OH - NY,23317,560.29,1100,-1900
05/13/2016 16:15,SCH - PJ - NY,23316,-81.83,2300,-800
05/13/2016 16:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:15,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:15,SPR/DUN-SOUTH,23320,769.83,4350,-9999
05/13/2016 16:15,TOTAL EAST,23314,2331.4,6500,-9999
05/13/2016 16:15,UPNY CONED,23315,720.63,4850,-9999
05/13/2016 16:15,WEST CENTRAL,23312,-191.76,9999,-9999
05/13/2016 16:20,CENTRAL EAST - VC,23330,2364.25,2465,-9999
05/13/2016 16:20,DYSINGER EAST,23326,250.54,3150,-9999
05/13/2016 16:20,MOSES SOUTH,23319,1386.65,2850,-1600
05/13/2016 16:20,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:20,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:20,SCH - NE - NY,23318,-1396.87,1400,-1600
05/13/2016 16:20,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:20,SCH - OH - NY,23317,560.47,1100,-1900
05/13/2016 16:20,SCH - PJ - NY,23316,-116.91,2300,-800
05/13/2016 16:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:20,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:20,SPR/DUN-SOUTH,23320,758.75,4350,-9999
05/13/2016 16:20,TOTAL EAST,23314,2266.29,6500,-9999
05/13/2016 16:20,UPNY CONED,23315,706.68,4850,-9999
05/13/2016 16:20,WEST CENTRAL,23312,-227.48,9999,-9999
05/13/2016 16:25,CENTRAL EAST - VC,23330,2362.2,2465,-9999
05/13/2016 16:25,DYSINGER EAST,23326,289.73,3150,-9999
05/13/2016 16:25,MOSES SOUTH,23319,1375.42,2850,-1600
05/13/2016 16:25,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:25,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:25,SCH - NE - NY,23318,-1396.93,1400,-1600
05/13/2016 16:25,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:25,SCH - OH - NY,23317,560.35,1100,-1900
05/13/2016 16:25,SCH - PJ - NY,23316,-116.98,2300,-800
05/13/2016 16:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:25,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:25,SPR/DUN-SOUTH,23320,745.14,4350,-9999
05/13/2016 16:25,TOTAL EAST,23314,2337.85,6500,-9999
05/13/2016 16:25,UPNY CONED,23315,708.31,4850,-9999
05/13/2016 16:25,WEST CENTRAL,23312,-183.95,9999,-9999
05/13/2016 16:30,CENTRAL EAST - VC,23330,2358.45,2465,-9999
05/13/2016 16:30,DYSINGER EAST,23326,181.51,3150,-9999
05/13/2016 16:30,MOSES SOUTH,23319,1387.81,2850,-1600
05/13/2016 16:30,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:30,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:30,SCH - NE - NY,23318,-1396.68,1400,-1600
05/13/2016 16:30,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:30,SCH - OH - NY,23317,560.18,1100,-1900
05/13/2016 16:30,SCH - PJ - NY,23316,-101.44,2300,-800
05/13/2016 16:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:30,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:30,SPR/DUN-SOUTH,23320,788.86,4350,-9999
05/13/2016 16:30,TOTAL EAST,23314,2258.09,6500,-9999
05/13/2016 16:30,UPNY CONED,23315,771.18,4850,-9999
05/13/2016 16:30,WEST CENTRAL,23312,-292.97,9999,-9999
05/13/2016 16:35,CENTRAL EAST - VC,23330,2373.35,2490,-9999
05/13/2016 16:35,DYSINGER EAST,23326,143.38,3150,-9999
05/13/2016 16:35,MOSES SOUTH,23319,1372.48,2850,-1600
05/13/2016 16:35,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:35,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:35,SCH - NE - NY,23318,-1396.82,1400,-1600
05/13/2016 16:35,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:35,SCH - OH - NY,23317,558.87,1100,-1900
05/13/2016 16:35,SCH - PJ - NY,23316,-82.9,2300,-800
05/13/2016 16:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:35,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:35,SPR/DUN-SOUTH,23320,738.38,4350,-9999
05/13/2016 16:35,TOTAL EAST,23314,2492.13,6500,-9999
05/13/2016 16:35,UPNY CONED,23315,723.74,4850,-9999
05/13/2016 16:35,WEST CENTRAL,23312,-329.97,9999,-9999
05/13/2016 16:40,CENTRAL EAST - VC,23330,2386.44,2490,-9999
05/13/2016 16:40,DYSINGER EAST,23326,246.15,3150,-9999
05/13/2016 16:40,MOSES SOUTH,23319,1316.19,2850,-1600
05/13/2016 16:40,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:40,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:40,SCH - NE - NY,23318,-1396.93,1400,-1600
05/13/2016 16:40,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:40,SCH - OH - NY,23317,558.94,1100,-1900
05/13/2016 16:40,SCH - PJ - NY,23316,-82.28,2300,-800
05/13/2016 16:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:40,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:40,SPR/DUN-SOUTH,23320,738.88,4350,-9999
05/13/2016 16:40,TOTAL EAST,23314,2514.02,6500,-9999
05/13/2016 16:40,UPNY CONED,23315,727.56,4850,-9999
05/13/2016 16:40,WEST CENTRAL,23312,-224.9,9999,-9999
05/13/2016 16:45,CENTRAL EAST - VC,23330,2378.34,2490,-9999
05/13/2016 16:45,DYSINGER EAST,23326,291.67,3150,-9999
05/13/2016 16:45,MOSES SOUTH,23319,1303.36,2850,-1600
05/13/2016 16:45,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:45,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:45,SCH - NE - NY,23318,-1396.86,1400,-1600
05/13/2016 16:45,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:45,SCH - OH - NY,23317,558.98,1100,-1900
05/13/2016 16:45,SCH - PJ - NY,23316,-66.06,2300,-800
05/13/2016 16:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:45,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:45,SPR/DUN-SOUTH,23320,717.18,4350,-9999
05/13/2016 16:45,TOTAL EAST,23314,2559.99,6500,-9999
05/13/2016 16:45,UPNY CONED,23315,708.58,4850,-9999
05/13/2016 16:45,WEST CENTRAL,23312,-175.22,9999,-9999
05/13/2016 16:50,CENTRAL EAST - VC,23330,2380.72,2490,-9999
05/13/2016 16:50,DYSINGER EAST,23326,223.5,3150,-9999
05/13/2016 16:50,MOSES SOUTH,23319,1290.33,2850,-1600
05/13/2016 16:50,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:50,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:50,SCH - NE - NY,23318,-1396.74,1400,-1600
05/13/2016 16:50,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:50,SCH - OH - NY,23317,558.85,1100,-1900
05/13/2016 16:50,SCH - PJ - NY,23316,-50.53,2300,-800
05/13/2016 16:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:50,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:50,SPR/DUN-SOUTH,23320,783.48,4350,-9999
05/13/2016 16:50,TOTAL EAST,23314,2514.37,6500,-9999
05/13/2016 16:50,UPNY CONED,23315,781.07,4850,-9999
05/13/2016 16:50,WEST CENTRAL,23312,-243.52,9999,-9999
05/13/2016 16:55,CENTRAL EAST - VC,23330,2388.71,2490,-9999
05/13/2016 16:55,DYSINGER EAST,23326,294.03,3150,-9999
05/13/2016 16:55,MOSES SOUTH,23319,1324.62,2850,-1600
05/13/2016 16:55,SCH - HQ - NY,23324,1000,1000,0
05/13/2016 16:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 16:55,SCH - HQ_IMPORT_EXPORT,325376,741,1310,-9999
05/13/2016 16:55,SCH - NE - NY,23318,-1396.77,1400,-1600
05/13/2016 16:55,SCH - NPX_1385,325277,35,200,-200
05/13/2016 16:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 16:55,SCH - OH - NY,23317,559.51,1100,-1900
05/13/2016 16:55,SCH - PJ - NY,23316,-49.19,2300,-800
05/13/2016 16:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 16:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 16:55,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 16:55,SPR/DUN-SOUTH,23320,796.03,4350,-9999
05/13/2016 16:55,TOTAL EAST,23314,2490.5,6500,-9999
05/13/2016 16:55,UPNY CONED,23315,775.13,4850,-9999
05/13/2016 16:55,WEST CENTRAL,23312,-170.84,9999,-9999
05/13/2016 17:00,CENTRAL EAST - VC,23330,2390.01,2490,-9999
05/13/2016 17:00,DYSINGER EAST,23326,396.31,3150,-9999
05/13/2016 17:00,MOSES SOUTH,23319,1247.63,2850,-1600
05/13/2016 17:00,SCH - HQ - NY,23324,988,1000,0
05/13/2016 17:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:00,SCH - HQ_IMPORT_EXPORT,325376,729,1310,-9999
05/13/2016 17:00,SCH - NE - NY,23318,-1337.14,1400,-1600
05/13/2016 17:00,SCH - NPX_1385,325277,85,200,-200
05/13/2016 17:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:00,SCH - OH - NY,23317,534.38,1100,-1900
05/13/2016 17:00,SCH - PJ - NY,23316,40.83,2300,-800
05/13/2016 17:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:00,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:00,SPR/DUN-SOUTH,23320,914.51,4350,-9999
05/13/2016 17:00,TOTAL EAST,23314,2576.72,6500,-9999
05/13/2016 17:00,UPNY CONED,23315,857.19,4850,-9999
05/13/2016 17:00,WEST CENTRAL,23312,-65.08,9999,-9999
05/13/2016 17:05,CENTRAL EAST - VC,23330,2389.01,2490,-9999
05/13/2016 17:05,DYSINGER EAST,23326,287.12,3150,-9999
05/13/2016 17:05,MOSES SOUTH,23319,1321.83,2850,-1600
05/13/2016 17:05,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:05,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:05,SCH - NE - NY,23318,-1277.39,1400,-1600
05/13/2016 17:05,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:05,SCH - OH - NY,23317,509.62,1100,-1900
05/13/2016 17:05,SCH - PJ - NY,23316,135.16,2300,-800
05/13/2016 17:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:05,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:05,SPR/DUN-SOUTH,23320,930.48,4350,-9999
05/13/2016 17:05,TOTAL EAST,23314,2613.47,6500,-9999
05/13/2016 17:05,UPNY CONED,23315,856.7,4850,-9999
05/13/2016 17:05,WEST CENTRAL,23312,-169.61,9999,-9999
05/13/2016 17:10,CENTRAL EAST - VC,23330,2388.42,2490,-9999
05/13/2016 17:10,DYSINGER EAST,23326,346.53,3150,-9999
05/13/2016 17:10,MOSES SOUTH,23319,1346.01,2850,-1600
05/13/2016 17:10,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:10,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:10,SCH - NE - NY,23318,-1278.07,1400,-1600
05/13/2016 17:10,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:10,SCH - OH - NY,23317,509.6,1100,-1900
05/13/2016 17:10,SCH - PJ - NY,23316,134.83,2300,-800
05/13/2016 17:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:10,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:10,SPR/DUN-SOUTH,23320,856.11,4350,-9999
05/13/2016 17:10,TOTAL EAST,23314,2679.32,6500,-9999
05/13/2016 17:10,UPNY CONED,23315,768.08,4850,-9999
05/13/2016 17:10,WEST CENTRAL,23312,-106.11,9999,-9999
05/13/2016 17:15,CENTRAL EAST - VC,23330,2389.48,2490,-9999
05/13/2016 17:15,DYSINGER EAST,23326,396.61,3150,-9999
05/13/2016 17:15,MOSES SOUTH,23319,1269.38,2850,-1600
05/13/2016 17:15,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:15,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:15,SCH - NE - NY,23318,-1257.94,1400,-1600
05/13/2016 17:15,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:15,SCH - OH - NY,23317,509.34,1100,-1900
05/13/2016 17:15,SCH - PJ - NY,23316,193.4,2300,-800
05/13/2016 17:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:15,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:15,SPR/DUN-SOUTH,23320,805.54,4350,-9999
05/13/2016 17:15,TOTAL EAST,23314,2791.19,6500,-9999
05/13/2016 17:15,UPNY CONED,23315,765.31,4850,-9999
05/13/2016 17:15,WEST CENTRAL,23312,-54.48,9999,-9999
05/13/2016 17:20,CENTRAL EAST - VC,23330,2391.65,2490,-9999
05/13/2016 17:20,DYSINGER EAST,23326,456.69,3150,-9999
05/13/2016 17:20,MOSES SOUTH,23319,1252.59,2850,-1600
05/13/2016 17:20,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:20,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:20,SCH - NE - NY,23318,-1238.11,1400,-1600
05/13/2016 17:20,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:20,SCH - OH - NY,23317,509.97,1100,-1900
05/13/2016 17:20,SCH - PJ - NY,23316,252.69,2300,-800
05/13/2016 17:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:20,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:20,SPR/DUN-SOUTH,23320,812.47,4350,-9999
05/13/2016 17:20,TOTAL EAST,23314,2798.5,6500,-9999
05/13/2016 17:20,UPNY CONED,23315,772.19,4850,-9999
05/13/2016 17:20,WEST CENTRAL,23312,7.62,9999,-9999
05/13/2016 17:25,CENTRAL EAST - VC,23330,2372.8,2490,-9999
05/13/2016 17:25,DYSINGER EAST,23326,253.27,3150,-9999
05/13/2016 17:25,MOSES SOUTH,23319,1256.63,2850,-1600
05/13/2016 17:25,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:25,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:25,SCH - NE - NY,23318,-1237.5,1400,-1600
05/13/2016 17:25,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:25,SCH - OH - NY,23317,509.57,1100,-1900
05/13/2016 17:25,SCH - PJ - NY,23316,252.15,2300,-800
05/13/2016 17:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:25,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:25,SPR/DUN-SOUTH,23320,834.25,4350,-9999
05/13/2016 17:25,TOTAL EAST,23314,2699.54,6500,-9999
05/13/2016 17:25,UPNY CONED,23315,729.65,4850,-9999
05/13/2016 17:25,WEST CENTRAL,23312,-190.66,9999,-9999
05/13/2016 17:30,CENTRAL EAST - VC,23330,2387.23,2490,-9999
05/13/2016 17:30,DYSINGER EAST,23326,295.89,3150,-9999
05/13/2016 17:30,MOSES SOUTH,23319,1277.13,2850,-1600
05/13/2016 17:30,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:30,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:30,SCH - NE - NY,23318,-1275.49,1400,-1600
05/13/2016 17:30,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:30,SCH - OH - NY,23317,509.52,1100,-1900
05/13/2016 17:30,SCH - PJ - NY,23316,181.53,2300,-800
05/13/2016 17:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:30,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:30,SPR/DUN-SOUTH,23320,862.96,4350,-9999
05/13/2016 17:30,TOTAL EAST,23314,2720.51,6500,-9999
05/13/2016 17:30,UPNY CONED,23315,781.44,4850,-9999
05/13/2016 17:30,WEST CENTRAL,23312,-145.03,9999,-9999
05/13/2016 17:35,CENTRAL EAST - VC,23330,2388.38,2490,-9999
05/13/2016 17:35,DYSINGER EAST,23326,324.68,3150,-9999
05/13/2016 17:35,MOSES SOUTH,23319,1278.95,2850,-1600
05/13/2016 17:35,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:35,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:35,SCH - NE - NY,23318,-1314.27,1400,-1600
05/13/2016 17:35,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:35,SCH - OH - NY,23317,509.4,1100,-1900
05/13/2016 17:35,SCH - PJ - NY,23316,110.99,2300,-800
05/13/2016 17:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:35,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:35,SPR/DUN-SOUTH,23320,828.22,4350,-9999
05/13/2016 17:35,TOTAL EAST,23314,2730.56,6500,-9999
05/13/2016 17:35,UPNY CONED,23315,794.01,4850,-9999
05/13/2016 17:35,WEST CENTRAL,23312,-116.29,9999,-9999
05/13/2016 17:40,CENTRAL EAST - VC,23330,2380.84,2490,-9999
05/13/2016 17:40,DYSINGER EAST,23326,355.78,3150,-9999
05/13/2016 17:40,MOSES SOUTH,23319,1256.37,2850,-1600
05/13/2016 17:40,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:40,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:40,SCH - NE - NY,23318,-1314.31,1400,-1600
05/13/2016 17:40,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:40,SCH - OH - NY,23317,509.7,1100,-1900
05/13/2016 17:40,SCH - PJ - NY,23316,111.19,2300,-800
05/13/2016 17:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:40,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:40,SPR/DUN-SOUTH,23320,835.5,4350,-9999
05/13/2016 17:40,TOTAL EAST,23314,2709.58,6500,-9999
05/13/2016 17:40,UPNY CONED,23315,805.28,4850,-9999
05/13/2016 17:40,WEST CENTRAL,23312,-83.12,9999,-9999
05/13/2016 17:45,CENTRAL EAST - VC,23330,2382.8,2490,-9999
05/13/2016 17:45,DYSINGER EAST,23326,324.81,3150,-9999
05/13/2016 17:45,MOSES SOUTH,23319,1242.22,2850,-1600
05/13/2016 17:45,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:45,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:45,SCH - NE - NY,23318,-1333.9,1400,-1600
05/13/2016 17:45,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:45,SCH - OH - NY,23317,509.16,1100,-1900
05/13/2016 17:45,SCH - PJ - NY,23316,109.59,2300,-800
05/13/2016 17:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:45,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:45,SPR/DUN-SOUTH,23320,852.4,4350,-9999
05/13/2016 17:45,TOTAL EAST,23314,2730.08,6500,-9999
05/13/2016 17:45,UPNY CONED,23315,818.46,4850,-9999
05/13/2016 17:45,WEST CENTRAL,23312,-113.07,9999,-9999
05/13/2016 17:50,CENTRAL EAST - VC,23330,2380.79,2490,-9999
05/13/2016 17:50,DYSINGER EAST,23326,252.62,3150,-9999
05/13/2016 17:50,MOSES SOUTH,23319,1264.35,2850,-1600
05/13/2016 17:50,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:50,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:50,SCH - NE - NY,23318,-1354.8,1400,-1600
05/13/2016 17:50,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:50,SCH - OH - NY,23317,509.04,1100,-1900
05/13/2016 17:50,SCH - PJ - NY,23316,110.08,2300,-800
05/13/2016 17:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:50,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:50,SPR/DUN-SOUTH,23320,856.35,4350,-9999
05/13/2016 17:50,TOTAL EAST,23314,2687.58,6500,-9999
05/13/2016 17:50,UPNY CONED,23315,828.71,4850,-9999
05/13/2016 17:50,WEST CENTRAL,23312,-181.61,9999,-9999
05/13/2016 17:55,CENTRAL EAST - VC,23330,2382.69,2490,-9999
05/13/2016 17:55,DYSINGER EAST,23326,281.32,3150,-9999
05/13/2016 17:55,MOSES SOUTH,23319,1245.34,2850,-1600
05/13/2016 17:55,SCH - HQ - NY,23324,976,1000,0
05/13/2016 17:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 17:55,SCH - HQ_IMPORT_EXPORT,325376,717,1310,-9999
05/13/2016 17:55,SCH - NE - NY,23318,-1355,1400,-1600
05/13/2016 17:55,SCH - NPX_1385,325277,134,200,-200
05/13/2016 17:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 17:55,SCH - OH - NY,23317,508.86,1100,-1900
05/13/2016 17:55,SCH - PJ - NY,23316,110.97,2300,-800
05/13/2016 17:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 17:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 17:55,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 17:55,SPR/DUN-SOUTH,23320,842.89,4350,-9999
05/13/2016 17:55,TOTAL EAST,23314,2743.51,6500,-9999
05/13/2016 17:55,UPNY CONED,23315,820.42,4850,-9999
05/13/2016 17:55,WEST CENTRAL,23312,-150.95,9999,-9999
05/13/2016 18:00,CENTRAL EAST - VC,23330,2370.88,2490,-9999
05/13/2016 18:00,DYSINGER EAST,23326,224.71,3150,-9999
05/13/2016 18:00,MOSES SOUTH,23319,1244.92,2850,-1600
05/13/2016 18:00,SCH - HQ - NY,23324,969,1000,0
05/13/2016 18:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:00,SCH - HQ_IMPORT_EXPORT,325376,710,1310,-9999
05/13/2016 18:00,SCH - NE - NY,23318,-1255.68,1400,-1600
05/13/2016 18:00,SCH - NPX_1385,325277,89,200,-200
05/13/2016 18:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:00,SCH - OH - NY,23317,533.97,1100,-1900
05/13/2016 18:00,SCH - PJ - NY,23316,134.09,2300,-800
05/13/2016 18:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:00,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:00,SPR/DUN-SOUTH,23320,829.08,4350,-9999
05/13/2016 18:00,TOTAL EAST,23314,2745.24,6500,-9999
05/13/2016 18:00,UPNY CONED,23315,884.71,4850,-9999
05/13/2016 18:00,WEST CENTRAL,23312,-204.67,9999,-9999
05/13/2016 18:05,CENTRAL EAST - VC,23330,2374,2490,-9999
05/13/2016 18:05,DYSINGER EAST,23326,235.67,3150,-9999
05/13/2016 18:05,MOSES SOUTH,23319,1233.62,2850,-1600
05/13/2016 18:05,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:05,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:05,SCH - NE - NY,23318,-1156.24,1400,-1600
05/13/2016 18:05,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:05,SCH - OH - NY,23317,558.9,1100,-1900
05/13/2016 18:05,SCH - PJ - NY,23316,155.8,2300,-800
05/13/2016 18:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:05,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:05,SPR/DUN-SOUTH,23320,858.72,4350,-9999
05/13/2016 18:05,TOTAL EAST,23314,2777.95,6500,-9999
05/13/2016 18:05,UPNY CONED,23315,985.01,4850,-9999
05/13/2016 18:05,WEST CENTRAL,23312,-189.61,9999,-9999
05/13/2016 18:10,CENTRAL EAST - VC,23330,2379.87,2490,-9999
05/13/2016 18:10,DYSINGER EAST,23326,264.08,3150,-9999
05/13/2016 18:10,MOSES SOUTH,23319,1254.9,2850,-1600
05/13/2016 18:10,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:10,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:10,SCH - NE - NY,23318,-1155.86,1400,-1600
05/13/2016 18:10,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:10,SCH - OH - NY,23317,559.46,1100,-1900
05/13/2016 18:10,SCH - PJ - NY,23316,155.41,2300,-800
05/13/2016 18:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:10,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:10,SPR/DUN-SOUTH,23320,846.82,4350,-9999
05/13/2016 18:10,TOTAL EAST,23314,2722.52,6500,-9999
05/13/2016 18:10,UPNY CONED,23315,963.99,4850,-9999
05/13/2016 18:10,WEST CENTRAL,23312,-159.12,9999,-9999
05/13/2016 18:15,CENTRAL EAST - VC,23330,2368.11,2490,-9999
05/13/2016 18:15,DYSINGER EAST,23326,145.93,3150,-9999
05/13/2016 18:15,MOSES SOUTH,23319,1237.72,2850,-1600
05/13/2016 18:15,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:15,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:15,SCH - NE - NY,23318,-1244.37,1400,-1600
05/13/2016 18:15,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:15,SCH - OH - NY,23317,559.04,1100,-1900
05/13/2016 18:15,SCH - PJ - NY,23316,186.12,2300,-800
05/13/2016 18:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:15,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:15,SPR/DUN-SOUTH,23320,799.13,4350,-9999
05/13/2016 18:15,TOTAL EAST,23314,2674.78,6500,-9999
05/13/2016 18:15,UPNY CONED,23315,940.78,4850,-9999
05/13/2016 18:15,WEST CENTRAL,23312,-276.38,9999,-9999
05/13/2016 18:20,CENTRAL EAST - VC,23330,2371,2490,-9999
05/13/2016 18:20,DYSINGER EAST,23326,115.15,3150,-9999
05/13/2016 18:20,MOSES SOUTH,23319,1249.94,2850,-1600
05/13/2016 18:20,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:20,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:20,SCH - NE - NY,23318,-1334.52,1400,-1600
05/13/2016 18:20,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:20,SCH - OH - NY,23317,559.47,1100,-1900
05/13/2016 18:20,SCH - PJ - NY,23316,214.59,2300,-800
05/13/2016 18:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:20,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:20,SPR/DUN-SOUTH,23320,758.06,4350,-9999
05/13/2016 18:20,TOTAL EAST,23314,2637.68,6500,-9999
05/13/2016 18:20,UPNY CONED,23315,899.66,4850,-9999
05/13/2016 18:20,WEST CENTRAL,23312,-303.63,9999,-9999
05/13/2016 18:25,CENTRAL EAST - VC,23330,2381.33,2490,-9999
05/13/2016 18:25,DYSINGER EAST,23326,144.9,3150,-9999
05/13/2016 18:25,MOSES SOUTH,23319,1241.12,2850,-1600
05/13/2016 18:25,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:25,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:25,SCH - NE - NY,23318,-1335.14,1400,-1600
05/13/2016 18:25,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:25,SCH - OH - NY,23317,559.73,1100,-1900
05/13/2016 18:25,SCH - PJ - NY,23316,216.45,2300,-800
05/13/2016 18:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:25,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:25,SPR/DUN-SOUTH,23320,726.09,4350,-9999
05/13/2016 18:25,TOTAL EAST,23314,2653.5,6500,-9999
05/13/2016 18:25,UPNY CONED,23315,862.08,4850,-9999
05/13/2016 18:25,WEST CENTRAL,23312,-269.62,9999,-9999
05/13/2016 18:30,CENTRAL EAST - VC,23330,2370.88,2490,-9999
05/13/2016 18:30,DYSINGER EAST,23326,179.26,3150,-9999
05/13/2016 18:30,MOSES SOUTH,23319,1234.92,2850,-1600
05/13/2016 18:30,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:30,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:30,SCH - NE - NY,23318,-1365.55,1400,-1600
05/13/2016 18:30,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:30,SCH - OH - NY,23317,559.74,1100,-1900
05/13/2016 18:30,SCH - PJ - NY,23316,256.83,2300,-800
05/13/2016 18:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:30,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:30,SPR/DUN-SOUTH,23320,653.46,4350,-9999
05/13/2016 18:30,TOTAL EAST,23314,2775.38,6500,-9999
05/13/2016 18:30,UPNY CONED,23315,785.31,4850,-9999
05/13/2016 18:30,WEST CENTRAL,23312,-232.07,9999,-9999
05/13/2016 18:35,CENTRAL EAST - VC,23330,2370.96,2490,-9999
05/13/2016 18:35,DYSINGER EAST,23326,105.59,3150,-9999
05/13/2016 18:35,MOSES SOUTH,23319,1258.16,2850,-1600
05/13/2016 18:35,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:35,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:35,SCH - NE - NY,23318,-1396.36,1400,-1600
05/13/2016 18:35,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:35,SCH - OH - NY,23317,559.96,1100,-1900
05/13/2016 18:35,SCH - PJ - NY,23316,297.49,2300,-800
05/13/2016 18:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:35,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:35,SPR/DUN-SOUTH,23320,660.97,4350,-9999
05/13/2016 18:35,TOTAL EAST,23314,2740.09,6500,-9999
05/13/2016 18:35,UPNY CONED,23315,795.11,4850,-9999
05/13/2016 18:35,WEST CENTRAL,23312,-304.51,9999,-9999
05/13/2016 18:40,CENTRAL EAST - VC,23330,2385.29,2490,-9999
05/13/2016 18:40,DYSINGER EAST,23326,123.48,3150,-9999
05/13/2016 18:40,MOSES SOUTH,23319,1266.51,2850,-1600
05/13/2016 18:40,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:40,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:40,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:40,SCH - NE - NY,23318,-1396.12,1400,-1600
05/13/2016 18:40,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:40,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:40,SCH - OH - NY,23317,560.05,1100,-1900
05/13/2016 18:40,SCH - PJ - NY,23316,297.82,2300,-800
05/13/2016 18:40,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:40,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:40,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:40,SPR/DUN-SOUTH,23320,635.21,4350,-9999
05/13/2016 18:40,TOTAL EAST,23314,2750.09,6500,-9999
05/13/2016 18:40,UPNY CONED,23315,772.02,4850,-9999
05/13/2016 18:40,WEST CENTRAL,23312,-288.44,9999,-9999
05/13/2016 18:45,CENTRAL EAST - VC,23330,2386.28,2490,-9999
05/13/2016 18:45,DYSINGER EAST,23326,118.64,3150,-9999
05/13/2016 18:45,MOSES SOUTH,23319,1256.19,2850,-1600
05/13/2016 18:45,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:45,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:45,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:45,SCH - NE - NY,23318,-1395.91,1400,-1600
05/13/2016 18:45,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:45,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:45,SCH - OH - NY,23317,559.55,1100,-1900
05/13/2016 18:45,SCH - PJ - NY,23316,298.59,2300,-800
05/13/2016 18:45,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:45,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:45,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:45,SPR/DUN-SOUTH,23320,611.27,4350,-9999
05/13/2016 18:45,TOTAL EAST,23314,2776.48,6500,-9999
05/13/2016 18:45,UPNY CONED,23315,751.94,4850,-9999
05/13/2016 18:45,WEST CENTRAL,23312,-290.99,9999,-9999
05/13/2016 18:50,CENTRAL EAST - VC,23330,2384.52,2490,-9999
05/13/2016 18:50,DYSINGER EAST,23326,213.05,3150,-9999
05/13/2016 18:50,MOSES SOUTH,23319,1224.95,2850,-1600
05/13/2016 18:50,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:50,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:50,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:50,SCH - NE - NY,23318,-1396.15,1400,-1600
05/13/2016 18:50,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:50,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:50,SCH - OH - NY,23317,559.53,1100,-1900
05/13/2016 18:50,SCH - PJ - NY,23316,297.85,2300,-800
05/13/2016 18:50,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:50,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:50,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:50,SPR/DUN-SOUTH,23320,592.8,4350,-9999
05/13/2016 18:50,TOTAL EAST,23314,2849.37,6500,-9999
05/13/2016 18:50,UPNY CONED,23315,735.18,4850,-9999
05/13/2016 18:50,WEST CENTRAL,23312,-194.93,9999,-9999
05/13/2016 18:55,CENTRAL EAST - VC,23330,2380.61,2490,-9999
05/13/2016 18:55,DYSINGER EAST,23326,143.27,3150,-9999
05/13/2016 18:55,MOSES SOUTH,23319,1236.31,2850,-1600
05/13/2016 18:55,SCH - HQ - NY,23324,963,1000,0
05/13/2016 18:55,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 18:55,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 18:55,SCH - NE - NY,23318,-1396.48,1400,-1600
05/13/2016 18:55,SCH - NPX_1385,325277,45,200,-200
05/13/2016 18:55,SCH - NPX_CSC,325154,0,0,0
05/13/2016 18:55,SCH - OH - NY,23317,559.29,1100,-1900
05/13/2016 18:55,SCH - PJ - NY,23316,299.06,2300,-800
05/13/2016 18:55,SCH - PJM_HTP,325905,0,0,0
05/13/2016 18:55,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 18:55,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 18:55,SPR/DUN-SOUTH,23320,620.69,4350,-9999
05/13/2016 18:55,TOTAL EAST,23314,2834.79,6500,-9999
05/13/2016 18:55,UPNY CONED,23315,763.45,4850,-9999
05/13/2016 18:55,WEST CENTRAL,23312,-265.19,9999,-9999
05/13/2016 19:00,CENTRAL EAST - VC,23330,2388.24,2490,-9999
05/13/2016 19:00,DYSINGER EAST,23326,-40.4,3150,-9999
05/13/2016 19:00,MOSES SOUTH,23319,1425.36,2850,-1600
05/13/2016 19:00,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:00,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:00,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:00,SCH - NE - NY,23318,-1392.62,1400,-1600
05/13/2016 19:00,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:00,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:00,SCH - OH - NY,23317,534.41,1100,-1900
05/13/2016 19:00,SCH - PJ - NY,23316,237.29,2300,-800
05/13/2016 19:00,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:00,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:00,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:00,SPR/DUN-SOUTH,23320,662.46,4350,-9999
05/13/2016 19:00,TOTAL EAST,23314,2747.16,6500,-9999
05/13/2016 19:00,UPNY CONED,23315,802.24,4850,-9999
05/13/2016 19:00,WEST CENTRAL,23312,-449.84,9999,-9999
05/13/2016 19:05,CENTRAL EAST - VC,23330,2389.85,2490,-9999
05/13/2016 19:05,DYSINGER EAST,23326,24.43,3150,-9999
05/13/2016 19:05,MOSES SOUTH,23319,1452.4,2850,-1600
05/13/2016 19:05,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:05,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:05,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:05,SCH - NE - NY,23318,-1389.42,1400,-1600
05/13/2016 19:05,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:05,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:05,SCH - OH - NY,23317,509.52,1100,-1900
05/13/2016 19:05,SCH - PJ - NY,23316,173.19,2300,-800
05/13/2016 19:05,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:05,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:05,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:05,SPR/DUN-SOUTH,23320,667.59,4350,-9999
05/13/2016 19:05,TOTAL EAST,23314,2692.13,6500,-9999
05/13/2016 19:05,UPNY CONED,23315,801.17,4850,-9999
05/13/2016 19:05,WEST CENTRAL,23312,-385.53,9999,-9999
05/13/2016 19:10,CENTRAL EAST - VC,23330,2388.22,2490,-9999
05/13/2016 19:10,DYSINGER EAST,23326,172.53,3150,-9999
05/13/2016 19:10,MOSES SOUTH,23319,1430.61,2850,-1600
05/13/2016 19:10,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:10,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:10,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:10,SCH - NE - NY,23318,-1389.6,1400,-1600
05/13/2016 19:10,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:10,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:10,SCH - OH - NY,23317,509.55,1100,-1900
05/13/2016 19:10,SCH - PJ - NY,23316,175.23,2300,-800
05/13/2016 19:10,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:10,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:10,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:10,SPR/DUN-SOUTH,23320,647.42,4350,-9999
05/13/2016 19:10,TOTAL EAST,23314,2752.36,6500,-9999
05/13/2016 19:10,UPNY CONED,23315,781.69,4850,-9999
05/13/2016 19:10,WEST CENTRAL,23312,-235.86,9999,-9999
05/13/2016 19:15,CENTRAL EAST - VC,23330,2386.28,2490,-9999
05/13/2016 19:15,DYSINGER EAST,23326,162.3,3150,-9999
05/13/2016 19:15,MOSES SOUTH,23319,1417.78,2850,-1600
05/13/2016 19:15,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:15,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:15,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:15,SCH - NE - NY,23318,-1367.77,1400,-1600
05/13/2016 19:15,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:15,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:15,SCH - OH - NY,23317,509.28,1100,-1900
05/13/2016 19:15,SCH - PJ - NY,23316,104.86,2300,-800
05/13/2016 19:15,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:15,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:15,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:15,SPR/DUN-SOUTH,23320,618.29,4350,-9999
05/13/2016 19:15,TOTAL EAST,23314,2692.2,6500,-9999
05/13/2016 19:15,UPNY CONED,23315,758.33,4850,-9999
05/13/2016 19:15,WEST CENTRAL,23312,-242.93,9999,-9999
05/13/2016 19:20,CENTRAL EAST - VC,23330,2389.53,2490,-9999
05/13/2016 19:20,DYSINGER EAST,23326,203.42,3150,-9999
05/13/2016 19:20,MOSES SOUTH,23319,1439.81,2850,-1600
05/13/2016 19:20,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:20,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:20,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:20,SCH - NE - NY,23318,-1347.01,1400,-1600
05/13/2016 19:20,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:20,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:20,SCH - OH - NY,23317,509.09,1100,-1900
05/13/2016 19:20,SCH - PJ - NY,23316,35.07,2300,-800
05/13/2016 19:20,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:20,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:20,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:20,SPR/DUN-SOUTH,23320,633.42,4350,-9999
05/13/2016 19:20,TOTAL EAST,23314,2660.14,6500,-9999
05/13/2016 19:20,UPNY CONED,23315,774.32,4850,-9999
05/13/2016 19:20,WEST CENTRAL,23312,-200.45,9999,-9999
05/13/2016 19:25,CENTRAL EAST - VC,23330,2380.1,2490,-9999
05/13/2016 19:25,DYSINGER EAST,23326,177.44,3150,-9999
05/13/2016 19:25,MOSES SOUTH,23319,1439.39,2850,-1600
05/13/2016 19:25,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:25,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:25,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:25,SCH - NE - NY,23318,-1346.9,1400,-1600
05/13/2016 19:25,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:25,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:25,SCH - OH - NY,23317,508.94,1100,-1900
05/13/2016 19:25,SCH - PJ - NY,23316,37.46,2300,-800
05/13/2016 19:25,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:25,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:25,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:25,SPR/DUN-SOUTH,23320,643.38,4350,-9999
05/13/2016 19:25,TOTAL EAST,23314,2690.93,6500,-9999
05/13/2016 19:25,UPNY CONED,23315,789.39,4850,-9999
05/13/2016 19:25,WEST CENTRAL,23312,-226.86,9999,-9999
05/13/2016 19:30,CENTRAL EAST - VC,23330,2371.97,2490,-9999
05/13/2016 19:30,DYSINGER EAST,23326,144.84,3150,-9999
05/13/2016 19:30,MOSES SOUTH,23319,1430.17,2850,-1600
05/13/2016 19:30,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:30,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:30,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:30,SCH - NE - NY,23318,-1350.21,1400,-1600
05/13/2016 19:30,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:30,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:30,SCH - OH - NY,23317,508.84,1100,-1900
05/13/2016 19:30,SCH - PJ - NY,23316,72.85,2300,-800
05/13/2016 19:30,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:30,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:30,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:30,SPR/DUN-SOUTH,23320,651.58,4350,-9999
05/13/2016 19:30,TOTAL EAST,23314,2728.51,6500,-9999
05/13/2016 19:30,UPNY CONED,23315,799.4,4850,-9999
05/13/2016 19:30,WEST CENTRAL,23312,-256.79,9999,-9999
05/13/2016 19:35,CENTRAL EAST - VC,23330,2372.8,2490,-9999
05/13/2016 19:35,DYSINGER EAST,23326,125.8,3150,-9999
05/13/2016 19:35,MOSES SOUTH,23319,1358.18,2850,-1600
05/13/2016 19:35,SCH - HQ - NY,23324,963,1000,0
05/13/2016 19:35,SCH - HQ_CEDARS,325274,190,190,-40
05/13/2016 19:35,SCH - HQ_IMPORT_EXPORT,325376,704,1310,-9999
05/13/2016 19:35,SCH - NE - NY,23318,-1352.55,1400,-1600
05/13/2016 19:35,SCH - NPX_1385,325277,45,200,-200
05/13/2016 19:35,SCH - NPX_CSC,325154,0,0,0
05/13/2016 19:35,SCH - OH - NY,23317,508.88,1100,-1900
05/13/2016 19:35,SCH - PJ - NY,23316,110.06,2300,-800
05/13/2016 19:35,SCH - PJM_HTP,325905,0,0,0
05/13/2016 19:35,SCH - PJM_NEPTUNE,325305,660,660,-660
05/13/2016 19:35,SCH - PJM_VFT,325658,122,315,-315
05/13/2016 19:35,SPR/DUN-SOUTH,23320,691.66,4350,-9999
05/13/2016 19:35,TOTAL EAST,23314,2647.74,6500,-9999
05/13/2016 19:35,UPNY CONED,23315,846.37,4850,-9999
05/13/2016 19:35,WEST CENTRAL,23312,-275.45,9999,-9999
"""]
