/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephClients implements CephClientInterface
type FakeCephClients struct {
	Fake *FakeCephV1
	ns   string
}

var cephclientsResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephclients"}

var cephclientsKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephClient"}

// Get takes name of the cephClient, and returns the corresponding cephClient object, and an error if there is any.
func (c *FakeCephClients) Get(name string, options v1.GetOptions) (result *cephrookiov1.CephClient, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephclientsResource, c.ns, name), &cephrookiov1.CephClient{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephClient), err
}

// List takes label and field selectors, and returns the list of CephClients that match those selectors.
func (c *FakeCephClients) List(opts v1.ListOptions) (result *cephrookiov1.CephClientList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephclientsResource, cephclientsKind, c.ns, opts), &cephrookiov1.CephClientList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephClientList{ListMeta: obj.(*cephrookiov1.CephClientList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephClientList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephClients.
func (c *FakeCephClients) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephclientsResource, c.ns, opts))

}

// Create takes the representation of a cephClient and creates it.  Returns the server's representation of the cephClient, and an error, if there is any.
func (c *FakeCephClients) Create(cephClient *cephrookiov1.CephClient) (result *cephrookiov1.CephClient, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephclientsResource, c.ns, cephClient), &cephrookiov1.CephClient{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephClient), err
}

// Update takes the representation of a cephClient and updates it. Returns the server's representation of the cephClient, and an error, if there is any.
func (c *FakeCephClients) Update(cephClient *cephrookiov1.CephClient) (result *cephrookiov1.CephClient, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephclientsResource, c.ns, cephClient), &cephrookiov1.CephClient{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephClient), err
}

// Delete takes name of the cephClient and deletes it. Returns an error if one occurs.
func (c *FakeCephClients) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephclientsResource, c.ns, name), &cephrookiov1.CephClient{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephClients) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephclientsResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephClientList{})
	return err
}

// Patch applies the patch and returns the patched cephClient.
func (c *FakeCephClients) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *cephrookiov1.CephClient, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephclientsResource, c.ns, name, pt, data, subresources...), &cephrookiov1.CephClient{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephClient), err
}
