%%% % @format
%%%-----------------------------------------------------------------------------
%%% Copyright (c) Meta Platforms, Inc. and affiliates.
%%% Copyright (c) WhatsApp LLC
%%%
%%% This source code is licensed under the MIT license found in the
%%% LICENSE.md file in the root directory of this source tree.
%%%
%%% Created :  27 Mar 2023 by Andrew Bennett <potatosaladx@meta.com>
%%%-----------------------------------------------------------------------------
-module(vterm_newer_reference_ext).
-compile(warn_missing_spec_all).
-author("potatosaladx@meta.com").
-oncall("whatsapp_clr").

-behaviour(vterm_encode).
-behaviour(vterm_simplify).

-include_lib("erldist_filter/include/erldist_filter.hrl").
-include_lib("erldist_filter/include/erldist_filter_erts_external.hrl").

%% API
-export([
    new/4,
    internal_vterm_to_binary/2,
    simplify/1
]).

%% Types
-type t() :: #vterm_newer_reference_ext{}.

-export_type([
    t/0
]).

%% Macros
-define(is_len(X), (is_integer(X) andalso (X) >= 1 andalso (X) =< 5)).

%%%=============================================================================
%%% API functions
%%%=============================================================================

-spec new(Len, Node, Creation, Ids) -> T when
    Len :: 1..5, Node :: vterm:atom_t(), Creation :: vterm:u32(), Ids :: [vterm:u32()], T :: t().
new(Len, Node, Creation, Ids) when
    ?is_len(Len) andalso ?is_vterm_atom_t(Node) andalso ?is_u32(Creation) andalso is_list(Ids) andalso
        Len =:= length(Ids)
->
    #vterm_newer_reference_ext{len = Len, node = Node, creation = Creation, ids = Ids}.

-spec internal_vterm_to_binary(T, Opts) -> binary() when T :: t(), Opts :: term().
internal_vterm_to_binary(#vterm_newer_reference_ext{len = Len, node = Node0, creation = Creation, ids = Ids}, Opts) when
    ?is_len(Len) andalso ?is_vterm_atom_t(Node0) andalso ?is_u32(Creation) andalso is_list(Ids) andalso
        Len =:= length(Ids)
->
    Node = vterm_encode:internal_vterm_to_binary(Node0, Opts),
    EncodedIds = <<<<Id:32>> || Id <- Ids>>,
    <<?NEWER_REFERENCE_EXT, Len:16, Node/binary, Creation:32, EncodedIds/binary>>.

-spec simplify(t()) -> term().
simplify(VTerm = #vterm_newer_reference_ext{}) ->
    {ok, Term, <<>>} = vterm_decode:external_binary_to_term(vterm_encode:external_vterm_to_binary(VTerm, #{})),
    Term.
