%%% % DO NOT EDIT: this file was generated by 'just codegen'
%%% % @generated SignedSource<<17b69b3db3611e56ac164dbf19b48a8f>>
%%% % @format
%%%-----------------------------------------------------------------------------
%%% Copyright (c) Meta Platforms, Inc. and affiliates.
%%% Copyright (c) WhatsApp LLC
%%%
%%% This source code is licensed under the MIT license found in the
%%% LICENSE.md file in the root directory of this source tree.
%%%-----------------------------------------------------------------------------
-module(erldist_filter_nif_smoke_SUITE).
-moduledoc """
A test suite designed to load the `erldist_filter_nif' and perform some smoke tests.
""".
-moduledoc #{author => ["Andrew Bennett <potatosaladx@meta.com>"]}.
-moduledoc #{created => "2022-12-16", modified => "2025-08-13"}.
-moduledoc #{copyright => "Meta Platforms, Inc. and affiliates."}.
-compile(warn_missing_spec_all).
-oncall("whatsapp_clr").

-include_lib("stdlib/include/assert.hrl").

-include_lib("erldist_filter/include/erldist_filter_erts_dist.hrl").

-behaviour(ct_suite).

%% ct_suite callbacks
-export([
    all/0,
    groups/0,
    init_per_suite/1,
    end_per_suite/1,
    init_per_group/2,
    end_per_group/2,
    init_per_testcase/2,
    end_per_testcase/2
]).

%% Test Cases
-export([
    test_altact_sig_flags/0,
    test_altact_sig_flags/1,
    test_distribution_flags/0,
    test_distribution_flags/1,
    test_spawn_flags/0,
    test_spawn_flags/1
]).

%% Types
-type ct_testcase_result() ::
    term()
    | {skip, Reason :: term()}
    | {fail, Reason :: term()}
    | {comment, Comment :: string()}
    | {save_config, SaveConfig :: ct_suite:ct_config()}
    | {skip_and_save, Reason :: term(), SaveConfig :: ct_suite:ct_config()}.

%%%=============================================================================
%%% ct callbacks
%%%=============================================================================

-spec all() -> [TestDef :: ct_suite:ct_test_def()] | {skip, Reason :: term()}.
all() ->
    [
        {group, smoke}
    ].

-spec groups() -> [GroupDef :: ct_suite:ct_group_def()].
groups() ->
    [
        {smoke, [parallel], [
            test_altact_sig_flags,
            test_distribution_flags,
            test_spawn_flags
        ]}
    ].

-spec init_per_suite(Config :: ct_suite:ct_config()) ->
    NewConfig ::
        ct_suite:ct_config()
        | {skip, Reason :: term()}
        | {skip_and_save, Reason :: term(), SaveConfig :: ct_suite:ct_config()}.
init_per_suite(Config) ->
    Config.

-spec end_per_suite(Config :: ct_suite:ct_config()) ->
    term()
    | {save_config, SaveConfig :: ct_suite:ct_config()}.
end_per_suite(_Config) ->
    ok.

-spec init_per_group(GroupName :: ct_suite:ct_groupname(), Config :: ct_suite:ct_config()) ->
    NewConfig ::
        ct_suite:ct_config()
        | {skip, Reason :: term()}.
init_per_group(_Group, Config) ->
    Config.

-spec end_per_group(GroupName :: ct_suite:ct_groupname(), Config :: ct_suite:ct_config()) ->
    term()
    | {return_group_result, Status :: ct_suite:ct_status()}.
end_per_group(_Group, _Config) ->
    ok.

-spec init_per_testcase(TestCase :: ct_suite:ct_testname(), Config :: ct_suite:ct_config()) ->
    NewConfig ::
        ct_suite:ct_config()
        | {fail, Reason :: term()}
        | {skip, Reason :: term()}.
init_per_testcase(_TestCase, Config) ->
    Config.

-spec end_per_testcase(TestCase :: ct_suite:ct_testname(), Config :: ct_suite:ct_config()) ->
    term()
    | {fail, Reason :: term()}
    | {save_config, SaveConfig :: ct_suite:ct_config()}.
end_per_testcase(_TestCase, _Config) ->
    ok.

%%%=============================================================================
%%% Test Cases
%%%=============================================================================

-spec test_altact_sig_flags() -> [ct_suite:ct_info()].
test_altact_sig_flags() ->
    [
        {doc, "Loads the `erldist_filter_nif' and verifies that `altact_sig_flags/0' returns a map."},
        {timetrap, {seconds, 60}}
    ].

-spec test_altact_sig_flags(Config :: ct_suite:ct_config()) -> ct_testcase_result().
test_altact_sig_flags(_Config) ->
    Expected = #{
        'ERTS_DOP_ALTACT_SIG_FLG_PRIO' => ?ERTS_DOP_ALTACT_SIG_FLG_PRIO,
        'ERTS_DOP_ALTACT_SIG_FLG_TOKEN' => ?ERTS_DOP_ALTACT_SIG_FLG_TOKEN,
        'ERTS_DOP_ALTACT_SIG_FLG_ALIAS' => ?ERTS_DOP_ALTACT_SIG_FLG_ALIAS,
        'ERTS_DOP_ALTACT_SIG_FLG_NAME' => ?ERTS_DOP_ALTACT_SIG_FLG_NAME,
        'ERTS_DOP_ALTACT_SIG_FLG_EXIT' => ?ERTS_DOP_ALTACT_SIG_FLG_EXIT
    },
    ?assertEqual(Expected, erldist_filter_nif:altact_sig_flags()).

-spec test_distribution_flags() -> [ct_suite:ct_info()].
test_distribution_flags() ->
    [
        {doc, "Loads the `erldist_filter_nif' and verifies that `distribution_flags/0' returns a map."},
        {timetrap, {seconds, 60}}
    ].

-spec test_distribution_flags(Config :: ct_suite:ct_config()) -> ct_testcase_result().
test_distribution_flags(_Config) ->
    Expected = #{
        'DFLAG_PUBLISHED' => ?DFLAG_PUBLISHED,
        'DFLAG_ATOM_CACHE' => ?DFLAG_ATOM_CACHE,
        'DFLAG_EXTENDED_REFERENCES' => ?DFLAG_EXTENDED_REFERENCES,
        'DFLAG_DIST_MONITOR' => ?DFLAG_DIST_MONITOR,
        'DFLAG_FUN_TAGS' => ?DFLAG_FUN_TAGS,
        'DFLAG_DIST_MONITOR_NAME' => ?DFLAG_DIST_MONITOR_NAME,
        'DFLAG_HIDDEN_ATOM_CACHE' => ?DFLAG_HIDDEN_ATOM_CACHE,
        'DFLAG_NEW_FUN_TAGS' => ?DFLAG_NEW_FUN_TAGS,
        'DFLAG_EXTENDED_PIDS_PORTS' => ?DFLAG_EXTENDED_PIDS_PORTS,
        'DFLAG_EXPORT_PTR_TAG' => ?DFLAG_EXPORT_PTR_TAG,
        'DFLAG_BIT_BINARIES' => ?DFLAG_BIT_BINARIES,
        'DFLAG_NEW_FLOATS' => ?DFLAG_NEW_FLOATS,
        'DFLAG_UNICODE_IO' => ?DFLAG_UNICODE_IO,
        'DFLAG_DIST_HDR_ATOM_CACHE' => ?DFLAG_DIST_HDR_ATOM_CACHE,
        'DFLAG_SMALL_ATOM_TAGS' => ?DFLAG_SMALL_ATOM_TAGS,
        'DFLAG_ETS_COMPRESSED' => ?DFLAG_ETS_COMPRESSED,
        'DFLAG_UTF8_ATOMS' => ?DFLAG_UTF8_ATOMS,
        'DFLAG_MAP_TAG' => ?DFLAG_MAP_TAG,
        'DFLAG_BIG_CREATION' => ?DFLAG_BIG_CREATION,
        'DFLAG_SEND_SENDER' => ?DFLAG_SEND_SENDER,
        'DFLAG_BIG_SEQTRACE_LABELS' => ?DFLAG_BIG_SEQTRACE_LABELS,
        'DFLAG_PENDING_CONNECT' => ?DFLAG_PENDING_CONNECT,
        'DFLAG_EXIT_PAYLOAD' => ?DFLAG_EXIT_PAYLOAD,
        'DFLAG_FRAGMENTS' => ?DFLAG_FRAGMENTS,
        'DFLAG_HANDSHAKE_23' => ?DFLAG_HANDSHAKE_23,
        'DFLAG_UNLINK_ID' => ?DFLAG_UNLINK_ID,
        'DFLAG_MANDATORY_25_DIGEST' => ?DFLAG_MANDATORY_25_DIGEST,
        'DFLAG_RESERVED' => ?DFLAG_RESERVED,
        'DFLAG_SPAWN' => ?DFLAG_SPAWN,
        'DFLAG_NAME_ME' => ?DFLAG_NAME_ME,
        'DFLAG_V4_NC' => ?DFLAG_V4_NC,
        'DFLAG_ALIAS' => ?DFLAG_ALIAS,
        'DFLAG_LOCAL_EXT' => ?DFLAG_LOCAL_EXT,
        'DFLAG_ALTACT_SIG' => ?DFLAG_ALTACT_SIG,
        'DFLAG_DETERMINISTIC' => ?DFLAG_DETERMINISTIC,
        'DFLAG_DIST_MANDATORY_25' => ?DFLAG_DIST_MANDATORY_25,
        'DFLAG_DIST_MANDATORY_26' => ?DFLAG_DIST_MANDATORY_26,
        'DFLAG_DIST_MANDATORY' => ?DFLAG_DIST_MANDATORY,
        'DFLAG_DIST_HOPEFULLY' => ?DFLAG_DIST_HOPEFULLY,
        'DFLAG_DIST_DEFAULT' => ?DFLAG_DIST_DEFAULT,
        'DFLAG_DIST_ADDABLE' => ?DFLAG_DIST_ADDABLE,
        'DFLAG_DIST_REJECTABLE' => ?DFLAG_DIST_REJECTABLE,
        'DFLAG_DIST_STRICT_ORDER' => ?DFLAG_DIST_STRICT_ORDER,
        'TERM_TO_BINARY_DFLAGS' => ?TERM_TO_BINARY_DFLAGS
    },
    ?assertEqual(Expected, erldist_filter_nif:distribution_flags()).

-spec test_spawn_flags() -> [ct_suite:ct_info()].
test_spawn_flags() ->
    [
        {doc, "Loads the `erldist_filter_nif' and verifies that `spawn_flags/0' returns a map."},
        {timetrap, {seconds, 60}}
    ].

-spec test_spawn_flags(Config :: ct_suite:ct_config()) -> ct_testcase_result().
test_spawn_flags(_Config) ->
    Expected = #{
        'ERTS_DIST_SPAWN_FLAG_LINK' => ?ERTS_DIST_SPAWN_FLAG_LINK,
        'ERTS_DIST_SPAWN_FLAG_MONITOR' => ?ERTS_DIST_SPAWN_FLAG_MONITOR
    },
    ?assertEqual(Expected, erldist_filter_nif:spawn_flags()).
