%%% % DO NOT EDIT: this file was generated by 'just codegen'
%%% % @generated SignedSource<<0f8fdd4c0ab206ceaff019ef90597213>>
%%% % @format
%%%-----------------------------------------------------------------------------
%%% Copyright (c) Meta Platforms, Inc. and affiliates.
%%% Copyright (c) WhatsApp LLC
%%%
%%% This source code is licensed under the MIT license found in the
%%% LICENSE.md file in the root directory of this source tree.
%%%-----------------------------------------------------------------------------
-module(erldist_filter_config_SUITE).
-moduledoc """
Test suite for `erldist_filter_nif` configuration options.

Tests the various configuration modes of the Erlang Distribution Filter system,
including:

- **Fragment Compaction**: Tests fragment compression and optimization features
- **Deep Packet Inspection (DPI)**: Tests analysis of Erlang distribution packets
- **Traffic Logging**: Tests event logging capabilities
- **Traffic Control**: Tests dropping and redirecting of distribution operations

The test suite covers different distribution operations:
- Process spawning (spawn requests/replies)
- Process linking/unlinking
- Process monitoring and exits
- Message sending (to PIDs, names, aliases)
- Group leader operations

Each test group verifies behavior across different packet fragmentation modes
(normal, fragmented, pass-through) and various configuration combinations.
""".
-moduledoc #{author => ["Andrew Bennett <potatosaladx@meta.com>"]}.
-moduledoc #{created => "2023-05-11", modified => "2025-08-21"}.
-moduledoc #{copyright => "Meta Platforms, Inc. and affiliates."}.
-compile(warn_missing_spec_all).
-oncall("whatsapp_clr").

-include_lib("stdlib/include/assert.hrl").

-include_lib("erldist_filter/include/erldist_filter_erts_dist.hrl").

-behaviour(ct_suite).

%% ct_suite callbacks
-export([
    all/0,
    groups/0,
    init_per_suite/1,
    end_per_suite/1,
    init_per_group/2,
    end_per_group/2
]).

%% Common Test Cases
-export([
    compact_fragments_spawn_request_test/3,
    logging_spawn_request_test/3
]).

%% Test Cases
-export([
    compact_fragments_fragment_spawn_request_test/0,
    compact_fragments_fragment_spawn_request_test/1,
    compact_fragments_normal_spawn_request_test/0,
    compact_fragments_normal_spawn_request_test/1,
    compact_fragments_pass_through_spawn_request_test/0,
    compact_fragments_pass_through_spawn_request_test/1,
    logging_fragment_spawn_request_test/0,
    logging_fragment_spawn_request_test/1,
    logging_normal_spawn_request_test/0,
    logging_normal_spawn_request_test/1,
    logging_pass_through_spawn_request_test/0,
    logging_pass_through_spawn_request_test/1,
    traffic_drop_fragment_exit_test/0,
    traffic_drop_fragment_exit_test/1,
    traffic_drop_fragment_exit2_test/0,
    traffic_drop_fragment_exit2_test/1,
    traffic_drop_fragment_group_leader_test/0,
    traffic_drop_fragment_group_leader_test/1,
    traffic_drop_fragment_link_test/0,
    traffic_drop_fragment_link_test/1,
    traffic_drop_fragment_monitor_related_test/0,
    traffic_drop_fragment_monitor_related_test/1,
    traffic_drop_fragment_send_to_alias_test/0,
    traffic_drop_fragment_send_to_alias_test/1,
    traffic_drop_fragment_send_to_name_test/0,
    traffic_drop_fragment_send_to_name_test/1,
    traffic_drop_fragment_send_to_pid_test/0,
    traffic_drop_fragment_send_to_pid_test/1,
    traffic_drop_fragment_spawn_reply_test/0,
    traffic_drop_fragment_spawn_reply_test/1,
    traffic_drop_fragment_spawn_request_test/0,
    traffic_drop_fragment_spawn_request_test/1,
    traffic_drop_fragment_unlink_test/0,
    traffic_drop_fragment_unlink_test/1,
    traffic_drop_normal_exit_test/0,
    traffic_drop_normal_exit_test/1,
    traffic_drop_normal_exit2_test/0,
    traffic_drop_normal_exit2_test/1,
    traffic_drop_normal_group_leader_test/0,
    traffic_drop_normal_group_leader_test/1,
    traffic_drop_normal_link_test/0,
    traffic_drop_normal_link_test/1,
    traffic_drop_normal_monitor_related_test/0,
    traffic_drop_normal_monitor_related_test/1,
    traffic_drop_normal_send_to_alias_test/0,
    traffic_drop_normal_send_to_alias_test/1,
    traffic_drop_normal_send_to_name_test/0,
    traffic_drop_normal_send_to_name_test/1,
    traffic_drop_normal_send_to_pid_test/0,
    traffic_drop_normal_send_to_pid_test/1,
    traffic_drop_normal_spawn_reply_test/0,
    traffic_drop_normal_spawn_reply_test/1,
    traffic_drop_normal_spawn_request_test/0,
    traffic_drop_normal_spawn_request_test/1,
    traffic_drop_normal_unlink_test/0,
    traffic_drop_normal_unlink_test/1,
    traffic_drop_pass_through_exit_test/0,
    traffic_drop_pass_through_exit_test/1,
    traffic_drop_pass_through_exit2_test/0,
    traffic_drop_pass_through_exit2_test/1,
    traffic_drop_pass_through_group_leader_test/0,
    traffic_drop_pass_through_group_leader_test/1,
    traffic_drop_pass_through_link_test/0,
    traffic_drop_pass_through_link_test/1,
    traffic_drop_pass_through_monitor_related_test/0,
    traffic_drop_pass_through_monitor_related_test/1,
    traffic_drop_pass_through_send_to_alias_test/0,
    traffic_drop_pass_through_send_to_alias_test/1,
    traffic_drop_pass_through_send_to_name_test/0,
    traffic_drop_pass_through_send_to_name_test/1,
    traffic_drop_pass_through_send_to_pid_test/0,
    traffic_drop_pass_through_send_to_pid_test/1,
    traffic_drop_pass_through_spawn_reply_test/0,
    traffic_drop_pass_through_spawn_reply_test/1,
    traffic_drop_pass_through_spawn_request_test/0,
    traffic_drop_pass_through_spawn_request_test/1,
    traffic_drop_pass_through_unlink_test/0,
    traffic_drop_pass_through_unlink_test/1,
    traffic_redirect_fragment_exit_test/0,
    traffic_redirect_fragment_exit_test/1,
    traffic_redirect_fragment_exit2_test/0,
    traffic_redirect_fragment_exit2_test/1,
    traffic_redirect_fragment_group_leader_test/0,
    traffic_redirect_fragment_group_leader_test/1,
    traffic_redirect_fragment_link_test/0,
    traffic_redirect_fragment_link_test/1,
    traffic_redirect_fragment_monitor_related_test/0,
    traffic_redirect_fragment_monitor_related_test/1,
    traffic_redirect_fragment_send_to_alias_test/0,
    traffic_redirect_fragment_send_to_alias_test/1,
    traffic_redirect_fragment_send_to_name_test/0,
    traffic_redirect_fragment_send_to_name_test/1,
    traffic_redirect_fragment_send_to_pid_test/0,
    traffic_redirect_fragment_send_to_pid_test/1,
    traffic_redirect_fragment_spawn_reply_test/0,
    traffic_redirect_fragment_spawn_reply_test/1,
    traffic_redirect_fragment_spawn_request_test/0,
    traffic_redirect_fragment_spawn_request_test/1,
    traffic_redirect_fragment_unlink_test/0,
    traffic_redirect_fragment_unlink_test/1,
    traffic_redirect_normal_exit_test/0,
    traffic_redirect_normal_exit_test/1,
    traffic_redirect_normal_exit2_test/0,
    traffic_redirect_normal_exit2_test/1,
    traffic_redirect_normal_group_leader_test/0,
    traffic_redirect_normal_group_leader_test/1,
    traffic_redirect_normal_link_test/0,
    traffic_redirect_normal_link_test/1,
    traffic_redirect_normal_monitor_related_test/0,
    traffic_redirect_normal_monitor_related_test/1,
    traffic_redirect_normal_send_to_alias_test/0,
    traffic_redirect_normal_send_to_alias_test/1,
    traffic_redirect_normal_send_to_name_test/0,
    traffic_redirect_normal_send_to_name_test/1,
    traffic_redirect_normal_send_to_pid_test/0,
    traffic_redirect_normal_send_to_pid_test/1,
    traffic_redirect_normal_spawn_reply_test/0,
    traffic_redirect_normal_spawn_reply_test/1,
    traffic_redirect_normal_spawn_request_test/0,
    traffic_redirect_normal_spawn_request_test/1,
    traffic_redirect_normal_unlink_test/0,
    traffic_redirect_normal_unlink_test/1,
    traffic_redirect_pass_through_exit_test/0,
    traffic_redirect_pass_through_exit_test/1,
    traffic_redirect_pass_through_exit2_test/0,
    traffic_redirect_pass_through_exit2_test/1,
    traffic_redirect_pass_through_group_leader_test/0,
    traffic_redirect_pass_through_group_leader_test/1,
    traffic_redirect_pass_through_link_test/0,
    traffic_redirect_pass_through_link_test/1,
    traffic_redirect_pass_through_monitor_related_test/0,
    traffic_redirect_pass_through_monitor_related_test/1,
    traffic_redirect_pass_through_send_to_alias_test/0,
    traffic_redirect_pass_through_send_to_alias_test/1,
    traffic_redirect_pass_through_send_to_name_test/0,
    traffic_redirect_pass_through_send_to_name_test/1,
    traffic_redirect_pass_through_send_to_pid_test/0,
    traffic_redirect_pass_through_send_to_pid_test/1,
    traffic_redirect_pass_through_spawn_reply_test/0,
    traffic_redirect_pass_through_spawn_reply_test/1,
    traffic_redirect_pass_through_spawn_request_test/0,
    traffic_redirect_pass_through_spawn_request_test/1,
    traffic_redirect_pass_through_unlink_test/0,
    traffic_redirect_pass_through_unlink_test/1
]).

%% Deep Packet Inspection Test Cases
-export([
    dpi_exit_test/4,
    dpi_exit2_test/4,
    dpi_group_leader_test/4,
    dpi_link_test/4,
    dpi_monitor_related_test/4,
    dpi_send_to_alias_test/4,
    dpi_send_to_name_test/4,
    dpi_send_to_pid_test/4,
    dpi_spawn_reply_test/4,
    dpi_spawn_request_test/4,
    dpi_unlink_test/4
]).

%% Dist Operation functions
-export([
    dop_alias_send_noop/3,
    dop_alias_send_tt_noop/4,
    dop_altact_sig_send_noop/6,
    dop_exit_noop/3,
    dop_exit_tt_noop/4,
    dop_payload_exit_noop/3,
    dop_payload_exit_tt_noop/4,
    dop_exit2_noop/3,
    dop_exit2_tt_noop/4,
    dop_payload_exit2_noop/3,
    dop_payload_exit2_tt_noop/4,
    dop_group_leader_noop/3,
    dop_link_noop/3,
    dop_monitor_p_noop/3,
    dop_demonitor_p_noop/3,
    dop_monitor_p_exit_noop/3,
    dop_payload_monitor_p_exit_noop/3,
    dop_reg_send_noop/4,
    dop_reg_send_tt_noop/5,
    dop_send_noop/3,
    dop_send_tt_noop/4,
    dop_send_sender_noop/3,
    dop_send_sender_tt_noop/4,
    dop_spawn_reply_noop/3,
    dop_spawn_reply_tt_noop/4,
    dop_spawn_request_noop/3,
    dop_spawn_request_tt_noop/4,
    dop_unlink_noop/3,
    dop_unlink_id_noop/3,
    dop_unlink_id_ack_noop/3,
    spawn_request_noop/3
]).

%%%=============================================================================
%%% ct_suite callbacks
%%%=============================================================================

-spec all() -> erldist_filter_test:all().
all() ->
    [
        {group, config}
    ].

-spec groups() -> erldist_filter_test:groups().
groups() ->
    [
        {config, [shuffle], [
            compact_fragments_fragment_spawn_request_test,
            compact_fragments_normal_spawn_request_test,
            compact_fragments_pass_through_spawn_request_test,
            logging_fragment_spawn_request_test,
            logging_normal_spawn_request_test,
            logging_pass_through_spawn_request_test,
            traffic_drop_fragment_exit_test,
            traffic_drop_fragment_exit2_test,
            traffic_drop_fragment_group_leader_test,
            traffic_drop_fragment_link_test,
            traffic_drop_fragment_monitor_related_test,
            traffic_drop_fragment_send_to_alias_test,
            traffic_drop_fragment_send_to_name_test,
            traffic_drop_fragment_send_to_pid_test,
            traffic_drop_fragment_spawn_reply_test,
            traffic_drop_fragment_spawn_request_test,
            traffic_drop_fragment_unlink_test,
            traffic_drop_normal_exit_test,
            traffic_drop_normal_exit2_test,
            traffic_drop_normal_group_leader_test,
            traffic_drop_normal_link_test,
            traffic_drop_normal_monitor_related_test,
            traffic_drop_normal_send_to_alias_test,
            traffic_drop_normal_send_to_name_test,
            traffic_drop_normal_send_to_pid_test,
            traffic_drop_normal_spawn_reply_test,
            traffic_drop_normal_spawn_request_test,
            traffic_drop_normal_unlink_test,
            traffic_drop_pass_through_exit_test,
            traffic_drop_pass_through_exit2_test,
            traffic_drop_pass_through_group_leader_test,
            traffic_drop_pass_through_link_test,
            traffic_drop_pass_through_monitor_related_test,
            traffic_drop_pass_through_send_to_alias_test,
            traffic_drop_pass_through_send_to_name_test,
            traffic_drop_pass_through_send_to_pid_test,
            traffic_drop_pass_through_spawn_reply_test,
            traffic_drop_pass_through_spawn_request_test,
            traffic_drop_pass_through_unlink_test,
            traffic_redirect_fragment_exit_test,
            traffic_redirect_fragment_exit2_test,
            traffic_redirect_fragment_group_leader_test,
            traffic_redirect_fragment_link_test,
            traffic_redirect_fragment_monitor_related_test,
            traffic_redirect_fragment_send_to_alias_test,
            traffic_redirect_fragment_send_to_name_test,
            traffic_redirect_fragment_send_to_pid_test,
            traffic_redirect_fragment_spawn_reply_test,
            traffic_redirect_fragment_spawn_request_test,
            traffic_redirect_fragment_unlink_test,
            traffic_redirect_normal_exit_test,
            traffic_redirect_normal_exit2_test,
            traffic_redirect_normal_group_leader_test,
            traffic_redirect_normal_link_test,
            traffic_redirect_normal_monitor_related_test,
            traffic_redirect_normal_send_to_alias_test,
            traffic_redirect_normal_send_to_name_test,
            traffic_redirect_normal_send_to_pid_test,
            traffic_redirect_normal_spawn_reply_test,
            traffic_redirect_normal_spawn_request_test,
            traffic_redirect_normal_unlink_test,
            traffic_redirect_pass_through_exit_test,
            traffic_redirect_pass_through_exit2_test,
            traffic_redirect_pass_through_group_leader_test,
            traffic_redirect_pass_through_link_test,
            traffic_redirect_pass_through_monitor_related_test,
            traffic_redirect_pass_through_send_to_alias_test,
            traffic_redirect_pass_through_send_to_name_test,
            traffic_redirect_pass_through_send_to_pid_test,
            traffic_redirect_pass_through_spawn_reply_test,
            traffic_redirect_pass_through_spawn_request_test,
            traffic_redirect_pass_through_unlink_test
        ]}
    ].

-spec init_per_suite(Config :: ct_suite:ct_config()) -> erldist_filter_test:init_per_suite().
init_per_suite(Config) ->
    Config.

-spec end_per_suite(Config :: ct_suite:ct_config()) -> erldist_filter_test:end_per_suite().
end_per_suite(_Config) ->
    ok.

-spec init_per_group(GroupName :: ct_suite:ct_groupname(), Config :: ct_suite:ct_config()) ->
    erldist_filter_test:init_per_group().
init_per_group(_Group, Config) ->
    ok = config_set_default(),
    Config.

-spec end_per_group(GroupName :: ct_suite:ct_groupname(), Config :: ct_suite:ct_config()) ->
    erldist_filter_test:end_per_group().
end_per_group(_Group, _Config) ->
    ok = config_set_default(),
    ok.

%%%=============================================================================
%%% Common Test Cases
%%%=============================================================================

-spec compact_fragments_spawn_request_test(Config, DFlags, SendOptions) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options().
compact_fragments_spawn_request_test(_Config, DFlags, SendOptions) ->
    ConfigMap = #{
        compact_fragments => true,
        deep_packet_inspection => false,
        logging => false,
        redirect_dist_operations => false
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap),
    ControlA = spawn_request_noop(0, 0, 0),
    ControlB = spawn_request_noop(1, 1, 1),
    ControlC = spawn_request_noop(2, 2, 2),
    LargeBin = binary:copy(<<"a">>, 255),
    Payload = [{LargeBin, A, B, C}],
    {ok, P0, C0} = vedf_channel:send_encode(C0, ControlA, vterm:expand(Payload), SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, ControlB, vterm:expand(Payload), SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, ControlC, vterm:expand(Payload), SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    AllPackets = lists:concat([P0, P1, P2]),
    AllActions = lists:concat([A1, A2, A3]),
    ?assertEqual(AllActions, simplify_logger_time(erldist_filter_nif:channel_recv(Channel, AllPackets))),
    _ = C3,
    ok = erldist_filter_nif:channel_close(Channel),
    ok = config_set_default(),
    ok.

-spec logging_spawn_request_test(Config, DFlags, SendOptions) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options().
logging_spawn_request_test(_Config, DFlags, SendOptions) ->
    ConfigMap = #{
        compact_fragments => true,
        deep_packet_inspection => true,
        logging => true,
        redirect_dist_operations => false
    },
    ok = config_set(ConfigMap),
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(2),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    ControlA = spawn_request_noop(0, 0, 0),
    ControlB = spawn_request_noop(1, 1, 1),
    ControlC = spawn_request_noop(2, 2, 2),
    LargeBin = binary:copy(<<"a">>, 255),
    Payload = [{LargeBin, A, B, C}],
    {ok, P0, C0} = vedf_channel:send_encode(C0, ControlA, vterm:expand(Payload), SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, ControlB, vterm:expand(Payload), SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, ControlC, vterm:expand(Payload), SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    AllPackets = lists:concat([P0, P1, P2]),
    AllActions0 = lists:concat([A1, A2, A3]),
    {AllActions, [_Log_A, Log_B, Log_C]} = extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_B, Control_B, Payload_B}}} = Log_B,
    {log, _, {_, {Sysname, Atoms_C, Control_C, Payload_C}}} = Log_C,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel, AllPackets)),
    _ = C3,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    ?assertMatch(
        {2, 1, [{_, {Sysname, Atoms_B, Control_B, Payload_B}}, {_, {Sysname, Atoms_C, Control_C, Payload_C}}]},
        erldist_filter_nif:logger_recv(Logger)
    ),
    ok = erldist_filter_nif:channel_close(Channel),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

%%%=============================================================================
%%% Test Cases
%%%=============================================================================

-spec compact_fragments_fragment_spawn_request_test() -> erldist_filter_test:testcase_info().
compact_fragments_fragment_spawn_request_test() ->
    [
        {doc, "Tests sending multiple fragment packets to erldist_filter_nif and that compact_fragments works"},
        {timetrap, {seconds, 60}}
    ].

-spec compact_fragments_fragment_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
compact_fragments_fragment_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    compact_fragments_spawn_request_test(Config, DFlags, SendOptions).

-spec compact_fragments_normal_spawn_request_test() -> erldist_filter_test:testcase_info().
compact_fragments_normal_spawn_request_test() ->
    [
        {doc, "Tests sending multiple normal packets to erldist_filter_nif and that compact_fragments works"},
        {timetrap, {seconds, 60}}
    ].

-spec compact_fragments_normal_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
compact_fragments_normal_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    compact_fragments_spawn_request_test(Config, DFlags, SendOptions).

-spec compact_fragments_pass_through_spawn_request_test() -> erldist_filter_test:testcase_info().
compact_fragments_pass_through_spawn_request_test() ->
    [
        {doc, "Tests sending multiple pass-through packets to erldist_filter_nif and that compact_fragments works"},
        {timetrap, {seconds, 60}}
    ].

-spec compact_fragments_pass_through_spawn_request_test(Config :: ct_suite:ct_config()) ->
    erldist_filter_test:testcase().
compact_fragments_pass_through_spawn_request_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    compact_fragments_spawn_request_test(Config, DFlags, SendOptions).

-spec logging_fragment_spawn_request_test() -> erldist_filter_test:testcase_info().
logging_fragment_spawn_request_test() ->
    [
        {doc, "Tests sending multiple fragment packets to erldist_filter_nif and that logging works"},
        {timetrap, {seconds, 60}}
    ].

-spec logging_fragment_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
logging_fragment_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    logging_spawn_request_test(Config, DFlags, SendOptions).

-spec logging_normal_spawn_request_test() -> erldist_filter_test:testcase_info().
logging_normal_spawn_request_test() ->
    [
        {doc, "Tests sending multiple normal packets to erldist_filter_nif and that logging works"},
        {timetrap, {seconds, 60}}
    ].

-spec logging_normal_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
logging_normal_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    logging_spawn_request_test(Config, DFlags, SendOptions).

-spec logging_pass_through_spawn_request_test() -> erldist_filter_test:testcase_info().
logging_pass_through_spawn_request_test() ->
    [
        {doc, "Tests sending multiple pass-through packets to erldist_filter_nif and that logging works"},
        {timetrap, {seconds, 60}}
    ].

-spec logging_pass_through_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
logging_pass_through_spawn_request_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    logging_spawn_request_test(Config, DFlags, SendOptions).

-spec traffic_drop_fragment_exit_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_exit_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all exit type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_exit_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_exit_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_exit_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_exit2_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_exit2_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all exit2 type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_exit2_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_exit2_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_exit2_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_group_leader_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_group_leader_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all group_leader type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_group_leader_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_group_leader_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_group_leader_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_link_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_link_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all link type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_link_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_link_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_link_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_monitor_related_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_monitor_related_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all monitor_related type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_monitor_related_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_monitor_related_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_monitor_related_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_send_to_alias_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_send_to_alias_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all send_to_alias type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_send_to_alias_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_send_to_alias_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_send_to_alias_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_send_to_name_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_send_to_name_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all send_to_name type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_send_to_name_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_send_to_name_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_send_to_name_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_send_to_pid_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_send_to_pid_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all send_to_pid type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_send_to_pid_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_send_to_pid_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_send_to_pid_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_spawn_reply_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_spawn_reply_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all spawn_reply type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_spawn_reply_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_spawn_reply_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_spawn_reply_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_spawn_request_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_spawn_request_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all spawn_request type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_spawn_request_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_fragment_unlink_test() -> erldist_filter_test:testcase_info().
traffic_drop_fragment_unlink_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that dropping works for all unlink type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_fragment_unlink_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_fragment_unlink_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_unlink_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_exit_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_exit_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all exit type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_exit_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_exit_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_exit_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_exit2_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_exit2_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all exit2 type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_exit2_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_exit2_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_exit2_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_group_leader_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_group_leader_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all group_leader type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_group_leader_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_group_leader_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_group_leader_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_link_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_link_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all link type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_link_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_link_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_link_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_monitor_related_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_monitor_related_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all monitor_related type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_monitor_related_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_monitor_related_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_monitor_related_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_send_to_alias_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_send_to_alias_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all send_to_alias type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_send_to_alias_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_send_to_alias_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_send_to_alias_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_send_to_name_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_send_to_name_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all send_to_name type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_send_to_name_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_send_to_name_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_send_to_name_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_send_to_pid_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_send_to_pid_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all send_to_pid type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_send_to_pid_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_send_to_pid_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_send_to_pid_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_spawn_reply_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_spawn_reply_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all spawn_reply type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_spawn_reply_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_spawn_reply_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_spawn_reply_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_spawn_request_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_spawn_request_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all spawn_request type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_spawn_request_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_normal_unlink_test() -> erldist_filter_test:testcase_info().
traffic_drop_normal_unlink_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that dropping works for all unlink type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_normal_unlink_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_normal_unlink_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_unlink_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_exit_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_exit_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all exit type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_exit_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_exit_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_exit_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_exit2_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_exit2_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all exit2 type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_exit2_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_exit2_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_exit2_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_group_leader_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_group_leader_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all group_leader type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_group_leader_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_group_leader_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_group_leader_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_link_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_link_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all link type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_link_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_link_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_link_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_monitor_related_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_monitor_related_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all monitor_related type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_monitor_related_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_monitor_related_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_monitor_related_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_send_to_alias_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_send_to_alias_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all send_to_alias type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_send_to_alias_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_send_to_alias_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_send_to_alias_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_send_to_name_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_send_to_name_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all send_to_name type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_send_to_name_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_send_to_name_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_send_to_name_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_send_to_pid_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_send_to_pid_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all send_to_pid type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_send_to_pid_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_send_to_pid_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_send_to_pid_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_spawn_reply_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_spawn_reply_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all spawn_reply type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_spawn_reply_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_spawn_reply_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_spawn_reply_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_spawn_request_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_spawn_request_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all spawn_request type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_spawn_request_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_spawn_request_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_drop_pass_through_unlink_test() -> erldist_filter_test:testcase_info().
traffic_drop_pass_through_unlink_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that dropping works for all unlink type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_drop_pass_through_unlink_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_drop_pass_through_unlink_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_unlink_test(Config, DFlags, SendOptions, #{redirect_dist_operations => false}).

-spec traffic_redirect_fragment_exit_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_exit_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all exit type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_exit_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_exit_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_exit_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_exit2_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_exit2_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all exit2 type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_exit2_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_exit2_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_exit2_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_group_leader_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_group_leader_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all group_leader type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_group_leader_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_group_leader_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_group_leader_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_link_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_link_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all link type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_link_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_link_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_link_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_monitor_related_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_monitor_related_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all monitor_related type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_monitor_related_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_monitor_related_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_monitor_related_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_send_to_alias_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_send_to_alias_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all send_to_alias type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_send_to_alias_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_send_to_alias_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_send_to_alias_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_send_to_name_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_send_to_name_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all send_to_name type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_send_to_name_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_send_to_name_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_send_to_name_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_send_to_pid_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_send_to_pid_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all send_to_pid type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_send_to_pid_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_send_to_pid_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_send_to_pid_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_spawn_reply_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_spawn_reply_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all spawn_reply type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_spawn_reply_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_spawn_reply_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_spawn_reply_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_spawn_request_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_spawn_request_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all spawn_request type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_spawn_request_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_fragment_unlink_test() -> erldist_filter_test:testcase_info().
traffic_redirect_fragment_unlink_test() ->
    [
        {doc,
            "Tests sending fragment traffic to erldist_filter_nif and checks that redirecting works for all unlink type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_fragment_unlink_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_fragment_unlink_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'fragment',
        fragment_size => 16#7F
    },
    dpi_unlink_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_exit_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_exit_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all exit type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_exit_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_exit_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_exit_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_exit2_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_exit2_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all exit2 type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_exit2_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_exit2_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_exit2_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_group_leader_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_group_leader_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all group_leader type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_group_leader_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_group_leader_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_group_leader_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_link_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_link_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all link type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_link_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_link_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_link_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_monitor_related_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_monitor_related_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all monitor_related type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_monitor_related_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_monitor_related_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_monitor_related_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_send_to_alias_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_send_to_alias_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all send_to_alias type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_send_to_alias_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_send_to_alias_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_send_to_alias_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_send_to_name_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_send_to_name_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all send_to_name type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_send_to_name_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_send_to_name_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_send_to_name_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_send_to_pid_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_send_to_pid_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all send_to_pid type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_send_to_pid_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_send_to_pid_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_send_to_pid_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_spawn_reply_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_spawn_reply_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all spawn_reply type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_spawn_reply_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_spawn_reply_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_spawn_reply_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_spawn_request_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_spawn_request_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all spawn_request type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_spawn_request_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_spawn_request_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_spawn_request_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_normal_unlink_test() -> erldist_filter_test:testcase_info().
traffic_redirect_normal_unlink_test() ->
    [
        {doc,
            "Tests sending normal traffic to erldist_filter_nif and checks that redirecting works for all unlink type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_normal_unlink_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_normal_unlink_test(Config) ->
    #{'DFLAG_DIST_DEFAULT' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'normal'
    },
    dpi_unlink_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_exit_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_exit_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all exit type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_exit_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_exit_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_exit_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_exit2_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_exit2_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all exit2 type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_exit2_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_exit2_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_exit2_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_group_leader_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_group_leader_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all group_leader type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_group_leader_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_group_leader_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_group_leader_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_link_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_link_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all link type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_link_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_link_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_link_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_monitor_related_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_monitor_related_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all monitor_related type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_monitor_related_test(Config :: ct_suite:ct_config()) ->
    erldist_filter_test:testcase().
traffic_redirect_pass_through_monitor_related_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_monitor_related_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_send_to_alias_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_send_to_alias_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all send_to_alias type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_send_to_alias_test(Config :: ct_suite:ct_config()) ->
    erldist_filter_test:testcase().
traffic_redirect_pass_through_send_to_alias_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_send_to_alias_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_send_to_name_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_send_to_name_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all send_to_name type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_send_to_name_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_send_to_name_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_send_to_name_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_send_to_pid_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_send_to_pid_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all send_to_pid type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_send_to_pid_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_send_to_pid_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_send_to_pid_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_spawn_reply_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_spawn_reply_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all spawn_reply type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_spawn_reply_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_spawn_reply_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_spawn_reply_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_spawn_request_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_spawn_request_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all spawn_request type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_spawn_request_test(Config :: ct_suite:ct_config()) ->
    erldist_filter_test:testcase().
traffic_redirect_pass_through_spawn_request_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_spawn_request_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

-spec traffic_redirect_pass_through_unlink_test() -> erldist_filter_test:testcase_info().
traffic_redirect_pass_through_unlink_test() ->
    [
        {doc,
            "Tests sending pass-through traffic to erldist_filter_nif and checks that redirecting works for all unlink type operations"},
        {timetrap, {seconds, 60}}
    ].

-spec traffic_redirect_pass_through_unlink_test(Config :: ct_suite:ct_config()) -> erldist_filter_test:testcase().
traffic_redirect_pass_through_unlink_test(Config) ->
    #{'DFLAG_DIST_MANDATORY' := DFlags} = erldist_filter_nif:distribution_flags(),
    SendOptions = #{
        header_mode => 'pass_through'
    },
    dpi_unlink_test(Config, DFlags, SendOptions, #{redirect_dist_operations => true}).

%%%=============================================================================
%%% Deep Packet Inspection Test Cases
%%%=============================================================================

-spec dpi_exit_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_exit_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(4),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    Control0 = dop_exit_noop(0, 0, 0),
    Control1 = dop_exit_noop(1, 0, 0),
    Control2 = dop_exit_tt_noop(2, 0, 0, Token),
    Control3 = dop_payload_exit_noop(3, 0, 0),
    Control4 = dop_payload_exit_tt_noop(4, 0, 0, Token),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    {ok, P3, C3} = vedf_channel:send_encode(C3, Control3, vterm:expand(NestedPayload), SendOptions),
    {ok, A4, C4} = vedf_channel:recv(C3, P3),
    {ok, P4, C4} = vedf_channel:send_encode(C4, Control4, vterm:expand(NestedPayload), SendOptions),
    {ok, A5, C5} = vedf_channel:recv(C4, P4),
    AllPackets = lists:concat([P0, P1, P2, P3, P4]),
    AllActions0 = lists:concat([A1, A2, A3, A4, A5]),
    {AllActions, [_Log_0, Log_1, Log_2, Log_3, Log_4]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    {log, _, {_, {Sysname, Atoms_2, Control_2, Payload_2}}} = Log_2,
    {log, _, {_, {Sysname, Atoms_3, Control_3, Payload_3}}} = Log_3,
    {log, _, {_, {Sysname, Atoms_4, Control_4, Payload_4}}} = Log_4,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C5,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({4, 1, [_, _, _, _]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1,
        LogEvent_2,
        LogEvent_3,
        LogEvent_4
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual({2, {Sysname, Atoms_2, Control_2, Payload_2}}, LogEvent_2),
    ?assertEqual({3, {Sysname, Atoms_3, Control_3, Payload_3}}, LogEvent_3),
    ?assertEqual({4, {Sysname, Atoms_4, Control_4, Payload_4}}, LogEvent_4),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_exit2_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_exit2_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(12),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    Control0 = dop_exit2_noop(0, 0, 0),
    Control1 = dop_exit2_noop(1, 0, 0),
    Control2 = dop_exit2_tt_noop(2, 0, 0, Token),
    Control3 = dop_payload_exit2_noop(3, 0, 0),
    Control4 = dop_payload_exit2_tt_noop(4, 0, 0, Token),
    Control5 = dop_altact_sig_send_noop(5, 0, 0, [exit], none),
    Control6 = dop_altact_sig_send_noop(6, 0, 0, [alias, exit], none),
    Control7 = dop_altact_sig_send_noop(7, 0, 0, [token, exit], {some, Token}),
    Control8 = dop_altact_sig_send_noop(8, 0, 0, [token, alias, exit], {some, Token}),
    Control9 = dop_altact_sig_send_noop(9, 0, 0, [prio, exit], none),
    Control10 = dop_altact_sig_send_noop(10, 0, 0, [prio, alias, exit], none),
    Control11 = dop_altact_sig_send_noop(11, 0, 0, [prio, token, exit], {some, Token}),
    Control12 = dop_altact_sig_send_noop(12, 0, 0, [prio, token, alias, exit], {some, Token}),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    {ok, P3, C3} = vedf_channel:send_encode(C3, Control3, vterm:expand(NestedPayload), SendOptions),
    {ok, A4, C4} = vedf_channel:recv(C3, P3),
    {ok, P4, C4} = vedf_channel:send_encode(C4, Control4, vterm:expand(NestedPayload), SendOptions),
    {ok, A5, C5} = vedf_channel:recv(C4, P4),
    {ok, P5, C5} = vedf_channel:send_encode(C5, Control5, vterm:expand(NestedPayload), SendOptions),
    {ok, A6, C6} = vedf_channel:recv(C5, P5),
    {ok, P6, C6} = vedf_channel:send_encode(C6, Control6, vterm:expand(NestedPayload), SendOptions),
    {ok, A7, C7} = vedf_channel:recv(C6, P6),
    {ok, P7, C7} = vedf_channel:send_encode(C7, Control7, vterm:expand(NestedPayload), SendOptions),
    {ok, A8, C8} = vedf_channel:recv(C7, P7),
    {ok, P8, C8} = vedf_channel:send_encode(C8, Control8, vterm:expand(NestedPayload), SendOptions),
    {ok, A9, C9} = vedf_channel:recv(C8, P8),
    {ok, P9, C9} = vedf_channel:send_encode(C9, Control9, vterm:expand(NestedPayload), SendOptions),
    {ok, A10, C10} = vedf_channel:recv(C9, P9),
    {ok, P10, C10} = vedf_channel:send_encode(C10, Control10, vterm:expand(NestedPayload), SendOptions),
    {ok, A11, C11} = vedf_channel:recv(C10, P10),
    {ok, P11, C11} = vedf_channel:send_encode(C11, Control11, vterm:expand(NestedPayload), SendOptions),
    {ok, A12, C12} = vedf_channel:recv(C11, P11),
    {ok, P12, C12} = vedf_channel:send_encode(C12, Control12, vterm:expand(NestedPayload), SendOptions),
    {ok, A13, C13} = vedf_channel:recv(C12, P12),
    AllPackets = lists:concat([P0, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12]),
    AllActions0 = lists:concat([A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]),
    {AllActions, [_Log_0, Log_1, Log_2, Log_3, Log_4, Log_5, Log_6, Log_7, Log_8, Log_9, Log_10, Log_11, Log_12]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    {log, _, {_, {Sysname, Atoms_2, Control_2, Payload_2}}} = Log_2,
    {log, _, {_, {Sysname, Atoms_3, Control_3, Payload_3}}} = Log_3,
    {log, _, {_, {Sysname, Atoms_4, Control_4, Payload_4}}} = Log_4,
    {log, _, {_, {Sysname, Atoms_5, Control_5, Payload_5}}} = Log_5,
    {log, _, {_, {Sysname, Atoms_6, Control_6, Payload_6}}} = Log_6,
    {log, _, {_, {Sysname, Atoms_7, Control_7, Payload_7}}} = Log_7,
    {log, _, {_, {Sysname, Atoms_8, Control_8, Payload_8}}} = Log_8,
    {log, _, {_, {Sysname, Atoms_9, Control_9, Payload_9}}} = Log_9,
    {log, _, {_, {Sysname, Atoms_10, Control_10, Payload_10}}} = Log_10,
    {log, _, {_, {Sysname, Atoms_11, Control_11, Payload_11}}} = Log_11,
    {log, _, {_, {Sysname, Atoms_12, Control_12, Payload_12}}} = Log_12,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C13,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({12, 1, [_, _, _, _, _, _, _, _, _, _, _, _]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1,
        LogEvent_2,
        LogEvent_3,
        LogEvent_4,
        LogEvent_5,
        LogEvent_6,
        LogEvent_7,
        LogEvent_8,
        LogEvent_9,
        LogEvent_10,
        LogEvent_11,
        LogEvent_12
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual({2, {Sysname, Atoms_2, Control_2, Payload_2}}, LogEvent_2),
    ?assertEqual({3, {Sysname, Atoms_3, Control_3, Payload_3}}, LogEvent_3),
    ?assertEqual({4, {Sysname, Atoms_4, Control_4, Payload_4}}, LogEvent_4),
    ?assertEqual({5, {Sysname, Atoms_5, Control_5, Payload_5}}, LogEvent_5),
    ?assertEqual({6, {Sysname, Atoms_6, Control_6, Payload_6}}, LogEvent_6),
    ?assertEqual({7, {Sysname, Atoms_7, Control_7, Payload_7}}, LogEvent_7),
    ?assertEqual({8, {Sysname, Atoms_8, Control_8, Payload_8}}, LogEvent_8),
    ?assertEqual({9, {Sysname, Atoms_9, Control_9, Payload_9}}, LogEvent_9),
    ?assertEqual({10, {Sysname, Atoms_10, Control_10, Payload_10}}, LogEvent_10),
    ?assertEqual({11, {Sysname, Atoms_11, Control_11, Payload_11}}, LogEvent_11),
    ?assertEqual({12, {Sysname, Atoms_12, Control_12, Payload_12}}, LogEvent_12),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_group_leader_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_group_leader_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(1),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    _ = Token,
    _ = NestedPayload,
    Control0 = dop_group_leader_noop(0, 0, 0),
    Control1 = dop_group_leader_noop(1, 0, 0),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    AllPackets = lists:concat([P0, P1]),
    AllActions0 = lists:concat([A1, A2]),
    {AllActions, [_Log_0, Log_1]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C2,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({1, 1, [_]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_link_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_link_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(1),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    _ = Token,
    _ = NestedPayload,
    Control0 = dop_link_noop(0, 0, 0),
    Control1 = dop_link_noop(1, 0, 0),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    AllPackets = lists:concat([P0, P1]),
    AllActions0 = lists:concat([A1, A2]),
    {AllActions, [_Log_0, Log_1]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C2,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({1, 1, [_]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_monitor_related_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_monitor_related_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(0),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    _ = Token,
    Control0 = dop_monitor_p_noop(0, 0, 0),
    Control1 = dop_monitor_p_noop(1, 0, 0),
    Control2 = dop_demonitor_p_noop(2, 0, 0),
    Control3 = dop_monitor_p_exit_noop(3, 0, 0),
    Control4 = dop_payload_monitor_p_exit_noop(4, 0, 0),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    {ok, P3, C3} = vedf_channel:send_encode(C3, Control3, SendOptions),
    {ok, A4, C4} = vedf_channel:recv(C3, P3),
    {ok, P4, C4} = vedf_channel:send_encode(C4, Control4, vterm:expand(NestedPayload), SendOptions),
    {ok, A5, C5} = vedf_channel:recv(C4, P4),
    AllPackets = lists:concat([P0, P1, P2, P3, P4]),
    AllActions0 = lists:concat([A1, A2, A3, A4, A5]),
    {AllActions, []} =
        extract_action_logs(AllActions0, [], []),
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C5,
    _ = LoggerSelectHandle,
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_send_to_alias_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_send_to_alias_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(7),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    PayloadSendSystemCall = {system, [], NestedPayload},
    PayloadSendGenCall = {'$gen_call', [], NestedPayload},
    Control0 = dop_alias_send_noop(0, 0, 0),
    Control1 = dop_alias_send_noop(1, 0, 0),
    Control2 = dop_alias_send_tt_noop(2, 0, 0, Token),
    Control3 = dop_alias_send_tt_noop(3, 0, 0, Token),
    Control4 = dop_alias_send_noop(4, 0, 0),
    Control5 = dop_altact_sig_send_noop(5, 0, 0, [alias], none),
    Control6 = dop_altact_sig_send_noop(6, 0, 0, [token, alias], {some, Token}),
    Control7 = dop_altact_sig_send_noop(7, 0, 0, [prio, alias], none),
    Control8 = dop_altact_sig_send_noop(8, 0, 0, [prio, token, alias], {some, Token}),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    {ok, P3, C3} = vedf_channel:send_encode(C3, Control3, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A4, C4} = vedf_channel:recv(C3, P3),
    {ok, P4, C4} = vedf_channel:send_encode(C4, Control4, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A5, C5} = vedf_channel:recv(C4, P4),
    {ok, P5, C5} = vedf_channel:send_encode(C5, Control5, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A6, C6} = vedf_channel:recv(C5, P5),
    {ok, P6, C6} = vedf_channel:send_encode(C6, Control6, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A7, C7} = vedf_channel:recv(C6, P6),
    {ok, P7, C7} = vedf_channel:send_encode(C7, Control7, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A8, C8} = vedf_channel:recv(C7, P7),
    {ok, P8, C8} = vedf_channel:send_encode(C8, Control8, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A9, C9} = vedf_channel:recv(C8, P8),
    AllPackets = lists:concat([P0, P1, P2, P3, P4, P5, P6, P7, P8]),
    AllActions0 = lists:concat([A1, A2, A3, A4, A5, A6, A7, A8, A9]),
    {AllActions, [Log_0, Log_2, Log_4, Log_5, Log_6, Log_7, Log_8]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_0, Control_0, Payload_0}}} = Log_0,
    {log, _, {_, {Sysname, Atoms_2, Control_2, Payload_2}}} = Log_2,
    {log, _, {_, {Sysname, Atoms_4, Control_4, Payload_4}}} = Log_4,
    {log, _, {_, {Sysname, Atoms_5, Control_5, Payload_5}}} = Log_5,
    {log, _, {_, {Sysname, Atoms_6, Control_6, Payload_6}}} = Log_6,
    {log, _, {_, {Sysname, Atoms_7, Control_7, Payload_7}}} = Log_7,
    {log, _, {_, {Sysname, Atoms_8, Control_8, Payload_8}}} = Log_8,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C9,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({7, 0, [_, _, _, _, _, _, _]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_0,
        LogEvent_2,
        LogEvent_4,
        LogEvent_5,
        LogEvent_6,
        LogEvent_7,
        LogEvent_8
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_0, Control_0, Payload_0}}, LogEvent_0),
    ?assertEqual({2, {Sysname, Atoms_2, Control_2, Payload_2}}, LogEvent_2),
    ?assertEqual({3, {Sysname, Atoms_4, Control_4, Payload_4}}, LogEvent_4),
    ?assertEqual({4, {Sysname, Atoms_5, Control_5, Payload_5}}, LogEvent_5),
    ?assertEqual({5, {Sysname, Atoms_6, Control_6, Payload_6}}, LogEvent_6),
    ?assertEqual({6, {Sysname, Atoms_7, Control_7, Payload_7}}, LogEvent_7),
    ?assertEqual({7, {Sysname, Atoms_8, Control_8, Payload_8}}, LogEvent_8),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_send_to_name_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_send_to_name_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(9),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    PayloadSendSystemCall = {system, [], NestedPayload},
    PayloadSendGenCall = {'$gen_call', [], NestedPayload},
    PayloadSendGenCallIsAuth = {'$gen_call', [], {is_auth, []}},
    PayloadSendFeaturesRequest = {[], features_request},
    PayloadSendFeaturesReply = {features_reply, [], []},
    AtomNetKernel = vterm_small_atom_utf8_ext:new(10, <<"net_kernel">>),
    AtomRex = vterm_small_atom_utf8_ext:new(3, <<"rex">>),
    AtomTimerServer = vterm_small_atom_utf8_ext:new(12, <<"timer_server">>),
    Control0 = dop_reg_send_noop(0, 0, 0, AtomNetKernel),
    Control1 = dop_reg_send_noop(1, 0, 0, AtomNetKernel),
    Control2 = dop_reg_send_noop(2, 0, 0, AtomNetKernel),
    Control3 = dop_reg_send_tt_noop(3, 0, 0, AtomNetKernel, Token),
    Control4 = dop_reg_send_tt_noop(4, 0, 0, AtomNetKernel, Token),
    Control5 = dop_reg_send_noop(5, 0, 0, AtomRex),
    Control6 = dop_reg_send_noop(6, 0, 0, AtomRex),
    Control7 = dop_reg_send_tt_noop(7, 0, 0, AtomRex, Token),
    Control8 = dop_reg_send_tt_noop(8, 0, 0, AtomRex, Token),
    Control9 = dop_altact_sig_send_noop(9, 0, 0, [name], AtomTimerServer, none),
    Control10 = dop_altact_sig_send_noop(10, 0, 0, [token, name], AtomTimerServer, {some, Token}),
    Control11 = dop_altact_sig_send_noop(11, 0, 0, [prio, name], AtomTimerServer, none),
    Control12 = dop_altact_sig_send_noop(12, 0, 0, [prio, token, name], AtomTimerServer, {some, Token}),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, vterm:expand(PayloadSendGenCallIsAuth), SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    {ok, P3, C3} = vedf_channel:send_encode(C3, Control3, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A4, C4} = vedf_channel:recv(C3, P3),
    {ok, P4, C4} = vedf_channel:send_encode(C4, Control4, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A5, C5} = vedf_channel:recv(C4, P4),
    {ok, P5, C5} = vedf_channel:send_encode(C5, Control5, vterm:expand(PayloadSendFeaturesRequest), SendOptions),
    {ok, A6, C6} = vedf_channel:recv(C5, P5),
    {ok, P6, C6} = vedf_channel:send_encode(C6, Control6, vterm:expand(PayloadSendFeaturesReply), SendOptions),
    {ok, A7, C7} = vedf_channel:recv(C6, P6),
    {ok, P7, C7} = vedf_channel:send_encode(C7, Control7, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A8, C8} = vedf_channel:recv(C7, P7),
    {ok, P8, C8} = vedf_channel:send_encode(C8, Control8, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A9, C9} = vedf_channel:recv(C8, P8),
    {ok, P9, C9} = vedf_channel:send_encode(C9, Control9, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A10, C10} = vedf_channel:recv(C9, P9),
    {ok, P10, C10} = vedf_channel:send_encode(C10, Control10, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A11, C11} = vedf_channel:recv(C10, P10),
    {ok, P11, C11} = vedf_channel:send_encode(C11, Control11, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A12, C12} = vedf_channel:recv(C11, P11),
    {ok, P12, C12} = vedf_channel:send_encode(C12, Control12, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A13, C13} = vedf_channel:recv(C12, P12),
    AllPackets = lists:concat([P0, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12]),
    AllActions0 = lists:concat([A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13]),
    {AllActions, [_Log_0, Log_1, Log_3, Log_4, Log_7, Log_8, Log_9, Log_10, Log_11, Log_12]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    {log, _, {_, {Sysname, Atoms_3, Control_3, Payload_3}}} = Log_3,
    {log, _, {_, {Sysname, Atoms_4, Control_4, Payload_4}}} = Log_4,
    {log, _, {_, {Sysname, Atoms_7, Control_7, Payload_7}}} = Log_7,
    {log, _, {_, {Sysname, Atoms_8, Control_8, Payload_8}}} = Log_8,
    {log, _, {_, {Sysname, Atoms_9, Control_9, Payload_9}}} = Log_9,
    {log, _, {_, {Sysname, Atoms_10, Control_10, Payload_10}}} = Log_10,
    {log, _, {_, {Sysname, Atoms_11, Control_11, Payload_11}}} = Log_11,
    {log, _, {_, {Sysname, Atoms_12, Control_12, Payload_12}}} = Log_12,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C13,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({9, 1, [_, _, _, _, _, _, _, _, _]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1,
        LogEvent_3,
        LogEvent_4,
        LogEvent_7,
        LogEvent_8,
        LogEvent_9,
        LogEvent_10,
        LogEvent_11,
        LogEvent_12
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual({2, {Sysname, Atoms_3, Control_3, Payload_3}}, LogEvent_3),
    ?assertEqual({3, {Sysname, Atoms_4, Control_4, Payload_4}}, LogEvent_4),
    ?assertEqual({4, {Sysname, Atoms_7, Control_7, Payload_7}}, LogEvent_7),
    ?assertEqual({5, {Sysname, Atoms_8, Control_8, Payload_8}}, LogEvent_8),
    ?assertEqual({6, {Sysname, Atoms_9, Control_9, Payload_9}}, LogEvent_9),
    ?assertEqual({7, {Sysname, Atoms_10, Control_10, Payload_10}}, LogEvent_10),
    ?assertEqual({8, {Sysname, Atoms_11, Control_11, Payload_11}}, LogEvent_11),
    ?assertEqual({9, {Sysname, Atoms_12, Control_12, Payload_12}}, LogEvent_12),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_send_to_pid_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_send_to_pid_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(10),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    PayloadSendSystemCall = {system, [], NestedPayload},
    PayloadSendExit = {'EXIT', [], []},
    PayloadSendGenCast = {'$gen_cast', {try_again_restart, []}},
    PayloadSendGenCall = {'$gen_call', [], NestedPayload},
    PayloadSendGenCallStartChild = {'$gen_call', [], {start_child, []}},
    PayloadSendIoRequest = {io_request, [], [], {put_chars, unicode, remote, rce, []}},
    PayloadSendIoReply = {io_reply, [], []},
    Control0 = dop_send_noop(0, 0, 0),
    Control1 = dop_send_noop(1, 0, 0),
    Control2 = dop_send_noop(2, 0, 0),
    Control3 = dop_send_tt_noop(3, 0, 0, Token),
    Control4 = dop_send_tt_noop(4, 0, 0, Token),
    Control5 = dop_send_sender_noop(5, 0, 0),
    Control6 = dop_send_sender_noop(6, 0, 0),
    Control7 = dop_send_sender_tt_noop(7, 0, 0, Token),
    Control8 = dop_send_sender_tt_noop(8, 0, 0, Token),
    Control9 = dop_send_sender_noop(9, 0, 0),
    Control10 = dop_send_sender_tt_noop(10, 0, 0, Token),
    Control11 = dop_altact_sig_send_noop(11, 0, 0, [], none),
    Control12 = dop_altact_sig_send_noop(12, 0, 0, [token], {some, Token}),
    Control13 = dop_altact_sig_send_noop(13, 0, 0, [prio], none),
    Control14 = dop_altact_sig_send_noop(14, 0, 0, [prio, token], {some, Token}),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    {ok, P3, C3} = vedf_channel:send_encode(C3, Control3, vterm:expand(PayloadSendExit), SendOptions),
    {ok, A4, C4} = vedf_channel:recv(C3, P3),
    {ok, P4, C4} = vedf_channel:send_encode(C4, Control4, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A5, C5} = vedf_channel:recv(C4, P4),
    {ok, P5, C5} = vedf_channel:send_encode(C5, Control5, vterm:expand(PayloadSendGenCast), SendOptions),
    {ok, A6, C6} = vedf_channel:recv(C5, P5),
    {ok, P6, C6} = vedf_channel:send_encode(C6, Control6, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A7, C7} = vedf_channel:recv(C6, P6),
    {ok, P7, C7} = vedf_channel:send_encode(C7, Control7, vterm:expand(PayloadSendGenCallStartChild), SendOptions),
    {ok, A8, C8} = vedf_channel:recv(C7, P7),
    {ok, P8, C8} = vedf_channel:send_encode(C8, Control8, vterm:expand(PayloadSendGenCall), SendOptions),
    {ok, A9, C9} = vedf_channel:recv(C8, P8),
    {ok, P9, C9} = vedf_channel:send_encode(C9, Control9, vterm:expand(PayloadSendIoRequest), SendOptions),
    {ok, A10, C10} = vedf_channel:recv(C9, P9),
    {ok, P10, C10} = vedf_channel:send_encode(C10, Control10, vterm:expand(PayloadSendIoReply), SendOptions),
    {ok, A11, C11} = vedf_channel:recv(C10, P10),
    {ok, P11, C11} = vedf_channel:send_encode(C11, Control11, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A12, C12} = vedf_channel:recv(C11, P11),
    {ok, P12, C12} = vedf_channel:send_encode(C12, Control12, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A13, C13} = vedf_channel:recv(C12, P12),
    {ok, P13, C13} = vedf_channel:send_encode(C13, Control13, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A14, C14} = vedf_channel:recv(C13, P13),
    {ok, P14, C14} = vedf_channel:send_encode(C14, Control14, vterm:expand(PayloadSendSystemCall), SendOptions),
    {ok, A15, C15} = vedf_channel:recv(C14, P14),
    AllPackets = lists:concat([P0, P1, P2, P3, P4, P5, P6, P7, P8, P9, P10, P11, P12, P13, P14]),
    AllActions0 = lists:concat([A1, A2, A3, A4, A5, A6, A7, A8, A9, A10, A11, A12, A13, A14, A15]),
    {AllActions, [_Log_0, Log_1, Log_3, Log_5, Log_7, Log_9, Log_10, Log_11, Log_12, Log_13, Log_14]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    {log, _, {_, {Sysname, Atoms_3, Control_3, Payload_3}}} = Log_3,
    {log, _, {_, {Sysname, Atoms_5, Control_5, Payload_5}}} = Log_5,
    {log, _, {_, {Sysname, Atoms_7, Control_7, Payload_7}}} = Log_7,
    {log, _, {_, {Sysname, Atoms_9, Control_9, Payload_9}}} = Log_9,
    {log, _, {_, {Sysname, Atoms_10, Control_10, Payload_10}}} = Log_10,
    {log, _, {_, {Sysname, Atoms_11, Control_11, Payload_11}}} = Log_11,
    {log, _, {_, {Sysname, Atoms_12, Control_12, Payload_12}}} = Log_12,
    {log, _, {_, {Sysname, Atoms_13, Control_13, Payload_13}}} = Log_13,
    {log, _, {_, {Sysname, Atoms_14, Control_14, Payload_14}}} = Log_14,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C15,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({10, 1, [_, _, _, _, _, _, _, _, _, _]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1,
        LogEvent_3,
        LogEvent_5,
        LogEvent_7,
        LogEvent_9,
        LogEvent_10,
        LogEvent_11,
        LogEvent_12,
        LogEvent_13,
        LogEvent_14
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual({2, {Sysname, Atoms_3, Control_3, Payload_3}}, LogEvent_3),
    ?assertEqual({3, {Sysname, Atoms_5, Control_5, Payload_5}}, LogEvent_5),
    ?assertEqual({4, {Sysname, Atoms_7, Control_7, Payload_7}}, LogEvent_7),
    ?assertEqual({5, {Sysname, Atoms_9, Control_9, Payload_9}}, LogEvent_9),
    ?assertEqual({6, {Sysname, Atoms_10, Control_10, Payload_10}}, LogEvent_10),
    ?assertEqual({7, {Sysname, Atoms_11, Control_11, Payload_11}}, LogEvent_11),
    ?assertEqual({8, {Sysname, Atoms_12, Control_12, Payload_12}}, LogEvent_12),
    ?assertEqual({9, {Sysname, Atoms_13, Control_13, Payload_13}}, LogEvent_13),
    ?assertEqual({10, {Sysname, Atoms_14, Control_14, Payload_14}}, LogEvent_14),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_spawn_reply_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_spawn_reply_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(0),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    _ = NestedPayload,
    Control0 = dop_spawn_reply_noop(0, 0, 0),
    Control1 = dop_spawn_reply_tt_noop(1, 0, 0, Token),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    AllPackets = lists:concat([P0, P1]),
    AllActions0 = lists:concat([A1, A2]),
    {AllActions, []} =
        extract_action_logs(AllActions0, [], []),
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C2,
    _ = LoggerSelectHandle,
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_spawn_request_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_spawn_request_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(2),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    Control0 = dop_spawn_request_noop(0, 0, 0),
    Control1 = dop_spawn_request_noop(1, 0, 0),
    Control2 = dop_spawn_request_tt_noop(1, 0, 0, Token),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, vterm:expand(NestedPayload), SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, vterm:expand(NestedPayload), SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, vterm:expand(NestedPayload), SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    AllPackets = lists:concat([P0, P1, P2]),
    AllActions0 = lists:concat([A1, A2, A3]),
    {AllActions, [_Log_0, Log_1, Log_2]} =
        extract_action_logs(AllActions0, [], []),
    {log, _, {_, {Sysname, Atoms_1, Control_1, Payload_1}}} = Log_1,
    {log, _, {_, {Sysname, Atoms_2, Control_2, Payload_2}}} = Log_2,
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C3,
    LoggerMessage = first_message_in_mailbox(1000),
    ?assertEqual({'$logger', Logger, select, LoggerSelectHandle}, LoggerMessage),
    LoggerRecv = erldist_filter_nif:logger_recv(Logger),
    ?assertMatch({2, 1, [_, _]}, LoggerRecv),
    {_, _, LoggerEvents0} = LoggerRecv,
    [
        LogEvent_1,
        LogEvent_2
    ] = simplify_logger_events(LoggerEvents0),
    ?assertEqual({1, {Sysname, Atoms_1, Control_1, Payload_1}}, LogEvent_1),
    ?assertEqual({2, {Sysname, Atoms_2, Control_2, Payload_2}}, LogEvent_2),
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

-spec dpi_unlink_test(Config, DFlags, SendOptions, ConfigMap) -> erldist_filter_test:testcase() when
    Config :: ct_suite:ct_config(),
    DFlags :: erldist_filter_nif_types:flag(),
    SendOptions :: vdist_entry_encode:options(),
    ConfigMap :: erldist_filter_nif_types:config_map_set().
dpi_unlink_test(_Config, DFlags, SendOptions, ConfigMap0) ->
    ConfigMap = ConfigMap0#{
        compact_fragments => true, deep_packet_inspection => true, logging => true, otp_name_blocklist => true
    },
    ok = config_set(ConfigMap),
    PacketSize = 4,
    [A, B, C] = [a, b, c],
    Sysname = 'nonode@nohost',
    Channel0 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    Channel1 = erldist_filter_nif:channel_open(PacketSize, Sysname, 0, 0, DFlags),
    C0 = vedf_channel:new(PacketSize, DFlags, ConfigMap#{sysname => Sysname}),
    Token = vterm:expand(<<"token">>),
    LargeBin = binary:copy(<<"a">>, 255),
    NestedPayload = [{LargeBin, A, B, C}],
    ?assertEqual([], erldist_filter_nif:logger_list()),
    _OldCapacity = erldist_filter_nif:logger_set_capacity(0),
    Logger = erldist_filter_nif:logger_open(),
    LoggerSelectHandle = flush_logger(Logger),
    _ = Token,
    _ = NestedPayload,
    Control0 = dop_unlink_noop(0, 0, 0),
    Control1 = dop_unlink_id_noop(1, 0, 0),
    Control2 = dop_unlink_id_ack_noop(2, 0, 0),
    {ok, P0, C0} = vedf_channel:send_encode(C0, Control0, SendOptions),
    {ok, A1, C1} = vedf_channel:recv(C0, P0),
    {ok, P1, C1} = vedf_channel:send_encode(C1, Control1, SendOptions),
    {ok, A2, C2} = vedf_channel:recv(C1, P1),
    {ok, P2, C2} = vedf_channel:send_encode(C2, Control2, SendOptions),
    {ok, A3, C3} = vedf_channel:recv(C2, P2),
    AllPackets = lists:concat([P0, P1, P2]),
    AllActions0 = lists:concat([A1, A2, A3]),
    {AllActions, []} =
        extract_action_logs(AllActions0, [], []),
    ?assertEqual(AllActions, erldist_filter_nif:channel_recv(Channel0, AllPackets)),
    _ = C3,
    _ = LoggerSelectHandle,
    ?assertEqual(
        AllActions, lists:flatten([erldist_filter_nif:channel_recv(Channel1, Packet) || Packet <- AllPackets])
    ),
    ok = erldist_filter_nif:channel_close(Channel1),
    ok = erldist_filter_nif:channel_close(Channel0),
    _ = flush_logger(Logger),
    ok = erldist_filter_nif:logger_close(Logger),
    ok = config_set_default(),
    ok.

%%%=============================================================================
%%% Dist Operation functions
%%%=============================================================================

-spec dop_alias_send_noop(Id, Serial, Creation) -> DopAliasSend when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopAliasSend :: vdist_dop_alias_send:t().
dop_alias_send_noop(Id, Serial, Creation) ->
    EmptyAtom = vterm_atom_utf8_ext:new(0, <<>>),
    FromPid = vterm_new_pid_ext:new(EmptyAtom, Id, Serial, Creation),
    Alias = vterm_newer_reference_ext:new(1, EmptyAtom, Creation, [Id]),
    vdist_dop_alias_send:new(FromPid, Alias).

-spec dop_alias_send_tt_noop(Id, Serial, Creation, Token) -> DopAliasSendTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopAliasSendTT :: vdist_dop_alias_send_tt:t().
dop_alias_send_tt_noop(Id, Serial, Creation, Token) ->
    EmptyAtom = vterm_atom_utf8_ext:new(0, <<>>),
    FromPid = vterm_new_pid_ext:new(EmptyAtom, Id, Serial, Creation),
    Alias = vterm_newer_reference_ext:new(1, EmptyAtom, Creation, [Id]),
    vdist_dop_alias_send_tt:new(FromPid, Alias, Token).

-spec dop_altact_sig_send_noop(Id, Serial, Creation, Flags, OptionToken) -> DopAltactSigSend when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Flags :: vdist_dop_altact_sig_send:flags(),
    OptionToken :: none | {some, Token},
    Token :: vterm:t(),
    DopAltactSigSend :: vdist_dop_altact_sig_send:t().
dop_altact_sig_send_noop(Id, Serial, Creation, Flags, OptionToken) ->
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FlagsList = vdist_dop_altact_sig_send:flags_as_list(Flags),
    FlagsMap = #{Flag => [] || Flag <- FlagsList},
    To =
        case FlagsMap of
            #{exit := _, alias := _} ->
                vterm_newer_reference_ext:new(1, NodeB, Creation, [Id]);
            #{exit := _} ->
                vterm_new_pid_ext:new(NodeB, Id, Serial, Creation);
            #{alias := _} ->
                vterm_newer_reference_ext:new(1, NodeB, Creation, [Id]);
            #{name := _} ->
                vterm_atom_utf8_ext:new(1, <<"c">>);
            #{} ->
                vterm_new_pid_ext:new(NodeB, Id, Serial, Creation)
        end,
    dop_altact_sig_send_noop(Id, Serial, Creation, Flags, To, OptionToken).

-spec dop_altact_sig_send_noop(Id, Serial, Creation, Flags, To, OptionToken) -> DopAltactSigSend when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Flags :: vdist_dop_altact_sig_send:flags(),
    To :: vterm:pid_t() | vterm:reference_t() | vterm:atom_t(),
    OptionToken :: none | {some, Token},
    Token :: vterm:t(),
    DopAltactSigSend :: vdist_dop_altact_sig_send:t().
dop_altact_sig_send_noop(Id, Serial, Creation, Flags, To, OptionToken) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    SenderPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    FlagsVTerm = vdist_dop_altact_sig_send:flags_as_vterm(Flags),
    case OptionToken of
        none ->
            vdist_dop_altact_sig_send:new(FlagsVTerm, SenderPid, To);
        {some, Token} ->
            vdist_dop_altact_sig_send:new(FlagsVTerm, SenderPid, To, Token)
    end.

-spec dop_exit_noop(Id, Serial, Creation) -> DopExit when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopExit :: vdist_dop_exit:t().
dop_exit_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    Reason = vterm_atom_utf8_ext:new(6, <<"killed">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_exit:new(FromPid, ToPid, Reason).

-spec dop_exit_tt_noop(Id, Serial, Creation, Token) -> DopExitTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopExitTT :: vdist_dop_exit_tt:t().
dop_exit_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    Reason = vterm_atom_utf8_ext:new(6, <<"killed">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_exit_tt:new(FromPid, ToPid, Token, Reason).

-spec dop_payload_exit_noop(Id, Serial, Creation) -> DopPayloadExit when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopPayloadExit :: vdist_dop_payload_exit:t().
dop_payload_exit_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_payload_exit:new(FromPid, ToPid).

-spec dop_payload_exit_tt_noop(Id, Serial, Creation, Token) -> DopPayloadExitTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopPayloadExitTT :: vdist_dop_payload_exit_tt:t().
dop_payload_exit_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_payload_exit_tt:new(FromPid, ToPid, Token).

-spec dop_exit2_noop(Id, Serial, Creation) -> DopExit2 when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopExit2 :: vdist_dop_exit2:t().
dop_exit2_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    Reason = vterm_atom_utf8_ext:new(4, <<"kill">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_exit2:new(FromPid, ToPid, Reason).

-spec dop_exit2_tt_noop(Id, Serial, Creation, Token) -> DopExit2TT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopExit2TT :: vdist_dop_exit2_tt:t().
dop_exit2_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    Reason = vterm_atom_utf8_ext:new(4, <<"kill">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_exit2_tt:new(FromPid, ToPid, Token, Reason).

-spec dop_payload_exit2_noop(Id, Serial, Creation) -> DopPayloadExit2 when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopPayloadExit2 :: vdist_dop_payload_exit2:t().
dop_payload_exit2_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_payload_exit2:new(FromPid, ToPid).

-spec dop_payload_exit2_tt_noop(Id, Serial, Creation, Token) -> DopPayloadExit2TT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopPayloadExit2TT :: vdist_dop_payload_exit2_tt:t().
dop_payload_exit2_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_payload_exit2_tt:new(FromPid, ToPid, Token).

-spec dop_group_leader_noop(Id, Serial, Creation) -> DopGroupLeader when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopGroupLeader :: vdist_dop_group_leader:t().
dop_group_leader_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_group_leader:new(FromPid, ToPid).

-spec dop_link_noop(Id, Serial, Creation) -> DopLink when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopLink :: vdist_dop_link:t().
dop_link_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_link:new(FromPid, ToPid).

-spec dop_monitor_p_noop(Id, Serial, Creation) -> DopMonitorP when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopMonitorP :: vdist_dop_monitor_p:t().
dop_monitor_p_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToProc = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    Ref = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    vdist_dop_monitor_p:new(FromPid, ToProc, Ref).

-spec dop_demonitor_p_noop(Id, Serial, Creation) -> DopDemonitorP when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopDemonitorP :: vdist_dop_demonitor_p:t().
dop_demonitor_p_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToProc = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    Ref = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    vdist_dop_demonitor_p:new(FromPid, ToProc, Ref).

-spec dop_monitor_p_exit_noop(Id, Serial, Creation) -> DopMonitorPExit when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopMonitorPExit :: vdist_dop_monitor_p_exit:t().
dop_monitor_p_exit_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromProc = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    Ref = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    Reason = vterm_atom_utf8_ext:new(6, <<"killed">>),
    vdist_dop_monitor_p_exit:new(FromProc, ToPid, Ref, Reason).

-spec dop_payload_monitor_p_exit_noop(Id, Serial, Creation) -> DopPayloadMonitorPExit when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopPayloadMonitorPExit :: vdist_dop_payload_monitor_p_exit:t().
dop_payload_monitor_p_exit_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromProc = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    Ref = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    vdist_dop_payload_monitor_p_exit:new(FromProc, ToPid, Ref).

-spec dop_reg_send_noop(Id, Serial, Creation, ToName) -> DopRegSend when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    ToName :: vterm:atom_t(),
    DopRegSend :: vdist_dop_reg_send:t().
dop_reg_send_noop(Id, Serial, Creation, ToName) ->
    Unused = vterm_atom_utf8_ext:new(0, <<>>),
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    vdist_dop_reg_send:new(FromPid, Unused, ToName).

-spec dop_reg_send_tt_noop(Id, Serial, Creation, ToName, Token) -> DopRegSendTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    ToName :: vterm:atom_t(),
    Token :: vterm:t(),
    DopRegSendTT :: vdist_dop_reg_send_tt:t().
dop_reg_send_tt_noop(Id, Serial, Creation, ToName, Token) ->
    Unused = vterm_atom_utf8_ext:new(0, <<>>),
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    vdist_dop_reg_send_tt:new(FromPid, Unused, ToName, Token).

-spec dop_send_noop(Id, Serial, Creation) -> DopSend when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopSend :: vdist_dop_send:t().
dop_send_noop(Id, Serial, Creation) ->
    Unused = vterm_atom_utf8_ext:new(0, <<>>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_send:new(Unused, ToPid).

-spec dop_send_tt_noop(Id, Serial, Creation, Token) -> DopSendTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopSendTT :: vdist_dop_send_tt:t().
dop_send_tt_noop(Id, Serial, Creation, Token) ->
    Unused = vterm_atom_utf8_ext:new(0, <<>>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_send_tt:new(Unused, ToPid, Token).

-spec dop_send_sender_noop(Id, Serial, Creation) -> DopSendSender when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopSendSender :: vdist_dop_send_sender:t().
dop_send_sender_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_send_sender:new(FromPid, ToPid).

-spec dop_send_sender_tt_noop(Id, Serial, Creation, Token) -> DopSendSenderTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopSendSenderTT :: vdist_dop_send_sender_tt:t().
dop_send_sender_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_send_sender_tt:new(FromPid, ToPid, Token).

-spec dop_spawn_reply_noop(Id, Serial, Creation) -> DopSpawnReply when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopSpawnReply :: vdist_dop_spawn_reply:t().
dop_spawn_reply_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    ReqId = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    To = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    Flags = vterm_small_integer_ext:new(2),
    Result = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_spawn_reply:new(ReqId, To, Flags, Result).

-spec dop_spawn_reply_tt_noop(Id, Serial, Creation, Token) -> DopSpawnReplyTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopSpawnReplyTT :: vdist_dop_spawn_reply_tt:t().
dop_spawn_reply_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    ReqId = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    To = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    Flags = vterm_small_integer_ext:new(2),
    Result = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_spawn_reply_tt:new(ReqId, To, Flags, Result, Token).

-spec dop_spawn_request_noop(Id, Serial, Creation) -> DopSpawnRequest when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopSpawnRequest :: vdist_dop_spawn_request:t().
dop_spawn_request_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    UndefinedAtom = vterm_atom_utf8_ext:new(9, <<"undefined">>),
    ReqId = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    GroupLeaderPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    Module = UndefinedAtom,
    Function = UndefinedAtom,
    Arity = vterm_small_integer_ext:new(1),
    OptList = [],
    vdist_dop_spawn_request:new(ReqId, FromPid, GroupLeaderPid, Module, Function, Arity, OptList).

-spec dop_spawn_request_tt_noop(Id, Serial, Creation, Token) -> DopSpawnRequestTT when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    Token :: vterm:t(),
    DopSpawnRequestTT :: vdist_dop_spawn_request_tt:t().
dop_spawn_request_tt_noop(Id, Serial, Creation, Token) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    UndefinedAtom = vterm_atom_utf8_ext:new(9, <<"undefined">>),
    ReqId = vterm_newer_reference_ext:new(1, NodeA, Creation, [Id]),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    GroupLeaderPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    Module = UndefinedAtom,
    Function = UndefinedAtom,
    Arity = vterm_small_integer_ext:new(1),
    OptList = [],
    vdist_dop_spawn_request_tt:new(ReqId, FromPid, GroupLeaderPid, Module, Function, Arity, OptList, Token).

-spec dop_unlink_noop(Id, Serial, Creation) -> DopUnlink when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopUnlink :: vdist_dop_unlink:t().
dop_unlink_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    vdist_dop_unlink:new(FromPid, ToPid).

-spec dop_unlink_id_noop(Id, Serial, Creation) -> DopUnlinkId when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopUnlinkId :: vdist_dop_unlink_id:t().
dop_unlink_id_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    IdInteger = vterm_integer_ext:new(Id + 1024),
    vdist_dop_unlink_id:new(IdInteger, FromPid, ToPid).

-spec dop_unlink_id_ack_noop(Id, Serial, Creation) -> DopUnlinkIdAck when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopUnlinkIdAck :: vdist_dop_unlink_id_ack:t().
dop_unlink_id_ack_noop(Id, Serial, Creation) ->
    NodeA = vterm_atom_utf8_ext:new(1, <<"a">>),
    NodeB = vterm_atom_utf8_ext:new(1, <<"b">>),
    FromPid = vterm_new_pid_ext:new(NodeA, Id, Serial, Creation),
    ToPid = vterm_new_pid_ext:new(NodeB, Id, Serial, Creation),
    IdInteger = vterm_integer_ext:new(Id + 1024),
    vdist_dop_unlink_id_ack:new(IdInteger, FromPid, ToPid).

-spec spawn_request_noop(Id, Serial, Creation) -> DopSpawnRequest when
    Id :: vterm:u32(),
    Serial :: vterm:u32(),
    Creation :: vterm:u32(),
    DopSpawnRequest :: vdist_dop_spawn_request:t().
spawn_request_noop(Id, Serial, Creation) ->
    EmptyAtom = vterm_atom_utf8_ext:new(0, <<>>),
    UndefinedAtom = vterm_atom_utf8_ext:new(9, <<"undefined">>),
    ReqId = vterm_newer_reference_ext:new(1, EmptyAtom, Creation, [Id]),
    FromPid = vterm_new_pid_ext:new(EmptyAtom, Id, Serial, Creation),
    GroupLeaderPid = vterm_new_pid_ext:new(EmptyAtom, Id, Serial, Creation),
    Module = UndefinedAtom,
    Function = UndefinedAtom,
    Arity = vterm_small_integer_ext:new(1),
    OptList = [],
    vdist_dop_spawn_request:new(ReqId, FromPid, GroupLeaderPid, Module, Function, Arity, OptList).

%%%-----------------------------------------------------------------------------
%%% Internal functions
%%%-----------------------------------------------------------------------------

%% @private
-spec config_set_default() -> ok.
config_set_default() ->
    config_set(#{}).

%% @private
-spec config_set(ConfigMapSet) -> ok when
    ConfigMapSet :: erldist_filter_nif_types:config_map_set().
config_set(ConfigMapSet1) ->
    DefaultConfigMapSet =
        #{
            ConfigKey =>
                case ConfigVal of
                    _ when is_boolean(ConfigVal) -> false;
                    _ when is_integer(ConfigVal) -> 0
                end
         || ConfigKey := ConfigVal <- erldist_filter_nif:config_get()
        },
    ConfigMapSet2 = maps:merge(DefaultConfigMapSet, ConfigMapSet1),
    erldist_filter_nif:config_set(ConfigMapSet2).

%% @private
-spec extract_action_logs(ActionListIn, ActionListOut, LogListOut) -> {ActionListOut, LogListOut} when
    ActionListIn :: [Action],
    Action :: erldist_filter_nif:action(),
    ActionListOut :: [Action],
    LogListOut :: [Log],
    Log :: erldist_filter_nif:action_log().
extract_action_logs([Action = {log, _, _} | Rest], Actions, Logs) ->
    extract_action_logs(Rest, Actions, [Action | Logs]);
extract_action_logs([Action | Rest], Actions, Logs) ->
    extract_action_logs(Rest, [Action | Actions], Logs);
extract_action_logs([], Actions, Logs) ->
    {lists:reverse(Actions), lists:reverse(Logs)}.

%% @private
-spec first_message_in_mailbox(Timeout) -> Msg when
    Timeout :: timeout(),
    Msg :: dynamic().
first_message_in_mailbox(Timeout) ->
    receive
        Msg ->
            Msg
    after Timeout ->
        erlang:error(timeout_waiting_for_first_message_in_mailbox)
    end.

%% @private
-spec flush_logger(Logger) -> LoggerSelectHandle when
    Logger :: erldist_filter_nif:logger(),
    LoggerSelectHandle :: erldist_filter_nif:logger_select_handle().
flush_logger(Logger) ->
    case erldist_filter_nif:logger_recv(Logger) of
        {_QueueSize, _QueueDrop, _Events} ->
            flush_logger(Logger);
        {select, LoggerSelectHandle} ->
            LoggerSelectHandle
    end.

%% @private
-spec simplify_logger_events(Events) -> Events when
    Events :: [Event],
    Event :: {LoggerTime, LoggerEvent},
    LoggerTime :: erldist_filter_nif:logger_time(),
    LoggerEvent :: erldist_filter_nif:logger_event().
simplify_logger_events(Events) ->
    simplify_logger_events(Events, 1).

%% @private
-spec simplify_logger_events(Events, SimpleTime) -> Events when
    Events :: [Event],
    Event :: {LoggerTime, LoggerEvent},
    LoggerTime :: erldist_filter_nif:logger_time(),
    LoggerEvent :: erldist_filter_nif:logger_event(),
    SimpleTime :: erldist_filter_nif:logger_time().
simplify_logger_events(Events, SimpleTime) ->
    simplify_logger_events(Events, SimpleTime, []).

%% @private
-spec simplify_logger_events(Events, SimpleTime, Acc) -> Events when
    Events :: [Event],
    Event :: {LoggerTime, LoggerEvent},
    LoggerTime :: erldist_filter_nif:logger_time(),
    LoggerEvent :: erldist_filter_nif:logger_event(),
    SimpleTime :: erldist_filter_nif:logger_time(),
    Acc :: [Event].
simplify_logger_events([{_LoggerTime, LoggerEvent} | Events], SimpleTime, Acc) ->
    Event = {SimpleTime, LoggerEvent},
    simplify_logger_events(Events, SimpleTime + 1, [Event | Acc]);
simplify_logger_events([], _SimpleTime, Acc) ->
    lists:reverse(Acc).

%% @private
-spec simplify_logger_time(Events) -> Events when
    Events :: [Event],
    Event :: erldist_filter_nif:action_log().
simplify_logger_time(Events) ->
    simplify_logger_time(Events, 0).

%% @private
-spec simplify_logger_time(Events, SimpleTime) -> Events when
    Events :: [Event],
    Event :: erldist_filter_nif:action_log(),
    SimpleTime :: erldist_filter_nif:logger_time().
simplify_logger_time(Events, SimpleTime) ->
    simplify_logger_time(Events, SimpleTime, []).

%% @private
-spec simplify_logger_time(Events, SimpleTime, Acc) -> Events when
    Events :: [Event],
    Event :: erldist_filter_nif:action_log(),
    SimpleTime :: erldist_filter_nif:logger_time(),
    Acc :: [Event].
simplify_logger_time([{log, FragmentCount, {_LoggerTime, LoggerEvent}} | Events], SimpleTime, Acc) ->
    Event = {log, FragmentCount, {SimpleTime, LoggerEvent}},
    simplify_logger_time(Events, SimpleTime + 1, [Event | Acc]);
simplify_logger_time([Event | Events], SimpleTime, Acc) ->
    simplify_logger_time(Events, SimpleTime, [Event | Acc]);
simplify_logger_time([], _SimpleTime, Acc) ->
    lists:reverse(Acc).
