using System;
using Interfaces;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Orleans;
using Orleans.CodeGeneration;
using Orleans.Hosting;
using VBGrains;

[assembly: KnownAssembly(typeof(HelloGrain))]
[assembly: KnownAssembly(typeof(IHelloGrain))]

using var host = new HostBuilder()
    .UseOrleans(builder =>
    {
        builder.UseLocalhostClustering();
    })
    .Build();

await host.StartAsync();

var grainFactory = host.Services.GetRequiredService<IGrainFactory>();
var friend = grainFactory.GetGrain<IHelloGrain>(0);
Console.WriteLine("\n\n{0}\n\n", friend.SayHello("Good morning!").Result);

Console.WriteLine("Orleans is running.\nPress Enter to terminate...");
Console.ReadLine();
Console.WriteLine("Orleans is stopping...");

await host.StopAsync();
