# Contributing to Brain Networks in Python project

Welcome to the Brain Networks in Python GitHub repository, and thank you for thinking about contributing! :smiley::heart::smiley:

The point of this file is to make it suuuuuper easy for you to get involved. So if you have any questions that aren't covered here please let us know! Check out the [Share your thoughts](#share-your-thoughts) section below for more details.

Before you start you'll need to set up a free [GitHub][link_github] account and sign in. Here are some [instructions][link_signupinstructions].

Scroll down or jump to one of the following sections:

* [Share your thoughts](#share-your-thoughts)
  * [A description of the different labels](#labels)
* [Make a change](#make-a-change)
* [Recognising contributions](#recognising-contributions)
* [Get in touch](#how-to-get-in-touch)

## Share your thoughts

Although GitHub calls them **issues**, we'd like you to think of them as **conversation starters**. They're our way of communicating across all the members of the team.

(If you're here you ***already are*** a member of the Brain Networks in Python team.)

Your thoughts can be [questions][link_question], [bugs][link_bug], [requests][link_request], or a myriad of other suggestions. In the next section we'll talk through some of the labels on each issue to help you select the ones you'd most like to help with.

GitHub has a nice set of help pages if you're looking for more information about [discussing projects in issues][link_discussingissues].

### Labels

You can find all currently open conversations under the [issues tab][link_issues].

The current list of labels are [here][link_labels] and include:

* [![question](https://img.shields.io/badge/-question-cc317c.svg)][link_question] These issues are questions and represent a great place to start. Whomever has opened the issue wants to hear from you!

    To reply, read the question and then respond in a variety of different ways:

    * If you want to just agree with everything you can [react to the post][link_react] with one of :+1: :laugh: :heart: :tada:
    * Alternatively you could write a comment to:
      * express your emotions more dramatically (check out this [cheat sheet][link_emojis] for emojis you might need)
      * provide a more nuanced description of your answer (using your words)
      * ask for a clarification
      * ask a follow up question

<br>

* [![no-code](https://img.shields.io/badge/-no--code-207de5.svg)][link_nocode] These issues don't require any coding knowledge.

    If you're looking to contribute but aren't very confident in your coding skills these issues are a great place to start.

    All issues with the no code label are suggesting documentation tasks, or asking for feedback or suggestions.

<br>

* [![good-first-bug](https://img.shields.io/badge/-good--first--bug-5319e7.svg)][link_goodfirstbug] These issues contain a task that anyone with any level of experience can help with.

    A major goal of the project is to have as many people as possible complete their very first [pull request][link_pullrequest] on one of these issues. They will always have explicit information on who to contact to help you through the process.

    Remember: **There are no stupid questions!**

    We can not encourage you enough to submit even the tiniest change to the project repository. Let's go from :confused: & :anguished: to :smiley: & :tada: together!

<br>

* [![help-wanted](https://img.shields.io/badge/-help--wanted-159818.svg)][link_helpwanted] These issues contain a task that a member of the team has determined we need additional help with.

    If you have particular skills then consider reading through these issues as they are a great place to offer your expertise.

    If you aren't sure what to offer, you could also recommend issues to your friends/colleagues who may be able to help.

<br>

* [![bug](https://img.shields.io/badge/-bug-fc2929.svg)][link_bug] These issues point to problems in the project.

    If you find a bug, please give as much detail as possible in your issue.

    If you experience the same bug as one already listed, please add any additional information that you have as a comment.

<br>

* [![request](https://img.shields.io/badge/-request-fbca04.svg)][link_request] These issues are asking for features (or anything else) to be added to the project.

    If you have a good idea and would like to see it implemented in the Brain Networks in Python project please open a new issue and add in as much detail as possible.

    Please try to make sure that your feature is distinct from any others that have already been requested or implemented. If you find one that's similar but there are subtle differences please reference the other request in your issue.


## Make a change

Once you've identified one of the issues above that you feel you can contribute to, you're ready to make a change to the project repository! :tada::smiley:

1. First, describe what you're planning to do as a comment to the issue, (and this might mean making a new issue).

    Check in with one of the Brain Networks in Python development team to ensure you aren't overlapping with work that's currently underway and that everyone is on the same page with the goal of the work you're going to carry out.

    [This blog][link_pushpullblog] is a nice explanation of why putting this work in up front is so useful to everyone involved.

2. [Fork][link_fork] the [Brain Networks in Python][link_brainnetworksrepo] to your profile.

    You can now do whatever you want with this copy of the project. You won't mess up anyone else's work so you're super safe.

    Make sure to [keep your fork up to date][link_updateupstreamwiki] with the master repository.

3. Make the changes you've discussed.

    Try to keep the changes focused rather than changing lots of things at once. If you feel tempted to branch out then please *literally* branch out: create [separate branches][link_branches] for different updates to make the next step much easier!

4. Submit a [pull request][link_pullrequest].

    A member of the executive team will review your changes, have a bit of discussion and hopefully merge them in!  
    N.B. you don't have to be ready to merge to make a pull request! We encourage you to submit a pull request as early as you want to. They help us to keep track of progress and help you to get earlier feedback.

**Success!!** :balloon::balloon::balloon: Well done! And thank you :smiley::tada::sparkles:

## Recognising contributions

If you're logged into GitHub you can see everyone who has contributed to the repository via our [live contributors page][link_contributorslive]. (You might have to add `WhitakerLab/BrainNetworksInPython` as the repository name before you click to sign in via GitHub.)

These pages are powered by the [Let's all build a hat rack][link_hatrackhome] project, and we love them.

Quoting from their [website][link_hatrackhome]:

> Open Source project contribution focuses a lot on the code committed to projects, but there is so much more that goes on behind the scenes that is just as valuable to FOSS than the code itself.
>
> LABHR seeks to find those that provide these non-code contributions, and thank them.
>
> LABHR started as an [idea by Leslie Hawthorn][link_hatrackidea]. She advocates openly thanking people on social media, and writing recommendations.
>
> This idea was extended by Katie McLaughlin with her work on [automating this process on GitHub][link_hatrackcontributions].

## How to get in touch

If you have a question or a comment we'd love for you to [open an issue][link_issues] because that will be our fastest way of communicating, getting the answers to you and (if necessary) making a change.

If you'd prefer email, you can contact [Isla](https://github.com/Islast) at [istaden@turing.ac.uk](mailto:istaden@turing.ac.uk). If she doesn't reply to your email after a couple of days please feel free to ping her again.

## Thank you!

You are awesome. :heart_eyes::sparkles::sunny:

And if you've found typos in this (or any other) page, you could consider submitting your very first pull request to fix them via the [typos and broken links][link_fixingtyposissue] issue!

[link_github]: https://github.com/
[link_brainnetworksrepo]: https://github.com/WhitakerLab/BrainNetworksInPython
[link_signupinstructions]: https://help.github.com/articles/signing-up-for-a-new-github-account
[link_react]: https://github.com/blog/2119-add-reactions-to-pull-requests-issues-and-comments
[link_issues]: https://github.com/WhitakerLab/BrainNetworksInPython/issues
[link_labels]: https://github.com/WhitakerLab/BrainNetworksInPython/labels
[link_discussingissues]: https://help.github.com/articles/discussing-projects-in-issues-and-pull-requests
[link_bug]: https://github.com/WhitakerLab/BrainNetworksInPython/labels/bug
[link_goodfirstbug]: https://github.com/WhitakerLab/BrainNetworksInPython/labels/good-first-bug
[link_helpwanted]: https://github.com/WhitakerLab/BrainNetworksInPython/labels/help-wanted
[link_nocode]: https://github.com/WhitakerLab/BrainNetworksInPython/labels/no-code
[link_question]: https://github.com/WhitakerLab/BrainNetworksInPython/labels/question
[link_request]: https://github.com/WhitakerLab/BrainNetworksInPython/labels/request

[link_emojis]: http://www.emoji-cheat-sheet.com/
[link_pullrequest]: https://help.github.com/articles/proposing-changes-to-a-project-with-pull-requests/
[link_fork]: https://help.github.com/articles/fork-a-repo/
[link_pushpullblog]: https://www.igvita.com/2011/12/19/dont-push-your-pull-requests/
[link_branches]: https://help.github.com/articles/creating-and-deleting-branches-within-your-repository/
[link_updateupstreamwiki]: https://github.com/KirstieJane/STEMMRoleModels/wiki/Syncing-your-fork-to-the-original-repository-via-the-browser
[link_contributorslive]: https://labhr.github.io/hatrack/#repo=WhitakerLab/BrainNetworksInPython
[link_hatrackhome]: https://labhr.github.io/
[link_hatrackidea]: http://hawthornlandings.org/2015/02/13/a-place-to-hang-your-hat/
[link_hatrackcontributions]: http://opensource.com/life/15/10/octohat-github-non-code-contribution-tracker
[link_fixingtyposissue]: https://github.com/WhitakerLab/BrainNetworksInPython//issues/4
