# BrainNetworksInPython &nbsp;
[![Join the chat at https://gitter.im/WhitakerLab/BrainNetworksInPython](https://badges.gitter.im/WhitakerLab/BrainNetworksInPython.svg)](https://gitter.im/WhitakerLab/BrainNetworksInPython?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![Build Status](https://travis-ci.org/WhitakerLab/BrainNetworksInPython.svg?branch=master)](https://travis-ci.org/WhitakerLab/BrainNetworksInPython)
[![License: MIT](https://img.shields.io/badge/License-MIT-yellow.svg)](https://github.com/WhitakerLab/BrainNetworksInPython/blob/master/LICENSE)
[![Binder](https://mybinder.org/badge.svg)](https://mybinder.org/v2/gh/WhitakerLab/BrainNetworksInPython/master)

Welcome to the BrainNetworksInPython GitHub repository!:sparkles: <img align="right" src="https://media.giphy.com/media/3ohhwwL4kj5z1Id6uI/giphy.gif">





## What are we doing?
BrainNetworksInPython is a toolkit to analyse structural covariance brain networks using python.  

BrainNetworksInPython takes regional cortical thickness data obtained from structural MRI and generates a matrix of correlations between regions over a cohort of subjects. The correlation matrix is used alongside the [networkx package](https://networkx.github.io/) to generate a variety of networks and network measures.

The BrainNetworksInPython codebase was first developed by Dr Kirstie Whitaker for the Neuroscience in Psychiatry Network publication "Adolescence is associated with genomically patterned consolidation of the hubs of the human brain connectome" published in PNAS in 2016 [(Whitaker*, Vertes* et al, 2016](http://dx.doi.org/10.1073/pnas.1601745113)). This project is to take the existing codebase (accessible at https://github.com/KirstieJane/NSPN_WhitakerVertes_PNAS2016) and turn it into a documented, tested python package that is easy to use and re-use.

Check out our [tutorial](tutorials/jupyter_demo.ipynb) to get started.

## Want to get involved?
BrainNetworksInPython is openly developed and welcomes contributers.

If you're thinking about contributing (:green_heart: you are loved), our [roadmap](https://github.com/WhitakerLab/BrainNetworksInPython/issues/12) and our [contributing guidelines](https://github.com/WhitakerLab/BrainNetworksInPython/blob/master/CONTRIBUTING.md) are a good place to start. You don't need advanced skills or knowledge to help out. Newbies to Python, neuroscience, git and GitHub are all welcome.

If you have questions or want to get in touch you can join our [gitter lobby](https://gitter.im/WhitakerLab/BrainNetworksInPython?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge), tweet @Whitaker\_Lab or email Isla at islastaden __*at*__ gmail __*dot*__ com.

## Other Stuff

To view our (successful) Mozilla Mini-Grant application, head [here](https://github.com/WhitakerLab/WhitakerLabProjectManagement/blob/master/FUNDING_APPLICATIONS/MozillaScienceLabMiniGrant_June2017.md).

In October 2017 BrainNetworksInPython ran a MozFest [session](https://github.com/MozillaFoundation/mozfest-program-2017/issues/724)

We are still choosing a name for our python package, vote here https://poll.ly/#/Gx4yMMY7
