from deca.ff_vfs import vfs_structure_prep
import os


def main():
    game_dir = '/home/krys/prj/as_games/GenerationZero_BETA/'
    game_id = 'gzb'
    working_dir = './work/gzb/'
    archive_paths = []
    for cat in ['initial', 'supplemental', 'optional']:
        archive_paths.append(os.path.join(game_dir, 'archives_win64', cat))

    vfs = vfs_structure_prep(game_dir, game_id, archive_paths, working_dir)

    files = [
        b'settings/charactertypes.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_scout_a.bmp_datac',
        b'editor/entities/equipment/clothing/generic_gas_resistant.sattribsc',
        b'editor/entities/equipment/clothing/pants_camo.sattribsc',
        b'settings/all_disable_at_distance.disableatdistance',
        b'settings/node_templates.bin',
        b'editor/entities/characters/machines/harvester/weapons/machine_weapon_harv_rockets_01.wtunec',
        b'editor/entities/characters/machines/dreadnought/weapons/machine_weapon_dread_missiles_01.wtunec',
        b'settings/hp_settings/animal_senses.bin',
        b'editor/entities/hp_weapons/special/tuning/weapon_special_vertical_aim.wtunec',
        b'settings/keymap_keyboard_justedit.bin',
        b'editor/entities/weapons/wpn_rifle_assault_762_02/wpn_rifle_assault_762_02.wtunec',
        b'settings/game_materials.bin',
        b'editor/entities/weapons/wpn_rifle_sniper_50_01/wpn_rifle_sniper_50_01.wtunec',
        b'settings/hp_settings/hp_ai_textures/bitmaps/flee_reserve_0.bmp_datac',
        b'settings/hp_settings/animal_interest.bin',
        b'settings/all_animal_groups.animal_groups',
        b'editor/entities/characters/machines/skirmisher/weapons/machine_weapon_skirm_smg_01.wtunec',
        b'settings/spawn_defs/spawn_encounter_defs.bin',
        b'editor/entities/hp_weapons/weapon_shotguns_01/weapon_shotgun_vertical_aim.wtunec',
        b'editor/entities/hp_weapons/weapon_handguns_01/weapon_handgun_default.wtunec',
        b'settings/weathersettings.bin',
        b'settings/damage_types.bin',
        b'editor/entities/hp_weapons/shared/autoaim_tuning/autoaim_pistol.wtunec',
        b'editor/entities/characters/machines/harvester/harvester_damage.mdpc',
        b'settings/lightenumplane.bin',
        b'settings/spawn_defs/spawn_vehicle_defs.bin',
        b'settings/grassbillboards.bin',
        b'editor/entities/weapons/wpn_handgun_semiauto_32acp_01/wpn_handgun_semiauto_32acp_01.wtunec',
        b'settings/crowd_voiceover.bin',
        b'settings/texturemanager.bin',
        b'settings/build_version.bin',
        b'editor/entities/equipment/clothing/generic_camo_low.sattribsc',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_skirmisher_a.bmp_datac',
        b'settings/hp_settings/characters.bin',
        b'settings/hp_settings/player_initial_loadout.bin',
        b'settings/smartobjectsettings.bin',
        b'settings/effects_budget_pools.bin',
        b'settings/spawn_defs/spawn_ammunition_defs.bin',
        b'settings/lightenumtrain.bin',
        b'settings/post_effects.bin',
        b'settings/spawn_defs/spawn_equipment_defs.bin',
        b'editor/entities/equipment/clothing/generic_military.sattribsc',
        b'settings/spawn_defs/spawn_weapon_defs.bin',
        b'settings/worlddecorations.bin',
        b'editor/entities/weapons/wpn_handgun_revolver_44m_01/wpn_handgun_revolver_44m_01.wtunec',
        b'editor/entities/weapons/wpn_rifle_hunting_270_01/wpn_rifle_hunting_270_01.wtunec',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_skirmisher_c.bmp_datac',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_scout_b.bmp_datac',
        b'settings/hp_settings/hp_ai_textures/bitmaps/animal_forbidden_map_0.bmp_datac',
        b'settings/hp_settings/animal_call.bin',
        b'settings/hp_settings/player_skills.bin',
        b'settings/weapon_tuning.bin',
        b'settings/benchmarks.bin',
        b'settings/locator.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_hunter_a.bmp_datac',
        b'editor/entities/hp_weapons/weapon_handguns_01/tuning/weapon_handgun_357.wtunec',
        b'settings/game_materials_all_asphalt.bin',
        b'settings/pdaicontypetexttags.bin',
        b'editor/entities/hp_weapons/weapon_rifles_01/weapon_rifles.wtunec',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_boar.bmp_datac',
        b'settings/factions.bin',
        b'settings/landscape_effects.bin',
        b'settings/ui_settingsscreen_definitions.bin',
        b'settings/ammunition.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_skirmisher_b.bmp_datac',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_dreadnought_c.bmp_datac',
        b'settings/hp_settings/animal_type_ragdoll_settings.bin',
        b'editor/entities/equipment/clothing/jacket_denim.sattribsc',
        b'settings/weapon_attachment_tuning.bin',
        b'editor/entities/characters/machines/skirmisher/weapons/machine_weapon_skirm_shotgun_01.wtunec',
        b'editor/entities/characters/machines/dreadnought/weapons/machine_weapon_dread_mortar_01.wtunec',
        b'editor/entities/weapons/wpn_rifle_assault_762_01/wpn_rifle_assault_762_01.wtunec',
        b'editor/entities/equipment/clothing/generic_default.sattribsc',
        b'settings/sun.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_harvester_c.bmp_datac',
        b'editor/entities/hp_weapons/shared/attach_settings/default_rifle.wtunec',
        b'editor/entities/hp_weapons/shared/autoaim_tuning/autoaim_assault_rifle.wtunec',
        b'editor/entities/hp_weapons/weapon_shotguns_01/weapon_shotgun.wtunec',
        b'global/all_network_objects.networkobjects',
        b'settings/lightenumboat.bin',
        b'settings/spawn_defs/spawn_animals_defs.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_hunter_b.bmp_datac',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_roe.bmp_datac',
        b'settings/asset_areas_color_info.bin',
        b'editor/entities/characters/machines/hunter/weapons/machine_weapon_hunt_machinegun_01.wtunec',
        b'settings/voice_over_definitions.bin',
        b'editor/entities/characters/machines/scout/scout_damage.mdpc',
        b'settings/vehicletackleparams.bin',
        b'settings/hp_settings/player_rewards.bin',
        b'settings/road_presets.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_moose.bmp_datac',
        b'editor/entities/weapons/wpn_submach_9mm_02/wpn_submach_9mm_02.wtunec',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_hunter_c.bmp_datac',
        b'settings/asset_memory_budgets.bin',
        b'settings/player_character_customization.bin',
        b'editor/entities/weapons/wpn_rifle_hunting_243_01/wpn_rifle_hunting_243_01.wtunec',
        b'editor/entities/equipment/clothing/jacket_camo.sattribsc',
        b'editor/entities/jc_weapons/00_shared/attach_settings/default_pistols.wtunec',
        b'settings/vehicletypes.bin',
        b'settings/all_machine_interests.machineinterests',
        b'editor/entities/characters/machines/dreadnought/dreadnought_damage.mdpc',
        b'settings/missionruletemplates.bin',
        b'settings/lookout_linked_pois.linked_pois',
        b'settings/road_logic.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_dreadnought_a.bmp_datac',
        b'editor/entities/hp_weapons/weapon_rifles_01/weapon_rifles_attach_settings.wtunec',
        b'editor/entities/hp_weapons/weapon_handguns_01/tuning/weapon_handgun_vertical_aim.wtunec',
        b'settings/collectitemtypes.bin',
        b'settings/creatures.bin',
        b'settings/enemytypespawnsettings.bin',
        b'settings/spawn_defs/spawn_road_decoration_defs.bin',
        b'settings/turn_taker.bin',
        b'settings/spawn_defs/spawn_loot_defs.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_scout_c.bmp_datac',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_harvester_a.bmp_datac',
        b'settings/gamestaterun.bin',
        b'settings/hp_settings/tooltip_icon_data.bin',
        b'settings/weapon_sight_tuning.bin',
        b'global/collection.collectionc',
        b'settings/spawn_defs/spawn_budget_pools.bin',
        b'editor/entities/characters/machines/pest/pest_damage.mdpc',
        b'editor/entities/characters/machines/skirmisher/weapons/machine_weapon_skirm_launcher_01.wtunec',
        b'settings/lightenumhelicopter.bin',
        b'settings/spawn_defs/spawn_placeables_defs.bin',
        b'editor/entities/hp_equipment/tuning/weapon_sway_item_left.wtunec',
        b'settings/settlements.bin',
        b'editor/entities/characters/machines/dreadnought/weapons/machine_weapon_dread_sniper_01.wtunec',
        b'settings/ainavmeshlayers.bin',
        b'editor/entities/hp_weapons/weapon_handguns_01/weapon_handgun_attach_settings.wtunec',
        b'editor/entities/equipment/clothing/shoes_athletic_high.sattribsc',
        b'editor/entities/weapons/wpn_rifle_assault_556_01/wpn_rifle_assault_556_01.wtunec',
        b'settings/hp_settings/player_deep_water_handling.bin',
        b'editor/entities/equipment/clothing/pants_denim.sattribsc',
        b'editor/entities/equipment/clothing/generic_noticeable_low.sattribsc',
        b'settings/all_machine_organs.machine_organs',
        b'editor/entities/hp_weapons/weapon_rifles_01/tuning/weapon_rifle_vertical_aim.wtunec',
        b'settings/hp_settings/animal_settings.bin',
        b'editor/entities/equipment/clothing/shoes_workboots.sattribsc',
        b'settings/hp_settings/player_emotes.bin',
        b'settings/spawn_defs/spawn_prop_defs.bin',
        b'settings/hp_settings/hp_ai_textures/bitmaps/dreadnought_forbidden_map.bmp_datac',
        b'editor/entities/characters/machines/hunter/weapons/machine_weapon_hunt_sniper_01.wtunec',
        b'editor/entities/weapons/wpn_shotgun_semi_12ga_01/wpn_shotgun_semi_12ga_01.wtunec',
        b'editor/entities/characters/machines/hunter/weapons/machine_weapon_hunt_grenadelauncher_01.wtunec',
        b'editor/entities/hp_weapons/shared/grip_points/default_rifle.wtunec',
        b'editor/entities/characters/machines/dreadnought/weapons/machine_weapon_dread_cannon_01.wtunec',
        b'settings/hp_settings/world_object_types.bin',
        b'settings/hp_settings/reserve_0.bin',
        b'settings/worldsim.bin',
        b'editor/entities/characters/machines/hunter/weapons/machine_weapon_hunt_shotgun_01.wtunec',
        b'settings/all_location_summaries.location_summary',
        b'editor/entities/weapons/wpn_shotgun_pump_12ga_01/wpn_shotgun_pump_12ga_01.wtunec',
        b'settings/spawn_defs/spawn_interaction_defs.bin',
        b'settings/spawn_defs/spawn_sight_defs.bin',
        b'editor/entities/weapons/wpn_handgun_semiauto_9mm_01/wpn_handgun_semiauto_9mm_01.wtunec',
        b'settings/road_rendering.bin',
        b'settings/roaddecorationtypes.bin',
        b'editor/entities/characters/machines/skirmisher/skir_damage.mdpc',
        b'editor/entities/equipment/clothing/shoes_athletic_low.sattribsc',
        b'settings/lightenumbike.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_dreadnought_b.bmp_datac',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_harvester_b.bmp_datac',
        b'editor/entities/hp_weapons/weapon_shotguns_01/weapon_shotgun_attach_settings.wtunec',
        b'editor/entities/hp_weapons/weapon_handguns_01/tuning/weapon_sway_handgun.wtunec',
        b'editor/entities/weapons/wpn_submach_9mm_01/wpn_submach_9mm_01.wtunec',
        b'editor/entities/hp_weapons/weapon_rifles_01/tuning/weapon_sway_rifle.wtunec',
        b'settings/hp_settings/contextual_help/contextual_settings.bin',
        b'settings/hp_settings/hp_ai_textures/spawn_maps/spawn_fox.bmp_datac',
        b'settings/camera_debugger.bin',
        b'editor/entities/hp_weapons/weapon_rifles_01/tuning/weapon_45-70_lever_action.wtunec',
        b'settings/hp_settings/animal_types.bin',
        b'editor/entities/hp_equipment/tuning/weapon_sway_item_right.wtunec',
        b'editor/entities/jc_weapons/00_shared/autoaim_tuning/autoaim_pistol.wtunec',
        b'settings/lightenumcar.bin',
        b'settings/hp_settings/fast_forward.bin',
        b'editor/entities/weapons/wpn_special_launcher_01/wpn_special_launcher_01.wtunec',
        b'settings/hp_settings/notification_popup_data.bin',
        b'editor/entities/characters/machines/hunter/hunt_damage.mdpc',
        b'settings/ui_fonts.bin',
        b'settings/hp_settings/player_skill_trees.bin',
        b'settings/all_loot_crates.lootcrates',
        b'settings/hp_settings/codex_data.bin',
        b'settings/hp_settings/player_equipment.bin',
    ]

    for file in files:
        vnodes = vfs.map_vpath_to_vfsnodes[file]
        vinfo = [v.size_u for v in vnodes]
        print(file, vinfo)


if __name__ == "__main__":
    main()
