export default {
  error: {
    title404: "We are sorry, Page not found!",
    text404:
      "The page you are looking for might have been removed had its name changed or is temporarily unavailable.",
    button404: "Back to home",
    insertSkillError:
      "Unable to add this skill, check that it does not already exist.",
    unknown: "An unknown error has occurred.",
    refetch: "Retry",
    noData: "No data available.",
    requiredField: "This field is required",
    tagRequired: "Add at least 1 tag",
    topicRequired: "Add at least 1 topic",
    duplicatedTag: "This tag already exists, you can't create it",
  },
  nav: {
    mySkills: "My skills",
    zenikaSkills: "Zenika skills",
    search: "Search",
    darkmode: "Dark",
    classic: "Classic",
    preferences: "Preferences",
  },
  admin: {
    deleteSkill: "Delete from Skillz",
    verified: "Verify",
    skillsPending: "Skills that are pending validation",
    allSkills: "All skills",
    skills: "Skills",
    modify: "Modify",
    duplicate: "Duplicate",
    markSkillAsDuplicate: "Mark %s as duplicate",
    markAsDuplicate: "Mark as duplicate",
    update: "Update",
    skillList: "Skills list",
    category: "Category",
    categories: "Categories",
    categoriesList: "Categories list",
    approve: "Approve this skill",
    topics: "Associated topics",
    addTags: "Add tags",
    placeHolderDescription: "Set the description",
    save: "Save",
    description: "Description",
    name: "Name",
    notification: {
      descriptionEmpty: "The description can't be empty",
      descriptionSuccess:
        "The descrition of %skill% has been modified with success",
      descriptionError: "Error, try again",
      nameEmpty: "The name can't be empty",
      nameSuccess: "The skill has been renamed successfully",
    },
  },
  sidepanel: {
    profile: "Profile",
    language: "Language",
    darkMode: "Dark mode",
    logout: "Logout",
    tutorial: "Tutorial mode",
    botNotifications: "Slack bot notifications",
  },
  home: {
    bestSkills: "Top 5 skills",
    addSkill: "Add skill",
    noSkill: "No skill here",
    practices: "Practices",
    activities: "Activities",
    knowledge: "Knowledge",
    behaviors: "Behavior",
  },
  commonPageNav: {
    addSkill: "Add skill",
    practices: "Practice",
    activities: "Activity",
    knowledge: "Knowledge",
    behaviors: "Behavior",
    profile: "Profile",
    search: "Search",
  },
  onboarding: {
    skip: "Skip",
    addSkillsDescription: "Add and manage your skills",
    discoverZenikaSkillsDescription: "Discover all Zenika collabs skills",
    home: {
      welcome:
        "You are currently in tutorial mode. We'll be happy to help you find your way around !",

      remind:
        "You can desactivate it, and reactivate it at any time in your taskbar.",
      remindBeginner: "Start by note your first skill",
      startTutorial: "Let's start !",
      stopTutorial: "Stop tutorial",
    },
    demo: {
      steps: {
        back: "Back",
        next: "Next",
        last: "Close",
        skip: "Skip",
        close: "Close",
      },
      home: {
        titlestep1: "The total number of your rated skills",
        step1:
          "Here you can see the total number of skills you have scored for this category.",
        step2:
          "These are the top 5 skills you could rate based on your desire and skill levels.",
        titlestep3: "Let's note some skills ! 🚀",
        step3:
          "Here you can see the graphic representation of your top 5 skills. But by clicking on it, you will be able to note new skills, or modify the ones you want !",
      },
      mine: {
        titlestep1: "My skills",
        step1:
          "This is your skills tab. All the ones you have already noted, and which are represented on the graph, are put in this list.",
        titelstep2: "Add",
        step2:
          "This tab allows you to note new skills that are already created. But it is also possible to create new ones thanks to the search bar.",
        mySkills: {
          titlestep1: "Topics and tags",
          step1:
            "By clicking on a skill, you will be able to access its description, its Topics and Tags. They allow to improve the understanding, and to implement a skill suggestion system.",
          titlestep2: "Let's go ! 🚀",
          step2:
            "This button allows you to rate a skill, and thus add it to your chart. You will be able to modify it at any time !",
        },
      },
    },
  },
  loading: {
    loadingText: "Loading...",
  },
  createProfile: {
    title: "Let's create a profile !",
    profileCreated: "Congratulations your profile is now created !",
    homepage: "Back to homepage",
    agency: "First, which agency are you working at ?",
    topics:
      "What topic are you interested in ? Don't worry you can change it later",
    submit: "Submit",
    warningAgencyTitle: "Warning",
    warningAgency: "To fully utilize Skillz, please fill out your agency.",
  },
  skillLevels: {
    1: "I looked at what it was",
    2: "I played with it, I tested it",
    3: "I have worked with it on significant projects",
    4: "I've worked with it, I'm pretty comfortable, I've done some research",
    5: "I've worked a lot with it in different contexts, I know it perfectly",
  },
  desireLevels: {
    1: "I don't want to use it anymore and/or I don't want to learn",
    2: "I prefer to avoid, or only to troubleshoot",
    3: "I don't love it but it doesn't bother me",
    4: "I really like it",
    5: "I want to use it everyday",
  },
  skills: {
    nothingHere: "There is nothing here, try adding a skill",
    editSkill: "Edit this skill",
    cancelAction: "Cancel action",
    mySkills: "MY SKILLS",
    addSkill: "ADD SKILL",
    add: "ADD",
    desireLevel: "Desire level",
    skillLevel: "Skill level",
    searchPlaceholder: "Search for a skill",
    noMatchingSkills: "There is no skill in this category matching your search",
    addNewSkill: "Add %skill% as a new skill from this category",
    globalSkillSearch: "Searching %skill% in other categories",
    globalSkillResult: "See the %result% result(s)",
    addButton: "Add %skill%",
    didYouMean: "Did you mean :",
    modal: {
      knowledge: "Skill level",
      desire: "Desire level",
      cancel: "CANCEL",
      addSkill: "ADD SKILL",
      editSkill: "UPDATE",
      delete: "Delete",
    },
    addSkillSuccess: "Skill %skill% was added successfully",
    updateSkillSuccess: "Skill %skill% was updated successfully",
    addSkillTopicSuccess:
      "Topic %topic% has been successfully added to the skill.",
    deleteSkillTopicSuccess:
      "Topic %topic% has been successfully removed from the skill.",
    deleteSkillSuccess: "Skill %skill% was deleted successfully",
    refreshSkillFailed: "Error while refreshing skills",
    updateSkillFailed: "Error while updating %skill%.",
    deleteSkillFailed: "Error while deleting %skill%.",
    topBar: {
      title: "Here is the graph of %category% from",
    },
    lastUpdate: "Last update",
    topics: {
      topics: "Associated topics",
    },
    tags: {
      tags: "Associated tags",
      create: "Create new tag : ",
      tagDeleted: "The tag has been removed with success",
      tagAdded: "The tag %tag% has been added in the tag list",
      tagLinked: "The tag %tag% has been linked to %skill% with success",
      description:
        "Create or modify tags that you feel are associated with this skill. Your contribution will help us improve the classification of Skillz data 🚀",
    },
  },
  myProfile: {
    onboardingButton: "Let's go !",
    onboarding:
      "Welcome to SkillZ ! 🎉 We recommend you set your prefered topics, and your certifications so your profile is complete. But let's start with your agency.",
    lastLogin: "Last login",
    agency: "My agency",
    selectPlaceholder: "Select my agency",
    contact: "My prefered method of contact",
    topics: "My prefered topics",
    certifications: "My certifications",
    addCertification: "Add a certification",
    removeCertification: "Delete",
    confirm: "CONFIRM PROFILE",
    validFrom: "valid from",
    targeting: "aiming for",
    validTo: "to",
    addCert: "Add Cert",
    updateUserCertSuccess: "Certifications were successfully updated",
    updateUserCertError: "Error while updating certifications",
    deleteUserCertSuccess: "Certification was successfully deleted",
    deleteUserCertError: "Error while deleting certification",
    certModal: {
      confirm: "Confirm",
      cancel: "Cancel",
      editCert: "Edit",
      orDelete: "Or delete?",
      addCert: "Add Cert",
      selectCert: "Select a cert",
      obtained: "I have it!",
      deadline: "Deadline",
      from: "Valid from",
      hasExpiryDate: "Eventually expires?",
      to: "Valid until",
      selectDate: "Select a date",
    },
  },
  userProfile: {
    agency: "Agency",
    contact: "Preferred method of contact",
    topics: "Preferred topics",
    certifications: "Certifications",
    selectPlaceholder: "Agency",
    validFrom: "valid from",
    targeting: "aiming for",
    validTo: "to",
    addCert: "Add Cert",
    seeRadars: "See graphs",
    certModal: {
      confirm: "Confirm",
      cancel: "Cancel",
      editCert: "Edit",
      orDelete: "Or delete?",
      addCert: "Add Cert",
      selectCert: "Select a cert",
      obtained: "I have it!",
      deadline: "Deadline",
      from: "Valid from",
      hasExpiryDate: "Eventually expires?",
      to: "Valid until",
      selectDate: "Select a date",
    },
  },
  graph: {
    scatter: {
      desire: "Desire level",
      level: "Skill level",
    },
  },
  search: {
    placeholder: "Search for a skill",
    skills: "Skills",
    profiles: "Profiles",
    certifications: "Certifications",
    placeHolderFilterSelect: "Alphabetical order",
    trends: "Best rated",
    alphabetical: "Alphabetical order",
    noSkill: "No skill found",
    noProfile: "No profile found",
    noCertification: "No certification found",
    mostNoted: "Most noted",
    pageSkillzGraphs: {
      title: "These are the Skillz graphs of ",
    },
    result: "results",
  },
  statistics: {
    myTitleSection: "My statistics",
    titleSection: "Statistics",
    monthStreak: "Months Streak",
    sentenceRankIncodming1: "Still ",
    sentenceRankIncodming2: "xp to be promoted",
    add: "Add %label%",
    league: "League",
    bronze: "Bronze",
    silver: "Silver",
    gold: "Gold",
    platin: "Platin",
    diamond: "Diamond",
    numberCompetencies: "Number of competences",
    ProfileCompDesc: "Complete your profile page",
    ProfileCompTitle: "Profile page",
    subobjectivesLegends: "Add more skills to increase your level !",
  },
};
