package cats
package free

import cats.tests.CatsSuite
import cats.arrow.FunctionK
import cats.laws.discipline.{FunctorTests, SerializableTests}

import org.scalacheck.Arbitrary

class CoyonedaTests extends CatsSuite {
  implicit def coyonedaArbitrary[F[_] : Functor, A : Arbitrary](implicit F: Arbitrary[F[A]]): Arbitrary[Coyoneda[F, A]] =
    Arbitrary(F.arbitrary.map(Coyoneda.lift))

  implicit def coyonedaEq[F[_]: Functor, A](implicit FA: Eq[F[A]]): Eq[Coyoneda[F, A]] =
    new Eq[Coyoneda[F, A]] {
      def eqv(a: Coyoneda[F, A], b: Coyoneda[F, A]): Boolean = FA.eqv(a.run, b.run)
    }

  checkAll("Coyoneda[Option, ?]", FunctorTests[Coyoneda[Option, ?]].functor[Int, Int, Int])
  checkAll("Functor[Coyoneda[Option, ?]]", SerializableTests.serializable(Functor[Coyoneda[Option, ?]]))

  test("toYoneda and then toCoyoneda is identity"){
    forAll{ (y: Coyoneda[Option, Int]) =>
      y.toYoneda.toCoyoneda should === (y)
    }
  }

  test("transform and run is same as applying natural trans") {
      val nt = λ[FunctionK[Option, List]](_.toList)
      val o = Option("hello")
      val c = Coyoneda.lift(o)
      c.transform(nt).run should === (nt(o))
  }
}
