/****************************************************************************
 Copyright (c) 2010-2012 cocos2d-x.org
 Copyright (c) 2013-2016 Chukong Technologies Inc.
 Copyright (c) 2017-2022 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
****************************************************************************/

#ifndef __etc2_h__
#define __etc2_h__
/// @cond DO_NOT_SHOW

typedef unsigned char etc2_byte;
typedef int           etc2_bool;
typedef unsigned int  etc2_uint32;

#ifndef GL_COMPRESSED_RGB8_ETC2
    #define GL_COMPRESSED_RGB8_ETC2 0x9274
#endif

#ifndef GL_COMPRESSED_RGBA8_ETC2_EAC
    #define GL_COMPRESSED_RGBA8_ETC2_EAC 0x9278
#endif

#ifdef __cplusplus
extern "C" {
#endif

// Size of a PKM header, in bytes.

#define ETC2_PKM_HEADER_SIZE 16

#define ETC2_RGB_NO_MIPMAPS  1
#define ETC2_RGBA_NO_MIPMAPS 3

// Check if a PKM header is correctly formatted.

etc2_bool etc2_pkm_is_valid(const etc2_byte *pHeader);

// Read the image width from a PKM header

etc2_uint32 etc2_pkm_get_width(const etc2_byte *pHeader);

// Read the image height from a PKM header

etc2_uint32 etc2_pkm_get_height(const etc2_byte *pHeader);

// Read the image format from a PKM header

etc2_uint32 etc2_pkm_get_format(const etc2_byte *pHeader);

#ifdef __cplusplus
}
#endif

/// @endcond
#endif
