/****************************************************************************
 Copyright (c) 2016 Chukong Technologies Inc.
 Copyright (c) 2017-2022 Xiamen Yaji Software Co., Ltd.

 http://www.cocos.com

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated engine source code (the "Software"), a limited,
 worldwide, royalty-free, non-assignable, revocable and non-exclusive license
 to use Cocos Creator solely to develop games on your target platforms. You shall
 not use Cocos Creator software for developing other software or tools that's
 used for developing games. You are not granted to publish, distribute,
 sublicense, and/or sell copies of Cocos Creator.

 The software or tools in this License Agreement are licensed, not sold.
 Xiamen Yaji Software Co., Ltd. reserves all rights not expressly granted to you.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
****************************************************************************/

#pragma once

#include <unordered_map>

namespace se {

class Object;

class NativePtrToObjectMap {
public:
    // key: native ptr, value: se::Object
    using Map = std::unordered_map<void *, Object *>;

    static bool init();
    static void destroy();

    static Map::iterator find(void *nativeObj);
    static Map::iterator erase(Map::iterator iter);
    static void          erase(void *nativeObj);
    static void          clear();
    static size_t        size();

    static const Map &instance();

    static Map::iterator begin();
    static Map::iterator end();

private:
    static void emplace(void *nativeObj, Object *seObj);
    static Map *__nativePtrToObjectMap;

    friend class Object;
};

class NonRefNativePtrCreatedByCtorMap {
public:
    // key: native ptr, value: non-ref object created by ctor
    using Map = std::unordered_map<void *, bool>;

    static bool init();
    static void destroy();

    static void          emplace(void *nativeObj);
    static Map::iterator find(void *nativeObj);
    static Map::iterator erase(Map::iterator iter);
    static void          erase(void *nativeObj);
    static void          clear();
    static size_t        size();

    static const Map &instance();

    static Map::iterator begin();
    static Map::iterator end();

private:
    static Map *__nonRefNativeObjectCreatedByCtorMap;
};

} // namespace se
