#pragma region Ares Copyrights
/*
 *Copyright (c) 2008+, All Ares Contributors
 *All rights reserved.
 *
 *Redistribution and use in source and binary forms, with or without
 *modification, are permitted provided that the following conditions are met:
 *1. Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 *2. Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the distribution.
 *3. All advertising materials mentioning features or use of this software
 *   must display the following acknowledgement:
 *   This product includes software developed by the Ares Contributors.
 *4. Neither the name of Ares nor the
 *   names of its contributors may be used to endorse or promote products
 *   derived from this software without specific prior written permission.
 *
 *THIS SOFTWARE IS PROVIDED BY ITS CONTRIBUTORS ''AS IS'' AND ANY
 *EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *DISCLAIMED. IN NO EVENT SHALL THE ARES CONTRIBUTORS BE LIABLE FOR ANY
 *DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
#pragma endregion

#pragma once

#include "Parser.h"

#include <Phobos.h>
#include <CCINIClass.h>

class INI_EX {
	CCINIClass* IniFile;

public:
	explicit INI_EX(CCINIClass* pIniFile)
		: IniFile(pIniFile)
	{ }

	explicit INI_EX(CCINIClass& iniFile)
		: IniFile(&iniFile)
	{ }

	char* value() const {
		return Phobos::readBuffer;
	}

	size_t max_size() const {
		return Phobos::readLength;
	}

	bool empty() const {
		return !Phobos::readBuffer[0];
	}

	// basic string reader
	size_t ReadString(const char* pSection, const char* pKey) {
		auto const res = IniFile->ReadString(
			pSection, pKey, "", this->value(), this->max_size());
		return static_cast<size_t>(res);
	}

	// parser template
	template <typename T, size_t Count>
	bool Read(const char* pSection, const char* pKey, T* pBuffer) {
		if (this->ReadString(pSection, pKey)) {
			return Parser<T, Count>::Parse(this->value(), pBuffer) == Count;
		}
		return false;
	}

	// helpers

	bool ReadBool(const char* pSection, const char* pKey, bool* bBuffer) {
		return Read<bool, 1>(pSection, pKey, bBuffer);
	}

	bool ReadInteger(const char* pSection, const char* pKey, int* nBuffer) {
		return Read<int, 1>(pSection, pKey, nBuffer);
	}

	bool Read2Integers(const char* pSection, const char* pKey, int* nBuffer) {
		return Read<int, 2>(pSection, pKey, nBuffer);
	}

	bool Read3Integers(const char* pSection, const char* pKey, int* nBuffer) {
		return Read<int, 3>(pSection, pKey, nBuffer);
	}

	bool Read4Integers(const char* pSection, const char* pKey, int* nBuffer) {
		return Read<int, 4>(pSection, pKey, nBuffer);
	}

	size_t ReadMultipleIntegers(const char* pSection, const char* pKey, int* nBuffer, size_t maxCount = UINT32_MAX)
	{
		if (this->ReadString(pSection, pKey))
			return MultiParser<int>::Parse(this->value(), nBuffer, maxCount);

		return 0;
	}

	bool Read3Bytes(const char* pSection, const char* pKey, byte* nBuffer) {
		return Read<byte, 3>(pSection, pKey, nBuffer);
	}

	bool ReadDouble(const char* pSection, const char* pKey, double* nBuffer) {
		return Read<double, 1>(pSection, pKey, nBuffer);
	}

	bool Read2Doubles(const char* pSection, const char* pKey, double* nBuffer) {
		return Read<double, 2>(pSection, pKey, nBuffer);
	}

	size_t ReadMultipleDoubles(const char* pSection, const char* pKey, double* nBuffer, size_t maxCount = UINT32_MAX)
	{
		if (this->ReadString(pSection, pKey))
			return MultiParser<double>::Parse(this->value(), nBuffer, maxCount);

		return 0;
	}

	bool ReadArmor(const char* pSection, const char* pKey, int *nBuffer) {
		*nBuffer = IniFile->ReadArmorType(pSection, pKey, *nBuffer);
		return (*nBuffer != -1);
	}
};
