/* @preserve
 * IndoorJS 0.2.14+master.c4c9b25, a JS library for interactive indoor maps. https://mudin.github.io/indoorjs
 * (c) 2019 Mudin Ibrahim
 */
!function(t,e){"object"==typeof exports&&"undefined"!=typeof module?e(exports,require("fabric"),require("eventemitter2")):"function"==typeof define&&define.amd?define(["exports","fabric","eventemitter2"],e):e((t=t||self).Indoor={},t.fabric,t.EventEmitter2)}(this,function(t,e,s){"use strict";e=e&&e.hasOwnProperty("default")?e.default:e,s=s&&s.hasOwnProperty("default")?s.default:s;var i="0.2.14+master.c4c9b25";function q(t,e){if(!(t instanceof e))throw new TypeError("Cannot call a class as a function")}function n(t,e){for(var i=0;i<e.length;i++){var n=e[i];n.enumerable=n.enumerable||!1,n.configurable=!0,"value"in n&&(n.writable=!0),Object.defineProperty(t,n.key,n)}}function a(t,e,i){return e&&n(t.prototype,e),i&&n(t,i),t}function c(t,e){if("function"!=typeof e&&null!==e)throw new TypeError("Super expression must either be null or a function");t.prototype=Object.create(e&&e.prototype,{constructor:{value:t,writable:!0,configurable:!0}}),e&&r(t,e)}function h(t){return(h=Object.setPrototypeOf?Object.getPrototypeOf:function(t){return t.__proto__||Object.getPrototypeOf(t)})(t)}function r(t,e){return(r=Object.setPrototypeOf||function(t,e){return t.__proto__=e,t})(t,e)}function o(t,e,i){return(o=function(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Date.prototype.toString.call(Reflect.construct(Date,[],function(){})),!0}catch(t){return!1}}()?Reflect.construct:function(t,e,i){var n=[null];n.push.apply(n,e);var o=new(Function.bind.apply(t,n));return i&&r(o,i.prototype),o}).apply(null,arguments)}function u(t){if(void 0===t)throw new ReferenceError("this hasn't been initialised - super() hasn't been called");return t}function l(t,e){return!e||"object"!=typeof e&&"function"!=typeof e?u(t):e}function d(t,e,i){return(d="undefined"!=typeof Reflect&&Reflect.get?Reflect.get:function(t,e,i){var n=function(t,e){for(;!Object.prototype.hasOwnProperty.call(t,e)&&null!==(t=h(t)););return t}(t,e);if(n){var o=Object.getOwnPropertyDescriptor(n,e);return o.get?o.get.call(i):o.value}})(t,e,i||t)}function N(t,e){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var i=[],n=!0,o=!1,s=void 0;try{for(var r,a=t[Symbol.iterator]();!(n=(r=a.next()).done)&&(i.push(r.value),!e||i.length!==e);n=!0);}catch(t){o=!0,s=t}finally{try{n||null==a.return||a.return()}finally{if(o)throw s}}return i}(t,e)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance")}()}var f=function(t){function r(){var t,e;q(this,r);for(var i=arguments.length,n=new Array(i),o=0;o<i;o++)n[o]=arguments[o];if(1<n.length)t=n[0],e=n[1];else if(0!==n.length&&n[0])if(Object.prototype.hasOwnProperty.call(n[0],"x"))t=n[0].x,e=n[0].y;else if(n[0].length){var s=N(n[0],2);t=s[0],e=s[1]}else console.error("Parameter for Point is not valid. Use Point(x,y) or Point({x,y}) or Point([x,y])",n);else e=t=0;return l(this,h(r).call(this,t,e))}return c(r,fabric.Point),a(r,[{key:"setX",value:function(t){this.x=t||0}},{key:"setY",value:function(t){this.y=t||0}},{key:"getArray",value:function(){return[this.x,this.y]}}]),r}(),v={SELECT:"SELECT",GRAB:"GRAB",DRAW:"DRAW"},p={center:new f,zoom:1,minZoom:0,maxZoom:20,gridEnabled:!0,zoomEnabled:!0,selectEnabled:!0,mode:v.SELECT},g={position:new f,minZoom:1,maxZoom:20},y={url:"data:image/png;base64,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",size:[128,128],anchor:[64,64]};fabric.Object.prototype.originX="center",fabric.Object.prototype.originY="center",fabric.Object.prototype.lockUniScaling=!0,fabric.Object.prototype.lockScalingFlip=!0,fabric.Object.prototype.transparentCorners=!1,fabric.Object.prototype.centeredScaling=!0,fabric.Object.prototype.cornerStyle="circle",fabric.Object.prototype.cornerColor="blue",fabric.Object.prototype.borderColor="blue",fabric.Object.prototype.borderOpacity=.7,fabric.Object.prototype.cornerOpacity=.7,fabric.Object.prototype.cornerStrokeColor="blue",fabric.Object.prototype.borderColor="#2dcfab",fabric.Object.prototype.cornerColor="#2dcfab",fabric.Object.prototype.cornerStrokeColor="#176957",fabric.Object.prototype.objectCaching=!1,fabric.Group.prototype.objectCaching=!0,fabric.Group.prototype.selectionBackgroundColor="rgba(45,207,171,0.25)",fabric.Object.prototype.borderDashArray=[3,3],fabric.Object.prototype.padding=5,fabric.Object.prototype.getBounds=function(){var t=[];return t.push(new f(this.left-this.width/2,this.top-this.height/2)),t.push(new f(this.left+this.width/2,this.top+this.height/2)),t};var m="undefined"!=typeof global?global:"undefined"!=typeof self?self:"undefined"!=typeof window?window:{};function b(){throw new Error("setTimeout has not been defined")}function w(){throw new Error("clearTimeout has not been defined")}var x=b,k=w;function O(e){if(x===setTimeout)return setTimeout(e,0);if((x===b||!x)&&setTimeout)return x=setTimeout,setTimeout(e,0);try{return x(e,0)}catch(t){try{return x.call(null,e,0)}catch(t){return x.call(this,e,0)}}}"function"==typeof m.setTimeout&&(x=setTimeout),"function"==typeof m.clearTimeout&&(k=clearTimeout);var E,j=[],C=!1,L=-1;function A(){C&&E&&(C=!1,E.length?j=E.concat(j):L=-1,j.length&&M())}function M(){if(!C){var t=O(A);C=!0;for(var e=j.length;e;){for(E=j,j=[];++L<e;)E&&E[L].run();L=-1,e=j.length}E=null,C=!1,function(e){if(k===clearTimeout)return clearTimeout(e);if((k===w||!k)&&clearTimeout)return k=clearTimeout,clearTimeout(e);try{k(e)}catch(t){try{return k.call(null,e)}catch(t){return k.call(this,e)}}}(t)}}function z(t){var e=new Array(arguments.length-1);if(1<arguments.length)for(var i=1;i<arguments.length;i++)e[i-1]=arguments[i];j.push(new P(t,e)),1!==j.length||C||O(M)}function P(t,e){this.fun=t,this.array=e}P.prototype.run=function(){this.fun.apply(null,this.array)};var W=m.performance||{},R=(W.now||W.mozNow||W.msNow||W.oNow||W.webkitNow,function(t){return"number"==typeof t&&!isNaN(t)}),S=function(t,e){var i=(e=e||t.currentTarget).getBoundingClientRect(),n=t.originalEvent||t,o=0,s=0;return t.touches&&t.touches.length?R(t.touches[0].pageX)&&R(t.touches[0].pageY)?(o=t.touches[0].pageX,s=t.touches[0].pageY):R(t.touches[0].clientX)&&R(t.touches[0].clientY)&&(o=n.touches[0].clientX,s=n.touches[0].clientY):R(t.pageX)&&R(t.pageY)?(o=t.pageX,s=t.pageY):t.currentPoint&&R(t.currentPoint.x)&&R(t.currentPoint.y)&&(o=t.currentPoint.x,s=t.currentPoint.y),{x:o-i.left,y:s-i.top}};window.addEventListener("touchmove",function(){});var T=function t(e){var n,o,s,r,a,c,h,u,i,l,d,f=e.source,v=void 0===f?document:f,p=e.update,g=e.multiplier,y=void 0===g?1:g,m=e.friction,b=void 0===m?.92:m,w=e.initialValues,x=e.boundX,k=e.boundY,O=e.bounce,E=void 0===O||O;q(this,t);var j=0,C=0,L=.3*y,A=!1,M=!1,z=!1,P=!1,W=[];function R(){document.removeEventListener("touchmove",Y,!!K()&&{passive:!1}),document.removeEventListener("touchend",X),document.removeEventListener("touchcancel",B),document.removeEventListener("mousemove",Y,!!K()&&{passive:!1}),document.removeEventListener("mouseup",X)}function S(){p.call(v,j,C)}function T(t){if("touchmove"!==t.type&&"touchstart"!==t.type&&"touchend"!==t.type)return{x:t.clientX,y:t.clientY,id:null};var e=t.targetTouches[0]||t.changedTouches[0];return{x:e.clientX,y:e.clientY,id:e.identifier}}function I(t){var e=T(t);M||z||(P=!(M=!0),i=e.id,a=h=e.x,c=u=e.y,W=[],F(a,c),R(),document.addEventListener("touchmove",Y,!!K()&&{passive:!1}),document.addEventListener("touchend",X),document.addEventListener("touchcancel",B),document.addEventListener("mousemove",Y,!!K()&&{passive:!1}),document.addEventListener("mouseup",X))}function Y(t){t.preventDefault();var e=T(t);M&&e.id===i&&(h=e.x,u=e.y,F(a,c),function(){A||Z(U);A=!0}())}function X(t){var e=T(t);M&&e.id===i&&B()}function B(){M=!1,F(a,c),function(){var t=W[0],e=W[W.length-1],i=e.x-t.x,n=e.y-t.y,o=(e.time-t.time)/15/y;l=i/o||0,d=n/o||0;var s=G();(1<Math.abs(l)||1<Math.abs(d)||!s.inBounds)&&(P=!0,Z(Q))}(),R()}function F(t,e){for(var i=Date.now();0<W.length&&!(i-W[0].time<=100);)W.shift();W.push({x:t,y:e,time:i})}function U(){var t=h-a,e=u-c;if(j+=t*y,C+=e*y,E){var i=G();0!==i.x&&(j-=t*D(i.x)*y),0!==i.y&&(C-=e*D(i.y)*y)}else G(!0);S(),a=h,c=u,A=!1}function D(t){return 5e-6*Math.pow(t,2)+1e-4*t+.55}function G(t){var e=0,i=0;return void 0!==n&&j<n?e=n-j:void 0!==o&&o<j&&(e=o-j),void 0!==s&&C<s?i=s-C:void 0!==r&&r<C&&(i=r-C),t&&(0!==e&&(j=0<e?n:o),0!==i&&(C=0<i?s:r)),{x:e,y:i,inBounds:0===e&&0===i}}function Q(){if(P){j+=l*=b,C+=d*=b;var t=G();if(Math.abs(l)>L||Math.abs(d)>L||!t.inBounds){if(E){if(0!==t.x)if(t.x*l<=0)l+=.04*t.x;else{var e=0<t.x?2.5:-2.5;l=.11*(t.x+e)}if(0!==t.y)if(t.y*d<=0)d+=.04*t.y;else{var i=0<t.y?2.5:-2.5;d=.11*(t.y+i)}}else 0!==t.x&&(j=0<t.x?n:o,l=0),0!==t.y&&(C=0<t.y?s:r,d=0);S(),Z(Q)}else P=!1}}!function(){if(!(v="string"==typeof v?document.querySelector(v):v))throw new Error("IMPETUS: source not found.");if(!p)throw new Error("IMPETUS: update function not defined.");w&&(w[0]&&(j=w[0]),w[1]&&(C=w[1]),S()),x&&(n=x[0],o=x[1]),k&&(s=k[0],r=k[1]),v.addEventListener("touchstart",I),v.addEventListener("mousedown",I)}(),this.destroy=function(){return v.removeEventListener("touchstart",I),v.removeEventListener("mousedown",I),R(),null},this.pause=function(){R(),z=!(M=!1)},this.resume=function(){z=!1},this.setValues=function(t,e){"number"==typeof t&&(j=t),"number"==typeof e&&(C=e)},this.setMultiplier=function(t){L=.3*(y=t)},this.setBoundX=function(t){n=t[0],o=t[1]},this.setBoundY=function(t){s=t[0],r=t[1]}},Z=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||function(t){window.setTimeout(t,1e3/60)};function K(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){t=!0}});window.addEventListener("test",null,e)}catch(t){}return K=function(){return t},t}var I=function(t,e){e||(e=[0,""]),t=String(t);var i=parseFloat(t,10);return e[0]=i,e[1]=t.match(/[\d.\-\+]*\s*(.*)/)[1]||"",e},Y={ch:8,ex:7.15625,em:16,rem:16,in:96,cm:96/2.54,mm:96/25.4,pt:96/72,pc:16,px:1};function X(t){if(!t)return null;if(Y[t])return Y[t];var e=I(t);if(isNaN(e[0])||!e[1])return null;var i=X(e[1]);return"number"==typeof i?e[0]*i:null}var B={left:0,top:0};function F(t,e,i){e=e||t.currentTarget||t.srcElement,Array.isArray(i)||(i=[0,0]);var n,o=t.clientX||0,s=t.clientY||0,r=(n=e)===window||n===document||n===document.body?B:n.getBoundingClientRect();return i[0]=o-r.left,i[1]=s-r.top,i}function U(h){h=h||window;var u=new s,l=[null,null],d=0,f=0,v=!1,t=!1;return Object.defineProperties(u,{pinching:function(){return 2===d},fingers:function(){return l}}),e(),u.enable=e,u.disable=function(){if(!t)return;t=!1,l[d=0]=null,l[1]=null,f=0,v=!1,h.removeEventListener("touchstart",i,!1),h.removeEventListener("touchmove",n,!1),h.removeEventListener("touchend",o,!1),h.removeEventListener("touchcancel",o,!1)},u.indexOfTouch=p,u;function p(t){for(var e=t.identifier,i=0;i<l.length;i++)if(l[i]&&l[i].touch&&l[i].touch.identifier===e)return i;return-1}function e(){t||(t=!0,h.addEventListener("touchstart",i,!1),h.addEventListener("touchmove",n,!1),h.addEventListener("touchend",o,!1),h.addEventListener("touchcancel",o,!1))}function i(t){for(var e=0;e<t.changedTouches.length;e++){var i=t.changedTouches[e];if(-1===p(i.identifier)&&d<2){var n=0===d,o=l[0]?1:0,s=l[0]?0:1,r=new D;l[o]=r,d++,F(r.touch=i,h,r.position);var a=l[s]?l[s].touch:void 0;if(u.emit("place",i,a),!n){var c=g();v=!1,u.emit("start",c),f=c}}}}function n(t){for(var e=!1,i=0;i<t.changedTouches.length;i++){var n=t.changedTouches[i],o=p(n);-1!==o&&(e=!0,F(l[o].touch=n,h,l[o].position))}if(2===d&&e){var s=g();u.emit("change",s,f),f=s}}function o(t){for(var e=0;e<t.changedTouches.length;e++){var i=t.changedTouches[e],n=p(i);if(-1!==n){l[n]=null,d--;var o=0===n?1:0,s=l[o]?l[o].touch:void 0;u.emit("lift",i,s)}}v||2===d||(v=!0,u.emit("end"))}function g(){return d<2?0:(t=l[0].position,e=l[1].position,i=e[0]-t[0],n=e[1]-t[1],Math.sqrt(i*i+n*n));var t,e,i,n}}function D(){this.position=[0,0],this.touch=null}function G(t){return window["webkit"+t]||window["moz"+t]||window["ms"+t]}var Q=0;function H(t){var e=+new Date,i=Math.max(0,16-(e-Q));return Q=e+i,window.setTimeout(t,i)}var V=window.requestAnimationFrame||G("RequestAnimationFrame")||H,J=window.cancelAnimationFrame||G("CancelAnimationFrame")||G("CancelRequestAnimationFrame")||function(t){window.clearTimeout(t)},_=function(t,e,i){if(!i||V!==H)return V.call(window,function(t,e){var i=Array.prototype.slice;if(t.bind)return t.bind.apply(t,i.call(arguments,1));var n=i.call(arguments,2);return function(){return t.apply(e,n.length?n.concat(i.call(arguments)):arguments)}}(t,e));t.call(e)};_.cancel=function(t){t&&J.call(window,t)};var $=function(o,i){o instanceof Function&&(i=o,o=document.documentElement||document.body),"string"==typeof o&&(o=document.querySelector(o));var n,s={x:0,y:0},r=0,a=0,c=!0,t=function(t){c=!0};o.addEventListener("mousedown",t),o.addEventListener("mousemove",function(t){s=S(t)}),o.addEventListener("wheel",function(t){t&&(s=S(t))}),o.addEventListener("touchstart",t,!!function(){var e=!1;try{var t=Object.defineProperty({},"passive",{get:function(){e=!0}});window.addEventListener("test",null,t),window.removeEventListener("test",null,t)}catch(t){e=!1}return e}()&&{passive:!0});var h=0,u=0;n=new T({source:o,update:function(t,e){c&&(c=!1,r=s.x,a=s.y);var i={target:o,type:"mouse",dx:t-u,dy:e-h,dz:0,x:s.x,y:s.y,x0:r,y0:a};u=t,h=e,p(i)},multiplier:1,friction:.75});var l,d,f,e=function(t,s,r){"function"==typeof t&&(r=!!s,s=t,t=window);var a=X("ex"),e=function(t){r&&t.preventDefault();var e=t.deltaX||0,i=t.deltaY||0,n=t.deltaZ||0,o=1;switch(t.deltaMode){case 1:o=a;break;case 2:o=window.innerHeight}if(i*=o,n*=o,(e*=o)||i||n)return s(e,i,n,t)};return t.addEventListener("wheel",e),e}(o,function(t,e,i,n){n.preventDefault(),p({target:o,type:"mouse",dx:0,dy:0,dz:e,x:s.x,y:s.y,x0:s.x,y0:s.y})}),v=U(o);function p(e){null==f?f=_(function(){if(i(e),f=null,d){var t=d;d=null,p(t)}}):d?(d.dx+=e.dx,d.dy+=e.dy,d.dz+=e.dz,d.x=e.x,d.y=e.y):d=e}return v.on("start",function(t){var e=v.fingers[0],i=v.fingers[1];l=[.5*i.position[0]+.5*e.position[0],.5*i.position[1]+.5*e.position[1]],n&&n.pause()}),v.on("end",function(){l&&(l=null,n&&n.resume())}),v.on("change",function(t,e){v.pinching&&l&&p({target:o,type:"touch",dx:0,dy:0,dz:2*-(t-e),x:l[0],y:l[1],x0:l[0],y0:l[0]})}),function(){o.removeEventListener("mousedown",t),o.removeEventListener("wheel"),o.removeEventListener("touchstart",t),n.destroy(),o.removeEventListener("wheel",e),v.disable(),_.cancel(f)}};function tt(t,e,i){return e<i?Math.max(Math.min(t,i),e):Math.max(Math.min(t,e),i)}var et=Math.abs,it=Math.min;function nt(t,e,i,n){var o=et(t-e);return null==i&&(i=nt.DBL_EPSILON),null==n&&(n=i),o<=i||(o<=n*it(et(t),et(e))||t===e)}nt.FLT_EPSILON=1.1920929e-7,nt.DBL_EPSILON=2220446049250313e-31;var ot=Math.log10||function(t){return Math.log(t)/Math.log(10)};function st(t,e,i){var n=t%e;return i||(i=nt.FLT_EPSILON),!n||!(!nt(0,n,i,0)&&!nt(Math.abs(e),Math.abs(n),i,0))}function rt(t,e){var i=Math.floor(ot(t)),n=Math.pow(10,i),o=e.map(function(t){return t*n});n=Math.pow(10,i+1),o=o.concat(e.map(function(t){return t*n}));for(var s=0,r=0;r<o.length&&!(t<=(s=o[r]));r++);return s}var at=function(t){if("[object Object]"!==Object.prototype.toString.call(t))return!1;var e=Object.getPrototypeOf(t);return null===e||e===Object.getPrototypeOf({})},ct=function(t){function i(t){var e;return q(this,i),(e=l(this,h(i).call(this,t)))._options=t||{},Object.assign(u(e),t),e}return c(i,s),i}();function ht(t,e){var i=t.replace(/[^\d,]/g,"").split(",");return null==e&&(e=i[3]||1),i[3]=e,"rgba("+i.join(",")+")"}var ut={steps:[1,2,5],distance:20,unit:10,lines:function(t){var e=t.coordinate,i=t.step=rt(e.distance*e.zoom,e.steps);return function(t,e,i){if(null!=t&&"number"!=typeof t)throw new Error("start must be a number or null");if(null!=e&&"number"!=typeof e)throw new Error("stop must be a number or null");if(null!=i&&"number"!=typeof i)throw new Error("step must be a number or null");null==e&&(e=t||0,t=0),null==i&&(i=t<e?1:-1);for(var n=[],o=t<e;o?t<e:e<t;t+=i)n.push(t);return n}(Math.floor(t.offset/i)*i,Math.ceil((t.offset+t.range)/i+1)*i,i)},lineColor:function(t){if(t.lines){var e=t.coordinate,i=ht(e.color,.1),n=ht(e.color,.3),o=t.step,s=Math.ceil(ot(o)),r=Math.pow(10,s),a=Math.pow(10,s+1),c=o/10;return t.lines.map(function(t){return st(t,a,c)?n:st(t,r,c)?i:null})}},ticks:function(t){if(t.lines){var e=t.coordinate,i=rt(1.1*rt(1.1*t.step,e.steps),e.steps),n=i/10,o=4*t.axisWidth;return t.lines.map(function(t){return st(t,i,n)?nt(t,0,n)?null:o:null})}},labels:function(t){if(t.lines){var e=t.coordinate,i=rt(1.1*rt(1.1*t.step,e.steps),e.steps),n=i/100;return t.lines.map(function(t){return st(t,i,n)?nt(t,0,n)?"y"===e.orientation?null:"0":(t=Number((t/100).toFixed(2)),e.format(t)):null})}}},lt=function(){function i(t,e){q(this,i),Object.assign(this,e),this.orientation=t||"x"}return a(i,[{key:"getCoords",value:function(t){var e=[];if(!t)return e;for(var i=0;i<t.length;i+=1){var n=this.getRatio(t[i]);e.push(n),e.push(0),e.push(n),e.push(1)}return e}},{key:"getRange",value:function(){var t=this.width;return"y"===this.orientation&&(t=this.height),t*this.zoom}},{key:"getRatio",value:function(t){return(t-this.offset)/this.range}},{key:"setOffset",value:function(t){this.offset=t}},{key:"update",value:function(t){t=t||{},Object.assign(this,t),this.range=this.getRange()}}]),i}(),dt=function(t){function n(t,e){var i;return q(this,n),(i=l(this,h(n).call(this,e))).canvas=t,i.context=i.canvas.getContext("2d"),i.state={},i.setDefaults(),i.update(e),i}return c(n,ct),a(n,[{key:"render",value:function(){return this.draw(),this}},{key:"getCenterCoords",value:function(){var t=this.state.x,e=N(t.shape,2),i=e[0],n=e[1],o=N(t.padding,4),s=o[0],r=o[1],a=o[2],c=o[3],h=t.opposite.coordinate.getCoords([t.coordinate.axisOrigin],t.opposite),u=s+h[1]*(n-s-a),l=N((t=this.state.y).shape,2);i=l[0],n=l[1];var d=N(t.padding,4);return s=d[0],r=d[1],a=d[2],{x:(c=d[3])+(h=t.opposite.coordinate.getCoords([t.coordinate.axisOrigin],t.opposite))[0]*(i-r-c),y:u}}},{key:"setSize",value:function(t,e){this.setWidth(t),this.setHeight(e)}},{key:"setWidth",value:function(t){this.canvas.width=t}},{key:"setHeight",value:function(t){this.canvas.height=t}},{key:"update",value:function(t){t||(t={});var e=[this.canvas.width,this.canvas.height];return this.state.x=this.calcCoordinate(this.axisX,e,this),this.state.y=this.calcCoordinate(this.axisY,e,this),this.state.x.opposite=this.state.y,this.state.y.opposite=this.state.x,this.emit("update",t),this}},{key:"update2",value:function(t){var e=[this.canvas.width,this.canvas.height];Object.assign(this.center,t),this.state.x=this.calcCoordinate(this.axisX,e,this),this.state.y=this.calcCoordinate(this.axisY,e,this),this.state.x.opposite=this.state.y,this.state.y.opposite=this.state.x,this.emit("update",t),this.axisX.offset=t.x,this.axisX.zoom=1/t.zoom,this.axisY.offset=t.y,this.axisY.zoom=1/t.zoom}},{key:"calcCoordinate",value:function(t,e){var i,n,o,s={coordinate:t,shape:e,grid:this};if(s.range=t.getRange(s),s.offset=tt(t.offset-s.range*tt(.5,0,1),Math.max(t.min,1-Number.MAX_VALUE),Math.min(t.max,Number.MAX_VALUE)-s.range),s.zoom=t.zoom,s.axisColor="number"==typeof t.axisColor?ht(t.color,t.axisColor):t.axisColor||t.color,s.axisWidth=t.axisWidth||t.lineWidth,s.lineWidth=t.lineWidth,s.tickAlign=t.tickAlign,s.labelColor=s.color,"number"==typeof t.padding?s.padding=Array(4).fill(t.padding):t.padding instanceof Function?s.padding=t.padding(s):s.padding=t.padding,"number"==typeof t.fontSize)s.fontSize=t.fontSize;else{var r=I(t.fontSize);s.fontSize=r[0]*X(r[1])}if(s.fontFamily=t.fontFamily||"sans-serif",i=t.lines instanceof Function?t.lines(s):t.lines||[],s.lines=i,t.lineColor instanceof Function)s.lineColors=t.lineColor(s);else if(Array.isArray(t.lineColor))s.lineColors=t.lineColor;else{var a=ht(t.color,t.lineColor);"number"!=typeof t.lineColor&&(a=!1===t.lineColor||null==t.lineColor?null:t.color),s.lineColors=Array(i.length).fill(a)}if(t.ticks instanceof Function)n=t.ticks(s);else if(Array.isArray(t.ticks))n=t.ticks;else{var c=!0===t.ticks||!0===t.ticks?2*s.axisWidth:t.ticks||0;n=Array(i.length).fill(c)}return s.ticks=n,o=!0===t.labels?s.lines:t.labels instanceof Function?t.labels(s):Array.isArray(t.labels)?t.labels:at(t.labels)?t.labels:Array(s.lines.length).fill(null),s.labels=o,at(n)&&(s.ticks=Array(i.length).fill(0)),at(o)&&(s.labels=Array(i.length).fill(null)),at(n)&&Object.keys(n).forEach(function(t,e){s.ticks.push(e),s.lines.push(parseFloat(t)),s.lineColors.push(null),s.labels.push(null)}),at(o)&&Object.keys(o).forEach(function(t,e){s.labels.push(t),s.lines.push(parseFloat(e)),s.lineColors.push(null),s.ticks.push(null)}),s}},{key:"setDefaults",value:function(){this.pixelRatio=window.devicePixelRatio,this.autostart=!0,this.interactions=!0,this.defaults=Object.assign({type:"linear",name:"",units:"",state:{},minZoom:-1/0,maxZoom:1/0,min:-1/0,max:1/0,offset:0,origin:.5,center:{x:0,y:0,zoom:1},zoom:1,zoomEnabled:!0,panEnabled:!0,labels:!0,fontSize:"11pt",fontFamily:"sans-serif",padding:0,color:"rgb(0,0,0,1)",lines:!0,tick:8,tickAlign:.5,lineWidth:1,distance:13,style:"lines",lineColor:.4,axis:!0,axisOrigin:0,axisWidth:2,axisColor:.8,getCoords:function(){return[0,0,0,0]},getRatio:function(){return 0},format:function(t){return t}},ut,this._options),this.axisX=new lt("x",this.defaults),this.axisY=new lt("y",this.defaults),this.axisX=Object.assign({},this.defaults,{orientation:"x",offset:this.center.x,getCoords:function(t,e){var i=[];if(!t)return i;for(var n=0;n<t.length;n+=1){var o=e.coordinate.getRatio(t[n],e);i.push(o),i.push(0),i.push(o),i.push(1)}return i},getRange:function(t){return t.shape[0]*t.coordinate.zoom},getRatio:function(t,e){return(t-e.offset)/e.range}}),this.axisY=Object.assign({},this.defaults,{orientation:"y",offset:this.center.y,getCoords:function(t,e){var i=[];if(!t)return i;for(var n=0;n<t.length;n+=1){var o=e.coordinate.getRatio(t[n],e);i.push(0),i.push(o),i.push(1),i.push(o)}return i},getRange:function(t){return t.shape[1]*t.coordinate.zoom},getRatio:function(t,e){return 1-(t-e.offset)/e.range}}),Object.assign(this,this.defaults),Object.assign(this,this._options),this.center=new f(this.center)}},{key:"draw",value:function(){return this.context.clearRect(0,0,this.canvas.width,this.canvas.height),this.drawLines(this.state.x),this.drawLines(this.state.y),this}},{key:"drawLines",value:function(t){if(t&&t.coordinate){var e=this.context,i=N(t.shape,2),n=i[0],o=i[1],s=N(t.padding,4),r=s[0],a=s[1],c=s[2],h=s[3],u=t.opposite.coordinate.getRatio(t.coordinate.axisOrigin,t.opposite);u=tt(u,0,1);var l=t.coordinate.getCoords(t.lines,t);e.lineWidth=1;for(var d=0,f=0;d<l.length;d+=4,f+=1){var v=t.lineColors[f];if(v){e.strokeStyle=v,e.beginPath();var p=0+h+l[d]*(n-a-h),g=0+r+l[d+1]*(o-c-r),y=0+h+l[d+2]*(n-a-h),m=0+r+l[d+3]*(o-c-r);e.moveTo(p,g),e.lineTo(y,m),e.stroke(),e.closePath()}}for(var b,w,x=[],k=0;k<l.length;k+=4){var O=l[k],E=l[k+1],j=l[k+2]-O,C=l[k+3]-E,L=(b=j,w=C,Math.sqrt(b*b+w*w));x.push(j/L),x.push(C/L)}var A=[];t.labelCoords=[];for(var M=t.ticks,z=0,P=0,W=0;z<x.length;W+=1,z+=2,P+=4){var R=l[P],S=l[P+1],T=(l[P+2]-R)*u,I=(l[P+3]-S)*u,Y=[x[z]*M[W]/(n-h-a),x[z+1]*M[W]/(o-r-c)];A.push(x[z]*(T+Y[0]*t.tickAlign)+R),A.push(x[z+1]*(I+Y[1]*t.tickAlign)+S),A.push(x[z]*(T-Y[0]*(1-t.tickAlign))+R),A.push(x[z+1]*(I-Y[1]*(1-t.tickAlign))+S),t.labelCoords.push(x[z]*T+R),t.labelCoords.push(x[z+1]*I+S)}if(M.length){e.lineWidth=t.axisWidth/2,e.beginPath();for(var X=0,B=0;X<A.length;X+=4,B+=1)if(!nt(t.lines[B],t.opposite.coordinate.axisOrigin)){var F=0+h+A[X]*(n-h-a),U=0+r+A[X+1]*(o-r-c),D=0+h+A[X+2]*(n-h-a),G=0+r+A[X+3]*(o-r-c);e.moveTo(F,U),e.lineTo(D,G)}e.strokeStyle=t.axisColor,e.stroke(),e.closePath()}if(t.coordinate.axis&&t.axisColor){var Q=t.opposite.coordinate.getCoords([t.coordinate.axisOrigin],t.opposite);e.lineWidth=t.axisWidth/2;var q=0+h+tt(Q[0],0,1)*(n-a-h),Z=0+r+tt(Q[1],0,1)*(o-r-c),K=0+h+tt(Q[2],0,1)*(n-a-h),H=0+r+tt(Q[3],0,1)*(o-r-c);e.beginPath(),e.moveTo(q,Z),e.lineTo(K,H),e.strokeStyle=t.axisColor,e.stroke(),e.closePath()}this.drawLabels(t)}}},{key:"drawLabels",value:function(t){if(t.labels){var e=this.context,i=N(t.shape,2),n=i[0],o=i[1],s=N(t.padding,4),r=s[0],a=s[1],c=s[2],h=s[3];e.font="300 ".concat(t.fontSize,"px ").concat(t.fontFamily),e.fillStyle=t.labelColor,e.textBaseline="top";for(var u=t.fontSize,l=t.axisWidth+1.5,d=t.tickAlign<.5?-u-2*t.axisWidth:2*t.axisWidth,f="y"===t.coordinate.orientation&&!t.opposite.disabled,v=0;v<t.labels.length;v+=1){var p=t.labels[v];if(null!=p&&(!f||!nt(t.lines[v],t.opposite.coordinate.axisOrigin))){var g=e.measureText(p).width,y=t.labelCoords[2*v]*(n-h-a)+l+h;"y"===t.coordinate.orientation&&(y=tt(y,l,n-g-1-t.axisWidth),p*=-1);var m=t.labelCoords[2*v+1]*(o-r-c)+d+r;"x"===t.coordinate.orientation&&(m=tt(m,0,o-u-d)),e.fillText(p,y,m)}}}}}]),n}(),ft=function(e){return function(t){function i(t){var e;return q(this,i),e=l(this,h(i).call(this,t)),console.log("modesMixin"),e}return c(i,e),a(i,[{key:"setMode",value:function(t){switch(this.mode=t){case v.SELECT:this.canvas.isDrawingMode=!1,this.canvas.interactive=!0,this.canvas.selection=!0,this.canvas.hoverCursor="default",this.canvas.moveCursor="default",this.canvas.setCursor("default");break;case v.GRAB:this.canvas.isDrawingMode=!1,this.canvas.interactive=!1,this.canvas.selection=!1,this.canvas.discardActiveObject(),this.canvas.hoverCursor="move",this.canvas.moveCursor="move",this.canvas.setCursor("move");break;case v.DRAW:this.canvas.isDrawingMode=!0}}},{key:"setModeAsDraw",value:function(){this.setMode(v.DRAW),console.log("MODE: DRAW")}},{key:"setModeAsSelect",value:function(){this.setMode(v.SELECT),console.log("MODE: SELECT")}},{key:"setModeAsGrab",value:function(){this.setMode(v.GRAB),console.log("MODE: GRAB")}},{key:"isSelectMode",value:function(){return this.mode===v.SELECT}},{key:"isGrabMode",value:function(){return this.mode===v.GRAB}},{key:"isDrawMode",value:function(){return this.mode===v.DRAW}}]),i}()},vt=function(t){return new pt(t)},pt=function(){function e(t){q(this,e),this.superclass=t||function(){return function t(){q(this,t)}}()}return a(e,[{key:"with",value:function(){for(var t=arguments.length,e=new Array(t),i=0;i<t;i++)e[i]=arguments[i];return e.reduce(function(t,e){return e(t)},this.superclass)}}]),e}(),gt=function(t){function s(t,e){var i;q(this,s),(i=l(this,h(s).call(this,e))).defaults=Object.assign({},p),Object.assign(u(i),i.defaults),Object.assign(u(i),i._options),i.center=new f(i.center),i.container=t||document.body;var n=document.createElement("canvas");i.container.appendChild(n),n.setAttribute("id","indoors-map-canvas"),n.width=i.width||i.container.clientWidth,n.height=i.height||i.container.clientHeight,i.canvas=new fabric.Canvas(n,{preserveObjectStacking:!0}),i.context=i.canvas.getContext("2d"),i.on("render",function(){i.autostart&&i.clear()}),i.originX=-i.canvas.width/2,i.originY=-i.canvas.height/2,i.canvas.absolutePan({x:i.originX,y:i.originY}),i.x=i.center.x,i.y=i.center.y,i.dx=0,i.dy=0;try{i.addFloorPlan()}catch(t){console.error(t)}i.addGrid(),i.setMode(i.mode||v.GRAB);var o=u(i);return $(i.container,function(t){o.panzoom(t)}),i.registerListeners(),setTimeout(function(){i.emit("ready",u(i))},300),i}return c(s,vt(ct)["with"](ft)),a(s,[{key:"addFloorPlan",value:function(){if(this.floorplan){var e=this;this.floorplan.on("load",function(t){e.addLayer(t)})}}},{key:"addLayer",value:function(t){t.shape?(this.canvas.add(t.shape),this.canvas._objects.sort(function(t,e){return t.zIndex-e.zIndex}),t.shape.keepOnZoom&&(t.shape._set("scaleX",1/this.zoom),t.shape._set("scaleY",1/this.zoom),this.emit("".concat(t.class,"scaling"),t)),t.class&&this.emit("".concat(t.class,":added"),t)):console.error("shape is undefined")}},{key:"removeLayer",value:function(t){t&&t.shape&&(t.class&&this.emit("".concat(t.class,":removed"),t),this.canvas.remove(t.shape))}},{key:"addGrid",value:function(){this.gridCanvas=this.cloneCanvas(),this.gridCanvas.setAttribute("id","indoors-grid-canvas"),this.grid=new dt(this.gridCanvas,this),this.grid.draw()}},{key:"moveTo",value:function(t,e){void 0!==e&&(t.zIndex=e),this.canvas.moveTo(t.shape,t.zIndex)}},{key:"cloneCanvas",value:function(t){t=t||this.canvas;var e=document.createElement("canvas");return e.width=t.width,e.height=t.height,t.wrapperEl.appendChild(e),e}},{key:"setZoom",value:function(t){var e=this,i=this.canvas,n=i.width,o=i.height;this.zoom=tt(t,this.minZoom,this.maxZoom),this.dx=0,this.dy=0,this.x=n/2,this.y=o/2,this.update(),z(function(){e.update()})}},{key:"getBounds",value:function(){var e=1/0,i=-1/0,n=1/0,o=-1/0;return this.canvas.forEachObject(function(t){t.getBounds().forEach(function(t){e=Math.min(e,t.x),i=Math.max(i,t.x),n=Math.min(n,t.y),o=Math.max(o,t.y)})}),[new f(e,n),new f(i,o)]}},{key:"fitBounds",value:function(){var t=this,e=0<arguments.length&&void 0!==arguments[0]?arguments[0]:100;this.onResize();var i=this.canvas,n=i.width,o=i.height;this.originX=-this.canvas.width/2,this.originY=-this.canvas.height/2;var s=this.getBounds();this.center.x=(s[0].x+s[1].x)/2,this.center.y=-(s[0].y+s[1].y)/2;var r=n/(Math.abs(s[0].x-s[1].x)+e),a=o/(Math.abs(s[0].y-s[1].y)+e);this.zoom=Math.min(r,a),this.canvas.setZoom(this.zoom),this.canvas.absolutePan({x:this.originX+this.center.x*this.zoom,y:this.originY-this.center.y*this.zoom}),this.update(),z(function(){t.update()})}},{key:"reset",value:function(){var t=this,e=this.canvas,i=e.width,n=e.height;this.zoom=this._options.zoom||1,this.center=new f,this.originX=-this.canvas.width/2,this.originY=-this.canvas.height/2,this.canvas.absolutePan({x:this.originX,y:this.originY}),this.x=i/2,this.y=n/2,this.update(),z(function(){t.update()})}},{key:"onResize",value:function(t,e){var i=this.canvas.width,n=this.canvas.height;t=t||this.container.clientWidth,e=e||this.container.clientHeight,this.canvas.setWidth(t),this.canvas.setHeight(e),this.grid.setSize(t,e);var o=t/2-i/2,s=e/2-n/2;this.canvas.relativePan({x:o,y:s}),this.update()}},{key:"update",value:function(){var t=this.canvas;this.grid.update2({x:this.center.x,y:this.center.y,zoom:this.zoom}),this.emit("update",this),this.grid.render(),t.zoomToPoint(new f(this.x,this.y),this.zoom),this.isGrabMode()&&(t.relativePan(new f(this.dx,this.dy)),this.emit("panning"));for(var e=t.getObjects(),i=0;i<e.length;i+=1){var n=e[i];n.keepOnZoom&&(n._set("scaleX",1/this.zoom),n._set("scaleY",1/this.zoom),this.emit("".concat(n.class,"scaling"),n))}}},{key:"panzoom",value:function(t){var e=this.canvas,i=e.width,n=e.height,o=tt(-t.dz,.75*-n,.75*n)/n,s=1/this.zoom,r=s*(1-o);r=tt(r,this.minZoom,this.maxZoom);var a=this.center,c=a.x,h=a.y;(this.isGrabMode()&&(c-=s*t.dx,h+=s*t.dy),this.zoomEnabled)&&(c-=i*(r-s)*(t.x/i-.5),h-=n*(r-s)*(.5-t.y/n));this.center.setX(c),this.center.setY(h),this.zoom=1/r,this.dx=t.dx,this.dy=t.dy,this.x=t.x0,this.y=t.y0,this.update()}},{key:"registerListeners",value:function(){var s=this,r=this;this.canvas.on("object:scaling",function(t){if(t.target.class)r.emit("".concat(t.target.class,":scaling"),t.target.parent);else{var e=t.target;if(e.getObjects){var i=e.getObjects();e.removeWithUpdate();for(var n=0;n<i.length;n+=1){var o=i[n];o.fire("moving",o.parent),r.emit("".concat(o.class,":moving"),o.parent)}r.update(),r.canvas.renderAll()}}}),this.canvas.on("object:rotating",function(t){if(t.target.class)r.emit("".concat(t.target.class,":rotating"),t.target.parent);else{var e=t.target;if(e.getObjects){for(var i=e.getObjects(),n=0;n<i.length;n+=1){var o=i[n];o.class&&(o._set("angle",-e.angle),o.fire("moving",o.parent),r.emit("".concat(o.class,":moving"),o.parent))}s.update()}}}),this.canvas.on("object:moving",function(t){if(t.target.class)r.emit("".concat(t.target.class,":moving"),t.target.parent);else{var e=t.target;if(e.getObjects){for(var i=e.getObjects(),n=0;n<i.length;n+=1){var o=i[n];o.class&&(o.fire("moving",o.parent),r.emit("".concat(o.class,":moving"),o.parent))}s.update()}}}),this.canvas.on("object:moved",function(t){t.target.class&&r.emit("".concat(t.target.class,"dragend"),t),s.update()}),this.canvas.on("selection:cleared",function(t){var e=t.deselected;if(e&&e.length)for(var i=0;i<e.length;i+=1){var n=e[i];n.class&&(n._set("angle",0),n._set("scaleX",1/r.zoom),n._set("scaleY",1/r.zoom),n.parent&&(n.parent.inGroup=!1),n.fire("moving",n.parent))}}),this.canvas.on("selection:created",function(t){console.log(t);var e=t.selected;if(e&&!(e.length<2))for(var i=0;i<e.length;i+=1){var n=e[i];n.class&&n.parent&&(n.parent.inGroup=!0)}}),this.canvas.on("selection:updated",function(t){console.log(t);var e=t.selected;if(e&&!(e.length<2))for(var i=0;i<e.length;i+=1){var n=e[i];n.class&&n.parent&&(n.parent.inGroup=!0)}}),this.canvas.on("mouse:down",function(t){r.dragObject=t.target}),this.canvas.on("mouse:move",function(t){r.dragObject&&r.dragObject.clickable&&(r.dragObject===t.target?r.dragObject.dragging=!0:r.dragObject.dragging=!1)}),this.canvas.on("mouse:up",function(t){if(r.dragObject&&r.dragObject.clickable){if(r.dragObject!==t.target)return;r.dragObject.dragging||r.modeToggleByKey||(console.log("click"),r.emit("".concat(r.dragObject.class,":click"),r.dragObject.parent)),r.dragObject.dragging=!1}r.dragObject=null}),window.addEventListener("resize",function(){r.onResize()}),document.addEventListener("keyup",function(){s.modeToggleByKey&&s.isGrabMode()&&(s.setModeAsSelect(),s.modeToggleByKey=!1)}),document.addEventListener("keydown",function(t){(t.ctrlKey||t.metaKey)&&(s.isSelectMode()&&s.setModeAsGrab(),s.modeToggleByKey=!0)})}},{key:"unregisterListeners",value:function(){this.canvas.off("object:moving"),this.canvas.off("object:moved")}},{key:"getMarkerById",value:function(t){for(var e=this.canvas.getObjects(),i=0;i<e.length;i+=1){var n=e[i];if("marker"===n.class&&n.id===t)return n.parent}return null}},{key:"getMarkers",value:function(){for(var t=[],e=this.canvas.getObjects(),i=0;i<e.length;i+=1){var n=e[i];"marker"===n.class&&t.push(n.parent)}return t}}]),s}(),yt=function(t){function i(t,e){return q(this,i),e=e||{},l(this,h(i).call(this,t,e))}return c(i,fabric.Group),a(i,[{key:"getBounds",value:function(){var t=[];return t.push(new f(this.left-this.width/2,this.top-this.height/2)),t.push(new f(this.left+this.width/2,this.top+this.height/2)),t}}]),i}(),mt=function(t){function i(t){var e;return q(this,i),(e=l(this,h(i).call(this,t))).label=void 0!==e.label?e.label:null,e.draggable=e.draggable||!1,e.zIndex=e.zIndex||1,e.opacity=e.opacity||1,e.keepOnZoom=e.keepOnZoom||!1,e.clickable=e.clickable||!1,e.hoverCursor=e.hoverCursor||e.clickable?"pointer":"default",e.moveCursor=e.moveCursor||"move",e.class=e.class||e.constructor.name.toLowerCase(),e.style={zIndex:e.zIndex,class:e.class,parent:u(e),keepOnZoom:e.keepOnZoom,id:e.id,hasControls:!1,hasBorders:!1,lockMovementX:!e.draggable,lockMovementY:!e.draggable,draggable:e.draggable,clickable:e.clickable,selectable:e.draggable,hoverCursor:e.hoverCursor,moveCursor:e.moveCursor},e}return c(i,ct),a(i,[{key:"addTo",value:function(t){t?(this._map=t,this._map.addLayer(this)):this._map&&this._map.removeLayer(this)}}]),i}(),bt=function(t){function i(t){var e;return q(this,i),(e=l(this,h(i).call(this,t))).width=e.width||-1,e.height=e.height||-1,e.position=new f(e.position),e.class="floorplan",e.load(),e}return c(i,mt),a(i,[{key:"load",value:function(){var e=this;fabric.Image.fromURL(this.url,function(t){e.setImage(t)},{selectable:!1,opacity:this.opacity}),this.handler=new fabric.Rect({left:0,top:0,width:20,height:20,stroke:"green",fill:"",hasControls:!1,hasBorders:!1})}},{key:"setImage",value:function(t){this.shape&&this.image&&this.shape.remove(this.image);var e=t.width/t.height;-1===this.width&&-1===this.height?(this.width=t.width,this.height=t.height):-1===this.width?this.width=this.height/e:-1===this.height&&(this.height=this.width*e),t.originalWidth=t.width,t.originalHeight=t.height,this.image=t.scaleToWidth(this.width),this.scaleX=t.scaleX+0,this.scaleY=t.scaleY+0,this.drawShape()}},{key:"drawShape",value:function(){if(this.shape)return this.shape.addWithUpdate(this.image),void this.emit("load",this);this.shape=new yt([this.image,this.handler],{selectable:!1,draggable:!1,left:this.position.x,top:this.position.y,parent:this,lockMovementX:!0,lockMovementY:!0,class:this.class,zIndex:this.zIndex}),this.emit("load",this)}},{key:"setWidth",value:function(t){this.width=t,this.onResize()}},{key:"setHeight",value:function(t){this.height=t,this.onResize()}},{key:"setPosition",value:function(t){this.position=new f(t),this.shape&&this.shape.set({left:this.position.x,top:this.position.y})}},{key:"setUrl",value:function(t){this.url=t,this.load()}},{key:"onResize",value:function(t,e){void 0!==t&&(this.width=t),void 0!==e&&(this.height=e);var i=this.image.width/this.image.height;-1===this.width&&-1===this.height?(this.width=this.image.width,this.height=this.image.height):-1===this.width?this.width=this.height/i:-1===this.height&&(this.height=this.width*i),this.image=this.image.scaleToWidth(this.width),this.shape.addWithUpdate()}}]),i}(),wt=function(t){function n(t,e){var i;return q(this,n),(e=e||{}).strokeWidth=e.strokeWidth||1,(i=l(this,h(n).call(this,t,e)))._strokeWidth=e.strokeWidth,i}return c(n,fabric.Line),a(n,[{key:"_renderStroke",value:function(t){this.strokeWidth=this._strokeWidth/this.canvas.getZoom(),d(h(n.prototype),"_renderStroke",this).call(this,t)}}]),n}(),xt=function(t){function o(t,e,i){var n;return q(this,o),(i=i||{}).zIndex=i.zIndex||9,n=l(this,h(o).call(this,i)),t&&e?(n.start=t,n.end=e,n.strokeWidth=n.strokeWidth||1,Object.assign(n.style,{strokeWidth:n.strokeWidth,stroke:n.color||"grey",fill:n.fill||!1,selectable:!1}),n.draw(),n.registerListeners(),n):(console.error("start or end is missing"),l(n))}return c(o,mt),a(o,[{key:"registerListeners",value:function(){var t=this;this.start.on("update:links",function(){t.shape.set({x1:t.start.position.x,y1:t.start.position.y})}),this.end.on("update:links",function(){t.shape.set({x2:t.end.position.x,y2:t.end.position.y})})}},{key:"draw",value:function(){this.shape=new wt([this.start.position.x,this.start.position.y,this.end.position.x,this.end.position.y],this.style)}},{key:"redraw",value:function(){this.shape.set({x1:this.start.position.x,y1:this.start.position.y,x2:this.end.position.x,y2:this.end.position.y})}},{key:"setStart",value:function(t){this.start=t,this.redraw()}},{key:"setEnd",value:function(t){this.end=t,this.redraw()}}]),o}(),kt=function(t){function o(t,e){var i;q(this,o),(e=e||{}).zIndex=e.zIndex||10,e.keepOnZoom=!0,e.position=new f(t),e.rotation=e.rotation||0,e.clickable=e.clickable||!0;var n=u(i=l(this,h(o).call(this,e)));return i.text=i.text||"",i.size=i.size||10,i.textColor=i.textColor||"black",i.fill=i.fill||"white",i.stroke=i.stroke||"red",Object.assign(i.style,{left:i.position.x,top:i.position.y,angle:i.rotation}),i.text&&(i.textObj=new fabric.Text(i.text,{fontSize:i.size,fill:i.textColor})),i.icon?fabric.Image.fromURL(i.icon.url,function(t){n.image=t.scaleToWidth(100),i.init()},{selectable:!0,opacity:i.opacity}):(i.circle=new fabric.Circle({radius:i.size,strokeWidth:2,stroke:i.stroke,fill:i.fill}),i.init()),i}return c(o,mt),a(o,[{key:"init",value:function(){var t=this,e=[];this.image&&e.push(this.image),this.circle&&e.push(this.circle),this.textObj&&e.push(this.textObj),this.shape=new yt(e,this.style),this.links=this.links||[],this.addLinks(),this.registerListeners(),z(function(){t.emit("ready")})}},{key:"registerListeners",value:function(){var e=this;this.shape.on("moving",function(){e.onShapeDrag()}),this.shape.on("mousedown",function(t){e.onShapeMouseDown(t)}),this.shape.on("mousemove",function(t){e.onShapeMouseMove(t)}),this.shape.on("mouseup",function(t){e.onShapeMouseUp(t)}),this.shape.on("mouseover",function(){e.emit("mouseover",e)}),this.shape.on("mouseout",function(){e.emit("mouseout",e)})}},{key:"setPosition",value:function(t){this.position=new f(t),this.shape&&(this.shape.set({left:this.position.x,top:this.position.y}),this.emit("update:links"),this.shape.canvas&&this.shape.canvas.renderAll())}},{key:"setRotation",value:function(t){this.rotation=t,this.shape&&(this.shape.set({angle:this.rotation}),this.shape.canvas&&this.shape.canvas.renderAll())}},{key:"setTextColor",value:function(t){this.text&&this.text.setColor(t)}},{key:"setStroke",value:function(t){this.circle&&this.circle.set("stroke",t)}},{key:"setColor",value:function(t){this.circle&&this.circle.setColor(t)}},{key:"setLinks",value:function(t){this.links=t,this.addLinks()}},{key:"addLinks",value:function(){var i=this;this.connectors=[],this.links.forEach(function(t){var e=new xt(i,t);i.connectors.push(e)}),this.addConnectors()}},{key:"addConnectors",value:function(){var e=this;this.connectors.forEach(function(t){e._map.addLayer(t)})}},{key:"onAdded",value:function(){this.addConnectors()}},{key:"onShapeDrag",value:function(){var t=N(this.shape.calcTransformMatrix(),6),e=t[4],i=t[5];this.position=new f(e,i),this.emit("update:links"),this.emit("moving")}},{key:"onShapeMouseDown",value:function(t){console.log(t),this.dragStart=t}},{key:"onShapeMouseMove",value:function(){this.dragStart&&(this.emit("dragstart"),this.dragging=!0,this.dragStart=null),this.dragging?this.emit("drag"):this.emit("hover")}},{key:"onShapeMouseUp",value:function(){this.dragging?this.emit("moved"):this.emit("click"),this.dragStart=null,this.dragging=!1}}]),o}(),Ot=function(t){function i(t){var e;return q(this,i),(e=l(this,h(i).call(this,t))).defaults=Object.assign({},y),Object.assign({},e.defaults),Object.assign({},e._options),e}return c(i,fabric.Image),i}(),Et=function(t){function e(t){return q(this,e),t=t||{},l(this,h(e).call(this,t))}return c(e,yt),e}(),jt=function(t){function n(t,e){var i;return q(this,n),(e=e||{}).points=t||[],(i=l(this,h(n).call(this,e))).lines=[],i.class="polyline",i.strokeWidth=1,i.lineOptions={strokeWidth:i.strokeWidth,stroke:i.color||"grey",fill:i.fill||!1},i.shape=new yt([],{selectable:!1,hasControls:!1,class:i.class,parent:u(i)}),i.setPoints(i._points),i}return c(n,mt),a(n,[{key:"addPoint",value:function(t){if(this.points.push(new f(t)),1<this.points.length){var e=this.points.length-1,i=this.points.length-2,n=this.points[e],o=this.points[i],s=new fabric.Line(n.getArray().concat(o.getArray()),this.lineOptions);this.lines.push(s),this.shape.addWithUpdate(s)}}},{key:"setStrokeWidth",value:function(e){this.lines.forEach(function(t){t.setStrokeWidth(e)})}},{key:"setPoints",value:function(){var t=0<arguments.length&&void 0!==arguments[0]?arguments[0]:[];this.removeLines(),this.points=[];for(var e=0;e<t.length;e+=1){var i=new f(t[e]);this.points.push(i),this.addPoint()}}},{key:"removeLines",value:function(){for(var t=0;t<this.lines.length;t+=1)this.shape.remove(this.lines[t]);this.lines=[]}}]),n}(),Ct=function(t){function i(t){var e;return q(this,i),e=l(this,h(i).call(this,t)),console.log("circle"),e}return c(i,fabric.Circle),i}();console.log("fabricJS ",e.version||window.fabric.version),console.log("IndoorJS ",i),t.Circle=Ct,t.Connector=xt,t.Floor=bt,t.Group=yt,t.ICON=y,t.Icon=Ot,t.Layer=mt,t.Line=wt,t.MAP=p,t.MARKER=g,t.Map=gt,t.Marker=kt,t.MarkerGroup=Et,t.Modes=v,t.Point=f,t.Polyline=jt,t.circle=function(t){return new Ct(t)},t.connector=function(t,e,i){return new xt(t,e,i)},t.floorplan=function(t){return new bt(t)},t.group=function(t,e){return new yt(t,e)},t.icon=function(t){return new Ot(t)},t.layer=function(t){return new mt(t)},t.line=function(t,e){return new wt(t,e)},t.map=function(t,e){return new gt(t,e)},t.marker=function(t,e){return new kt(t,e)},t.markerGroup=function(t){return new Et(t)},t.point=function(){for(var t=arguments.length,e=new Array(t),i=0;i<t;i++)e[i]=arguments[i];return o(f,e)},t.polyline=function(t,e){return new jt(t,e)},t.version=i,Object.defineProperty(t,"__esModule",{value:!0});var Lt=window.I;t.noConflict=function(){return window.I=Lt,this},window.I=t});