
# Komodo Core (komodod) Software Contribution Guidelines

Thank you for reaching out and trying to make Komodo an even better software application and blockchain platform. These contribution guidelines shall help you figuring out where you can be helpful and how to easily get started.

## Table of Contents

0. [Types of contributions we're looking for](#types-of-contributions-were-looking-for)
0. [Ground rules & expectations](#ground-rules--expectations)
0. [How to contribute](#how-to-contribute)
0. [Style guide](#style-guide)
0. [Setting up your environment](#setting-up-your-environment)
0. [Contribution review process](#contribution-review-process)
0. [Community](#community)

## Types of contributions we're looking for
There are many ways you can directly contribute to Komodo:

* Debug and test the Komodo Core code
* Find and fix bugs
* Improve suboptimal code
* Extend our software
* Perform a secure code review of Komodo Core and other Komodo-related software

Interested in making a contribution? Read on!

## Ground rules & expectations

Before we get started, here are a few things we expect from you (and that you should expect from others):

* Be kind and thoughtful in your conversations around this project. We all come from different backgrounds and projects, which means we likely have different perspectives on "how open source is done." Try to listen to others rather than convince them that your way is correct.
* Open Source Guides are released with a [Contributor Code of Conduct](./code_of_conduct.md). By participating in this project, you agree to abide by its terms.
* If you open a pull request, please ensure that your contribution passes all tests. If there are test failures, you will need to address them before we can merge your contribution.
* When adding content, please consider if it is widely valuable. Please don't add references or links to things you or your employer have created as others will do so if they appreciate it.

## How to contribute

If you'd like to contribute, start by searching through the [issues](https://github.com/komodoplatform/komodo/issues) and [pull requests](https://github.com/komodoplatform/komodo/pulls) to see whether someone else has raised a similar idea or question.

If you don't see your idea listed, and you think it can contribute to Komodo, do one of the following:
* **If your contribution is minor,** such as a fixing a typo, open a pull request.
* **If your contribution is major,** such as a new feature or bugfix, start by opening an issue first. That way, other contributors can weigh in on the discussion before you do any work.

## Style guide
Write clear, clean and consistent code. Follow well-known and established style guidelines like [Google's C++ Style Guide](https://google.github.io/styleguide/cppguide.html) or [Bjarne Stroustrup's C++ Style FAQ](http://www.stroustrup.com/bs_faq2.html).

## Setting up your environment

The Komodo Core (komodod) is mainly written in C++ with specific modules written in C. Follow the [Getting Started](https://github.com/komodoplatform/komodo#getting-started) instructions to build komodod from sources. For more informations about the Komodo Platform and a full API documentation please visit the official [Komodo developer documentation](https://docs.komodoplatform.com/). 

## Contribution review process

Our team and community will review your contribution and start a transparent testing and quality assurance process. As soon as your contribution has undergone sucessful review and QA signoff it gets merged into the Komodo sourcecode. 

## Community

Discussions about Komodo's development take place on our [discord server](https://discord.gg/yhfzqsg). Anybody is welcome to join these conversations. There is also a [newsletter](http://komodoplatform.com) with regular updates.

Wherever possible, do not take these conversations to private channels, including contacting the maintainers directly. Keeping communication public means everybody can benefit and learn from the conversation.


This contribution guideline is adapted from the Open Source Guides.
