rust_packages := rust librustzcash

ifeq ($(build_os),darwin)
	zcash_packages := libsnark libgmp libsodium utfcpp
else
	proton_packages := proton
	zcash_packages := libgmp libsodium utfcpp
endif

qt_native_packages = native_protobuf
qt_packages = qrencode protobuf

qt_linux_packages:=qt expat libxcb xcb_proto libXau xproto freetype fontconfig
qt_android_packages=qt

qt_darwin_packages=qt
qt_mingw32_packages=qt

rust_crates := \
  crate_aes \
  crate_aesni \
  crate_aes_soft \
  crate_arrayvec \
  crate_bitflags \
  crate_bit_vec \
  crate_blake2_rfc \
  crate_block_cipher_trait \
  crate_byte_tools \
  crate_byteorder \
  crate_constant_time_eq \
  crate_crossbeam \
  crate_digest \
  crate_fpe \
  crate_fuchsia_zircon \
  crate_fuchsia_zircon_sys \
  crate_futures_cpupool \
  crate_futures \
  crate_generic_array \
  crate_lazy_static \
  crate_libc \
  crate_nodrop \
  crate_num_bigint \
  crate_num_cpus \
  crate_num_integer \
  crate_num_traits \
  crate_opaque_debug \
  crate_rand \
  crate_stream_cipher \
  crate_typenum \
  crate_winapi_i686_pc_windows_gnu \
  crate_winapi \
  crate_winapi_x86_64_pc_windows_gnu
rust_packages := rust $(rust_crates) librustzcash
native_packages := native_ccache

wallet_packages=bdb

ifeq ($(host_os),linux)
	packages := boost openssl libevent zeromq $(zcash_packages) zlib libarchive googletest libcurl #googlemock
else
	packages := boost openssl libevent zeromq $(zcash_packages) zlib libarchive libcurl googletest #googlemock
endif
