/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.inprocess;

import com.google.common.base.Preconditions;
import io.grpc.HandlerRegistry;
import io.grpc.inprocess.InProcessServer;
import io.grpc.internal.AbstractServerImplBuilder;
import java.io.File;

public final class InProcessServerBuilder
extends AbstractServerImplBuilder<InProcessServerBuilder> {
    private final String name;

    public static InProcessServerBuilder forName(String name, HandlerRegistry registry) {
        return new InProcessServerBuilder(name, registry);
    }

    public static InProcessServerBuilder forName(String name) {
        return new InProcessServerBuilder(name);
    }

    private InProcessServerBuilder(String name, HandlerRegistry registry) {
        super(registry);
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    private InProcessServerBuilder(String name) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name");
    }

    @Override
    protected InProcessServer buildTransportServer() {
        return new InProcessServer(this.name);
    }

    @Override
    public InProcessServerBuilder useTransportSecurity(File certChain, File privateKey) {
        throw new UnsupportedOperationException("TLS not supported in InProcessServer");
    }
}

