/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.MoreExecutors;
import io.grpc.CompressorRegistry;
import io.grpc.Context;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.MutableHandlerRegistry;
import io.grpc.MutableHandlerRegistryImpl;
import io.grpc.ServerBuilder;
import io.grpc.ServerServiceDefinition;
import io.grpc.internal.Server;
import io.grpc.internal.ServerImpl;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

public abstract class AbstractServerImplBuilder<T extends AbstractServerImplBuilder<T>>
extends ServerBuilder<T> {
    private final HandlerRegistry registry;
    @Nullable
    private Executor executor;
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;

    protected AbstractServerImplBuilder(HandlerRegistry registry) {
        this.registry = (HandlerRegistry)Preconditions.checkNotNull((Object)registry);
    }

    protected AbstractServerImplBuilder() {
        this.registry = new MutableHandlerRegistryImpl();
    }

    @Override
    public final T directExecutor() {
        return (T)this.executor(MoreExecutors.directExecutor());
    }

    @Override
    public final T executor(@Nullable Executor executor) {
        this.executor = executor;
        return this.thisT();
    }

    @Override
    public final T addService(ServerServiceDefinition service) {
        if (this.registry instanceof MutableHandlerRegistry) {
            ((MutableHandlerRegistry)this.registry).addService(service);
            return this.thisT();
        }
        throw new UnsupportedOperationException("Underlying HandlerRegistry is not mutable");
    }

    @Override
    public final T decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public final T compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = registry;
        return this.thisT();
    }

    @Override
    public ServerImpl build() {
        Server transportServer = this.buildTransportServer();
        return new ServerImpl(this.executor, this.registry, transportServer, Context.ROOT, (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()));
    }

    protected abstract Server buildTransportServer();

    private T thisT() {
        AbstractServerImplBuilder thisT = this;
        return (T)thisT;
    }
}

