/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;

@BugPattern(name="GuiceAssistedInjectScoping", summary="Scope annotation on implementation class of AssistedInject factory is not allowed", explanation="Classes that AssistedInject factories create may not be annotated with scope annotations, such as @Singleton.  This will cause a Guice error at runtime.\n\nSee [https://code.google.com/p/google-guice/issues/detail?id=742 this bug report] for details.", category=BugPattern.Category.GUICE, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class GuiceAssistedInjectScoping
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    private static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private static final String ASSISTED_ANNOTATION = "com.google.inject.assistedinject.Assisted";
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final String ASSISTED_INJECT_ANNOTATION = "com.google.inject.assistedinject.AssistedInject";
    private static MultiMatcher<ClassTree, AnnotationTree> classAnnotationMatcher = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.ScopeAnnotation"), Matchers.hasAnnotation("javax.inject.Scope")));
    private static MultiMatcher<ClassTree, MethodTree> constructorWithInjectMatcher = Matchers.constructor(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject")));
    private static Matcher<ClassTree> assistedMatcher = new Matcher<ClassTree>(){

        @Override
        public boolean matches(ClassTree classTree, VisitorState state) {
            if (constructorWithInjectMatcher.matches(classTree, state)) {
                return Matchers.methodHasParameters(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasAnnotation(GuiceAssistedInjectScoping.ASSISTED_ANNOTATION)).matches((MethodTree)constructorWithInjectMatcher.getMatchingNode(), state);
            }
            return Matchers.constructor(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasAnnotation(GuiceAssistedInjectScoping.ASSISTED_INJECT_ANNOTATION)).matches(classTree, state);
        }
    };
    public static final Matcher<ClassTree> MATCHER = Matchers.allOf(classAnnotationMatcher, assistedMatcher);

    @Override
    public final Description matchClass(ClassTree classTree, VisitorState state) {
        if (!MATCHER.matches(classTree, state)) {
            return Description.NO_MATCH;
        }
        AnnotationTree annotationWithScopeAnnotation = classAnnotationMatcher.getMatchingNode();
        if (annotationWithScopeAnnotation == null) {
            throw new IllegalStateException("Expected to find an annotation that was annotated with @ScopeAnnotation");
        }
        return this.describeMatch(annotationWithScopeAnnotation, SuggestedFix.delete(annotationWithScopeAnnotation));
    }
}

