/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.NoAllocation;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

@BugPattern(name="NoAllocation", summary="@NoAllocation was specified on this method, but something was found that would trigger an allocation", explanation="Like many other languages, Java provides automatic memory management. In Java, this feature incurs an runtime cost, and can also lead to unpredictable execution pauses. In most cases, this is a reasonable tradeoff, but sometimes the loss of performance or predictability is unacceptable. Examples include pause-sensitive user interface handlers, high query rate server response handlers, or other soft-realtime applications.\n\nIn these situations, you can annotate a few carefully written methods with @NoAllocation. Methods with this annotation will avoid allocations in most cases, reducing pressure on the garbage collector. Note that allocations may still occur in methods with @NoAllocation if the compiler or runtime system inserts them.\n\nTo ease the use of exceptions, allocations are allowed if they occur within a throw statement. But if the throw statement contains a nested class with methods annotated with @NoAllocation, those methods will be disallowed from allocating.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class NoAllocationChecker
extends BugChecker
implements BugChecker.AssignmentTreeMatcher,
BugChecker.BinaryTreeMatcher,
BugChecker.CompoundAssignmentTreeMatcher,
BugChecker.EnhancedForLoopTreeMatcher,
BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewArrayTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.ReturnTreeMatcher,
BugChecker.TypeCastTreeMatcher,
BugChecker.UnaryTreeMatcher,
BugChecker.VariableTreeMatcher {
    private static final String COMMON_MESSAGE_SUFFIX = "is disallowed in methods annotated with @NoAllocation";
    private static Matcher<MethodTree> noAllocationMethodMatcher = Matchers.hasAnnotation(NoAllocation.class.getName());
    private static Matcher<MethodInvocationTree> noAllocationMethodInvocationMatcher = Matchers.hasAnnotation(NoAllocation.class.getName());
    private static Matcher<ExpressionTree> anyExpression = Matchers.anything();
    private static Matcher<StatementTree> anyStatement = Matchers.anything();
    private static Matcher<VariableTree> anyVariable = Matchers.anything();
    private static Matcher<ExpressionTree> isString = Matchers.isSameType("java.lang.String");
    private static Matcher<ExpressionTree> arrayExpression = Matchers.isArrayType();
    private static Matcher<ExpressionTree> primitiveExpression = Matchers.isPrimitiveType();
    private static Matcher<ExpressionTree> primitiveArrayExpression = Matchers.isPrimitiveArrayType();
    private static final Set<Tree.Kind> ALL_COMPOUND_OPERATORS = Collections.unmodifiableSet(EnumSet.of(Tree.Kind.AND_ASSIGNMENT, new Tree.Kind[]{Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT}));
    private static Matcher<Tree> withinThrowOrAnnotation = new Matcher<Tree>(){

        @Override
        public boolean matches(Tree tree, VisitorState state) {
            for (TreePath path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                Tree node = path.getLeaf();
                state = state.withPath(path);
                switch (node.getKind()) {
                    case METHOD: {
                        return false;
                    }
                    case THROW: 
                    case ANNOTATION: {
                        return true;
                    }
                }
            }
            return false;
        }
    };
    private static Matcher<NewArrayTree> newArrayMatcher = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher));
    private static Matcher<NewClassTree> newClassMatcher = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher));
    private static Matcher<MethodInvocationTree> methodMatcher = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.not(noAllocationMethodInvocationMatcher));
    private static Matcher<BinaryTree> stringConcatenationMatcher = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.kindIs(Tree.Kind.PLUS), Matchers.binaryTree(anyExpression, isString));
    private static Matcher<CompoundAssignmentTree> compoundAssignmentMatcher = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.anyOf(Matchers.compoundAssignment(Tree.Kind.PLUS_ASSIGNMENT, isString, anyExpression), Matchers.compoundAssignment(ALL_COMPOUND_OPERATORS, Matchers.not(primitiveExpression), anyExpression)));
    private static Matcher<EnhancedForLoopTree> foreachMatcher = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.anyOf(Matchers.not(Matchers.enhancedForLoop(anyVariable, arrayExpression, anyStatement)), Matchers.enhancedForLoop(Matchers.variableType(Matchers.not(Matchers.isPrimitiveType())), primitiveArrayExpression, anyStatement)));
    private static Matcher<AssignmentTree> boxingAssignment = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.assignment(Matchers.not(primitiveExpression), primitiveExpression));
    private static Matcher<VariableTree> boxingInitialization = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.variableInitializer(primitiveExpression), Matchers.variableType(Matchers.not(Matchers.isPrimitiveType())));
    private static Matcher<TypeCastTree> boxingCast = Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.typeCast(Matchers.not(Matchers.isPrimitiveType()), primitiveExpression));
    private static Matcher<ReturnTree> boxingReturn = new Matcher<ReturnTree>(){

        @Override
        public boolean matches(ReturnTree tree, VisitorState state) {
            return Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(Matchers.allOf(noAllocationMethodMatcher, Matchers.methodReturnsNonPrimitiveType())), Matchers.isPrimitiveType()).matches(tree.getExpression(), state);
        }
    };
    private static Matcher<MethodInvocationTree> boxingInvocation = new Matcher<MethodInvocationTree>(){

        @Override
        public boolean matches(MethodInvocationTree tree, VisitorState state) {
            if (!Matchers.enclosingMethod(noAllocationMethodMatcher).matches(tree, state)) {
                return false;
            }
            JCTree.JCMethodInvocation methodInvocation = (JCTree.JCMethodInvocation)tree;
            List arguments = methodInvocation.getArguments();
            Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol(tree);
            List params = methodSymbol.getParameters();
            if (arguments.size() != params.size()) {
                return true;
            }
            int numArgs = arguments.size();
            int i = 0;
            Iterator argument = arguments.iterator();
            Iterator param = params.iterator();
            while (param.hasNext() && argument.hasNext()) {
                JCTree.JCExpression a = (JCTree.JCExpression)argument.next();
                Symbol.VarSymbol p = (Symbol.VarSymbol)param.next();
                if (a.type.isPrimitive() && !p.type.isPrimitive()) {
                    return true;
                }
                if (i == numArgs - 1 && !state.getTypes().isAssignable(a.type, p.type)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    };
    private static Matcher<UnaryTree> boxingUnary = new Matcher<UnaryTree>(){

        @Override
        public boolean matches(UnaryTree tree, VisitorState state) {
            return Matchers.allOf(Matchers.not(withinThrowOrAnnotation), Matchers.enclosingMethod(noAllocationMethodMatcher), Matchers.anyOf(Matchers.kindIs(Tree.Kind.POSTFIX_DECREMENT), Matchers.kindIs(Tree.Kind.POSTFIX_INCREMENT), Matchers.kindIs(Tree.Kind.PREFIX_DECREMENT), Matchers.kindIs(Tree.Kind.PREFIX_INCREMENT))).matches(tree, state) && Matchers.not(Matchers.isPrimitiveType()).matches(tree, state);
        }
    };

    @Override
    public Description matchNewArray(NewArrayTree tree, VisitorState state) {
        if (!newArrayMatcher.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Allocating a new array with \"new\" or \"{ ... }\" is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (!newClassMatcher.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Constructing a new object is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!methodMatcher.matches(tree, state) && !boxingInvocation.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Calling a method that is not annotated with @NoAllocation, calling a varargs method without exactly matching the signature, or passing a primitive value as non-primitive method argument is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        if (!stringConcatenationMatcher.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("String concatenation allocates a new String, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchCompoundAssignment(CompoundAssignmentTree tree, VisitorState state) {
        if (!compoundAssignmentMatcher.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Compound assignment to a String or boxed primitive allocates a new object, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchEnhancedForLoop(EnhancedForLoopTree tree, VisitorState state) {
        if (!foreachMatcher.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Iterating over a Collection or iterating over a primitive array using a non-primitive element type will trigger allocation, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchAssignment(AssignmentTree tree, VisitorState state) {
        if (!boxingAssignment.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Assigning a primitive value to a non-primitive variable or array element will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        if (!boxingInitialization.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Initializing a non-primitive variable with a primitive value will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchTypeCast(TypeCastTree tree, VisitorState state) {
        if (!boxingCast.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Casting a primitive value to a non-primitive type will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchReturn(ReturnTree tree, VisitorState state) {
        if (!boxingReturn.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Returning a primitive value from a method with a non-primitive return type will autobox the value, which is disallowed in methods annotated with @NoAllocation").build();
    }

    @Override
    public Description matchUnary(UnaryTree tree, VisitorState state) {
        if (!boxingUnary.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Pre- and post- increment/decrement operations on a non-primitive variable or array element will autobox the result, which is disallowed in methods annotated with @NoAllocation").build();
    }
}

