/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="NullableConstructor", summary="Constructors should be annotated with @Nullable since they cannot return null", explanation="Constructors never return null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class NullableConstructor
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (!sym.name.contentEquals("Nullable")) {
            return Description.NO_MATCH;
        }
        Tree annotatedNode = NullableConstructor.getAnnotatedNode(state);
        Symbol annotatedSymbol = ASTHelpers.getSymbol(annotatedNode);
        if (!annotatedSymbol.isConstructor()) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, SuggestedFix.delete(tree));
    }

    private static Tree getAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

