/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.type.TypeKind;

@BugPattern(name="NullableVoid", summary="void-returning methods should not be annotated with @Nullable, since they cannot return null", explanation="void-returning methods cannot return null.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.MATURE)
public class NullableVoid
extends BugChecker
implements BugChecker.AnnotationTreeMatcher {
    @Override
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        if (sym == null) {
            return Description.NO_MATCH;
        }
        if (!sym.name.contentEquals("Nullable")) {
            return Description.NO_MATCH;
        }
        Tree annotatedNode = NullableVoid.getAnnotatedNode(state);
        if (!(annotatedNode instanceof MethodTree)) {
            return Description.NO_MATCH;
        }
        Symbol.MethodSymbol annotatedMethod = ASTHelpers.getSymbol((MethodTree)annotatedNode);
        if (annotatedMethod == null) {
            return Description.NO_MATCH;
        }
        if (annotatedMethod.getReturnType().getKind() != TypeKind.VOID) {
            return Description.NO_MATCH;
        }
        return this.describeMatch(tree, SuggestedFix.delete(tree));
    }

    private static Tree getAnnotatedNode(VisitorState state) {
        return state.getPath().getParentPath().getParentPath().getLeaf();
    }
}

