/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;

@BugPattern(name="NumericEquality", summary="Numeric comparison using reference equality instead of value equality", explanation="Numbers are compared for reference equality/inequality using == or != instead of for value equality using .equals()", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class NumericEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    public static final Matcher<ExpressionTree> SUBCLASS_OF_NUMBER = Matchers.allOf(Matchers.isSubtypeOf("java.lang.Number"), Matchers.not(Matchers.kindIs(Tree.Kind.NULL_LITERAL)));
    public static final Matcher<BinaryTree> MATCHER = Matchers.allOf(Matchers.anyOf(Matchers.kindIs(Tree.Kind.EQUAL_TO), Matchers.kindIs(Tree.Kind.NOT_EQUAL_TO)), Matchers.binaryTree(SUBCLASS_OF_NUMBER, SUBCLASS_OF_NUMBER));

    @Override
    public Description matchBinary(BinaryTree tree, VisitorState state) {
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        Symbol left = ASTHelpers.getSymbol(leftOperand);
        Symbol right = ASTHelpers.getSymbol(rightOperand);
        if (left == null || right == null) {
            return Description.NO_MATCH;
        }
        if (NumericEquality.isFinal(left) && left.isStatic() || NumericEquality.isFinal(right) && right.isStatic()) {
            return Description.NO_MATCH;
        }
        if (!MATCHER.matches(tree, state)) {
            return Description.NO_MATCH;
        }
        StringBuilder fixedExpression = new StringBuilder();
        if (tree.getKind() == Tree.Kind.NOT_EQUAL_TO) {
            fixedExpression.append("!");
        }
        fixedExpression.append("Objects.equals(" + leftOperand + ", " + rightOperand + ")");
        Fix fix = SuggestedFix.builder().replace(tree, fixedExpression.toString()).addImport("java.util.Objects").build();
        return this.describeMatch(tree, fix);
    }

    public static boolean isFinal(Symbol s) {
        return (s.flags() & 0x10L) != 0L;
    }
}

