/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;

@BugPattern(name="OptionalEquality", summary="Comparison using reference equality instead of value equality", explanation="Optionals should be compared for value equality using `.equals()`, and not for reference equality using `==` and `!=`.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class OptionalEquality
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private final NullnessAnalysis nullnessAnalysis = new NullnessAnalysis();

    @Override
    public final Description matchBinary(BinaryTree tree, VisitorState state) {
        switch (tree.getKind()) {
            case EQUAL_TO: 
            case NOT_EQUAL_TO: {
                break;
            }
            default: {
                return Description.NO_MATCH;
            }
        }
        if (!OptionalEquality.isOptionalType(ASTHelpers.getType(tree.getLeftOperand()), state)) {
            return Description.NO_MATCH;
        }
        if (!OptionalEquality.isOptionalType(ASTHelpers.getType(tree.getRightOperand()), state)) {
            return Description.NO_MATCH;
        }
        Description.Builder builder = this.buildDescription(tree);
        this.addFixes(builder, tree, state);
        return builder.build();
    }

    void addFixes(Description.Builder builder, BinaryTree tree, VisitorState state) {
        String prefix = tree.getKind() == Tree.Kind.NOT_EQUAL_TO ? "!" : "";
        String lhs = state.getSourceForNode(tree.getLeftOperand());
        String rhs = state.getSourceForNode(tree.getRightOperand());
        Nullness nullness = this.getNullness(tree.getLeftOperand(), state);
        if (nullness != Nullness.NONNULL) {
            builder.addFix(SuggestedFix.builder().replace(tree, String.format("%sObjects.equals(%s, %s)", prefix, lhs, rhs)).addImport("java.util.Objects").build());
        }
        if (nullness != Nullness.NULL) {
            builder.addFix(SuggestedFix.replace(tree, String.format("%s%s.equals(%s)", prefix, lhs, rhs)));
        }
    }

    private Nullness getNullness(ExpressionTree expr, VisitorState state) {
        TreePath pathToExpr = new TreePath(state.getPath(), expr);
        return this.nullnessAnalysis.getNullness(pathToExpr, state.context);
    }

    private static boolean isOptionalType(Type type, VisitorState state) {
        Type guavaOptional = state.getTypeFromString(Optional.class.getName());
        Type utilOptional = state.getTypeFromString("java.util.Optional");
        return ASTHelpers.isSameType(type, guavaOptional, state) || ASTHelpers.isSameType(type, utilOptional, state);
    }
}

