/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.List;
import java.util.regex.Pattern;

@BugPattern(name="PreconditionsErrorMessageEagerEvaluation", summary="Second argument to Preconditions.* is a call to String.format(), which can be unwrapped", explanation="Preconditions checks take an error message to display if the check fails. The error message is rarely needed, so it should either be cheap to construct or constructed only when needed. This check ensures that these error messages are not constructed using expensive methods that are evaluated eagerly.", category=BugPattern.Category.GUAVA, severity=BugPattern.SeverityLevel.WARNING, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class PreconditionsExpensiveString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> matcher = Matchers.allOf(Matchers.anyOf(Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkNotNull"), Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkState"), Matchers.staticMethod().onClass("com.google.common.base.Preconditions").named("checkArgument")), Matchers.argument(1, Matchers.allOf(Matchers.kindIs(Tree.Kind.METHOD_INVOCATION), Matchers.staticMethod().onClass("java.lang.String").named("format"), new StringFormatCallContainsNoSpecialFormattingMatcher(Pattern.compile("%[^%s]")))));

    @Override
    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        if (!matcher.matches(methodInvocationTree, state)) {
            return Description.NO_MATCH;
        }
        MemberSelectTree method = (MemberSelectTree)methodInvocationTree.getMethodSelect();
        List<? extends ExpressionTree> arguments = methodInvocationTree.getArguments();
        MethodInvocationTree stringFormat = (MethodInvocationTree)arguments.get(1);
        return this.describeMatch(arguments.get(1));
    }

    private static class StringFormatCallContainsNoSpecialFormattingMatcher
    implements Matcher<ExpressionTree> {
        private final Pattern invalidFormatCharacters;

        StringFormatCallContainsNoSpecialFormattingMatcher(Pattern invalidFormatCharacters) {
            this.invalidFormatCharacters = invalidFormatCharacters;
        }

        @Override
        public boolean matches(ExpressionTree t, VisitorState state) {
            if (!(t instanceof MethodInvocationTree)) {
                return false;
            }
            MethodInvocationTree stringFormatInvocation = (MethodInvocationTree)t;
            if (!(stringFormatInvocation.getArguments().get(0) instanceof LiteralTree)) {
                return false;
            }
            LiteralTree firstArg = (LiteralTree)stringFormatInvocation.getArguments().get(0);
            String literal = firstArg.getValue().toString();
            return !this.invalidFormatCharacters.matcher(literal).find();
        }
    }
}

