/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;

@BugPattern(name="TryFailThrowable", summary="Catching Throwable masks failures from fail() or assert*() in the try block", explanation="When testing that a line of code throws an expected exception, it is typical to execute that line in a try block with a `fail()` or `assert*()` on the line following.  The expectation is that the expected exception will be thrown, and execution will continue in the catch block, and the `fail()` or `assert*()` will not be executed.\n\n`fail()` and `assert*()` throw AssertionErrors, which are a subtype of Throwable. That means that if if the catch block catches Throwable, then execution will always jump to the catch block, and the test will always pass.\n\nTo fix this, you usually want to catch Exception rather than Throwable. If you need to catch throwable (e.g., the expected exception is an AssertionError), then add logic in your catch block to ensure that the AssertionError that was caught is not the same one thrown by the call to `fail()` or `assert*()`.", category=BugPattern.Category.JUNIT, maturity=BugPattern.MaturityLevel.MATURE, severity=BugPattern.SeverityLevel.ERROR)
public class TryFailThrowable
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<VariableTree> javaLangThrowable = Matchers.isSameType("java.lang.Throwable");
    private static final Matcher<ExpressionTree> failOrAssert = new Matcher<ExpressionTree>(){

        @Override
        public boolean matches(ExpressionTree item, VisitorState state) {
            if (item.getKind() != Tree.Kind.METHOD_INVOCATION) {
                return false;
            }
            Symbol sym = ASTHelpers.getSymbol(item);
            if (!(sym instanceof Symbol.MethodSymbol)) {
                throw new IllegalArgumentException("not a method call");
            }
            if (!sym.isStatic()) {
                return false;
            }
            String methodName = sym.getQualifiedName().toString();
            String className = sym.owner.getQualifiedName().toString();
            return !(!methodName.startsWith("assert") && !methodName.startsWith("fail") || !className.equals("org.junit.Assert") && !className.equals("junit.framework.Assert") && !className.equals("junit.framework.TestCase") && !className.endsWith("MoreAsserts"));
        }
    };

    @Override
    public Description matchTry(TryTree tree, VisitorState state) {
        if (this.tryTreeMatches(tree, state)) {
            CatchTree firstCatch = tree.getCatches().get(0);
            VariableTree catchParameter = firstCatch.getParameter();
            return this.describeMatch(firstCatch, SuggestedFix.replace(catchParameter, "Exception " + catchParameter.getName()));
        }
        return Description.NO_MATCH;
    }

    private boolean tryTreeMatches(TryTree tryTree, VisitorState state) {
        BlockTree tryBlock = tryTree.getBlock();
        List<? extends StatementTree> statements = tryBlock.getStatements();
        if (statements.isEmpty()) {
            return false;
        }
        boolean foundFailOrAssert = false;
        for (StatementTree statementTree : statements) {
            if (!(statementTree instanceof ExpressionStatementTree) || !failOrAssert.matches(((ExpressionStatementTree)statementTree).getExpression(), state)) continue;
            foundFailOrAssert = true;
            break;
        }
        if (!foundFailOrAssert) {
            return false;
        }
        List<? extends CatchTree> catches = tryTree.getCatches();
        if (catches.size() != 1) {
            return false;
        }
        CatchTree catchTree = catches.get(0);
        VariableTree catchType = catchTree.getParameter();
        if (!javaLangThrowable.matches(catchType, state)) {
            return false;
        }
        List<? extends StatementTree> catchStatements = catchTree.getBlock().getStatements();
        for (StatementTree statementTree : catchStatements) {
            if (Matchers.kindIs(Tree.Kind.EMPTY_STATEMENT).matches(statementTree, state)) continue;
            return false;
        }
        return true;
    }
}

