/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.refaster.AutoValue_PlaceholderUnificationVisitor;
import com.google.errorprone.refaster.AutoValue_PlaceholderUnificationVisitor_State;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.LocalVarBinding;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UFreeIdent;
import com.google.errorprone.refaster.UPlaceholderExpression;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

abstract class PlaceholderUnificationVisitor
extends SimpleTreeVisitor<Choice<? extends State<? extends JCTree>>, State<?>> {
    static final TreeVisitor<Boolean, Unifier> FORBIDDEN_REFERENCE_VISITOR = new SimpleTreeVisitor<Boolean, Unifier>(){

        @Override
        protected Boolean defaultAction(Tree node, Unifier unifier) {
            if (!(node instanceof JCTree.JCExpression)) {
                return false;
            }
            JCTree.JCExpression expr = (JCTree.JCExpression)node;
            for (UFreeIdent.Key key : Iterables.filter((Iterable)unifier.getBindings().keySet(), UFreeIdent.Key.class)) {
                JCTree.JCExpression keyBinding = unifier.getBinding(key);
                if (!PlaceholderUnificationVisitor.equivalentExprs(unifier, expr, keyBinding)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitIdentifier(IdentifierTree node, Unifier unifier) {
            for (LocalVarBinding localBinding : Iterables.filter((Iterable)unifier.getBindings().values(), LocalVarBinding.class)) {
                if (!localBinding.getSymbol().equals(ASTHelpers.getSymbol(node))) continue;
                return true;
            }
            return this.defaultAction((Tree)node, unifier);
        }
    };
    private static final Set<JCTree.Tag> MUTATING_UNARY_TAGS = Collections.unmodifiableSet(EnumSet.of(JCTree.Tag.PREINC, JCTree.Tag.PREDEC, JCTree.Tag.POSTINC, JCTree.Tag.POSTDEC));

    PlaceholderUnificationVisitor() {
    }

    public static PlaceholderUnificationVisitor create(TreeMaker maker, Map<UVariableDecl, UExpression> arguments) {
        return new AutoValue_PlaceholderUnificationVisitor(maker, (ImmutableMap<UVariableDecl, UExpression>)ImmutableMap.copyOf(arguments));
    }

    abstract TreeMaker maker();

    abstract ImmutableMap<UVariableDecl, UExpression> arguments();

    Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> tryBindArguments(final ExpressionTree node, final State<?> state) {
        return Choice.from(this.arguments().entrySet()).thenChoose(new Function<Map.Entry<UVariableDecl, UExpression>, Choice<State<UPlaceholderExpression.PlaceholderParamIdent>>>(){

            public Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> apply(Map.Entry<UVariableDecl, UExpression> entry) {
                return PlaceholderUnificationVisitor.this.unifyParam(entry.getKey(), entry.getValue(), node, state.fork());
            }
        });
    }

    private Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> unifyParam(final UVariableDecl placeholderParam, UExpression placeholderArg, ExpressionTree toUnify, final State<?> state) {
        return placeholderArg.unify(toUnify, state.unifier()).transform(new Function<Unifier, State<UPlaceholderExpression.PlaceholderParamIdent>>(){

            public State<UPlaceholderExpression.PlaceholderParamIdent> apply(Unifier unifier) {
                return State.create(state.seenParameters().prepend(placeholderParam), unifier, new UPlaceholderExpression.PlaceholderParamIdent(placeholderParam, unifier.getContext()));
            }
        });
    }

    public Choice<? extends State<? extends JCTree>> unify(@Nullable Tree node, State<?> state) {
        if (node instanceof ExpressionTree) {
            return this.unifyExpression((ExpressionTree)node, state);
        }
        if (node == null) {
            return Choice.of(state.withResult(null));
        }
        return (Choice)node.accept(this, state);
    }

    public Choice<State<List<JCTree>>> unify(@Nullable Iterable<? extends Tree> nodes, State<?> state) {
        if (nodes == null) {
            return Choice.of(state.withResult(null));
        }
        Choice<State<List<Object>>> choice = Choice.of(state.withResult(List.nil()));
        for (final Tree tree : nodes) {
            choice = choice.thenChoose(new Function<State<List<JCTree>>, Choice<State<List<JCTree>>>>(){

                public Choice<State<List<JCTree>>> apply(final State<List<JCTree>> state) {
                    return PlaceholderUnificationVisitor.this.unify(tree, state).transform(new Function<State<? extends JCTree>, State<List<JCTree>>>(){

                        public State<List<JCTree>> apply(State<? extends JCTree> treeState) {
                            return treeState.withResult(((List)state.result()).prepend(treeState.result()));
                        }
                    });
                }
            });
        }
        return choice.transform(new Function<State<List<JCTree>>, State<List<JCTree>>>(){

            public State<List<JCTree>> apply(State<List<JCTree>> state) {
                return state.withResult(state.result().reverse());
            }
        });
    }

    static boolean equivalentExprs(Unifier unifier, JCTree.JCExpression expr1, JCTree.JCExpression expr2) {
        return Types.instance(unifier.getContext()).isSameType(expr2.type, expr1.type) && expr2.toString().equals(expr1.toString());
    }

    public Choice<? extends State<? extends JCTree.JCExpression>> unifyExpression(@Nullable ExpressionTree node, State<?> state) {
        if (node == null) {
            return Choice.of(state.withResult(null));
        }
        Choice<State<UPlaceholderExpression.PlaceholderParamIdent>> tryBindArguments = this.tryBindArguments(node, state);
        if (!node.accept(FORBIDDEN_REFERENCE_VISITOR, state.unifier()).booleanValue()) {
            return tryBindArguments.or((Choice)node.accept(this, state));
        }
        return tryBindArguments;
    }

    public Choice<State<List<JCTree.JCExpression>>> unifyExpressions(@Nullable Iterable<? extends ExpressionTree> nodes, State<?> state) {
        return this.unify(nodes, state).transform(new Function<State<List<JCTree>>, State<List<JCTree.JCExpression>>>(){

            public State<List<JCTree.JCExpression>> apply(State<List<JCTree>> state) {
                return state.withResult(List.convert(JCTree.JCExpression.class, state.result()));
            }
        });
    }

    public Choice<? extends State<? extends JCTree.JCStatement>> unifyStatement(@Nullable StatementTree node, State<?> state) {
        return this.unify(node, state);
    }

    public Choice<State<List<JCTree.JCStatement>>> unifyStatements(@Nullable Iterable<? extends StatementTree> nodes, State<?> state) {
        return this.unify(nodes, state).transform(new Function<State<List<JCTree>>, State<List<JCTree.JCStatement>>>(){

            public State<List<JCTree.JCStatement>> apply(State<List<JCTree>> state) {
                return state.withResult(List.convert(JCTree.JCStatement.class, state.result()));
            }
        });
    }

    @Override
    protected Choice<State<JCTree>> defaultAction(Tree node, State<?> state) {
        return Choice.of(state.withResult((JCTree)node));
    }

    @Override
    public Choice<State<JCTree.JCArrayAccess>> visitArrayAccess(final ArrayAccessTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCArrayAccess>>>(){

            public Choice<State<JCTree.JCArrayAccess>> apply(final State<? extends JCTree.JCExpression> expressionState) {
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getIndex(), expressionState).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCArrayAccess>>(){

                    public State<JCTree.JCArrayAccess> apply(State<? extends JCTree.JCExpression> indexState) {
                        return indexState.withResult(PlaceholderUnificationVisitor.this.maker().Indexed((JCTree.JCExpression)expressionState.result(), indexState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCBinary>> visitBinary(final BinaryTree node, State<?> state) {
        final JCTree.Tag tag = ((JCTree.JCBinary)node).getTag();
        return this.unifyExpression(node.getLeftOperand(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCBinary>>>(){

            public Choice<State<JCTree.JCBinary>> apply(final State<? extends JCTree.JCExpression> leftState) {
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getRightOperand(), leftState).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCBinary>>(){

                    public State<JCTree.JCBinary> apply(State<? extends JCTree.JCExpression> rightState) {
                        return rightState.withResult(PlaceholderUnificationVisitor.this.maker().Binary(tag, (JCTree.JCExpression)leftState.result(), rightState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCMethodInvocation>> visitMethodInvocation(final MethodInvocationTree node, State<?> state) {
        return this.unifyExpression(node.getMethodSelect(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCMethodInvocation>>>(){

            public Choice<State<JCTree.JCMethodInvocation>> apply(final State<? extends JCTree.JCExpression> selectState) {
                return PlaceholderUnificationVisitor.this.unifyExpressions(node.getArguments(), selectState).transform(new Function<State<List<JCTree.JCExpression>>, State<JCTree.JCMethodInvocation>>(){

                    public State<JCTree.JCMethodInvocation> apply(State<List<JCTree.JCExpression>> argsState) {
                        return argsState.withResult(PlaceholderUnificationVisitor.this.maker().Apply(null, (JCTree.JCExpression)selectState.result(), argsState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCFieldAccess>> visitMemberSelect(final MemberSelectTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCFieldAccess>>(){

            public State<JCTree.JCFieldAccess> apply(State<? extends JCTree.JCExpression> exprState) {
                return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Select(exprState.result(), (Name)node.getIdentifier()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCParens>> visitParenthesized(ParenthesizedTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCParens>>(){

            public State<JCTree.JCParens> apply(State<? extends JCTree.JCExpression> expressionState) {
                return expressionState.withResult(PlaceholderUnificationVisitor.this.maker().Parens(expressionState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCUnary>> visitUnary(UnaryTree node, State<?> state) {
        final JCTree.Tag tag = ((JCTree.JCUnary)node).getTag();
        return this.unifyExpression(node.getExpression(), state).thenOption(new Function<State<? extends JCTree.JCExpression>, Optional<State<JCTree.JCUnary>>>(){

            public Optional<State<JCTree.JCUnary>> apply(State<? extends JCTree.JCExpression> expressionState) {
                if (MUTATING_UNARY_TAGS.contains((Object)tag) && expressionState.result() instanceof UPlaceholderExpression.PlaceholderParamIdent) {
                    return Optional.absent();
                }
                return Optional.of(expressionState.withResult(PlaceholderUnificationVisitor.this.maker().Unary(tag, expressionState.result())));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCTypeCast>> visitTypeCast(final TypeCastTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCTypeCast>>(){

            public State<JCTree.JCTypeCast> apply(State<? extends JCTree.JCExpression> expressionState) {
                return expressionState.withResult(PlaceholderUnificationVisitor.this.maker().TypeCast((JCTree)node.getType(), expressionState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCInstanceOf>> visitInstanceOf(final InstanceOfTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCInstanceOf>>(){

            public State<JCTree.JCInstanceOf> apply(State<? extends JCTree.JCExpression> expressionState) {
                return expressionState.withResult(PlaceholderUnificationVisitor.this.maker().TypeTest(expressionState.result(), (JCTree)node.getType()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCNewClass>> visitNewClass(final NewClassTree node, State<?> state) {
        if (node.getEnclosingExpression() != null || node.getTypeArguments() != null && !node.getTypeArguments().isEmpty() || node.getClassBody() != null) {
            return Choice.none();
        }
        return this.unifyExpression(node.getIdentifier(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCNewClass>>>(){

            public Choice<State<JCTree.JCNewClass>> apply(final State<? extends JCTree.JCExpression> identifierState) {
                return PlaceholderUnificationVisitor.this.unifyExpressions(node.getArguments(), identifierState).transform(new Function<State<List<JCTree.JCExpression>>, State<JCTree.JCNewClass>>(){

                    public State<JCTree.JCNewClass> apply(State<List<JCTree.JCExpression>> argsState) {
                        return argsState.withResult(PlaceholderUnificationVisitor.this.maker().NewClass(null, null, (JCTree.JCExpression)identifierState.result(), argsState.result(), null));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCNewArray>> visitNewArray(final NewArrayTree node, State<?> state) {
        return this.unifyExpressions(node.getDimensions(), state).thenChoose(new Function<State<List<JCTree.JCExpression>>, Choice<State<JCTree.JCNewArray>>>(){

            public Choice<State<JCTree.JCNewArray>> apply(final State<List<JCTree.JCExpression>> dimsState) {
                return PlaceholderUnificationVisitor.this.unifyExpressions(node.getInitializers(), dimsState).transform(new Function<State<List<JCTree.JCExpression>>, State<JCTree.JCNewArray>>(){

                    public State<JCTree.JCNewArray> apply(State<List<JCTree.JCExpression>> initsState) {
                        return initsState.withResult(PlaceholderUnificationVisitor.this.maker().NewArray((JCTree.JCExpression)node.getType(), (List)dimsState.result(), initsState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCConditional>> visitConditionalExpression(final ConditionalExpressionTree node, State<?> state) {
        return this.unifyExpression(node.getCondition(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCConditional>>>(){

            public Choice<State<JCTree.JCConditional>> apply(final State<? extends JCTree.JCExpression> condState) {
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getTrueExpression(), condState).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCConditional>>>(){

                    public Choice<State<JCTree.JCConditional>> apply(final State<? extends JCTree.JCExpression> trueState) {
                        return PlaceholderUnificationVisitor.this.unifyExpression(node.getFalseExpression(), trueState).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCConditional>>(){

                            public State<JCTree.JCConditional> apply(State<? extends JCTree.JCExpression> falseState) {
                                return falseState.withResult(PlaceholderUnificationVisitor.this.maker().Conditional((JCTree.JCExpression)condState.result(), (JCTree.JCExpression)trueState.result(), falseState.result()));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCAssign>> visitAssignment(final AssignmentTree node, State<?> state) {
        return this.unifyExpression(node.getVariable(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCAssign>>>(){

            public Choice<State<JCTree.JCAssign>> apply(final State<? extends JCTree.JCExpression> varState) {
                if (varState.result() instanceof UPlaceholderExpression.PlaceholderParamIdent) {
                    return Choice.none();
                }
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getExpression(), varState).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCAssign>>(){

                    public State<JCTree.JCAssign> apply(State<? extends JCTree.JCExpression> exprState) {
                        return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Assign((JCTree.JCExpression)varState.result(), exprState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCAssignOp>> visitCompoundAssignment(final CompoundAssignmentTree node, State<?> state) {
        return this.unifyExpression(node.getVariable(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCAssignOp>>>(){

            public Choice<State<JCTree.JCAssignOp>> apply(final State<? extends JCTree.JCExpression> varState) {
                if (varState.result() instanceof UPlaceholderExpression.PlaceholderParamIdent) {
                    return Choice.none();
                }
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getExpression(), varState).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCAssignOp>>(){

                    public State<JCTree.JCAssignOp> apply(State<? extends JCTree.JCExpression> exprState) {
                        return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Assignop(((JCTree.JCAssignOp)node).getTag(), (JCTree)varState.result(), exprState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCExpressionStatement>> visitExpressionStatement(ExpressionStatementTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCExpressionStatement>>(){

            public State<JCTree.JCExpressionStatement> apply(State<? extends JCTree.JCExpression> exprState) {
                return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Exec(exprState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCBlock>> visitBlock(BlockTree node, State<?> state) {
        return this.unifyStatements(node.getStatements(), state).transform(new Function<State<List<JCTree.JCStatement>>, State<JCTree.JCBlock>>(){

            public State<JCTree.JCBlock> apply(State<List<JCTree.JCStatement>> state) {
                return state.withResult(PlaceholderUnificationVisitor.this.maker().Block(0L, state.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCThrow>> visitThrow(ThrowTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCThrow>>(){

            public State<JCTree.JCThrow> apply(State<? extends JCTree.JCExpression> exprState) {
                return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Throw(exprState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCEnhancedForLoop>> visitEnhancedForLoop(final EnhancedForLoopTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCEnhancedForLoop>>>(){

            public Choice<State<JCTree.JCEnhancedForLoop>> apply(final State<? extends JCTree.JCExpression> exprState) {
                return PlaceholderUnificationVisitor.this.unifyStatement(node.getStatement(), exprState).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCEnhancedForLoop>>(){

                    public State<JCTree.JCEnhancedForLoop> apply(State<? extends JCTree.JCStatement> stmtState) {
                        return stmtState.withResult(PlaceholderUnificationVisitor.this.maker().ForeachLoop((JCTree.JCVariableDecl)node.getVariable(), (JCTree.JCExpression)exprState.result(), stmtState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCIf>> visitIf(final IfTree node, State<?> state) {
        return this.unifyExpression(node.getCondition(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCIf>>>(){

            public Choice<State<JCTree.JCIf>> apply(final State<? extends JCTree.JCExpression> condState) {
                return PlaceholderUnificationVisitor.this.unifyStatement(node.getThenStatement(), condState).thenChoose(new Function<State<? extends JCTree.JCStatement>, Choice<State<JCTree.JCIf>>>(){

                    public Choice<State<JCTree.JCIf>> apply(final State<? extends JCTree.JCStatement> thenState) {
                        return PlaceholderUnificationVisitor.this.unifyStatement(node.getElseStatement(), thenState).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCIf>>(){

                            public State<JCTree.JCIf> apply(State<? extends JCTree.JCStatement> elseState) {
                                return elseState.withResult(PlaceholderUnificationVisitor.this.maker().If((JCTree.JCExpression)condState.result(), (JCTree.JCStatement)thenState.result(), elseState.result()));
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCDoWhileLoop>> visitDoWhileLoop(final DoWhileLoopTree node, State<?> state) {
        return this.unifyStatement(node.getStatement(), state).thenChoose(new Function<State<? extends JCTree.JCStatement>, Choice<State<JCTree.JCDoWhileLoop>>>(){

            public Choice<State<JCTree.JCDoWhileLoop>> apply(final State<? extends JCTree.JCStatement> stmtState) {
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getCondition(), stmtState).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCDoWhileLoop>>(){

                    public State<JCTree.JCDoWhileLoop> apply(State<? extends JCTree.JCExpression> condState) {
                        return condState.withResult(PlaceholderUnificationVisitor.this.maker().DoLoop((JCTree.JCStatement)stmtState.result(), condState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCForLoop>> visitForLoop(final ForLoopTree node, State<?> state) {
        return this.unifyStatements(node.getInitializer(), state).thenChoose(new Function<State<List<JCTree.JCStatement>>, Choice<State<JCTree.JCForLoop>>>(){

            public Choice<State<JCTree.JCForLoop>> apply(final State<List<JCTree.JCStatement>> initsState) {
                return PlaceholderUnificationVisitor.this.unifyExpression(node.getCondition(), initsState).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCForLoop>>>(){

                    public Choice<State<JCTree.JCForLoop>> apply(final State<? extends JCTree.JCExpression> condState) {
                        return PlaceholderUnificationVisitor.this.unifyStatements(node.getUpdate(), condState).thenChoose(new Function<State<List<JCTree.JCStatement>>, Choice<State<JCTree.JCForLoop>>>(){

                            public Choice<State<JCTree.JCForLoop>> apply(final State<List<JCTree.JCStatement>> updateState) {
                                return PlaceholderUnificationVisitor.this.unifyStatement(node.getStatement(), updateState).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCForLoop>>(){

                                    public State<JCTree.JCForLoop> apply(State<? extends JCTree.JCStatement> stmtState) {
                                        return stmtState.withResult(PlaceholderUnificationVisitor.this.maker().ForLoop((List)initsState.result(), (JCTree.JCExpression)condState.result(), List.convert(JCTree.JCExpressionStatement.class, (List)updateState.result()), stmtState.result()));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCLabeledStatement>> visitLabeledStatement(final LabeledStatementTree node, State<?> state) {
        return this.unifyStatement(node.getStatement(), state).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCLabeledStatement>>(){

            public State<JCTree.JCLabeledStatement> apply(State<? extends JCTree.JCStatement> stmtState) {
                return stmtState.withResult(PlaceholderUnificationVisitor.this.maker().Labelled((Name)node.getLabel(), stmtState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCVariableDecl>> visitVariable(final VariableTree node, State<?> state) {
        return this.unifyExpression(node.getInitializer(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCVariableDecl>>(){

            public State<JCTree.JCVariableDecl> apply(State<? extends JCTree.JCExpression> initState) {
                return initState.withResult(PlaceholderUnificationVisitor.this.maker().VarDef((JCTree.JCModifiers)node.getModifiers(), (Name)node.getName(), (JCTree.JCExpression)node.getType(), initState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCWhileLoop>> visitWhileLoop(final WhileLoopTree node, State<?> state) {
        return this.unifyExpression(node.getCondition(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCWhileLoop>>>(){

            public Choice<State<JCTree.JCWhileLoop>> apply(final State<? extends JCTree.JCExpression> condState) {
                return PlaceholderUnificationVisitor.this.unifyStatement(node.getStatement(), condState).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCWhileLoop>>(){

                    public State<JCTree.JCWhileLoop> apply(State<? extends JCTree.JCStatement> stmtState) {
                        return stmtState.withResult(PlaceholderUnificationVisitor.this.maker().WhileLoop((JCTree.JCExpression)condState.result(), stmtState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCSynchronized>> visitSynchronized(final SynchronizedTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCSynchronized>>>(){

            public Choice<State<JCTree.JCSynchronized>> apply(final State<? extends JCTree.JCExpression> exprState) {
                return PlaceholderUnificationVisitor.this.unifyStatement(node.getBlock(), exprState).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCSynchronized>>(){

                    public State<JCTree.JCSynchronized> apply(State<? extends JCTree.JCStatement> blockState) {
                        return blockState.withResult(PlaceholderUnificationVisitor.this.maker().Synchronized((JCTree.JCExpression)exprState.result(), (JCTree.JCBlock)blockState.result()));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCReturn>> visitReturn(ReturnTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCReturn>>(){

            public State<JCTree.JCReturn> apply(State<? extends JCTree.JCExpression> exprState) {
                return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Return(exprState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCTry>> visitTry(final TryTree node, State<?> state) {
        return this.unify(node.getResources(), state).thenChoose(new Function<State<List<JCTree>>, Choice<State<JCTree.JCTry>>>(){

            public Choice<State<JCTree.JCTry>> apply(final State<List<JCTree>> resourcesState) {
                return PlaceholderUnificationVisitor.this.unifyStatement(node.getBlock(), resourcesState).thenChoose(new Function<State<? extends JCTree.JCStatement>, Choice<State<JCTree.JCTry>>>(){

                    public Choice<State<JCTree.JCTry>> apply(final State<? extends JCTree.JCStatement> blockState) {
                        return PlaceholderUnificationVisitor.this.unify(node.getCatches(), blockState).thenChoose(new Function<State<List<JCTree>>, Choice<State<JCTree.JCTry>>>(){

                            public Choice<State<JCTree.JCTry>> apply(final State<List<JCTree>> catchesState) {
                                return PlaceholderUnificationVisitor.this.unifyStatement(node.getFinallyBlock(), catchesState).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCTry>>(){

                                    public State<JCTree.JCTry> apply(State<? extends JCTree.JCStatement> finallyState) {
                                        return finallyState.withResult(PlaceholderUnificationVisitor.this.maker().Try((List)resourcesState.result(), (JCTree.JCBlock)blockState.result(), List.convert(JCTree.JCCatch.class, (List)catchesState.result()), (JCTree.JCBlock)finallyState.result()));
                                    }
                                });
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCCatch>> visitCatch(final CatchTree node, State<?> state) {
        return this.unifyStatement(node.getBlock(), state).transform(new Function<State<? extends JCTree.JCStatement>, State<JCTree.JCCatch>>(){

            public State<JCTree.JCCatch> apply(State<? extends JCTree.JCStatement> blockState) {
                return blockState.withResult(PlaceholderUnificationVisitor.this.maker().Catch((JCTree.JCVariableDecl)node.getParameter(), (JCTree.JCBlock)blockState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCSwitch>> visitSwitch(final SwitchTree node, State<?> state) {
        return this.unifyExpression(node.getExpression(), state).thenChoose(new Function<State<? extends JCTree.JCExpression>, Choice<State<JCTree.JCSwitch>>>(){

            public Choice<State<JCTree.JCSwitch>> apply(final State<? extends JCTree.JCExpression> exprState) {
                return PlaceholderUnificationVisitor.this.unify(node.getCases(), exprState).transform(new Function<State<List<JCTree>>, State<JCTree.JCSwitch>>(){

                    public State<JCTree.JCSwitch> apply(State<List<JCTree>> casesState) {
                        return casesState.withResult(PlaceholderUnificationVisitor.this.maker().Switch((JCTree.JCExpression)exprState.result(), List.convert(JCTree.JCCase.class, casesState.result())));
                    }
                });
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCCase>> visitCase(final CaseTree node, State<?> state) {
        return this.unifyStatements(node.getStatements(), state).transform(new Function<State<List<JCTree.JCStatement>>, State<JCTree.JCCase>>(){

            public State<JCTree.JCCase> apply(State<List<JCTree.JCStatement>> stmtsState) {
                return stmtsState.withResult(PlaceholderUnificationVisitor.this.maker().Case((JCTree.JCExpression)node.getExpression(), stmtsState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCLambda>> visitLambdaExpression(final LambdaExpressionTree node, State<?> state) {
        return this.unify(node.getBody(), state).transform(new Function<State<? extends JCTree>, State<JCTree.JCLambda>>(){

            public State<JCTree.JCLambda> apply(State<? extends JCTree> bodyState) {
                return bodyState.withResult(PlaceholderUnificationVisitor.this.maker().Lambda(List.convert(JCTree.JCVariableDecl.class, (List)node.getParameters()), bodyState.result()));
            }
        });
    }

    @Override
    public Choice<State<JCTree.JCMemberReference>> visitMemberReference(final MemberReferenceTree node, State<?> state) {
        return this.unifyExpression(node.getQualifierExpression(), state).transform(new Function<State<? extends JCTree.JCExpression>, State<JCTree.JCMemberReference>>(){

            public State<JCTree.JCMemberReference> apply(State<? extends JCTree.JCExpression> exprState) {
                return exprState.withResult(PlaceholderUnificationVisitor.this.maker().Reference(node.getMode(), (Name)node.getName(), exprState.result(), List.convert(JCTree.JCExpression.class, (List)node.getTypeArguments())));
            }
        });
    }

    static abstract class State<R> {
        State() {
        }

        static <R> State<R> create(List<UVariableDecl> seenParameters, Unifier unifier, @Nullable R result) {
            return new AutoValue_PlaceholderUnificationVisitor_State<R>(seenParameters, unifier, result);
        }

        public abstract List<UVariableDecl> seenParameters();

        public abstract Unifier unifier();

        @Nullable
        public abstract R result();

        public <R2> State<R2> withResult(R2 result) {
            return State.create(this.seenParameters(), this.unifier(), result);
        }

        public State<R> fork() {
            return State.create(this.seenParameters(), this.unifier().fork(), this.result());
        }
    }
}

