/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_UBlock;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.USimpleStatement;
import com.google.errorprone.refaster.UStatement;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;

abstract class UBlock
extends USimpleStatement
implements BlockTree {
    UBlock() {
    }

    public static UBlock create(java.util.List<UStatement> statements) {
        return new AutoValue_UBlock((java.util.List<UStatement>)ImmutableList.copyOf(statements));
    }

    public static UBlock create(UStatement ... statements) {
        return UBlock.create((java.util.List<UStatement>)ImmutableList.copyOf((Object[])statements));
    }

    public abstract java.util.List<UStatement> getStatements();

    static Choice<Unifier> unifyStatementList(Iterable<? extends UStatement> statements, Iterable<? extends StatementTree> targets, Unifier unifier) {
        Choice<UStatement.UnifierWithUnconsumedStatements> choice = Choice.of(UStatement.UnifierWithUnconsumedStatements.create(unifier, (java.util.List<? extends StatementTree>)ImmutableList.copyOf(targets)));
        for (UStatement uStatement : statements) {
            choice = choice.thenChoose(uStatement);
        }
        return choice.thenOption(new Function<UStatement.UnifierWithUnconsumedStatements, Optional<Unifier>>(){

            public Optional<Unifier> apply(UStatement.UnifierWithUnconsumedStatements state) {
                return state.unconsumedStatements().isEmpty() ? Optional.of((Object)state.unifier()) : Optional.absent();
            }
        });
    }

    static List<JCTree.JCStatement> inlineStatementList(Iterable<? extends UStatement> statements, Inliner inliner) throws CouldNotResolveImportException {
        ListBuffer<JCTree.JCStatement> buffer = new ListBuffer<JCTree.JCStatement>();
        for (UStatement uStatement : statements) {
            buffer.appendList(uStatement.inlineStatements(inliner));
        }
        return buffer.toList();
    }

    @Override
    public Choice<Unifier> visitBlock(BlockTree block, Unifier unifier) {
        return UBlock.unifyStatementList(this.getStatements(), block.getStatements(), unifier);
    }

    @Override
    public JCTree.JCBlock inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Block(0L, UBlock.inlineStatementList(this.getStatements(), inliner));
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.BLOCK;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitBlock(this, data);
    }

    @Override
    public boolean isStatic() {
        return false;
    }
}

