/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetPartitionsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.partition.InternalPartition;
import com.hazelcast.partition.InternalPartitionService;
import java.security.Permission;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class GetPartitionsMessageTask
extends AbstractCallableMessageTask<ClientGetPartitionsCodec.RequestParameters> {
    public GetPartitionsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        InternalPartitionService service = (InternalPartitionService)this.getService("hz:core:partitionService");
        service.firstArrangement();
        InternalPartition[] partitions = service.getPartitions();
        int[] indexes = new int[partitions.length];
        HashMap<Address, HashSet<Integer>> partitionsMap = new HashMap<Address, HashSet<Integer>>();
        for (InternalPartition partition : partitions) {
            Address owner = partition.getOwnerOrNull();
            if (owner == null) {
                return ClientGetPartitionsCodec.encodeResponse(new Address[0], new int[0]);
            }
            HashSet<Integer> ownedPartitions = (HashSet<Integer>)partitionsMap.get(owner);
            if (ownedPartitions == null) {
                ownedPartitions = new HashSet<Integer>();
                partitionsMap.put(owner, ownedPartitions);
            }
            ownedPartitions.add(partition.getPartitionId());
        }
        Address[] addresses = new Address[partitionsMap.size()];
        int k = 0;
        for (Address owner : partitionsMap.keySet()) {
            addresses[k++] = owner;
        }
        for (k = 0; k < addresses.length; ++k) {
            Set ownedPartitions = (Set)partitionsMap.get(addresses[k]);
            Iterator i$ = ownedPartitions.iterator();
            while (i$.hasNext()) {
                int partitionId = (Integer)i$.next();
                indexes[partitionId] = k;
            }
        }
        return ClientGetPartitionsCodec.encodeResponse(addresses, indexes);
    }

    @Override
    protected ClientGetPartitionsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientGetPartitionsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return (ClientMessage)response;
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }
}

