/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.client.impl.client.CallableClientRequest;
import com.hazelcast.client.impl.client.RetryableRequest;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import com.hazelcast.replicatedmap.impl.record.ReplicatedRecordStore;
import java.io.IOException;

public abstract class AbstractReplicatedMapClientRequest
extends CallableClientRequest
implements RetryableRequest,
Portable {
    private String mapName;

    protected AbstractReplicatedMapClientRequest() {
    }

    public AbstractReplicatedMapClientRequest(String mapName) {
        this.mapName = mapName;
    }

    public String getMapName() {
        return this.mapName;
    }

    public void setMapName(String mapName) {
        this.mapName = mapName;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("mapName", this.mapName);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.mapName = reader.readUTF("mapName");
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    protected ReplicatedRecordStore getReplicatedRecordStore() {
        ReplicatedMapService replicatedMapService = (ReplicatedMapService)this.getService();
        return replicatedMapService.getReplicatedRecordStore(this.mapName, true);
    }

    @Override
    public String getDistributedObjectName() {
        return this.mapName;
    }
}

