/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.HashMultimap;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;

@BugPattern(name="FunctionalInterfaceClash", summary="Overloads will be ambiguous when passing lambda arguments", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class FunctionalInterfaceClash
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree tree, VisitorState state) {
        Symbol.MethodSymbol msym;
        Symbol.ClassSymbol origin = ASTHelpers.getSymbol((ClassTree)tree);
        Types types = state.getTypes();
        HashMultimap methods = HashMultimap.create();
        for (Symbol symbol : types.membersClosure(ASTHelpers.getType((ClassTree)tree), false).getSymbols()) {
            if (!(symbol instanceof Symbol.MethodSymbol) || this.isBugCheckerSuppressed((Symbol.MethodSymbol)symbol) || (msym = (Symbol.MethodSymbol)symbol).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types)) || msym.isConstructor() && !msym.owner.equals(origin)) continue;
            methods.put((Object)FunctionalInterfaceClash.functionalInterfaceSignature(state, msym), (Object)msym);
        }
        for (Tree tree2 : tree.getMembers()) {
            if (!(tree2 instanceof MethodTree) || (msym = ASTHelpers.getSymbol((MethodTree)((MethodTree)tree2))).getParameters().stream().noneMatch(p -> FunctionalInterfaceClash.maybeFunctionalInterface(p.type, types))) continue;
            ArrayList<Symbol.MethodSymbol> clash = new ArrayList<Symbol.MethodSymbol>(methods.removeAll((Object)FunctionalInterfaceClash.functionalInterfaceSignature(state, msym)));
            clash.remove(msym);
            clash.removeIf(m -> msym.overrides((Symbol)m, origin, types, false));
            if (clash.isEmpty()) continue;
            String message = "When passing lambda arguments to this function, callers will need a cast to disambiguate with: " + clash.stream().map(m -> Signatures.prettyMethodSignature((Symbol.ClassSymbol)origin, (Symbol.MethodSymbol)m)).collect(Collectors.joining("\n    "));
            state.reportMatch(this.buildDescription(tree2).setMessage(message).build());
        }
        return Description.NO_MATCH;
    }

    private static String functionalInterfaceSignature(VisitorState state, Symbol.MethodSymbol msym) {
        return String.format("%s(%s)", msym.getSimpleName(), msym.getParameters().stream().map(p -> FunctionalInterfaceClash.functionalInterfaceSignature(state, p.type)).collect(Collectors.joining(",")));
    }

    private static String functionalInterfaceSignature(VisitorState state, Type type) {
        Types types = state.getTypes();
        if (!FunctionalInterfaceClash.maybeFunctionalInterface(type, types)) {
            return Signatures.descriptor((Type)type, (Types)types);
        }
        Type descriptorType = types.findDescriptorType(type);
        List<Type> fiparams = descriptorType.getParameterTypes();
        String result = fiparams.isEmpty() ? Signatures.descriptor((Type)descriptorType.getReturnType(), (Types)types) : "_";
        return String.format("(%s)->%s", fiparams.stream().map(t -> Signatures.descriptor((Type)t, (Types)types)).collect(Collectors.joining(",")), result);
    }

    private static boolean maybeFunctionalInterface(Type type, Types types) {
        try {
            return types.isFunctionalInterface(type);
        }
        catch (Symbol.CompletionFailure e) {
            return false;
        }
    }

    private boolean isBugCheckerSuppressed(Symbol.MethodSymbol method) {
        SuppressWarnings suppression = (SuppressWarnings)ASTHelpers.getAnnotation((Symbol)method, SuppressWarnings.class);
        return suppression != null && !Collections.disjoint(Arrays.asList(suppression.value()), this.allNames());
    }
}

