/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	cephrookiov1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	labels "k8s.io/apimachinery/pkg/labels"
	schema "k8s.io/apimachinery/pkg/runtime/schema"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	testing "k8s.io/client-go/testing"
)

// FakeCephNFSes implements CephNFSInterface
type FakeCephNFSes struct {
	Fake *FakeCephV1
	ns   string
}

var cephnfsesResource = schema.GroupVersionResource{Group: "ceph.rook.io", Version: "v1", Resource: "cephnfses"}

var cephnfsesKind = schema.GroupVersionKind{Group: "ceph.rook.io", Version: "v1", Kind: "CephNFS"}

// Get takes name of the cephNFS, and returns the corresponding cephNFS object, and an error if there is any.
func (c *FakeCephNFSes) Get(name string, options v1.GetOptions) (result *cephrookiov1.CephNFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewGetAction(cephnfsesResource, c.ns, name), &cephrookiov1.CephNFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephNFS), err
}

// List takes label and field selectors, and returns the list of CephNFSes that match those selectors.
func (c *FakeCephNFSes) List(opts v1.ListOptions) (result *cephrookiov1.CephNFSList, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewListAction(cephnfsesResource, cephnfsesKind, c.ns, opts), &cephrookiov1.CephNFSList{})

	if obj == nil {
		return nil, err
	}

	label, _, _ := testing.ExtractFromListOptions(opts)
	if label == nil {
		label = labels.Everything()
	}
	list := &cephrookiov1.CephNFSList{ListMeta: obj.(*cephrookiov1.CephNFSList).ListMeta}
	for _, item := range obj.(*cephrookiov1.CephNFSList).Items {
		if label.Matches(labels.Set(item.Labels)) {
			list.Items = append(list.Items, item)
		}
	}
	return list, err
}

// Watch returns a watch.Interface that watches the requested cephNFSes.
func (c *FakeCephNFSes) Watch(opts v1.ListOptions) (watch.Interface, error) {
	return c.Fake.
		InvokesWatch(testing.NewWatchAction(cephnfsesResource, c.ns, opts))

}

// Create takes the representation of a cephNFS and creates it.  Returns the server's representation of the cephNFS, and an error, if there is any.
func (c *FakeCephNFSes) Create(cephNFS *cephrookiov1.CephNFS) (result *cephrookiov1.CephNFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewCreateAction(cephnfsesResource, c.ns, cephNFS), &cephrookiov1.CephNFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephNFS), err
}

// Update takes the representation of a cephNFS and updates it. Returns the server's representation of the cephNFS, and an error, if there is any.
func (c *FakeCephNFSes) Update(cephNFS *cephrookiov1.CephNFS) (result *cephrookiov1.CephNFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewUpdateAction(cephnfsesResource, c.ns, cephNFS), &cephrookiov1.CephNFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephNFS), err
}

// Delete takes name of the cephNFS and deletes it. Returns an error if one occurs.
func (c *FakeCephNFSes) Delete(name string, options *v1.DeleteOptions) error {
	_, err := c.Fake.
		Invokes(testing.NewDeleteAction(cephnfsesResource, c.ns, name), &cephrookiov1.CephNFS{})

	return err
}

// DeleteCollection deletes a collection of objects.
func (c *FakeCephNFSes) DeleteCollection(options *v1.DeleteOptions, listOptions v1.ListOptions) error {
	action := testing.NewDeleteCollectionAction(cephnfsesResource, c.ns, listOptions)

	_, err := c.Fake.Invokes(action, &cephrookiov1.CephNFSList{})
	return err
}

// Patch applies the patch and returns the patched cephNFS.
func (c *FakeCephNFSes) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *cephrookiov1.CephNFS, err error) {
	obj, err := c.Fake.
		Invokes(testing.NewPatchSubresourceAction(cephnfsesResource, c.ns, name, pt, data, subresources...), &cephrookiov1.CephNFS{})

	if obj == nil {
		return nil, err
	}
	return obj.(*cephrookiov1.CephNFS), err
}
