/*
 * Copyright 2018 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.quarkus.builder;

import java.util.Set;

/**
 */
final class StepInfo {
    private final BuildStep buildStep;
    private final int dependencies;
    private final Set<StepInfo> dependents;
    private final Set<ItemId> consumes;
    private final Set<ItemId> produces;

    StepInfo(final BuildStepBuilder builder, int dependencies, Set<StepInfo> dependents) {
        buildStep = builder.getBuildStep();
        consumes = builder.getRealConsumes();
        produces = builder.getRealProduces();
        this.dependencies = dependencies;
        this.dependents = dependents;
    }

    BuildStep getBuildStep() {
        return buildStep;
    }

    int getDependencies() {
        return dependencies;
    }

    Set<StepInfo> getDependents() {
        return dependents;
    }

    Set<ItemId> getConsumes() {
        return consumes;
    }

    Set<ItemId> getProduces() {
        return produces;
    }
}
