# 三大特性

- category: 1
- order: 1

与众不同的是，Ant Design 不但追求『用户』的使用体验，还追求『设计者』的使用体验，真真正正贯彻和践行『以人为本』的设计理念。

<div style="margin-left:-40px;margin-right:-40px;overflow:hidden;">
  <div class="col-8 features">
    <img src="https://os.alipayobjects.com/rmsportal/OVirOHTeAdzDBuQ.png">
    <h5>微小</h5>
    <div>致力于微小而美好的改变，力求在细节上精益求精，不仅让业务产品更加实用和可靠，而且还能让『用户』感到小惊喜。</div>
  </div>
  <div class="col-8 features">
    <img src="https://os.alipayobjects.com/rmsportal/iJbUiLYpuPBXUhV.png">
    <h5>确定</h5>
    <div>制定通俗而科学的设计原则、运用面向对象的方法、使用一致的文档沟通机制，给予研发团队一种高确定性、低熵值的研发状态。</div>
  </div>
  <div class="col-8 features">
    <img src="https://os.alipayobjects.com/rmsportal/uSOjjlCRjRIhtIY.png">
    <h5>幸福</h5>
    <div>不苛求简单，但是力求让『用户』和『设计者』流畅的完成目标，并带着成功和满足离开。</div>
  </div>
</div>

<style>
.features {
  padding: 0 40px;
  font-size: 12px;
}
.features h5 {
  font-size: 14px;
  margin-top: 16px;
}
@media only screen and (min-width: 320px) and (max-width: 767px) {
  .features {
    width: 100%;
    text-align: center;
    margin-bottom: 20px;;
  }
  .features img {
    width: 80%;
  }
}
</style>

---

## 微小

### 微创新

<img class="preview-img" align="right" alt="数值输入框示例" description="鼠标『悬停』时，可点击区域会放大。" src="https://os.alipayobjects.com/rmsportal/GGXdyrOtvUtOKXe.png">

<img class="preview-img" align="right" alt="分页示例" description="鼠标点击省略符，可以实现批量切换。" src="https://os.alipayobjects.com/rmsportal/UEYPnVhQsOjytSa.png">

<img class="preview-img" align="right" alt="字数校验框示例" description="使用颜色和下划线标注超出的文案，系统即时反应，以便用户进行调整。" src="https://os.alipayobjects.com/rmsportal/JxzQIRfMCtMjuaH.png">

『不同』不一定『更好』，但是『更好』一定『不同』。不断追求细节上的『更好』，使得我们的组件和同类产品都不一样，自然而然的『不同』。

### 集成创新

<img class="preview-img" align="right" alt="填空示例" description="组合了标签和输入项，可以帮助用户理解当前的状况，以及需要提供什么数据。" src="https://os.alipayobjects.com/rmsportal/RGFMJRSgCAVCKOl.png">

<img class="preview-img" align="right" alt="带图表的表格" description="组合了 Table 和 Chart ，鼠标『悬停』时展现更多详情内容。" src="https://os.alipayobjects.com/rmsportal/hjHOMRIbvIUUBXS.png">

选择合适的组件进行组合和集成，形成优势互补的创新过程，来满足多变的业务需求。

---

## 确定

### 面向对象的方法

<img class="preview-img" align="right" alt="色值换算工具示例" description="定义『原色』后，用『加黑』和『加白』的方式快速、科学的得出 Normal、Hover 等多个『状态色』。" src="https://os.alipayobjects.com/rmsportal/MqsXoBBSDmoEDqn.png">

<img class="preview-img" align="right" alt="排版规则示例" description="运用『亲密性』原则，只需定义 n 的值，就可以得出确定的间距。" src="https://os.alipayobjects.com/rmsportal/WNEbRORxzEvvFKy.png">

<img class="preview-img" noPadding align="right" alt="操作反馈 - 正确示例" description="将可被通用的文案抽象成『确定』、『操作』等通用术语，集中进行调用和维护。虽然『用户』体验 -1 分，但是『设计者』体验 +5 分。" good src="https://os.alipayobjects.com/rmsportal/rtbYGKfPOpWRJID.png">

<img class="preview-img" noPadding align="right" alt="操作反馈 - 错误示例" bad description="这是体验更好的反馈方式，但是对『设计者』来说是灾难。因为这些『删除』文案只能通过人肉维护，难免产生遗漏和错别字，增大了系统的不确定性，这在多人合作和需求变更时尤为明显。" src="https://os.alipayobjects.com/rmsportal/OWLtvGCGmqawyPt.png">

探索设计规律，并将其抽象成『对象』，增强界面设计的灵活性和可维护性，同时也减少『设计者』的主观干扰，从而降低系统的不确定性。

### 通俗而科学的设计原则

详见[『十大原则』](./principle)。

---

## 幸福

### 用户的幸福

<img class="preview-img" noPadding align="right" alt="用户的幸福示例" description="想了解更多内容，可阅读唐纳德•A•诺曼所著的 《设计心理学 3》。" src="https://os.alipayobjects.com/rmsportal/sBjNEGgHEpNfqTs.png">

漂亮的组件、精致的排版、流畅的动画等的元素，使用户在『本能层次』中产生积极反应；

良好的功能、性能和可用性，使用户在『行为层次』中产生积极反应；

自我形象、个人满足和美好记忆，使用户在『反思层次』中体验思想和情感的交融。

### 设计者的幸福

<img class="preview-img" noPadding align="right" alt="设计者的幸福示例" description="Ant Design 无法保证业务产品能否成功，但是能帮助业务产品『正确的成功』或者『正确的失败』。" src="https://os.alipayobjects.com/rmsportal/eMcdBWuZxRbvlvW.png">

从『无』到『有』时，提供一整套设计解决方案，帮助『设计者』将商业想法快速形成产品并推向市场，快速、低成本试错。

从『有』到『优』时，提供一系列自定义建议，帮助『设计者』塑造产品个性并提升整体体验，服务海量用户。
