---
title: "Compiler Error CS0173 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0173"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0173"
ms.assetid: eb1797ad-bf62-4e2b-8922-bef4aff36954
caps.latest.revision: 10
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0173
Type of conditional expression cannot be determined because there is no implicit conversion between 'class1' and 'class2'  
  
 Conversions between classes are useful when you want objects of different classes to work with the same code. However, two classes that work together cannot have mutual and redundant conversions, or no implicit conversions. The types of `class1` and `class2` are determined independently, and the more general type is selected as the type of the conditional expression. For more information about how types are determined, see [Conditional operator cannot cast implicitly](http://go.microsoft.com/fwlink/?LinkId=213999).  
  
 To resolve CS0173, verify that there is one and only one implicit conversion between `class1` and `class2`, regardless of which direction the conversion is in and regardless of which class the conversion is in. For more information, see [Implicit Numeric Conversions Table](../../../csharp/language-reference/keywords/implicit-numeric-conversions-table.md) and [Conversion Operators](../../../csharp/programming-guide/statements-expressions-operators/conversion-operators.md).  
  
## Example  
 The following sample generates CS0173:  
  
```cs  
// CS0173.cs  
public class C {}  
  
public class A   
{  
    //// The following code defines an implicit conversion operator from    
    //// type C to type A.  
    //public static implicit operator A(C c)  
    //{  
    //    A a = new A();  
    //    a = c;  
    //    return a;  
    //}  
}  
  
public class MyClass  
{  
    public static void F(bool b)  
    {  
        A a = new A();  
        C c = new C();  
  
        // The following line causes CS0173 because there is no implicit  
        // conversion from a to c or from c to a.  
        object o = b ? a : c;  
  
        // To resolve the error, you can cast a and c.  
        //object o = b ? (object)a : (object)c;  
  
        // Alternatively, you can add a conversion operator from class C to  
        // class A, or from class A to class C, but not both.  
    }  
  
   public static void Main()  
   {  
      F(true);  
   }  
}  
```  
  
## Example  
 The following code does not produce CS0173 in Visual Studio 2005, but does in later versions.  
  
```cs  
//cs0173_2.cs  
class M  
{  
    static int Main ()  
    {  
        int X = 1;  
        // The following line causes CS0173 in Visual Studio 2005.  
        object o = (X == 0) ? null : null;  
        return -1;  
    }  
}  
```