---
title: "Compiler Error CS0188 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0188"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0188"
ms.assetid: 4e693c18-584d-4c94-9863-283c69b97b0b
caps.latest.revision: 17
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0188
The 'this' object cannot be used before all of its fields are assigned to  
  
 All fields in a `struct` have to be assigned by a constructor before the constructor can call a method in the `struct`.  
  
 If you see this error when trying to initialize a property in a struct constructor, the solution is to change the constructor parameter to specify the backing field instead of the property itself. Auto-implemented properties should be avoided in structs because they have no backing field and therefore cannot be initialized in any way from the constructor.  
  
 For more information, see [Using Structs](../../../csharp/programming-guide/classes-and-structs/using-structs.md).  
  
## Example  
 The following sample generates CS0188:  
  
```  
// CS0188.cs  
// compile with: /t:library  
namespace MyNamespace  
{  
    class MyClass  
    {  
        struct S  
        {  
            public int a;  
  
            void MyMethod()  
            {  
            }  
  
            S(int i)  
            {  
                // a = i;  
                MyMethod();  // CS0188  
            }  
        }  
        public static void Main()  
        { }  
  
    }  
}  
```  
  
## See Also  
 [Structs](../../../csharp/programming-guide/classes-and-structs/structs.md)   
 [Auto-Implemented Properties](../../../csharp/programming-guide/classes-and-structs/auto-implemented-properties.md)