---
title: "Compiler Error CS0843 | Microsoft Docs"
ms.date: "2015-07-20"
ms.prod: .net
ms.technology: 
  - "devlang-csharp"
ms.topic: "error-reference"
f1_keywords: 
  - "CS0843"
dev_langs: 
  - "CSharp"
helpviewer_keywords: 
  - "CS0843"
ms.assetid: 5d9e01f5-9581-46e4-8d1b-9c3ffc438570
caps.latest.revision: 9
author: "BillWagner"
ms.author: "wiwagn"
translation.priority.ht: 
  - "cs-cz"
  - "de-de"
  - "es-es"
  - "fr-fr"
  - "it-it"
  - "ja-jp"
  - "ko-kr"
  - "pl-pl"
  - "pt-br"
  - "ru-ru"
  - "tr-tr"
  - "zh-cn"
  - "zh-tw"
---
# Compiler Error CS0843
Backing field for automatically implemented property 'name' must be fully assigned before control is returned to the caller. Consider calling the default constructor from a constructor initializer.  
  
 To assign a value to an automatically-implemented property from a constructor, you must first invoke the default constructor to create the object.  
  
## To correct this error  
  
1.  Add a call to the default constructor in a constructor initializer as shown in the following example. Note the use of `: this()`. For more information, see [this](../../../csharp/language-reference/keywords/this.md).  
  
## Example  
 The following code generates CS0843:  
  
```  
// cs0843.cs  
struct S  
{  
    public int AIProp { get; set; }  
    public S(int i){} //CS0843  
    // Try the following lines instead.  
   // public S(int i) : this()  
   // {  
   //     AIProp = i;  
   // }  
}  
  
class Test  
{  
    static int Main()  
    {  
        return 1;  
    }  
}  
```